# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['WorkstationArgs', 'Workstation']

@pulumi.input_type
class WorkstationArgs:
    def __init__(__self__, *,
                 workstation_cluster_id: pulumi.Input[str],
                 workstation_config_id: pulumi.Input[str],
                 workstation_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Workstation resource.
        :param pulumi.Input[str] workstation_id: Required. ID to use for the workstation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input[str] etag: Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[str] name: Full name of this resource.
        :param pulumi.Input[bool] validate_only: If set, validate the request and preview the review, but do not actually apply it.
        """
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        pulumi.set(__self__, "workstation_id", workstation_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workstation_config_id", value)

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> pulumi.Input[str]:
        """
        Required. ID to use for the workstation.
        """
        return pulumi.get(self, "workstation_id")

    @workstation_id.setter
    def workstation_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workstation_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, validate the request and preview the review, but do not actually apply it.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_only", value)


class Workstation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                 workstation_config_id: Optional[pulumi.Input[str]] = None,
                 workstation_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new workstation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input[str] etag: Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[str] name: Full name of this resource.
        :param pulumi.Input[bool] validate_only: If set, validate the request and preview the review, but do not actually apply it.
        :param pulumi.Input[str] workstation_id: Required. ID to use for the workstation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkstationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new workstation.

        :param str resource_name: The name of the resource.
        :param WorkstationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkstationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                 workstation_config_id: Optional[pulumi.Input[str]] = None,
                 workstation_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkstationArgs.__new__(WorkstationArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["etag"] = etag
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["validate_only"] = validate_only
            if workstation_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_cluster_id'")
            __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
            if workstation_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_config_id'")
            __props__.__dict__["workstation_config_id"] = workstation_config_id
            if workstation_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_id'")
            __props__.__dict__["workstation_id"] = workstation_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "workstation_cluster_id", "workstation_config_id", "workstation_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Workstation, __self__).__init__(
            'google-native:workstations/v1beta:Workstation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Workstation':
        """
        Get an existing Workstation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkstationArgs.__new__(WorkstationArgs)

        __props__.__dict__["annotations"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["delete_time"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["host"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["reconciling"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["validate_only"] = None
        __props__.__dict__["workstation_cluster_id"] = None
        __props__.__dict__["workstation_config_id"] = None
        __props__.__dict__["workstation_id"] = None
        return Workstation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Client-specified annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Time when this resource was soft-deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Host to which clients can send HTTPS traffic that will be received by the workstation. Authorized traffic will be received to the workstation as HTTP on port 80. To send traffic to a different port, clients may prefix the host with the destination port in the format `{port}-{host}`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Indicates whether this resource is currently being updated to match its intended state.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the workstation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        A system-assigned unique identified for this resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when this resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, validate the request and preview the review, but do not actually apply it.
        """
        return pulumi.get(self, "validate_only")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "workstation_cluster_id")

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "workstation_config_id")

    @property
    @pulumi.getter(name="workstationId")
    def workstation_id(self) -> pulumi.Output[str]:
        """
        Required. ID to use for the workstation.
        """
        return pulumi.get(self, "workstation_id")

