# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'ContainerResponse',
    'CustomerEncryptionKeyResponse',
    'ExprResponse',
    'GceConfidentialInstanceConfigResponse',
    'GceInstanceResponse',
    'GceRegionalPersistentDiskResponse',
    'GceShieldedInstanceConfigResponse',
    'HostResponse',
    'PersistentDirectoryResponse',
    'PrivateClusterConfigResponse',
    'StatusResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ContainerResponse(dict):
    """
    A Docker container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Mapping[str, str],
                 image: str,
                 run_as_user: int,
                 working_dir: str):
        """
        A Docker container.
        :param Sequence[str] args: Arguments passed to the entrypoint.
        :param Sequence[str] command: If set, overrides the default ENTRYPOINT specified by the image.
        :param Mapping[str, str] env: Environment variables passed to the container.
        :param str image: Docker image defining the container. This image must be accessible by the config's service account.
        :param int run_as_user: If set, overrides the USER specified in the image with the given uid.
        :param str working_dir: If set, overrides the default DIR specified by the image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments passed to the entrypoint.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        If set, overrides the default ENTRYPOINT specified by the image.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Mapping[str, str]:
        """
        Environment variables passed to the container.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image defining the container. This image must be accessible by the config's service account.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        If set, overrides the USER specified in the image with the given uid.
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        If set, overrides the default DIR specified by the image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class CustomerEncryptionKeyResponse(dict):
    """
    A customer-specified encryption key for the Compute Engine resources of this workstation configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "kmsKeyServiceAccount":
            suggest = "kms_key_service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomerEncryptionKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomerEncryptionKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomerEncryptionKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: str,
                 kms_key_service_account: str):
        """
        A customer-specified encryption key for the Compute Engine resources of this workstation configuration.
        :param str kms_key: The name of the encryption key that is stored in Google Cloud KMS, for example, `projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME`.
        :param str kms_key_service_account: The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. However, it is recommended to use a separate service account and to follow KMS best practices mentioned at https://cloud.google.com/kms/docs/separation-of-duties
        """
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "kms_key_service_account", kms_key_service_account)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        The name of the encryption key that is stored in Google Cloud KMS, for example, `projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME`.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="kmsKeyServiceAccount")
    def kms_key_service_account(self) -> str:
        """
        The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. However, it is recommended to use a separate service account and to follow KMS best practices mentioned at https://cloud.google.com/kms/docs/separation-of-duties
        """
        return pulumi.get(self, "kms_key_service_account")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GceConfidentialInstanceConfigResponse(dict):
    """
    A set of Compute Engine Confidential VM instance options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableConfidentialCompute":
            suggest = "enable_confidential_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GceConfidentialInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GceConfidentialInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GceConfidentialInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_confidential_compute: bool):
        """
        A set of Compute Engine Confidential VM instance options.
        :param bool enable_confidential_compute: Whether the instance has confidential compute enabled.
        """
        pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> bool:
        """
        Whether the instance has confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")


@pulumi.output_type
class GceInstanceResponse(dict):
    """
    A runtime using a Compute Engine instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "confidentialInstanceConfig":
            suggest = "confidential_instance_config"
        elif key == "disablePublicIpAddresses":
            suggest = "disable_public_ip_addresses"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "poolSize":
            suggest = "pool_size"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GceInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GceInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GceInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: int,
                 confidential_instance_config: 'outputs.GceConfidentialInstanceConfigResponse',
                 disable_public_ip_addresses: bool,
                 machine_type: str,
                 pool_size: int,
                 service_account: str,
                 shielded_instance_config: 'outputs.GceShieldedInstanceConfigResponse',
                 tags: Sequence[str]):
        """
        A runtime using a Compute Engine instance.
        :param int boot_disk_size_gb: Size of the boot disk in GB.
        :param 'GceConfidentialInstanceConfigResponse' confidential_instance_config: A set of Compute Engine Confidential VM instance options.
        :param bool disable_public_ip_addresses: Whether instances have no public IP address.
        :param str machine_type: The name of a Compute Engine machine type.
        :param int pool_size: Number of instances to pool for faster workstation starup.
        :param str service_account: Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        :param 'GceShieldedInstanceConfigResponse' shielded_instance_config: A set of Compute Engine Shielded instance options.
        :param Sequence[str] tags: Network tags to add to the Compute Engine machines backing the Workstations.
        """
        pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        pulumi.set(__self__, "disable_public_ip_addresses", disable_public_ip_addresses)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "pool_size", pool_size)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> int:
        """
        Size of the boot disk in GB.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> 'outputs.GceConfidentialInstanceConfigResponse':
        """
        A set of Compute Engine Confidential VM instance options.
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter(name="disablePublicIpAddresses")
    def disable_public_ip_addresses(self) -> bool:
        """
        Whether instances have no public IP address.
        """
        return pulumi.get(self, "disable_public_ip_addresses")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The name of a Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> int:
        """
        Number of instances to pool for faster workstation starup.
        """
        return pulumi.get(self, "pool_size")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.GceShieldedInstanceConfigResponse':
        """
        A set of Compute Engine Shielded instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Network tags to add to the Compute Engine machines backing the Workstations.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GceRegionalPersistentDiskResponse(dict):
    """
    A PersistentDirectory backed by a Compute Engine regional persistent disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "reclaimPolicy":
            suggest = "reclaim_policy"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GceRegionalPersistentDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GceRegionalPersistentDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GceRegionalPersistentDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: str,
                 fs_type: str,
                 reclaim_policy: str,
                 size_gb: int):
        """
        A PersistentDirectory backed by a Compute Engine regional persistent disk.
        :param str disk_type: Type of the disk to use.
        :param str fs_type: Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if source_snapshot is set.
        :param str reclaim_policy: What should happen to the disk after the workstation is deleted. Defaults to DELETE.
        :param int size_gb: Size of the disk in GB. Must be empty if source_snapshot is set.
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "fs_type", fs_type)
        pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of the disk to use.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> str:
        """
        Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if source_snapshot is set.
        """
        return pulumi.get(self, "fs_type")

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> str:
        """
        What should happen to the disk after the workstation is deleted. Defaults to DELETE.
        """
        return pulumi.get(self, "reclaim_policy")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> int:
        """
        Size of the disk in GB. Must be empty if source_snapshot is set.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GceShieldedInstanceConfigResponse(dict):
    """
    A set of Compute Engine Shielded instance options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GceShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GceShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GceShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        A set of Compute Engine Shielded instance options.
        :param bool enable_integrity_monitoring: Whether the instance has integrity monitoring enabled.
        :param bool enable_secure_boot: Whether the instance has Secure Boot enabled.
        :param bool enable_vtpm: Whether the instance has the vTPM enabled.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Whether the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Whether the instance has the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class HostResponse(dict):
    """
    Runtime host for a workstation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gceInstance":
            suggest = "gce_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_instance: 'outputs.GceInstanceResponse'):
        """
        Runtime host for a workstation.
        :param 'GceInstanceResponse' gce_instance: Specifies a Compute Engine instance as the host.
        """
        pulumi.set(__self__, "gce_instance", gce_instance)

    @property
    @pulumi.getter(name="gceInstance")
    def gce_instance(self) -> 'outputs.GceInstanceResponse':
        """
        Specifies a Compute Engine instance as the host.
        """
        return pulumi.get(self, "gce_instance")


@pulumi.output_type
class PersistentDirectoryResponse(dict):
    """
    A directory to persist across workstation sessions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcePd":
            suggest = "gce_pd"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_pd: 'outputs.GceRegionalPersistentDiskResponse',
                 mount_path: str):
        """
        A directory to persist across workstation sessions.
        :param 'GceRegionalPersistentDiskResponse' gce_pd: A PersistentDirectory backed by a Compute Engine persistent disk.
        :param str mount_path: Location of this directory in the running workstation.
        """
        pulumi.set(__self__, "gce_pd", gce_pd)
        pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="gcePd")
    def gce_pd(self) -> 'outputs.GceRegionalPersistentDiskResponse':
        """
        A PersistentDirectory backed by a Compute Engine persistent disk.
        """
        return pulumi.get(self, "gce_pd")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Location of this directory in the running workstation.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class PrivateClusterConfigResponse(dict):
    """
    Configuration options for private clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedProjects":
            suggest = "allowed_projects"
        elif key == "clusterHostname":
            suggest = "cluster_hostname"
        elif key == "enablePrivateEndpoint":
            suggest = "enable_private_endpoint"
        elif key == "serviceAttachmentUri":
            suggest = "service_attachment_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_projects: Sequence[str],
                 cluster_hostname: str,
                 enable_private_endpoint: bool,
                 service_attachment_uri: str):
        """
        Configuration options for private clusters.
        :param Sequence[str] allowed_projects: Additional projects that are allowed to attach to the workstation cluster's service attachment. By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        :param str cluster_hostname: Hostname for the workstation cluster. This field will be populated only when private endpoint is enabled. To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        :param bool enable_private_endpoint: Immutable. Whether Workstations endpoint is private.
        :param str service_attachment_uri: Service attachment URI for the workstation cluster. The service attachemnt is created when private endpoint is enabled. To access workstations in the cluster, configure access to the managed service using [Private Service Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
        """
        pulumi.set(__self__, "allowed_projects", allowed_projects)
        pulumi.set(__self__, "cluster_hostname", cluster_hostname)
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "service_attachment_uri", service_attachment_uri)

    @property
    @pulumi.getter(name="allowedProjects")
    def allowed_projects(self) -> Sequence[str]:
        """
        Additional projects that are allowed to attach to the workstation cluster's service attachment. By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        """
        return pulumi.get(self, "allowed_projects")

    @property
    @pulumi.getter(name="clusterHostname")
    def cluster_hostname(self) -> str:
        """
        Hostname for the workstation cluster. This field will be populated only when private endpoint is enabled. To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        """
        return pulumi.get(self, "cluster_hostname")

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        Immutable. Whether Workstations endpoint is private.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="serviceAttachmentUri")
    def service_attachment_uri(self) -> str:
        """
        Service attachment URI for the workstation cluster. The service attachemnt is created when private endpoint is enabled. To access workstations in the cluster, configure access to the managed service using [Private Service Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
        """
        return pulumi.get(self, "service_attachment_uri")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


