# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkstationConfigResult',
    'AwaitableGetWorkstationConfigResult',
    'get_workstation_config',
    'get_workstation_config_output',
]

@pulumi.output_type
class GetWorkstationConfigResult:
    def __init__(__self__, annotations=None, conditions=None, container=None, create_time=None, degraded=None, delete_time=None, display_name=None, encryption_key=None, etag=None, host=None, idle_timeout=None, labels=None, name=None, persistent_directories=None, reconciling=None, running_timeout=None, uid=None, update_time=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if container and not isinstance(container, dict):
            raise TypeError("Expected argument 'container' to be a dict")
        pulumi.set(__self__, "container", container)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if degraded and not isinstance(degraded, bool):
            raise TypeError("Expected argument 'degraded' to be a bool")
        pulumi.set(__self__, "degraded", degraded)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if encryption_key and not isinstance(encryption_key, dict):
            raise TypeError("Expected argument 'encryption_key' to be a dict")
        pulumi.set(__self__, "encryption_key", encryption_key)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if host and not isinstance(host, dict):
            raise TypeError("Expected argument 'host' to be a dict")
        pulumi.set(__self__, "host", host)
        if idle_timeout and not isinstance(idle_timeout, str):
            raise TypeError("Expected argument 'idle_timeout' to be a str")
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if persistent_directories and not isinstance(persistent_directories, list):
            raise TypeError("Expected argument 'persistent_directories' to be a list")
        pulumi.set(__self__, "persistent_directories", persistent_directories)
        if reconciling and not isinstance(reconciling, bool):
            raise TypeError("Expected argument 'reconciling' to be a bool")
        pulumi.set(__self__, "reconciling", reconciling)
        if running_timeout and not isinstance(running_timeout, str):
            raise TypeError("Expected argument 'running_timeout' to be a str")
        pulumi.set(__self__, "running_timeout", running_timeout)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Client-specified annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.StatusResponse']:
        """
        Status conditions describing the current resource state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def container(self) -> 'outputs.ContainerResponse':
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def degraded(self) -> bool:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the `conditions` field.
        """
        return pulumi.get(self, "degraded")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        Time when this resource was soft-deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        Encrypts resources of this workstation configuration using a customer-specified encryption key. If specified, the boot disk of the Compute Engine instance and the persistent disk will be encrypted using this encryption key. If this field is not set, the disks will be encrypted using a generated key. Customer-specified encryption keys do not protect disk metadata. If the customer-specified encryption key is rotated, when the workstation instance is stopped, the system will attempt to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost. If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> 'outputs.HostResponse':
        """
        Runtime host for the workstation.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> str:
        """
        How long to wait before automatically stopping an instance that hasn't received any user traffic. A value of 0 indicates that this instance should never time out due to idleness. Defaults to 20 minutes.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> Sequence['outputs.PersistentDirectoryResponse']:
        """
        Directories to persist across workstation sessions.
        """
        return pulumi.get(self, "persistent_directories")

    @property
    @pulumi.getter
    def reconciling(self) -> bool:
        """
        Indicates whether this resource is currently being updated to match its intended state.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> str:
        """
        How long to wait before automatically stopping a workstation after it started. A value of 0 indicates that workstations using this config should never time out. Must be greater than 0 and less than 24 hours if encryption_key is set. Defaults to 12 hours.
        """
        return pulumi.get(self, "running_timeout")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A system-assigned unique identified for this resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time when this resource was most recently updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetWorkstationConfigResult(GetWorkstationConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkstationConfigResult(
            annotations=self.annotations,
            conditions=self.conditions,
            container=self.container,
            create_time=self.create_time,
            degraded=self.degraded,
            delete_time=self.delete_time,
            display_name=self.display_name,
            encryption_key=self.encryption_key,
            etag=self.etag,
            host=self.host,
            idle_timeout=self.idle_timeout,
            labels=self.labels,
            name=self.name,
            persistent_directories=self.persistent_directories,
            reconciling=self.reconciling,
            running_timeout=self.running_timeout,
            uid=self.uid,
            update_time=self.update_time)


def get_workstation_config(location: Optional[str] = None,
                           project: Optional[str] = None,
                           workstation_cluster_id: Optional[str] = None,
                           workstation_config_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkstationConfigResult:
    """
    Returns the requested workstation configuration.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['workstationClusterId'] = workstation_cluster_id
    __args__['workstationConfigId'] = workstation_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:workstations/v1beta:getWorkstationConfig', __args__, opts=opts, typ=GetWorkstationConfigResult).value

    return AwaitableGetWorkstationConfigResult(
        annotations=__ret__.annotations,
        conditions=__ret__.conditions,
        container=__ret__.container,
        create_time=__ret__.create_time,
        degraded=__ret__.degraded,
        delete_time=__ret__.delete_time,
        display_name=__ret__.display_name,
        encryption_key=__ret__.encryption_key,
        etag=__ret__.etag,
        host=__ret__.host,
        idle_timeout=__ret__.idle_timeout,
        labels=__ret__.labels,
        name=__ret__.name,
        persistent_directories=__ret__.persistent_directories,
        reconciling=__ret__.reconciling,
        running_timeout=__ret__.running_timeout,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_workstation_config)
def get_workstation_config_output(location: Optional[pulumi.Input[str]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                                  workstation_config_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkstationConfigResult]:
    """
    Returns the requested workstation configuration.
    """
    ...
