# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkstationClusterResult',
    'AwaitableGetWorkstationClusterResult',
    'get_workstation_cluster',
    'get_workstation_cluster_output',
]

@pulumi.output_type
class GetWorkstationClusterResult:
    def __init__(__self__, annotations=None, conditions=None, create_time=None, degraded=None, delete_time=None, display_name=None, etag=None, labels=None, name=None, network=None, private_cluster_config=None, reconciling=None, subnetwork=None, uid=None, update_time=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if degraded and not isinstance(degraded, bool):
            raise TypeError("Expected argument 'degraded' to be a bool")
        pulumi.set(__self__, "degraded", degraded)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if private_cluster_config and not isinstance(private_cluster_config, dict):
            raise TypeError("Expected argument 'private_cluster_config' to be a dict")
        pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if reconciling and not isinstance(reconciling, bool):
            raise TypeError("Expected argument 'reconciling' to be a bool")
        pulumi.set(__self__, "reconciling", reconciling)
        if subnetwork and not isinstance(subnetwork, str):
            raise TypeError("Expected argument 'subnetwork' to be a str")
        pulumi.set(__self__, "subnetwork", subnetwork)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Client-specified annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.StatusResponse']:
        """
        Status conditions describing the current resource state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def degraded(self) -> bool:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the `conditions` field.
        """
        return pulumi.get(self, "degraded")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        Time when this resource was soft-deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Checksum computed by the server. May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Immutable. Name of the Compute Engine network in which instances associated with this cluster will be created.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> 'outputs.PrivateClusterConfigResponse':
        """
        Configuration for private cluster.
        """
        return pulumi.get(self, "private_cluster_config")

    @property
    @pulumi.getter
    def reconciling(self) -> bool:
        """
        Indicates whether this resource is currently being updated to match its intended state.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        Immutable. Name of the Compute Engine subnetwork in which instances associated with this cluster will be created. Must be part of the subnetwork specified for this cluster.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A system-assigned unique identified for this resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time when this resource was most recently updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetWorkstationClusterResult(GetWorkstationClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkstationClusterResult(
            annotations=self.annotations,
            conditions=self.conditions,
            create_time=self.create_time,
            degraded=self.degraded,
            delete_time=self.delete_time,
            display_name=self.display_name,
            etag=self.etag,
            labels=self.labels,
            name=self.name,
            network=self.network,
            private_cluster_config=self.private_cluster_config,
            reconciling=self.reconciling,
            subnetwork=self.subnetwork,
            uid=self.uid,
            update_time=self.update_time)


def get_workstation_cluster(location: Optional[str] = None,
                            project: Optional[str] = None,
                            workstation_cluster_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkstationClusterResult:
    """
    Returns the requested workstation cluster.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['workstationClusterId'] = workstation_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:workstations/v1beta:getWorkstationCluster', __args__, opts=opts, typ=GetWorkstationClusterResult).value

    return AwaitableGetWorkstationClusterResult(
        annotations=__ret__.annotations,
        conditions=__ret__.conditions,
        create_time=__ret__.create_time,
        degraded=__ret__.degraded,
        delete_time=__ret__.delete_time,
        display_name=__ret__.display_name,
        etag=__ret__.etag,
        labels=__ret__.labels,
        name=__ret__.name,
        network=__ret__.network,
        private_cluster_config=__ret__.private_cluster_config,
        reconciling=__ret__.reconciling,
        subnetwork=__ret__.subnetwork,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_workstation_cluster)
def get_workstation_cluster_output(location: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[Optional[str]]] = None,
                                   workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkstationClusterResult]:
    """
    Returns the requested workstation cluster.
    """
    ...
