# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'ContainerArgs',
    'CustomerEncryptionKeyArgs',
    'ExprArgs',
    'GceConfidentialInstanceConfigArgs',
    'GceInstanceArgs',
    'GceRegionalPersistentDiskArgs',
    'GceShieldedInstanceConfigArgs',
    'HostArgs',
    'PersistentDirectoryArgs',
    'PrivateClusterConfigArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        A Docker container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments passed to the entrypoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: If set, overrides the default ENTRYPOINT specified by the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env: Environment variables passed to the container.
        :param pulumi.Input[str] image: Docker image defining the container. This image must be accessible by the config's service account.
        :param pulumi.Input[int] run_as_user: If set, overrides the USER specified in the image with the given uid.
        :param pulumi.Input[str] working_dir: If set, overrides the default DIR specified by the image.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments passed to the entrypoint.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If set, overrides the default ENTRYPOINT specified by the image.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables passed to the container.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Docker image defining the container. This image must be accessible by the config's service account.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        """
        If set, overrides the USER specified in the image with the given uid.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        If set, overrides the default DIR specified by the image.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class CustomerEncryptionKeyArgs:
    def __init__(__self__, *,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 kms_key_service_account: Optional[pulumi.Input[str]] = None):
        """
        A customer-specified encryption key for the Compute Engine resources of this workstation configuration.
        :param pulumi.Input[str] kms_key: The name of the encryption key that is stored in Google Cloud KMS, for example, `projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME`.
        :param pulumi.Input[str] kms_key_service_account: The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. However, it is recommended to use a separate service account and to follow KMS best practices mentioned at https://cloud.google.com/kms/docs/separation-of-duties
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_service_account is not None:
            pulumi.set(__self__, "kms_key_service_account", kms_key_service_account)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the encryption key that is stored in Google Cloud KMS, for example, `projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="kmsKeyServiceAccount")
    def kms_key_service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. However, it is recommended to use a separate service account and to follow KMS best practices mentioned at https://cloud.google.com/kms/docs/separation-of-duties
        """
        return pulumi.get(self, "kms_key_service_account")

    @kms_key_service_account.setter
    def kms_key_service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_service_account", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GceConfidentialInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None):
        """
        A set of Compute Engine Confidential VM instance options.
        :param pulumi.Input[bool] enable_confidential_compute: Whether the instance has confidential compute enabled.
        """
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")

    @enable_confidential_compute.setter
    def enable_confidential_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_confidential_compute", value)


@pulumi.input_type
class GceInstanceArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 confidential_instance_config: Optional[pulumi.Input['GceConfidentialInstanceConfigArgs']] = None,
                 disable_public_ip_addresses: Optional[pulumi.Input[bool]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[int]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['GceShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A runtime using a Compute Engine instance.
        :param pulumi.Input[int] boot_disk_size_gb: Size of the boot disk in GB.
        :param pulumi.Input['GceConfidentialInstanceConfigArgs'] confidential_instance_config: A set of Compute Engine Confidential VM instance options.
        :param pulumi.Input[bool] disable_public_ip_addresses: Whether instances have no public IP address.
        :param pulumi.Input[str] machine_type: The name of a Compute Engine machine type.
        :param pulumi.Input[int] pool_size: Number of instances to pool for faster workstation starup.
        :param pulumi.Input[str] service_account: Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        :param pulumi.Input['GceShieldedInstanceConfigArgs'] shielded_instance_config: A set of Compute Engine Shielded instance options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Network tags to add to the Compute Engine machines backing the Workstations.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if disable_public_ip_addresses is not None:
            pulumi.set(__self__, "disable_public_ip_addresses", disable_public_ip_addresses)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if pool_size is not None:
            pulumi.set(__self__, "pool_size", pool_size)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the boot disk in GB.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['GceConfidentialInstanceConfigArgs']]:
        """
        A set of Compute Engine Confidential VM instance options.
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['GceConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter(name="disablePublicIpAddresses")
    def disable_public_ip_addresses(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether instances have no public IP address.
        """
        return pulumi.get(self, "disable_public_ip_addresses")

    @disable_public_ip_addresses.setter
    def disable_public_ip_addresses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_public_ip_addresses", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number of instances to pool for faster workstation starup.
        """
        return pulumi.get(self, "pool_size")

    @pool_size.setter
    def pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pool_size", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['GceShieldedInstanceConfigArgs']]:
        """
        A set of Compute Engine Shielded instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['GceShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network tags to add to the Compute Engine machines backing the Workstations.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GceRegionalPersistentDiskArgs:
    def __init__(__self__, *,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 fs_type: Optional[pulumi.Input[str]] = None,
                 reclaim_policy: Optional[pulumi.Input['GceRegionalPersistentDiskReclaimPolicy']] = None,
                 size_gb: Optional[pulumi.Input[int]] = None):
        """
        A PersistentDirectory backed by a Compute Engine regional persistent disk.
        :param pulumi.Input[str] disk_type: Type of the disk to use.
        :param pulumi.Input[str] fs_type: Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if source_snapshot is set.
        :param pulumi.Input['GceRegionalPersistentDiskReclaimPolicy'] reclaim_policy: What should happen to the disk after the workstation is deleted. Defaults to DELETE.
        :param pulumi.Input[int] size_gb: Size of the disk in GB. Must be empty if source_snapshot is set.
        """
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the disk to use.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if source_snapshot is set.
        """
        return pulumi.get(self, "fs_type")

    @fs_type.setter
    def fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_type", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input['GceRegionalPersistentDiskReclaimPolicy']]:
        """
        What should happen to the disk after the workstation is deleted. Defaults to DELETE.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input['GceRegionalPersistentDiskReclaimPolicy']]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk in GB. Must be empty if source_snapshot is set.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_gb", value)


@pulumi.input_type
class GceShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None):
        """
        A set of Compute Engine Shielded instance options.
        :param pulumi.Input[bool] enable_integrity_monitoring: Whether the instance has integrity monitoring enabled.
        :param pulumi.Input[bool] enable_secure_boot: Whether the instance has Secure Boot enabled.
        :param pulumi.Input[bool] enable_vtpm: Whether the instance has the vTPM enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)


@pulumi.input_type
class HostArgs:
    def __init__(__self__, *,
                 gce_instance: Optional[pulumi.Input['GceInstanceArgs']] = None):
        """
        Runtime host for a workstation.
        :param pulumi.Input['GceInstanceArgs'] gce_instance: Specifies a Compute Engine instance as the host.
        """
        if gce_instance is not None:
            pulumi.set(__self__, "gce_instance", gce_instance)

    @property
    @pulumi.getter(name="gceInstance")
    def gce_instance(self) -> Optional[pulumi.Input['GceInstanceArgs']]:
        """
        Specifies a Compute Engine instance as the host.
        """
        return pulumi.get(self, "gce_instance")

    @gce_instance.setter
    def gce_instance(self, value: Optional[pulumi.Input['GceInstanceArgs']]):
        pulumi.set(self, "gce_instance", value)


@pulumi.input_type
class PersistentDirectoryArgs:
    def __init__(__self__, *,
                 gce_pd: Optional[pulumi.Input['GceRegionalPersistentDiskArgs']] = None,
                 mount_path: Optional[pulumi.Input[str]] = None):
        """
        A directory to persist across workstation sessions.
        :param pulumi.Input['GceRegionalPersistentDiskArgs'] gce_pd: A PersistentDirectory backed by a Compute Engine persistent disk.
        :param pulumi.Input[str] mount_path: Location of this directory in the running workstation.
        """
        if gce_pd is not None:
            pulumi.set(__self__, "gce_pd", gce_pd)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="gcePd")
    def gce_pd(self) -> Optional[pulumi.Input['GceRegionalPersistentDiskArgs']]:
        """
        A PersistentDirectory backed by a Compute Engine persistent disk.
        """
        return pulumi.get(self, "gce_pd")

    @gce_pd.setter
    def gce_pd(self, value: Optional[pulumi.Input['GceRegionalPersistentDiskArgs']]):
        pulumi.set(self, "gce_pd", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Location of this directory in the running workstation.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)


@pulumi.input_type
class PrivateClusterConfigArgs:
    def __init__(__self__, *,
                 allowed_projects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_private_endpoint: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for private clusters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_projects: Additional projects that are allowed to attach to the workstation cluster's service attachment. By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        :param pulumi.Input[bool] enable_private_endpoint: Immutable. Whether Workstations endpoint is private.
        """
        if allowed_projects is not None:
            pulumi.set(__self__, "allowed_projects", allowed_projects)
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)

    @property
    @pulumi.getter(name="allowedProjects")
    def allowed_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional projects that are allowed to attach to the workstation cluster's service attachment. By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        """
        return pulumi.get(self, "allowed_projects")

    @allowed_projects.setter
    def allowed_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_projects", value)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Immutable. Whether Workstations endpoint is private.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @enable_private_endpoint.setter
    def enable_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_endpoint", value)


