# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EvaluationArgs', 'Evaluation']

@pulumi.input_type
class EvaluationArgs:
    def __init__(__self__, *,
                 evaluation_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_filter: Optional[pulumi.Input['ResourceFilterArgs']] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Evaluation resource.
        :param pulumi.Input[str] evaluation_id: Required. Id of the requesting object If auto-generating Id server-side, remove this field and evaluation_id from the method_signature of Create RPC
        :param pulumi.Input[str] description: Description of the Evaluation
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs
        :param pulumi.Input[str] name: name of resource names have the form 'projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}'
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input['ResourceFilterArgs'] resource_filter: annotations as key value pairs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: the name of the rule
        """
        pulumi.set(__self__, "evaluation_id", evaluation_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if resource_filter is not None:
            pulumi.set(__self__, "resource_filter", resource_filter)
        if rule_names is not None:
            pulumi.set(__self__, "rule_names", rule_names)

    @property
    @pulumi.getter(name="evaluationId")
    def evaluation_id(self) -> pulumi.Input[str]:
        """
        Required. Id of the requesting object If auto-generating Id server-side, remove this field and evaluation_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "evaluation_id")

    @evaluation_id.setter
    def evaluation_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "evaluation_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Evaluation
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of resource names have the form 'projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="resourceFilter")
    def resource_filter(self) -> Optional[pulumi.Input['ResourceFilterArgs']]:
        """
        annotations as key value pairs
        """
        return pulumi.get(self, "resource_filter")

    @resource_filter.setter
    def resource_filter(self, value: Optional[pulumi.Input['ResourceFilterArgs']]):
        pulumi.set(self, "resource_filter", value)

    @property
    @pulumi.getter(name="ruleNames")
    def rule_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the name of the rule
        """
        return pulumi.get(self, "rule_names")

    @rule_names.setter
    def rule_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rule_names", value)


class Evaluation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_filter: Optional[pulumi.Input[pulumi.InputType['ResourceFilterArgs']]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a new Evaluation in a given project and location.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the Evaluation
        :param pulumi.Input[str] evaluation_id: Required. Id of the requesting object If auto-generating Id server-side, remove this field and evaluation_id from the method_signature of Create RPC
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs
        :param pulumi.Input[str] name: name of resource names have the form 'projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}'
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[pulumi.InputType['ResourceFilterArgs']] resource_filter: annotations as key value pairs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: the name of the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EvaluationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Evaluation in a given project and location.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param EvaluationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EvaluationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_filter: Optional[pulumi.Input[pulumi.InputType['ResourceFilterArgs']]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EvaluationArgs.__new__(EvaluationArgs)

            __props__.__dict__["description"] = description
            if evaluation_id is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_id'")
            __props__.__dict__["evaluation_id"] = evaluation_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["resource_filter"] = resource_filter
            __props__.__dict__["rule_names"] = rule_names
            __props__.__dict__["create_time"] = None
            __props__.__dict__["resource_status"] = None
            __props__.__dict__["rule_versions"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["evaluation_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Evaluation, __self__).__init__(
            'google-native:workloadmanager/v1:Evaluation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Evaluation':
        """
        Get an existing Evaluation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EvaluationArgs.__new__(EvaluationArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["evaluation_id"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["resource_filter"] = None
        __props__.__dict__["resource_status"] = None
        __props__.__dict__["rule_names"] = None
        __props__.__dict__["rule_versions"] = None
        __props__.__dict__["update_time"] = None
        return Evaluation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        [Output only] Create time stamp
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the Evaluation
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationId")
    def evaluation_id(self) -> pulumi.Output[str]:
        """
        Required. Id of the requesting object If auto-generating Id server-side, remove this field and evaluation_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "evaluation_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels as key value pairs
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of resource names have the form 'projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resourceFilter")
    def resource_filter(self) -> pulumi.Output['outputs.ResourceFilterResponse']:
        """
        annotations as key value pairs
        """
        return pulumi.get(self, "resource_filter")

    @property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> pulumi.Output['outputs.ResourceStatusResponse']:
        """
        [Output only] The updated rule ids if exist.
        """
        return pulumi.get(self, "resource_status")

    @property
    @pulumi.getter(name="ruleNames")
    def rule_names(self) -> pulumi.Output[Sequence[str]]:
        """
        the name of the rule
        """
        return pulumi.get(self, "rule_names")

    @property
    @pulumi.getter(name="ruleVersions")
    def rule_versions(self) -> pulumi.Output[Sequence[str]]:
        """
        [Output only] The updated rule ids if exist.
        """
        return pulumi.get(self, "rule_versions")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        [Output only] Update time stamp
        """
        return pulumi.get(self, "update_time")

