# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GceInstanceFilterArgs',
    'ResourceFilterArgs',
]

@pulumi.input_type
class GceInstanceFilterArgs:
    def __init__(__self__, *,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Message describing compute engine instance filter
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_accounts: Service account of compute engine
        """
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Service account of compute engine
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_accounts", value)


@pulumi.input_type
class ResourceFilterArgs:
    def __init__(__self__, *,
                 gce_instance_filter: Optional[pulumi.Input['GceInstanceFilterArgs']] = None,
                 inclusion_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_id_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Message describing resource filters
        :param pulumi.Input['GceInstanceFilterArgs'] gce_instance_filter: Filter compute engine resource
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] inclusion_labels: The label used for filter resource
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_id_patterns: The id pattern for filter resource
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The scopes of evaluation resource
        """
        if gce_instance_filter is not None:
            pulumi.set(__self__, "gce_instance_filter", gce_instance_filter)
        if inclusion_labels is not None:
            pulumi.set(__self__, "inclusion_labels", inclusion_labels)
        if resource_id_patterns is not None:
            pulumi.set(__self__, "resource_id_patterns", resource_id_patterns)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="gceInstanceFilter")
    def gce_instance_filter(self) -> Optional[pulumi.Input['GceInstanceFilterArgs']]:
        """
        Filter compute engine resource
        """
        return pulumi.get(self, "gce_instance_filter")

    @gce_instance_filter.setter
    def gce_instance_filter(self, value: Optional[pulumi.Input['GceInstanceFilterArgs']]):
        pulumi.set(self, "gce_instance_filter", value)

    @property
    @pulumi.getter(name="inclusionLabels")
    def inclusion_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The label used for filter resource
        """
        return pulumi.get(self, "inclusion_labels")

    @inclusion_labels.setter
    def inclusion_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "inclusion_labels", value)

    @property
    @pulumi.getter(name="resourceIdPatterns")
    def resource_id_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id pattern for filter resource
        """
        return pulumi.get(self, "resource_id_patterns")

    @resource_id_patterns.setter
    def resource_id_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_id_patterns", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The scopes of evaluation resource
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


