# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['QueuedResourceArgs', 'QueuedResource']

@pulumi.input_type
class QueuedResourceArgs:
    def __init__(__self__, *,
                 best_effort: Optional[pulumi.Input['BestEffortArgs']] = None,
                 guaranteed: Optional[pulumi.Input['GuaranteedArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 queued_resource_id: Optional[pulumi.Input[str]] = None,
                 queueing_policy: Optional[pulumi.Input['QueueingPolicyArgs']] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 tpu: Optional[pulumi.Input['TpuArgs']] = None):
        """
        The set of arguments for constructing a QueuedResource resource.
        :param pulumi.Input['BestEffortArgs'] best_effort: The BestEffort tier.
        :param pulumi.Input['GuaranteedArgs'] guaranteed: The Guaranteed tier
        :param pulumi.Input[str] queued_resource_id: The unqualified resource name. Should follow the ^[A-Za-z0-9_.~+%-]+$ regex format.
        :param pulumi.Input['QueueingPolicyArgs'] queueing_policy: The queueing policy of the QueuedRequest.
        :param pulumi.Input[str] request_id: Idempotent request UUID.
        :param pulumi.Input['TpuArgs'] tpu: Defines a TPU resource.
        """
        if best_effort is not None:
            pulumi.set(__self__, "best_effort", best_effort)
        if guaranteed is not None:
            pulumi.set(__self__, "guaranteed", guaranteed)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if queued_resource_id is not None:
            pulumi.set(__self__, "queued_resource_id", queued_resource_id)
        if queueing_policy is not None:
            pulumi.set(__self__, "queueing_policy", queueing_policy)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if tpu is not None:
            pulumi.set(__self__, "tpu", tpu)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> Optional[pulumi.Input['BestEffortArgs']]:
        """
        The BestEffort tier.
        """
        return pulumi.get(self, "best_effort")

    @best_effort.setter
    def best_effort(self, value: Optional[pulumi.Input['BestEffortArgs']]):
        pulumi.set(self, "best_effort", value)

    @property
    @pulumi.getter
    def guaranteed(self) -> Optional[pulumi.Input['GuaranteedArgs']]:
        """
        The Guaranteed tier
        """
        return pulumi.get(self, "guaranteed")

    @guaranteed.setter
    def guaranteed(self, value: Optional[pulumi.Input['GuaranteedArgs']]):
        pulumi.set(self, "guaranteed", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="queuedResourceId")
    def queued_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unqualified resource name. Should follow the ^[A-Za-z0-9_.~+%-]+$ regex format.
        """
        return pulumi.get(self, "queued_resource_id")

    @queued_resource_id.setter
    def queued_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queued_resource_id", value)

    @property
    @pulumi.getter(name="queueingPolicy")
    def queueing_policy(self) -> Optional[pulumi.Input['QueueingPolicyArgs']]:
        """
        The queueing policy of the QueuedRequest.
        """
        return pulumi.get(self, "queueing_policy")

    @queueing_policy.setter
    def queueing_policy(self, value: Optional[pulumi.Input['QueueingPolicyArgs']]):
        pulumi.set(self, "queueing_policy", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Idempotent request UUID.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter
    def tpu(self) -> Optional[pulumi.Input['TpuArgs']]:
        """
        Defines a TPU resource.
        """
        return pulumi.get(self, "tpu")

    @tpu.setter
    def tpu(self, value: Optional[pulumi.Input['TpuArgs']]):
        pulumi.set(self, "tpu", value)


class QueuedResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 best_effort: Optional[pulumi.Input[pulumi.InputType['BestEffortArgs']]] = None,
                 guaranteed: Optional[pulumi.Input[pulumi.InputType['GuaranteedArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 queued_resource_id: Optional[pulumi.Input[str]] = None,
                 queueing_policy: Optional[pulumi.Input[pulumi.InputType['QueueingPolicyArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 tpu: Optional[pulumi.Input[pulumi.InputType['TpuArgs']]] = None,
                 __props__=None):
        """
        Creates a QueuedResource TPU instance.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BestEffortArgs']] best_effort: The BestEffort tier.
        :param pulumi.Input[pulumi.InputType['GuaranteedArgs']] guaranteed: The Guaranteed tier
        :param pulumi.Input[str] queued_resource_id: The unqualified resource name. Should follow the ^[A-Za-z0-9_.~+%-]+$ regex format.
        :param pulumi.Input[pulumi.InputType['QueueingPolicyArgs']] queueing_policy: The queueing policy of the QueuedRequest.
        :param pulumi.Input[str] request_id: Idempotent request UUID.
        :param pulumi.Input[pulumi.InputType['TpuArgs']] tpu: Defines a TPU resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QueuedResourceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a QueuedResource TPU instance.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param QueuedResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueuedResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 best_effort: Optional[pulumi.Input[pulumi.InputType['BestEffortArgs']]] = None,
                 guaranteed: Optional[pulumi.Input[pulumi.InputType['GuaranteedArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 queued_resource_id: Optional[pulumi.Input[str]] = None,
                 queueing_policy: Optional[pulumi.Input[pulumi.InputType['QueueingPolicyArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 tpu: Optional[pulumi.Input[pulumi.InputType['TpuArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueuedResourceArgs.__new__(QueuedResourceArgs)

            __props__.__dict__["best_effort"] = best_effort
            __props__.__dict__["guaranteed"] = guaranteed
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["queued_resource_id"] = queued_resource_id
            __props__.__dict__["queueing_policy"] = queueing_policy
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["tpu"] = tpu
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(QueuedResource, __self__).__init__(
            'google-native:tpu/v2alpha1:QueuedResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'QueuedResource':
        """
        Get an existing QueuedResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueuedResourceArgs.__new__(QueuedResourceArgs)

        __props__.__dict__["best_effort"] = None
        __props__.__dict__["guaranteed"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["queued_resource_id"] = None
        __props__.__dict__["queueing_policy"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tpu"] = None
        return QueuedResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> pulumi.Output['outputs.BestEffortResponse']:
        """
        The BestEffort tier.
        """
        return pulumi.get(self, "best_effort")

    @property
    @pulumi.getter
    def guaranteed(self) -> pulumi.Output['outputs.GuaranteedResponse']:
        """
        The Guaranteed tier
        """
        return pulumi.get(self, "guaranteed")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the QueuedResource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="queuedResourceId")
    def queued_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unqualified resource name. Should follow the ^[A-Za-z0-9_.~+%-]+$ regex format.
        """
        return pulumi.get(self, "queued_resource_id")

    @property
    @pulumi.getter(name="queueingPolicy")
    def queueing_policy(self) -> pulumi.Output['outputs.QueueingPolicyResponse']:
        """
        The queueing policy of the QueuedRequest.
        """
        return pulumi.get(self, "queueing_policy")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Idempotent request UUID.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['outputs.QueuedResourceStateResponse']:
        """
        State of the QueuedResource request
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tpu(self) -> pulumi.Output['outputs.TpuResponse']:
        """
        Defines a TPU resource.
        """
        return pulumi.get(self, "tpu")

