# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetQueuedResourceResult',
    'AwaitableGetQueuedResourceResult',
    'get_queued_resource',
    'get_queued_resource_output',
]

@pulumi.output_type
class GetQueuedResourceResult:
    def __init__(__self__, best_effort=None, guaranteed=None, name=None, queueing_policy=None, state=None, tpu=None):
        if best_effort and not isinstance(best_effort, dict):
            raise TypeError("Expected argument 'best_effort' to be a dict")
        pulumi.set(__self__, "best_effort", best_effort)
        if guaranteed and not isinstance(guaranteed, dict):
            raise TypeError("Expected argument 'guaranteed' to be a dict")
        pulumi.set(__self__, "guaranteed", guaranteed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if queueing_policy and not isinstance(queueing_policy, dict):
            raise TypeError("Expected argument 'queueing_policy' to be a dict")
        pulumi.set(__self__, "queueing_policy", queueing_policy)
        if state and not isinstance(state, dict):
            raise TypeError("Expected argument 'state' to be a dict")
        pulumi.set(__self__, "state", state)
        if tpu and not isinstance(tpu, dict):
            raise TypeError("Expected argument 'tpu' to be a dict")
        pulumi.set(__self__, "tpu", tpu)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> 'outputs.BestEffortResponse':
        """
        The BestEffort tier.
        """
        return pulumi.get(self, "best_effort")

    @property
    @pulumi.getter
    def guaranteed(self) -> 'outputs.GuaranteedResponse':
        """
        The Guaranteed tier
        """
        return pulumi.get(self, "guaranteed")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The name of the QueuedResource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queueingPolicy")
    def queueing_policy(self) -> 'outputs.QueueingPolicyResponse':
        """
        The queueing policy of the QueuedRequest.
        """
        return pulumi.get(self, "queueing_policy")

    @property
    @pulumi.getter
    def state(self) -> 'outputs.QueuedResourceStateResponse':
        """
        State of the QueuedResource request
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tpu(self) -> 'outputs.TpuResponse':
        """
        Defines a TPU resource.
        """
        return pulumi.get(self, "tpu")


class AwaitableGetQueuedResourceResult(GetQueuedResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueuedResourceResult(
            best_effort=self.best_effort,
            guaranteed=self.guaranteed,
            name=self.name,
            queueing_policy=self.queueing_policy,
            state=self.state,
            tpu=self.tpu)


def get_queued_resource(location: Optional[str] = None,
                        project: Optional[str] = None,
                        queued_resource_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueuedResourceResult:
    """
    Gets details of a queued resource.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['queuedResourceId'] = queued_resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:tpu/v2alpha1:getQueuedResource', __args__, opts=opts, typ=GetQueuedResourceResult).value

    return AwaitableGetQueuedResourceResult(
        best_effort=__ret__.best_effort,
        guaranteed=__ret__.guaranteed,
        name=__ret__.name,
        queueing_policy=__ret__.queueing_policy,
        state=__ret__.state,
        tpu=__ret__.tpu)


@_utilities.lift_output_func(get_queued_resource)
def get_queued_resource_output(location: Optional[pulumi.Input[str]] = None,
                               project: Optional[pulumi.Input[Optional[str]]] = None,
                               queued_resource_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueuedResourceResult]:
    """
    Gets details of a queued resource.
    """
    ...
