# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AcceleratorConfigArgs',
    'AttachedDiskArgs',
    'BestEffortArgs',
    'GuaranteedArgs',
    'IntervalArgs',
    'NetworkConfigArgs',
    'NodeSpecArgs',
    'NodeArgs',
    'QueueingPolicyArgs',
    'SchedulingConfigArgs',
    'ServiceAccountArgs',
    'ShieldedInstanceConfigArgs',
    'TpuArgs',
]

@pulumi.input_type
class AcceleratorConfigArgs:
    def __init__(__self__, *,
                 topology: pulumi.Input[str],
                 type: pulumi.Input['AcceleratorConfigType']):
        """
        A TPU accelerator configuration.
        :param pulumi.Input[str] topology: Topology of TPU in chips.
        :param pulumi.Input['AcceleratorConfigType'] type: Type of TPU.
        """
        pulumi.set(__self__, "topology", topology)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def topology(self) -> pulumi.Input[str]:
        """
        Topology of TPU in chips.
        """
        return pulumi.get(self, "topology")

    @topology.setter
    def topology(self, value: pulumi.Input[str]):
        pulumi.set(self, "topology", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AcceleratorConfigType']:
        """
        Type of TPU.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AcceleratorConfigType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AttachedDiskArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['AttachedDiskMode']] = None,
                 source_disk: Optional[pulumi.Input[str]] = None):
        """
        A node-attached disk resource. Next ID: 8;
        :param pulumi.Input['AttachedDiskMode'] mode: The mode in which to attach this disk. If not specified, the default is READ_WRITE mode. Only applicable to data_disks.
        :param pulumi.Input[str] source_disk: Specifies the full path to an existing disk. For example: "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['AttachedDiskMode']]:
        """
        The mode in which to attach this disk. If not specified, the default is READ_WRITE mode. Only applicable to data_disks.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['AttachedDiskMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the full path to an existing disk. For example: "projects/my-project/zones/us-central1-c/disks/my-disk".
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)


@pulumi.input_type
class BestEffortArgs:
    def __init__(__self__):
        """
        BestEffort tier definition.
        """
        pass


@pulumi.input_type
class GuaranteedArgs:
    def __init__(__self__, *,
                 min_duration: Optional[pulumi.Input[str]] = None,
                 reserved: Optional[pulumi.Input[bool]] = None):
        """
        Guaranteed tier definition.
        :param pulumi.Input[str] min_duration: Optional. Defines the minimum duration of the guarantee. If specified, the requested resources will only be provisioned if they can be allocated for at least the given duration.
        :param pulumi.Input[bool] reserved: Optional. Specifies the request should be scheduled on reserved capacity.
        """
        if min_duration is not None:
            pulumi.set(__self__, "min_duration", min_duration)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)

    @property
    @pulumi.getter(name="minDuration")
    def min_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Defines the minimum duration of the guarantee. If specified, the requested resources will only be provisioned if they can be allocated for at least the given duration.
        """
        return pulumi.get(self, "min_duration")

    @min_duration.setter
    def min_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_duration", value)

    @property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Specifies the request should be scheduled on reserved capacity.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reserved", value)


@pulumi.input_type
class IntervalArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a Timestamp end (exclusive). The start must be less than or equal to the end. When the start equals the end, the interval is empty (matches no time). When both start and end are unspecified, the interval matches any time.
        :param pulumi.Input[str] end_time: Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
        :param pulumi.Input[str] start_time: Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class NetworkConfigArgs:
    def __init__(__self__, *,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 enable_external_ips: Optional[pulumi.Input[bool]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        Network related configurations.
        :param pulumi.Input[bool] can_ip_forward: Allows the TPU node to send and receive packets with non-matching destination or source IPs. This is required if you plan to use the TPU workers to forward routes.
        :param pulumi.Input[bool] enable_external_ips: Indicates that external IP addresses would be associated with the TPU workers. If set to false, the specified subnetwork or network should have Private Google Access enabled.
        :param pulumi.Input[str] network: The name of the network for the TPU node. It must be a preexisting Google Compute Engine network. If none is provided, "default" will be used.
        :param pulumi.Input[str] subnetwork: The name of the subnetwork for the TPU node. It must be a preexisting Google Compute Engine subnetwork. If none is provided, "default" will be used.
        """
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if enable_external_ips is not None:
            pulumi.set(__self__, "enable_external_ips", enable_external_ips)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows the TPU node to send and receive packets with non-matching destination or source IPs. This is required if you plan to use the TPU workers to forward routes.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="enableExternalIps")
    def enable_external_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that external IP addresses would be associated with the TPU workers. If set to false, the specified subnetwork or network should have Private Google Access enabled.
        """
        return pulumi.get(self, "enable_external_ips")

    @enable_external_ips.setter
    def enable_external_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_external_ips", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network for the TPU node. It must be a preexisting Google Compute Engine network. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnetwork for the TPU node. It must be a preexisting Google Compute Engine subnetwork. If none is provided, "default" will be used.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class NodeSpecArgs:
    def __init__(__self__, *,
                 node: pulumi.Input['NodeArgs'],
                 parent: pulumi.Input[str],
                 node_id: Optional[pulumi.Input[str]] = None):
        """
        Details of the TPU node(s) being requested. Users can request either a single node or multiple nodes. NodeSpec provides the specification for node(s) to be created.
        :param pulumi.Input['NodeArgs'] node: The node.
        :param pulumi.Input[str] parent: The parent resource name.
        :param pulumi.Input[str] node_id: The unqualified resource name. Should follow the `^[A-Za-z0-9_.~+%-]+$` regex format. This is only specified when requesting a single node. In case of multi-node requests, multi_node_params must be populated instead. It's an error to specify both node_id and multi_node_params.
        """
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "parent", parent)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter
    def node(self) -> pulumi.Input['NodeArgs']:
        """
        The node.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: pulumi.Input['NodeArgs']):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        The parent resource name.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unqualified resource name. Should follow the `^[A-Za-z0-9_.~+%-]+$` regex format. This is only specified when requesting a single node. In case of multi-node requests, multi_node_params must be populated instead. It's an error to specify both node_id and multi_node_params.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_id", value)


@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 runtime_version: pulumi.Input[str],
                 accelerator_config: Optional[pulumi.Input['AcceleratorConfigArgs']] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health: Optional[pulumi.Input['NodeHealth']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network_config: Optional[pulumi.Input['NetworkConfigArgs']] = None,
                 scheduling_config: Optional[pulumi.Input['SchedulingConfigArgs']] = None,
                 service_account: Optional[pulumi.Input['ServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['ShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A TPU instance.
        :param pulumi.Input[str] runtime_version: The runtime version running in the Node.
        :param pulumi.Input['AcceleratorConfigArgs'] accelerator_config: The AccleratorConfig for the TPU Node.
        :param pulumi.Input[str] accelerator_type: The type of hardware accelerators associated with this node.
        :param pulumi.Input[str] cidr_block: The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger block would be wasteful (a node can only consume one IP address). Errors will occur if the CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts with any subnetworks in the user's provided network, or the provided network is peered with another network that is using that CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]] data_disks: The additional data disks for the Node.
        :param pulumi.Input[str] description: The user-supplied description of the TPU. Maximum of 512 characters.
        :param pulumi.Input['NodeHealth'] health: The health status of the TPU node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script
        :param pulumi.Input['NetworkConfigArgs'] network_config: Network configurations for the TPU node.
        :param pulumi.Input['SchedulingConfigArgs'] scheduling_config: The scheduling options for this node.
        :param pulumi.Input['ServiceAccountArgs'] service_account: The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is specified, the default compute service account will be used.
        :param pulumi.Input['ShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if scheduling_config is not None:
            pulumi.set(__self__, "scheduling_config", scheduling_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        The runtime version running in the Node.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional[pulumi.Input['AcceleratorConfigArgs']]:
        """
        The AccleratorConfig for the TPU Node.
        """
        return pulumi.get(self, "accelerator_config")

    @accelerator_config.setter
    def accelerator_config(self, value: Optional[pulumi.Input['AcceleratorConfigArgs']]):
        pulumi.set(self, "accelerator_config", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hardware accelerators associated with this node.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger block would be wasteful (a node can only consume one IP address). Errors will occur if the CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts with any subnetworks in the user's provided network, or the provided network is peered with another network that is using that CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]:
        """
        The additional data disks for the Node.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied description of the TPU. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input['NodeHealth']]:
        """
        The health status of the TPU node.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input['NodeHealth']]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user-provided metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom metadata to apply to the TPU Node. Can set startup-script and shutdown-script
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['NetworkConfigArgs']]:
        """
        Network configurations for the TPU node.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['NetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="schedulingConfig")
    def scheduling_config(self) -> Optional[pulumi.Input['SchedulingConfigArgs']]:
        """
        The scheduling options for this node.
        """
        return pulumi.get(self, "scheduling_config")

    @scheduling_config.setter
    def scheduling_config(self, value: Optional[pulumi.Input['SchedulingConfigArgs']]):
        pulumi.set(self, "scheduling_config", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['ServiceAccountArgs']]:
        """
        The Google Cloud Platform Service Account to be used by the TPU node VMs. If None is specified, the default compute service account will be used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['ServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ShieldedInstanceConfigArgs']]:
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to apply to the TPU Node. Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class QueueingPolicyArgs:
    def __init__(__self__, *,
                 valid_after_duration: Optional[pulumi.Input[str]] = None,
                 valid_after_time: Optional[pulumi.Input[str]] = None,
                 valid_interval: Optional[pulumi.Input['IntervalArgs']] = None,
                 valid_until_duration: Optional[pulumi.Input[str]] = None,
                 valid_until_time: Optional[pulumi.Input[str]] = None):
        """
        Defines the policy of the QueuedRequest.
        :param pulumi.Input[str] valid_after_duration: A relative time after which resources may be created.
        :param pulumi.Input[str] valid_after_time: An absolute time at which resources may be created.
        :param pulumi.Input['IntervalArgs'] valid_interval: An absolute time interval within which resources may be created.
        :param pulumi.Input[str] valid_until_duration: A relative time after which resources should not be created. If the request cannot be fulfilled by this time the request will be failed.
        :param pulumi.Input[str] valid_until_time: An absolute time after which resources should not be created. If the request cannot be fulfilled by this time the request will be failed.
        """
        if valid_after_duration is not None:
            pulumi.set(__self__, "valid_after_duration", valid_after_duration)
        if valid_after_time is not None:
            pulumi.set(__self__, "valid_after_time", valid_after_time)
        if valid_interval is not None:
            pulumi.set(__self__, "valid_interval", valid_interval)
        if valid_until_duration is not None:
            pulumi.set(__self__, "valid_until_duration", valid_until_duration)
        if valid_until_time is not None:
            pulumi.set(__self__, "valid_until_time", valid_until_time)

    @property
    @pulumi.getter(name="validAfterDuration")
    def valid_after_duration(self) -> Optional[pulumi.Input[str]]:
        """
        A relative time after which resources may be created.
        """
        return pulumi.get(self, "valid_after_duration")

    @valid_after_duration.setter
    def valid_after_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_after_duration", value)

    @property
    @pulumi.getter(name="validAfterTime")
    def valid_after_time(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute time at which resources may be created.
        """
        return pulumi.get(self, "valid_after_time")

    @valid_after_time.setter
    def valid_after_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_after_time", value)

    @property
    @pulumi.getter(name="validInterval")
    def valid_interval(self) -> Optional[pulumi.Input['IntervalArgs']]:
        """
        An absolute time interval within which resources may be created.
        """
        return pulumi.get(self, "valid_interval")

    @valid_interval.setter
    def valid_interval(self, value: Optional[pulumi.Input['IntervalArgs']]):
        pulumi.set(self, "valid_interval", value)

    @property
    @pulumi.getter(name="validUntilDuration")
    def valid_until_duration(self) -> Optional[pulumi.Input[str]]:
        """
        A relative time after which resources should not be created. If the request cannot be fulfilled by this time the request will be failed.
        """
        return pulumi.get(self, "valid_until_duration")

    @valid_until_duration.setter
    def valid_until_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_until_duration", value)

    @property
    @pulumi.getter(name="validUntilTime")
    def valid_until_time(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute time after which resources should not be created. If the request cannot be fulfilled by this time the request will be failed.
        """
        return pulumi.get(self, "valid_until_time")

    @valid_until_time.setter
    def valid_until_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_until_time", value)


@pulumi.input_type
class SchedulingConfigArgs:
    def __init__(__self__, *,
                 preemptible: Optional[pulumi.Input[bool]] = None,
                 reserved: Optional[pulumi.Input[bool]] = None):
        """
        Sets the scheduling options for this node.
        :param pulumi.Input[bool] preemptible: Defines whether the node is preemptible.
        :param pulumi.Input[bool] reserved: Whether the node is created under a reservation.
        """
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the node is preemptible.
        """
        return pulumi.get(self, "preemptible")

    @preemptible.setter
    def preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preemptible", value)

    @property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the node is created under a reservation.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reserved", value)


@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A service account.
        :param pulumi.Input[str] email: Email address of the service account. If empty, default Compute service account will be used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scope: The list of scopes to be made available for this service account. If empty, access to all Cloud APIs will be allowed.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the service account. If empty, default Compute service account will be used.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of scopes to be made available for this service account. If empty, access to all Cloud APIs will be allowed.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class ShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None):
        """
        A set of Shielded Instance options.
        :param pulumi.Input[bool] enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        """
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)


@pulumi.input_type
class TpuArgs:
    def __init__(__self__, *,
                 node_spec: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSpecArgs']]]] = None):
        """
        Details of the TPU resource(s) being requested.
        :param pulumi.Input[Sequence[pulumi.Input['NodeSpecArgs']]] node_spec: The TPU node(s) being requested.
        """
        if node_spec is not None:
            pulumi.set(__self__, "node_spec", node_spec)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeSpecArgs']]]]:
        """
        The TPU node(s) being requested.
        """
        return pulumi.get(self, "node_spec")

    @node_spec.setter
    def node_spec(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeSpecArgs']]]]):
        pulumi.set(self, "node_spec", value)


