# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AwsAccessKeyResponse',
    'AwsS3CompatibleDataResponse',
    'AwsS3DataResponse',
    'AzureBlobStorageDataResponse',
    'AzureCredentialsResponse',
    'BandwidthLimitResponse',
    'DateResponse',
    'EventStreamResponse',
    'GcsDataResponse',
    'HttpDataResponse',
    'LoggingConfigResponse',
    'MetadataOptionsResponse',
    'NotificationConfigResponse',
    'ObjectConditionsResponse',
    'PosixFilesystemResponse',
    'S3CompatibleMetadataResponse',
    'ScheduleResponse',
    'TimeOfDayResponse',
    'TransferManifestResponse',
    'TransferOptionsResponse',
    'TransferSpecResponse',
]

@pulumi.output_type
class AwsAccessKeyResponse(dict):
    """
    AWS access key (see [AWS Security Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)). For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsAccessKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsAccessKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsAccessKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 secret_access_key: str):
        """
        AWS access key (see [AWS Security Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)). For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str access_key_id: AWS access key ID.
        :param str secret_access_key: AWS secret access key. This field is not returned in RPC responses.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        AWS secret access key. This field is not returned in RPC responses.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class AwsS3CompatibleDataResponse(dict):
    """
    An AwsS3CompatibleData resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "s3Metadata":
            suggest = "s3_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsS3CompatibleDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsS3CompatibleDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsS3CompatibleDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 endpoint: str,
                 path: str,
                 region: str,
                 s3_metadata: 'outputs.S3CompatibleMetadataResponse'):
        """
        An AwsS3CompatibleData resource.
        :param str bucket_name: Specifies the name of the bucket.
        :param str endpoint: Specifies the endpoint of the storage service.
        :param str path: Specifies the root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param str region: Specifies the region to sign requests with. This can be left blank if requests should be signed with an empty region.
        :param 'S3CompatibleMetadataResponse' s3_metadata: A S3 compatible metadata.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "s3_metadata", s3_metadata)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Specifies the name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Specifies the endpoint of the storage service.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region to sign requests with. This can be left blank if requests should be signed with an empty region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="s3Metadata")
    def s3_metadata(self) -> 'outputs.S3CompatibleMetadataResponse':
        """
        A S3 compatible metadata.
        """
        return pulumi.get(self, "s3_metadata")


@pulumi.output_type
class AwsS3DataResponse(dict):
    """
    An AwsS3Data resource can be a data source, but not a data sink. In an AwsS3Data resource, an object's name is the S3 object's key name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccessKey":
            suggest = "aws_access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsS3DataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsS3DataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsS3DataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_access_key: 'outputs.AwsAccessKeyResponse',
                 bucket_name: str,
                 path: str,
                 role_arn: str):
        """
        An AwsS3Data resource can be a data source, but not a data sink. In an AwsS3Data resource, an object's name is the S3 object's key name.
        :param 'AwsAccessKeyResponse' aws_access_key: Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str bucket_name: S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param str role_arn: The Amazon Resource Name (ARN) of the role to support temporary credentials via `AssumeRoleWithWebIdentity`. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a `AssumeRoleWithWebIdentity` call for the provided role using the GoogleServiceAccount for this project.
        """
        pulumi.set(__self__, "aws_access_key", aws_access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> 'outputs.AwsAccessKeyResponse':
        """
        Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "aws_access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the role to support temporary credentials via `AssumeRoleWithWebIdentity`. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a `AssumeRoleWithWebIdentity` call for the provided role using the GoogleServiceAccount for this project.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AzureBlobStorageDataResponse(dict):
    """
    An AzureBlobStorageData resource can be a data source, but not a data sink. An AzureBlobStorageData resource represents one Azure container. The storage account determines the [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureCredentials":
            suggest = "azure_credentials"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobStorageDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobStorageDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobStorageDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_credentials: 'outputs.AzureCredentialsResponse',
                 container: str,
                 path: str,
                 storage_account: str):
        """
        An AzureBlobStorageData resource can be a data source, but not a data sink. An AzureBlobStorageData resource represents one Azure container. The storage account determines the [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
        :param 'AzureCredentialsResponse' azure_credentials: Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str container: The container to transfer from the Azure Storage account.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param str storage_account: The name of the Azure Storage account.
        """
        pulumi.set(__self__, "azure_credentials", azure_credentials)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> 'outputs.AzureCredentialsResponse':
        """
        Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "azure_credentials")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The container to transfer from the Azure Storage account.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> str:
        """
        The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")


@pulumi.output_type
class AzureCredentialsResponse(dict):
    """
    Azure credentials For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_token: str):
        """
        Azure credentials For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str sas_token: Azure shared access signature (SAS). For more information about SAS, see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        Azure shared access signature (SAS). For more information about SAS, see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class BandwidthLimitResponse(dict):
    """
    Specifies a bandwidth limit for an agent pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitMbps":
            suggest = "limit_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_mbps: str):
        """
        Specifies a bandwidth limit for an agent pool.
        :param str limit_mbps: Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        pulumi.set(__self__, "limit_mbps", limit_mbps)

    @property
    @pulumi.getter(name="limitMbps")
    def limit_mbps(self) -> str:
        """
        Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        return pulumi.get(self, "limit_mbps")


@pulumi.output_type
class DateResponse(dict):
    """
    Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class EventStreamResponse(dict):
    """
    Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventStreamExpirationTime":
            suggest = "event_stream_expiration_time"
        elif key == "eventStreamStartTime":
            suggest = "event_stream_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventStreamResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventStreamResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventStreamResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_stream_expiration_time: str,
                 event_stream_start_time: str,
                 name: str):
        """
        Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files.
        :param str event_stream_expiration_time: Specifies the data and time at which Storage Transfer Service stops listening for events from this stream. After this time, any transfers in progress will complete, but no new transfers are initiated.
        :param str event_stream_start_time: Specifies the date and time that Storage Transfer Service starts listening for events from this stream. If no start time is specified or start time is in the past, Storage Transfer Service starts listening immediately.
        :param str name: Specifies a unique name of the resource such as AWS SQS ARN in the form 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form 'projects/{project}/subscriptions/{sub}'.
        """
        pulumi.set(__self__, "event_stream_expiration_time", event_stream_expiration_time)
        pulumi.set(__self__, "event_stream_start_time", event_stream_start_time)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="eventStreamExpirationTime")
    def event_stream_expiration_time(self) -> str:
        """
        Specifies the data and time at which Storage Transfer Service stops listening for events from this stream. After this time, any transfers in progress will complete, but no new transfers are initiated.
        """
        return pulumi.get(self, "event_stream_expiration_time")

    @property
    @pulumi.getter(name="eventStreamStartTime")
    def event_stream_start_time(self) -> str:
        """
        Specifies the date and time that Storage Transfer Service starts listening for events from this stream. If no start time is specified or start time is in the past, Storage Transfer Service starts listening immediately.
        """
        return pulumi.get(self, "event_stream_start_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies a unique name of the resource such as AWS SQS ARN in the form 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form 'projects/{project}/subscriptions/{sub}'.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GcsDataResponse(dict):
    """
    In a GcsData resource, an object's name is the Cloud Storage object's name and its "last modification time" refers to the object's `updated` property of Cloud Storage objects, which changes when the content or the metadata of the object is updated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 path: str):
        """
        In a GcsData resource, an object's name is the Cloud Storage object's name and its "last modification time" refers to the object's `updated` property of Cloud Storage objects, which changes when the content or the metadata of the object is updated.
        :param str bucket_name: Cloud Storage bucket name. Must meet [Bucket Name Requirements](/storage/docs/naming#requirements).
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Cloud Storage bucket name. Must meet [Bucket Name Requirements](/storage/docs/naming#requirements).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class HttpDataResponse(dict):
    """
    An HttpData resource specifies a list of objects on the web to be transferred over HTTP. The information of the objects to be transferred is contained in a file referenced by a URL. The first line in the file must be `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent lines specify the information of the list of objects, one object per list entry. Each entry has the following tab-delimited fields: * **HTTP URL** — The location of the object. * **Length** — The size of the object in bytes. * **MD5** — The base64-encoded MD5 hash of the object. For an example of a valid TSV file, see [Transferring data from URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When transferring data based on a URL list, keep the following in mind: * When an object located at `http(s)://hostname:port/` is transferred to a data sink, the name of the object at the data sink is `/`. * If the specified size of an object does not match the actual size of the object fetched, the object is not transferred. * If the specified MD5 does not match the MD5 computed from the transferred bytes, the object transfer fails. * Ensure that each URL you specify is publicly accessible. For example, in Cloud Storage you can [share an object publicly] (/storage/docs/cloud-console#_sharingdata) and get a link to it. * Storage Transfer Service obeys `robots.txt` rules and requires the source HTTP server to support `Range` requests and to return a `Content-Length` header in each response. * ObjectConditions have no effect when filtering objects to transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listUrl":
            suggest = "list_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 list_url: str):
        """
        An HttpData resource specifies a list of objects on the web to be transferred over HTTP. The information of the objects to be transferred is contained in a file referenced by a URL. The first line in the file must be `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent lines specify the information of the list of objects, one object per list entry. Each entry has the following tab-delimited fields: * **HTTP URL** — The location of the object. * **Length** — The size of the object in bytes. * **MD5** — The base64-encoded MD5 hash of the object. For an example of a valid TSV file, see [Transferring data from URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When transferring data based on a URL list, keep the following in mind: * When an object located at `http(s)://hostname:port/` is transferred to a data sink, the name of the object at the data sink is `/`. * If the specified size of an object does not match the actual size of the object fetched, the object is not transferred. * If the specified MD5 does not match the MD5 computed from the transferred bytes, the object transfer fails. * Ensure that each URL you specify is publicly accessible. For example, in Cloud Storage you can [share an object publicly] (/storage/docs/cloud-console#_sharingdata) and get a link to it. * Storage Transfer Service obeys `robots.txt` rules and requires the source HTTP server to support `Range` requests and to return a `Content-Length` header in each response. * ObjectConditions have no effect when filtering objects to transfer.
        :param str list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> str:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")


@pulumi.output_type
class LoggingConfigResponse(dict):
    """
    Specifies the logging behavior for transfer operations. For cloud-to-cloud transfers, logs are sent to Cloud Logging. See [Read transfer logs](https://cloud.google.com/storage-transfer/docs/read-transfer-logs) for details. For transfers to or from a POSIX file system, logs are stored in the Cloud Storage bucket that is the source or sink of the transfer. See [Managing Transfer for on-premises jobs] (https://cloud.google.com/storage-transfer/docs/managing-on-prem-jobs#viewing-logs) for details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOnpremGcsTransferLogs":
            suggest = "enable_onprem_gcs_transfer_logs"
        elif key == "logActionStates":
            suggest = "log_action_states"
        elif key == "logActions":
            suggest = "log_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_onprem_gcs_transfer_logs: bool,
                 log_action_states: Sequence[str],
                 log_actions: Sequence[str]):
        """
        Specifies the logging behavior for transfer operations. For cloud-to-cloud transfers, logs are sent to Cloud Logging. See [Read transfer logs](https://cloud.google.com/storage-transfer/docs/read-transfer-logs) for details. For transfers to or from a POSIX file system, logs are stored in the Cloud Storage bucket that is the source or sink of the transfer. See [Managing Transfer for on-premises jobs] (https://cloud.google.com/storage-transfer/docs/managing-on-prem-jobs#viewing-logs) for details.
        :param bool enable_onprem_gcs_transfer_logs: For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        :param Sequence[str] log_action_states: States in which `log_actions` are logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        :param Sequence[str] log_actions: Specifies the actions to be logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        pulumi.set(__self__, "enable_onprem_gcs_transfer_logs", enable_onprem_gcs_transfer_logs)
        pulumi.set(__self__, "log_action_states", log_action_states)
        pulumi.set(__self__, "log_actions", log_actions)

    @property
    @pulumi.getter(name="enableOnpremGcsTransferLogs")
    def enable_onprem_gcs_transfer_logs(self) -> bool:
        """
        For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        """
        return pulumi.get(self, "enable_onprem_gcs_transfer_logs")

    @property
    @pulumi.getter(name="logActionStates")
    def log_action_states(self) -> Sequence[str]:
        """
        States in which `log_actions` are logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_action_states")

    @property
    @pulumi.getter(name="logActions")
    def log_actions(self) -> Sequence[str]:
        """
        Specifies the actions to be logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_actions")


@pulumi.output_type
class MetadataOptionsResponse(dict):
    """
    Specifies the metadata options for running a transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "storageClass":
            suggest = "storage_class"
        elif key == "temporaryHold":
            suggest = "temporary_hold"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl: str,
                 gid: str,
                 kms_key: str,
                 mode: str,
                 storage_class: str,
                 symlink: str,
                 temporary_hold: str,
                 time_created: str,
                 uid: str):
        """
        Specifies the metadata options for running a transfer.
        :param str acl: Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
        :param str gid: Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param str kms_key: Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
        :param str mode: Specifies how each file's mode attribute should be handled by the transfer. By default, mode is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param str storage_class: Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets. If unspecified, the default behavior is the same as STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
        :param str symlink: Specifies how symlinks should be handled by the transfer. By default, symlinks are not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param str temporary_hold: Specifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TEMPORARY_HOLD_PRESERVE.
        :param str time_created: Specifies how each object's `timeCreated` metadata is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TIME_CREATED_SKIP.
        :param str uid: Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "symlink", symlink)
        pulumi.set(__self__, "temporary_hold", temporary_hold)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def acl(self) -> str:
        """
        Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def gid(self) -> str:
        """
        Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Specifies how each file's mode attribute should be handled by the transfer. By default, mode is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets. If unspecified, the default behavior is the same as STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def symlink(self) -> str:
        """
        Specifies how symlinks should be handled by the transfer. By default, symlinks are not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "symlink")

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> str:
        """
        Specifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TEMPORARY_HOLD_PRESERVE.
        """
        return pulumi.get(self, "temporary_hold")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Specifies how each object's `timeCreated` metadata is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TIME_CREATED_SKIP.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    Specification to configure notifications published to Pub/Sub. Notifications are published to the customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The `PubsubMessage.data` contains a TransferOperation resource formatted according to the specified `PayloadFormat`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTypes":
            suggest = "event_types"
        elif key == "payloadFormat":
            suggest = "payload_format"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_types: Sequence[str],
                 payload_format: str,
                 pubsub_topic: str):
        """
        Specification to configure notifications published to Pub/Sub. Notifications are published to the customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The `PubsubMessage.data` contains a TransferOperation resource formatted according to the specified `PayloadFormat`.
        :param Sequence[str] event_types: Event types for which a notification is desired. If empty, send notifications for all event types.
        :param str payload_format: The desired format of the notification message payloads.
        :param str pubsub_topic: The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format results in an INVALID_ARGUMENT error.
        """
        pulumi.set(__self__, "event_types", event_types)
        pulumi.set(__self__, "payload_format", payload_format)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Sequence[str]:
        """
        Event types for which a notification is desired. If empty, send notifications for all event types.
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter(name="payloadFormat")
    def payload_format(self) -> str:
        """
        The desired format of the notification message payloads.
        """
        return pulumi.get(self, "payload_format")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format results in an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class ObjectConditionsResponse(dict):
    """
    Conditions that determine which objects are transferred. Applies only to Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last modification time" refers to the time of the last change to the object's content or metadata — specifically, this is the `updated` property of Cloud Storage objects, the `LastModified` field of S3 objects, and the `Last-Modified` header of Azure blobs. Transfers with a PosixFilesystem source or destination don't support `ObjectConditions`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includePrefixes":
            suggest = "include_prefixes"
        elif key == "lastModifiedBefore":
            suggest = "last_modified_before"
        elif key == "lastModifiedSince":
            suggest = "last_modified_since"
        elif key == "maxTimeElapsedSinceLastModification":
            suggest = "max_time_elapsed_since_last_modification"
        elif key == "minTimeElapsedSinceLastModification":
            suggest = "min_time_elapsed_since_last_modification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectConditionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectConditionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectConditionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_prefixes: Sequence[str],
                 include_prefixes: Sequence[str],
                 last_modified_before: str,
                 last_modified_since: str,
                 max_time_elapsed_since_last_modification: str,
                 min_time_elapsed_since_last_modification: str):
        """
        Conditions that determine which objects are transferred. Applies only to Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last modification time" refers to the time of the last change to the object's content or metadata — specifically, this is the `updated` property of Cloud Storage objects, the `LastModified` field of S3 objects, and the `Last-Modified` header of Azure blobs. Transfers with a PosixFilesystem source or destination don't support `ObjectConditions`.
        :param Sequence[str] exclude_prefixes: If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param Sequence[str] include_prefixes: If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param str last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred.
        :param str last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        :param str max_time_elapsed_since_last_modification: Ensures that objects are not transferred if a specific maximum time has elapsed since the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation`and the "last modification time" of the object is less than the value of max_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        :param str min_time_elapsed_since_last_modification: Ensures that objects are not transferred until a specific minimum time has elapsed after the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation` and the "last modification time" of the object is equal to or greater than the value of min_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        pulumi.set(__self__, "include_prefixes", include_prefixes)
        pulumi.set(__self__, "last_modified_before", last_modified_before)
        pulumi.set(__self__, "last_modified_since", last_modified_since)
        pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Sequence[str]:
        """
        If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "exclude_prefixes")

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Sequence[str]:
        """
        If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "include_prefixes")

    @property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> str:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred.
        """
        return pulumi.get(self, "last_modified_before")

    @property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> str:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        """
        return pulumi.get(self, "last_modified_since")

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> str:
        """
        Ensures that objects are not transferred if a specific maximum time has elapsed since the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation`and the "last modification time" of the object is less than the value of max_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> str:
        """
        Ensures that objects are not transferred until a specific minimum time has elapsed after the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation` and the "last modification time" of the object is equal to or greater than the value of min_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")


@pulumi.output_type
class PosixFilesystemResponse(dict):
    """
    A POSIX filesystem resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PosixFilesystemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PosixFilesystemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PosixFilesystemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 root_directory: str):
        """
        A POSIX filesystem resource.
        :param str root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class S3CompatibleMetadataResponse(dict):
    """
    S3CompatibleMetadata contains the metadata fields that apply to the basic types of S3-compatible data providers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "listApi":
            suggest = "list_api"
        elif key == "requestModel":
            suggest = "request_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in S3CompatibleMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        S3CompatibleMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        S3CompatibleMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_method: str,
                 list_api: str,
                 protocol: str,
                 request_model: str):
        """
        S3CompatibleMetadata contains the metadata fields that apply to the basic types of S3-compatible data providers.
        :param str auth_method: Specifies the authentication and authorization method used by the storage service. When not specified, Transfer Service will attempt to determine right auth method to use.
        :param str list_api: The Listing API to use for discovering objects. When not specified, Transfer Service will attempt to determine the right API to use.
        :param str protocol: Specifies the network protocol of the agent. When not specified, the default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
        :param str request_model: Specifies the API request model used to call the storage service. When not specified, the default value of RequestModel REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
        """
        pulumi.set(__self__, "auth_method", auth_method)
        pulumi.set(__self__, "list_api", list_api)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "request_model", request_model)

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> str:
        """
        Specifies the authentication and authorization method used by the storage service. When not specified, Transfer Service will attempt to determine right auth method to use.
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="listApi")
    def list_api(self) -> str:
        """
        The Listing API to use for discovering objects. When not specified, Transfer Service will attempt to determine the right API to use.
        """
        return pulumi.get(self, "list_api")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Specifies the network protocol of the agent. When not specified, the default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requestModel")
    def request_model(self) -> str:
        """
        Specifies the API request model used to call the storage service. When not specified, the default value of RequestModel REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
        """
        return pulumi.get(self, "request_model")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Transfers can be scheduled to recur or to run just once.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeOfDay":
            suggest = "end_time_of_day"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "scheduleEndDate":
            suggest = "schedule_end_date"
        elif key == "scheduleStartDate":
            suggest = "schedule_start_date"
        elif key == "startTimeOfDay":
            suggest = "start_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_of_day: 'outputs.TimeOfDayResponse',
                 repeat_interval: str,
                 schedule_end_date: 'outputs.DateResponse',
                 schedule_start_date: 'outputs.DateResponse',
                 start_time_of_day: 'outputs.TimeOfDayResponse'):
        """
        Transfers can be scheduled to recur or to run just once.
        :param 'TimeOfDayResponse' end_time_of_day: The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        :param str repeat_interval: Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        :param 'DateResponse' schedule_end_date: The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job runs each day at start_time_of_day through `schedule_end_date`.
        :param 'DateResponse' schedule_start_date: The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job starts later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it creates a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
        :param 'TimeOfDayResponse' start_time_of_day: The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        pulumi.set(__self__, "end_time_of_day", end_time_of_day)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="endTimeOfDay")
    def end_time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        """
        return pulumi.get(self, "end_time_of_day")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> str:
        """
        Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> 'outputs.DateResponse':
        """
        The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job runs each day at start_time_of_day through `schedule_end_date`.
        """
        return pulumi.get(self, "schedule_end_date")

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> 'outputs.DateResponse':
        """
        The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job starts later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it creates a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
        """
        return pulumi.get(self, "schedule_start_date")

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        return pulumi.get(self, "start_time_of_day")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TransferManifestResponse(dict):
    """
    Specifies where the manifest is located.
    """
    def __init__(__self__, *,
                 location: str):
        """
        Specifies where the manifest is located.
        :param str location: Specifies the path to the manifest in Cloud Storage. The Google-managed service account for the transfer must have `storage.objects.get` permission for this object. An example path is `gs://bucket_name/path/manifest.csv`.
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the path to the manifest in Cloud Storage. The Google-managed service account for the transfer must have `storage.objects.get` permission for this object. An example path is `gs://bucket_name/path/manifest.csv`.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class TransferOptionsResponse(dict):
    """
    TransferOptions define the actions to be performed on objects in a transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteObjectsFromSourceAfterTransfer":
            suggest = "delete_objects_from_source_after_transfer"
        elif key == "deleteObjectsUniqueInSink":
            suggest = "delete_objects_unique_in_sink"
        elif key == "metadataOptions":
            suggest = "metadata_options"
        elif key == "overwriteObjectsAlreadyExistingInSink":
            suggest = "overwrite_objects_already_existing_in_sink"
        elif key == "overwriteWhen":
            suggest = "overwrite_when"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: bool,
                 delete_objects_unique_in_sink: bool,
                 metadata_options: 'outputs.MetadataOptionsResponse',
                 overwrite_objects_already_existing_in_sink: bool,
                 overwrite_when: str):
        """
        TransferOptions define the actions to be performed on objects in a transfer.
        :param bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        :param bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        :param 'MetadataOptionsResponse' metadata_options: Represents the selected metadata options for a transfer job.
        :param bool overwrite_objects_already_existing_in_sink: When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source are overwritten with the source object.
        :param str overwrite_when: When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwrite_objects_already_existing_in_sink.
        """
        pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        pulumi.set(__self__, "metadata_options", metadata_options)
        pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)
        pulumi.set(__self__, "overwrite_when", overwrite_when)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> bool:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> bool:
        """
        Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> 'outputs.MetadataOptionsResponse':
        """
        Represents the selected metadata options for a transfer job.
        """
        return pulumi.get(self, "metadata_options")

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> bool:
        """
        When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source are overwritten with the source object.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @property
    @pulumi.getter(name="overwriteWhen")
    def overwrite_when(self) -> str:
        """
        When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwrite_objects_already_existing_in_sink.
        """
        return pulumi.get(self, "overwrite_when")


@pulumi.output_type
class TransferSpecResponse(dict):
    """
    Configuration for running a transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsS3CompatibleDataSource":
            suggest = "aws_s3_compatible_data_source"
        elif key == "awsS3DataSource":
            suggest = "aws_s3_data_source"
        elif key == "azureBlobStorageDataSource":
            suggest = "azure_blob_storage_data_source"
        elif key == "gcsDataSink":
            suggest = "gcs_data_sink"
        elif key == "gcsDataSource":
            suggest = "gcs_data_source"
        elif key == "gcsIntermediateDataLocation":
            suggest = "gcs_intermediate_data_location"
        elif key == "httpDataSource":
            suggest = "http_data_source"
        elif key == "objectConditions":
            suggest = "object_conditions"
        elif key == "posixDataSink":
            suggest = "posix_data_sink"
        elif key == "posixDataSource":
            suggest = "posix_data_source"
        elif key == "sinkAgentPoolName":
            suggest = "sink_agent_pool_name"
        elif key == "sourceAgentPoolName":
            suggest = "source_agent_pool_name"
        elif key == "transferManifest":
            suggest = "transfer_manifest"
        elif key == "transferOptions":
            suggest = "transfer_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_s3_compatible_data_source: 'outputs.AwsS3CompatibleDataResponse',
                 aws_s3_data_source: 'outputs.AwsS3DataResponse',
                 azure_blob_storage_data_source: 'outputs.AzureBlobStorageDataResponse',
                 gcs_data_sink: 'outputs.GcsDataResponse',
                 gcs_data_source: 'outputs.GcsDataResponse',
                 gcs_intermediate_data_location: 'outputs.GcsDataResponse',
                 http_data_source: 'outputs.HttpDataResponse',
                 object_conditions: 'outputs.ObjectConditionsResponse',
                 posix_data_sink: 'outputs.PosixFilesystemResponse',
                 posix_data_source: 'outputs.PosixFilesystemResponse',
                 sink_agent_pool_name: str,
                 source_agent_pool_name: str,
                 transfer_manifest: 'outputs.TransferManifestResponse',
                 transfer_options: 'outputs.TransferOptionsResponse'):
        """
        Configuration for running a transfer.
        :param 'AwsS3CompatibleDataResponse' aws_s3_compatible_data_source: An AWS S3 compatible data source.
        :param 'AwsS3DataResponse' aws_s3_data_source: An AWS S3 data source.
        :param 'AzureBlobStorageDataResponse' azure_blob_storage_data_source: An Azure Blob Storage data source.
        :param 'GcsDataResponse' gcs_data_sink: A Cloud Storage data sink.
        :param 'GcsDataResponse' gcs_data_source: A Cloud Storage data source.
        :param 'GcsDataResponse' gcs_intermediate_data_location: Cloud Storage intermediate data location.
        :param 'HttpDataResponse' http_data_source: An HTTP URL data source.
        :param 'ObjectConditionsResponse' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        :param 'PosixFilesystemResponse' posix_data_sink: A POSIX Filesystem data sink.
        :param 'PosixFilesystemResponse' posix_data_source: A POSIX Filesystem data source.
        :param str sink_agent_pool_name: Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        :param str source_agent_pool_name: Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        :param 'TransferManifestResponse' transfer_manifest: A manifest file provides a list of objects to be transferred from the data source. This field points to the location of the manifest file. Otherwise, the entire source bucket is used. ObjectConditions still apply.
        :param 'TransferOptionsResponse' transfer_options: If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        pulumi.set(__self__, "aws_s3_compatible_data_source", aws_s3_compatible_data_source)
        pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        pulumi.set(__self__, "gcs_intermediate_data_location", gcs_intermediate_data_location)
        pulumi.set(__self__, "http_data_source", http_data_source)
        pulumi.set(__self__, "object_conditions", object_conditions)
        pulumi.set(__self__, "posix_data_sink", posix_data_sink)
        pulumi.set(__self__, "posix_data_source", posix_data_source)
        pulumi.set(__self__, "sink_agent_pool_name", sink_agent_pool_name)
        pulumi.set(__self__, "source_agent_pool_name", source_agent_pool_name)
        pulumi.set(__self__, "transfer_manifest", transfer_manifest)
        pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3CompatibleDataSource")
    def aws_s3_compatible_data_source(self) -> 'outputs.AwsS3CompatibleDataResponse':
        """
        An AWS S3 compatible data source.
        """
        return pulumi.get(self, "aws_s3_compatible_data_source")

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> 'outputs.AwsS3DataResponse':
        """
        An AWS S3 data source.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> 'outputs.AzureBlobStorageDataResponse':
        """
        An Azure Blob Storage data source.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> 'outputs.GcsDataResponse':
        """
        A Cloud Storage data sink.
        """
        return pulumi.get(self, "gcs_data_sink")

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> 'outputs.GcsDataResponse':
        """
        A Cloud Storage data source.
        """
        return pulumi.get(self, "gcs_data_source")

    @property
    @pulumi.getter(name="gcsIntermediateDataLocation")
    def gcs_intermediate_data_location(self) -> 'outputs.GcsDataResponse':
        """
        Cloud Storage intermediate data location.
        """
        return pulumi.get(self, "gcs_intermediate_data_location")

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> 'outputs.HttpDataResponse':
        """
        An HTTP URL data source.
        """
        return pulumi.get(self, "http_data_source")

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> 'outputs.ObjectConditionsResponse':
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        """
        return pulumi.get(self, "object_conditions")

    @property
    @pulumi.getter(name="posixDataSink")
    def posix_data_sink(self) -> 'outputs.PosixFilesystemResponse':
        """
        A POSIX Filesystem data sink.
        """
        return pulumi.get(self, "posix_data_sink")

    @property
    @pulumi.getter(name="posixDataSource")
    def posix_data_source(self) -> 'outputs.PosixFilesystemResponse':
        """
        A POSIX Filesystem data source.
        """
        return pulumi.get(self, "posix_data_source")

    @property
    @pulumi.getter(name="sinkAgentPoolName")
    def sink_agent_pool_name(self) -> str:
        """
        Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        """
        return pulumi.get(self, "sink_agent_pool_name")

    @property
    @pulumi.getter(name="sourceAgentPoolName")
    def source_agent_pool_name(self) -> str:
        """
        Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        """
        return pulumi.get(self, "source_agent_pool_name")

    @property
    @pulumi.getter(name="transferManifest")
    def transfer_manifest(self) -> 'outputs.TransferManifestResponse':
        """
        A manifest file provides a list of objects to be transferred from the data source. This field points to the location of the manifest file. Otherwise, the entire source bucket is used. ObjectConditions still apply.
        """
        return pulumi.get(self, "transfer_manifest")

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> 'outputs.TransferOptionsResponse':
        """
        If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "transfer_options")


