# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTransferJobResult',
    'AwaitableGetTransferJobResult',
    'get_transfer_job',
    'get_transfer_job_output',
]

@pulumi.output_type
class GetTransferJobResult:
    def __init__(__self__, creation_time=None, deletion_time=None, description=None, event_stream=None, last_modification_time=None, latest_operation_name=None, logging_config=None, name=None, notification_config=None, project=None, schedule=None, status=None, transfer_spec=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if deletion_time and not isinstance(deletion_time, str):
            raise TypeError("Expected argument 'deletion_time' to be a str")
        pulumi.set(__self__, "deletion_time", deletion_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_stream and not isinstance(event_stream, dict):
            raise TypeError("Expected argument 'event_stream' to be a dict")
        pulumi.set(__self__, "event_stream", event_stream)
        if last_modification_time and not isinstance(last_modification_time, str):
            raise TypeError("Expected argument 'last_modification_time' to be a str")
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        if latest_operation_name and not isinstance(latest_operation_name, str):
            raise TypeError("Expected argument 'latest_operation_name' to be a str")
        pulumi.set(__self__, "latest_operation_name", latest_operation_name)
        if logging_config and not isinstance(logging_config, dict):
            raise TypeError("Expected argument 'logging_config' to be a dict")
        pulumi.set(__self__, "logging_config", logging_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_config and not isinstance(notification_config, dict):
            raise TypeError("Expected argument 'notification_config' to be a dict")
        pulumi.set(__self__, "notification_config", notification_config)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transfer_spec and not isinstance(transfer_spec, dict):
            raise TypeError("Expected argument 'transfer_spec' to be a dict")
        pulumi.set(__self__, "transfer_spec", transfer_spec)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The time that the transfer job was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> str:
        """
        The time that the transfer job was deleted.
        """
        return pulumi.get(self, "deletion_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description provided by the user for the job. Its max length is 1024 bytes when Unicode-encoded.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventStream")
    def event_stream(self) -> 'outputs.EventStreamResponse':
        """
        Specifies the event stream for the transfer job for event-driven transfers. When EventStream is specified, the Schedule fields are ignored.
        """
        return pulumi.get(self, "event_stream")

    @property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> str:
        """
        The time that the transfer job was last modified.
        """
        return pulumi.get(self, "last_modification_time")

    @property
    @pulumi.getter(name="latestOperationName")
    def latest_operation_name(self) -> str:
        """
        The name of the most recently started TransferOperation of this JobConfig. Present if a TransferOperation has been created for this JobConfig.
        """
        return pulumi.get(self, "latest_operation_name")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name (within the transfer project) assigned when the job is created. If this field is empty in a CreateTransferJobRequest, Storage Transfer Service assigns a unique name. Otherwise, the specified name is used as the unique name for this job. If the specified name is in use by a job, the creation request fails with an ALREADY_EXISTS error. This name must start with `"transferJobs/"` prefix and end with a letter or a number, and should be no more than 128 characters. For transfers involving PosixFilesystem, this name must start with `transferJobs/OPI` specifically. For all other transfer types, this name must not start with `transferJobs/OPI`. Non-PosixFilesystem example: `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"` PosixFilesystem example: `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"` Applications must not rely on the enforcement of naming requirements involving OPI. Invalid job names fail with an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.NotificationConfigResponse':
        """
        Notification configuration. This is not supported for transfers involving PosixFilesystem.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the Google Cloud project that owns the job.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.ScheduleResponse':
        """
        Specifies schedule for the transfer job. This is an optional field. When the field is not set, the job never executes a transfer, unless you invoke RunTransferJob or update the job to have a non-empty schedule.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job. This value MUST be specified for `CreateTransferJobRequests`. **Note:** The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transferSpec")
    def transfer_spec(self) -> 'outputs.TransferSpecResponse':
        """
        Transfer specification.
        """
        return pulumi.get(self, "transfer_spec")


class AwaitableGetTransferJobResult(GetTransferJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransferJobResult(
            creation_time=self.creation_time,
            deletion_time=self.deletion_time,
            description=self.description,
            event_stream=self.event_stream,
            last_modification_time=self.last_modification_time,
            latest_operation_name=self.latest_operation_name,
            logging_config=self.logging_config,
            name=self.name,
            notification_config=self.notification_config,
            project=self.project,
            schedule=self.schedule,
            status=self.status,
            transfer_spec=self.transfer_spec)


def get_transfer_job(project_id: Optional[str] = None,
                     transfer_job_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransferJobResult:
    """
    Gets a transfer job.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['transferJobId'] = transfer_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:storagetransfer/v1:getTransferJob', __args__, opts=opts, typ=GetTransferJobResult).value

    return AwaitableGetTransferJobResult(
        creation_time=__ret__.creation_time,
        deletion_time=__ret__.deletion_time,
        description=__ret__.description,
        event_stream=__ret__.event_stream,
        last_modification_time=__ret__.last_modification_time,
        latest_operation_name=__ret__.latest_operation_name,
        logging_config=__ret__.logging_config,
        name=__ret__.name,
        notification_config=__ret__.notification_config,
        project=__ret__.project,
        schedule=__ret__.schedule,
        status=__ret__.status,
        transfer_spec=__ret__.transfer_spec)


@_utilities.lift_output_func(get_transfer_job)
def get_transfer_job_output(project_id: Optional[pulumi.Input[str]] = None,
                            transfer_job_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransferJobResult]:
    """
    Gets a transfer job.
    """
    ...
