# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PhraseSetArgs', 'PhraseSet']

@pulumi.input_type
class PhraseSetArgs:
    def __init__(__self__, *,
                 phrase_set_id: pulumi.Input[str],
                 boost: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input['PhraseArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PhraseSet resource.
        :param pulumi.Input[str] phrase_set_id: The ID to use for the phrase set, which will become the final component of the phrase set's resource name. This value should restrict to letters, numbers, and hyphens, with the first character a letter, the last a letter or a number, and be 4-63 characters.
        :param pulumi.Input[float] boost: Hint Boost. Positive value will increase the probability that a specific phrase will be recognized over other similar sounding phrases. The higher the boost, the higher the chance of false positive recognition as well. Negative boost values would correspond to anti-biasing. Anti-biasing is not enabled, so negative boost will simply be ignored. Though `boost` can accept a wide range of positive values, most use cases are best served with values between 0 (exclusive) and 20. We recommend using a binary search approach to finding the optimal value for your use case as well as adding phrases both with and without boost to your requests.
        :param pulumi.Input[str] name: The resource name of the phrase set.
        :param pulumi.Input[Sequence[pulumi.Input['PhraseArgs']]] phrases: A list of word and phrases.
        """
        pulumi.set(__self__, "phrase_set_id", phrase_set_id)
        if boost is not None:
            pulumi.set(__self__, "boost", boost)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phrases is not None:
            pulumi.set(__self__, "phrases", phrases)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="phraseSetId")
    def phrase_set_id(self) -> pulumi.Input[str]:
        """
        The ID to use for the phrase set, which will become the final component of the phrase set's resource name. This value should restrict to letters, numbers, and hyphens, with the first character a letter, the last a letter or a number, and be 4-63 characters.
        """
        return pulumi.get(self, "phrase_set_id")

    @phrase_set_id.setter
    def phrase_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "phrase_set_id", value)

    @property
    @pulumi.getter
    def boost(self) -> Optional[pulumi.Input[float]]:
        """
        Hint Boost. Positive value will increase the probability that a specific phrase will be recognized over other similar sounding phrases. The higher the boost, the higher the chance of false positive recognition as well. Negative boost values would correspond to anti-biasing. Anti-biasing is not enabled, so negative boost will simply be ignored. Though `boost` can accept a wide range of positive values, most use cases are best served with values between 0 (exclusive) and 20. We recommend using a binary search approach to finding the optimal value for your use case as well as adding phrases both with and without boost to your requests.
        """
        return pulumi.get(self, "boost")

    @boost.setter
    def boost(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "boost", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the phrase set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PhraseArgs']]]]:
        """
        A list of word and phrases.
        """
        return pulumi.get(self, "phrases")

    @phrases.setter
    def phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PhraseArgs']]]]):
        pulumi.set(self, "phrases", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class PhraseSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrase_set_id: Optional[pulumi.Input[str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PhraseArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a set of phrase hints. Each item in the set can be a single word or a multi-word phrase. The items in the PhraseSet are favored by the recognition model when you send a call that includes the PhraseSet.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] boost: Hint Boost. Positive value will increase the probability that a specific phrase will be recognized over other similar sounding phrases. The higher the boost, the higher the chance of false positive recognition as well. Negative boost values would correspond to anti-biasing. Anti-biasing is not enabled, so negative boost will simply be ignored. Though `boost` can accept a wide range of positive values, most use cases are best served with values between 0 (exclusive) and 20. We recommend using a binary search approach to finding the optimal value for your use case as well as adding phrases both with and without boost to your requests.
        :param pulumi.Input[str] name: The resource name of the phrase set.
        :param pulumi.Input[str] phrase_set_id: The ID to use for the phrase set, which will become the final component of the phrase set's resource name. This value should restrict to letters, numbers, and hyphens, with the first character a letter, the last a letter or a number, and be 4-63 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PhraseArgs']]]] phrases: A list of word and phrases.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhraseSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a set of phrase hints. Each item in the set can be a single word or a multi-word phrase. The items in the PhraseSet are favored by the recognition model when you send a call that includes the PhraseSet.

        :param str resource_name: The name of the resource.
        :param PhraseSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhraseSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boost: Optional[pulumi.Input[float]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phrase_set_id: Optional[pulumi.Input[str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PhraseArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhraseSetArgs.__new__(PhraseSetArgs)

            __props__.__dict__["boost"] = boost
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if phrase_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'phrase_set_id'")
            __props__.__dict__["phrase_set_id"] = phrase_set_id
            __props__.__dict__["phrases"] = phrases
            __props__.__dict__["project"] = project
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PhraseSet, __self__).__init__(
            'google-native:speech/v1:PhraseSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PhraseSet':
        """
        Get an existing PhraseSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PhraseSetArgs.__new__(PhraseSetArgs)

        __props__.__dict__["boost"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["phrases"] = None
        __props__.__dict__["project"] = None
        return PhraseSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def boost(self) -> pulumi.Output[float]:
        """
        Hint Boost. Positive value will increase the probability that a specific phrase will be recognized over other similar sounding phrases. The higher the boost, the higher the chance of false positive recognition as well. Negative boost values would correspond to anti-biasing. Anti-biasing is not enabled, so negative boost will simply be ignored. Though `boost` can accept a wide range of positive values, most use cases are best served with values between 0 (exclusive) and 20. We recommend using a binary search approach to finding the optimal value for your use case as well as adding phrases both with and without boost to your requests.
        """
        return pulumi.get(self, "boost")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the phrase set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def phrases(self) -> pulumi.Output[Sequence['outputs.PhraseResponse']]:
        """
        A list of word and phrases.
        """
        return pulumi.get(self, "phrases")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

