# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    def __init__(__self__, annotations=None, binary_authorization=None, client=None, client_version=None, conditions=None, create_time=None, creator=None, delete_time=None, etag=None, execution_count=None, expire_time=None, generation=None, labels=None, last_modifier=None, latest_created_execution=None, launch_stage=None, name=None, observed_generation=None, reconciling=None, template=None, terminal_condition=None, uid=None, update_time=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if binary_authorization and not isinstance(binary_authorization, dict):
            raise TypeError("Expected argument 'binary_authorization' to be a dict")
        pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client and not isinstance(client, str):
            raise TypeError("Expected argument 'client' to be a str")
        pulumi.set(__self__, "client", client)
        if client_version and not isinstance(client_version, str):
            raise TypeError("Expected argument 'client_version' to be a str")
        pulumi.set(__self__, "client_version", client_version)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if execution_count and not isinstance(execution_count, int):
            raise TypeError("Expected argument 'execution_count' to be a int")
        pulumi.set(__self__, "execution_count", execution_count)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if generation and not isinstance(generation, str):
            raise TypeError("Expected argument 'generation' to be a str")
        pulumi.set(__self__, "generation", generation)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if last_modifier and not isinstance(last_modifier, str):
            raise TypeError("Expected argument 'last_modifier' to be a str")
        pulumi.set(__self__, "last_modifier", last_modifier)
        if latest_created_execution and not isinstance(latest_created_execution, dict):
            raise TypeError("Expected argument 'latest_created_execution' to be a dict")
        pulumi.set(__self__, "latest_created_execution", latest_created_execution)
        if launch_stage and not isinstance(launch_stage, str):
            raise TypeError("Expected argument 'launch_stage' to be a str")
        pulumi.set(__self__, "launch_stage", launch_stage)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if observed_generation and not isinstance(observed_generation, str):
            raise TypeError("Expected argument 'observed_generation' to be a str")
        pulumi.set(__self__, "observed_generation", observed_generation)
        if reconciling and not isinstance(reconciling, bool):
            raise TypeError("Expected argument 'reconciling' to be a bool")
        pulumi.set(__self__, "reconciling", reconciling)
        if template and not isinstance(template, dict):
            raise TypeError("Expected argument 'template' to be a dict")
        pulumi.set(__self__, "template", template)
        if terminal_condition and not isinstance(terminal_condition, dict):
            raise TypeError("Expected argument 'terminal_condition' to be a dict")
        pulumi.set(__self__, "terminal_condition", terminal_condition)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        KRM-style annotations for the resource. Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects. Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected. All system annotations in v1 now have a corresponding field in v2 Job. This field follows Kubernetes annotations' namespacing, limits, and rules. More info: https://kubernetes.io/docs/user-guide/annotations
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> 'outputs.GoogleCloudRunV2BinaryAuthorizationResponse':
        """
        Settings for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter
    def client(self) -> str:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> str:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GoogleCloudRunV2ConditionResponse']:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in `reconciling` for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> int:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        For a deleted resource, the time after which it will be permamently deleted.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        A number that monotonically increases every time the user modifies the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        KRM-style labels for the resource. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected. All system labels in v1 now have a corresponding field in v2 Job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> str:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @property
    @pulumi.getter(name="latestCreatedExecution")
    def latest_created_execution(self) -> 'outputs.GoogleCloudRunV2ExecutionReferenceResponse':
        """
        Name of the last created execution.
        """
        return pulumi.get(self, "latest_created_execution")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> str:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA is assumed.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified name of this Job. Format: projects/{project}/locations/{location}/jobs/{job}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> str:
        """
        The generation of this Job. See comments in `reconciling` for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def reconciling(self) -> bool:
        """
        Returns true if the Job is currently being acted upon by the system to bring it into the desired state. When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, `observed_generation` and `latest_succeeded_execution`, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in `terminal_condition.state`. If reconciliation succeeded, the following fields will match: `observed_generation` and `generation`, `latest_succeeded_execution` and `latest_created_execution`. If reconciliation failed, `observed_generation` and `latest_succeeded_execution` will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in `terminal_condition` and `conditions`.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.GoogleCloudRunV2ExecutionTemplateResponse':
        """
        The template used to create executions for this Job.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="terminalCondition")
    def terminal_condition(self) -> 'outputs.GoogleCloudRunV2ConditionResponse':
        """
        The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state.
        """
        return pulumi.get(self, "terminal_condition")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            annotations=self.annotations,
            binary_authorization=self.binary_authorization,
            client=self.client,
            client_version=self.client_version,
            conditions=self.conditions,
            create_time=self.create_time,
            creator=self.creator,
            delete_time=self.delete_time,
            etag=self.etag,
            execution_count=self.execution_count,
            expire_time=self.expire_time,
            generation=self.generation,
            labels=self.labels,
            last_modifier=self.last_modifier,
            latest_created_execution=self.latest_created_execution,
            launch_stage=self.launch_stage,
            name=self.name,
            observed_generation=self.observed_generation,
            reconciling=self.reconciling,
            template=self.template,
            terminal_condition=self.terminal_condition,
            uid=self.uid,
            update_time=self.update_time)


def get_job(job_id: Optional[str] = None,
            location: Optional[str] = None,
            project: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Gets information about a Job.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:run/v2:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        annotations=__ret__.annotations,
        binary_authorization=__ret__.binary_authorization,
        client=__ret__.client,
        client_version=__ret__.client_version,
        conditions=__ret__.conditions,
        create_time=__ret__.create_time,
        creator=__ret__.creator,
        delete_time=__ret__.delete_time,
        etag=__ret__.etag,
        execution_count=__ret__.execution_count,
        expire_time=__ret__.expire_time,
        generation=__ret__.generation,
        labels=__ret__.labels,
        last_modifier=__ret__.last_modifier,
        latest_created_execution=__ret__.latest_created_execution,
        launch_stage=__ret__.launch_stage,
        name=__ret__.name,
        observed_generation=__ret__.observed_generation,
        reconciling=__ret__.reconciling,
        template=__ret__.template,
        terminal_condition=__ret__.terminal_condition,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_job)
def get_job_output(job_id: Optional[pulumi.Input[str]] = None,
                   location: Optional[pulumi.Input[str]] = None,
                   project: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobResult]:
    """
    Gets information about a Job.
    """
    ...
