# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudRetailV2alphaAudienceResponse',
    'GoogleCloudRetailV2alphaColorInfoResponse',
    'GoogleCloudRetailV2alphaConditionQueryTermResponse',
    'GoogleCloudRetailV2alphaConditionResponse',
    'GoogleCloudRetailV2alphaConditionTimeRangeResponse',
    'GoogleCloudRetailV2alphaFulfillmentInfoResponse',
    'GoogleCloudRetailV2alphaImageResponse',
    'GoogleCloudRetailV2alphaIntervalResponse',
    'GoogleCloudRetailV2alphaLocalInventoryResponse',
    'GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse',
    'GoogleCloudRetailV2alphaPriceInfoResponse',
    'GoogleCloudRetailV2alphaProductResponse',
    'GoogleCloudRetailV2alphaPromotionResponse',
    'GoogleCloudRetailV2alphaRatingResponse',
    'GoogleCloudRetailV2alphaRuleBoostActionResponse',
    'GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse',
    'GoogleCloudRetailV2alphaRuleFilterActionResponse',
    'GoogleCloudRetailV2alphaRuleIgnoreActionResponse',
    'GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse',
    'GoogleCloudRetailV2alphaRuleRedirectActionResponse',
    'GoogleCloudRetailV2alphaRuleReplacementActionResponse',
    'GoogleCloudRetailV2alphaRuleResponse',
    'GoogleCloudRetailV2alphaRuleTwowaySynonymsActionResponse',
    'GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpecResponse',
    'GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse',
    'GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse',
    'GoogleCloudRetailV2alphaSearchRequestPersonalizationSpecResponse',
]

@pulumi.output_type
class GoogleCloudRetailV2alphaAudienceResponse(dict):
    """
    An intended audience of the Product for whom it's sold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ageGroups":
            suggest = "age_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaAudienceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaAudienceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaAudienceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 age_groups: Sequence[str],
                 genders: Sequence[str]):
        """
        An intended audience of the Product for whom it's sold.
        :param Sequence[str] age_groups: The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        :param Sequence[str] genders: The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        pulumi.set(__self__, "age_groups", age_groups)
        pulumi.set(__self__, "genders", genders)

    @property
    @pulumi.getter(name="ageGroups")
    def age_groups(self) -> Sequence[str]:
        """
        The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        """
        return pulumi.get(self, "age_groups")

    @property
    @pulumi.getter
    def genders(self) -> Sequence[str]:
        """
        The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        return pulumi.get(self, "genders")


@pulumi.output_type
class GoogleCloudRetailV2alphaColorInfoResponse(dict):
    """
    The color information of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colorFamilies":
            suggest = "color_families"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaColorInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaColorInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaColorInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color_families: Sequence[str],
                 colors: Sequence[str]):
        """
        The color information of a Product.
        :param Sequence[str] color_families: The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        :param Sequence[str] colors: The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        pulumi.set(__self__, "color_families", color_families)
        pulumi.set(__self__, "colors", colors)

    @property
    @pulumi.getter(name="colorFamilies")
    def color_families(self) -> Sequence[str]:
        """
        The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "color_families")

    @property
    @pulumi.getter
    def colors(self) -> Sequence[str]:
        """
        The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "colors")


@pulumi.output_type
class GoogleCloudRetailV2alphaConditionQueryTermResponse(dict):
    """
    Query terms that we want to match on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullMatch":
            suggest = "full_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaConditionQueryTermResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaConditionQueryTermResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaConditionQueryTermResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_match: bool,
                 value: str):
        """
        Query terms that we want to match on.
        :param bool full_match: Whether this is supposed to be a full or partial match.
        :param str value: The value of the term to match on. Value cannot be empty. Value can have at most 3 terms if specified as a partial match. Each space separated string is considered as one term. For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms and not allowed for a partial match.
        """
        pulumi.set(__self__, "full_match", full_match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="fullMatch")
    def full_match(self) -> bool:
        """
        Whether this is supposed to be a full or partial match.
        """
        return pulumi.get(self, "full_match")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the term to match on. Value cannot be empty. Value can have at most 3 terms if specified as a partial match. Each space separated string is considered as one term. For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms and not allowed for a partial match.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudRetailV2alphaConditionResponse(dict):
    """
    Metadata that is used to define a condition that triggers an action. A valid condition must specify at least one of 'query_terms' or 'products_filter'. If multiple fields are specified, the condition is met if all the fields are satisfied e.g. if a set of query terms and product_filter are set, then only items matching the product_filter for requests with a query matching the query terms wil get boosted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeTimeRange":
            suggest = "active_time_range"
        elif key == "queryTerms":
            suggest = "query_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_time_range: Sequence['outputs.GoogleCloudRetailV2alphaConditionTimeRangeResponse'],
                 query_terms: Sequence['outputs.GoogleCloudRetailV2alphaConditionQueryTermResponse']):
        """
        Metadata that is used to define a condition that triggers an action. A valid condition must specify at least one of 'query_terms' or 'products_filter'. If multiple fields are specified, the condition is met if all the fields are satisfied e.g. if a set of query terms and product_filter are set, then only items matching the product_filter for requests with a query matching the query terms wil get boosted.
        :param Sequence['GoogleCloudRetailV2alphaConditionTimeRangeResponse'] active_time_range: Range of time(s) specifying when Condition is active. Condition true if any time range matches.
        :param Sequence['GoogleCloudRetailV2alphaConditionQueryTermResponse'] query_terms: A list (up to 10 entries) of terms to match the query on. If not specified, match all queries. If many query terms are specified, the condition is matched if any of the terms is a match (i.e. using the OR operator).
        """
        pulumi.set(__self__, "active_time_range", active_time_range)
        pulumi.set(__self__, "query_terms", query_terms)

    @property
    @pulumi.getter(name="activeTimeRange")
    def active_time_range(self) -> Sequence['outputs.GoogleCloudRetailV2alphaConditionTimeRangeResponse']:
        """
        Range of time(s) specifying when Condition is active. Condition true if any time range matches.
        """
        return pulumi.get(self, "active_time_range")

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Sequence['outputs.GoogleCloudRetailV2alphaConditionQueryTermResponse']:
        """
        A list (up to 10 entries) of terms to match the query on. If not specified, match all queries. If many query terms are specified, the condition is matched if any of the terms is a match (i.e. using the OR operator).
        """
        return pulumi.get(self, "query_terms")


@pulumi.output_type
class GoogleCloudRetailV2alphaConditionTimeRangeResponse(dict):
    """
    Used for time-dependent conditions. Example: Want to have rule applied for week long sale.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaConditionTimeRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaConditionTimeRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaConditionTimeRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        Used for time-dependent conditions. Example: Want to have rule applied for week long sale.
        :param str end_time: End of time range. Range is inclusive.
        :param str start_time: Start of time range. Range is inclusive.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End of time range. Range is inclusive.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start of time range. Range is inclusive.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GoogleCloudRetailV2alphaFulfillmentInfoResponse(dict):
    """
    Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "placeIds":
            suggest = "place_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaFulfillmentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaFulfillmentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaFulfillmentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 place_ids: Sequence[str],
                 type: str):
        """
        Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods.
        :param Sequence[str] place_ids: The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        :param str type: The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        pulumi.set(__self__, "place_ids", place_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="placeIds")
    def place_ids(self) -> Sequence[str]:
        """
        The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "place_ids")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudRetailV2alphaImageResponse(dict):
    """
    Product image. Recommendations AI and Retail Search do not use product images to improve prediction and search results. However, product images can be returned in results, and are shown in prediction or search previews in the console.
    """
    def __init__(__self__, *,
                 height: int,
                 uri: str,
                 width: int):
        """
        Product image. Recommendations AI and Retail Search do not use product images to improve prediction and search results. However, product images can be returned in results, and are shown in prediction or search previews in the console.
        :param int height: Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param str uri: URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        :param int width: Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class GoogleCloudRetailV2alphaIntervalResponse(dict):
    """
    A floating point interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaIntervalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaIntervalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaIntervalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusive_maximum: float,
                 exclusive_minimum: float,
                 maximum: float,
                 minimum: float):
        """
        A floating point interval.
        :param float exclusive_maximum: Exclusive upper bound.
        :param float exclusive_minimum: Exclusive lower bound.
        :param float maximum: Inclusive upper bound.
        :param float minimum: Inclusive lower bound.
        """
        pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> float:
        """
        Exclusive upper bound.
        """
        return pulumi.get(self, "exclusive_maximum")

    @property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> float:
        """
        Exclusive lower bound.
        """
        return pulumi.get(self, "exclusive_minimum")

    @property
    @pulumi.getter
    def maximum(self) -> float:
        """
        Inclusive upper bound.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> float:
        """
        Inclusive lower bound.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GoogleCloudRetailV2alphaLocalInventoryResponse(dict):
    """
    The inventory information at a place (e.g. a store) identified by a place ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fulfillmentTypes":
            suggest = "fulfillment_types"
        elif key == "placeId":
            suggest = "place_id"
        elif key == "priceInfo":
            suggest = "price_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaLocalInventoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaLocalInventoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaLocalInventoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Mapping[str, str],
                 fulfillment_types: Sequence[str],
                 place_id: str,
                 price_info: 'outputs.GoogleCloudRetailV2alphaPriceInfoResponse'):
        """
        The inventory information at a place (e.g. a store) identified by a place ID.
        :param Mapping[str, str] attributes: Additional local inventory attributes, for example, store name, promotion tags, etc. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * At most 30 attributes are allowed. * The key must be a UTF-8 encoded string with a length limit of 32 characters. * The key must match the pattern: `a-zA-Z0-9*`. For example, key0LikeThis or KEY_1_LIKE_THIS. * The attribute values must be of the same type (text or number). * Only 1 value is allowed for each attribute. * For text values, the length limit is 256 UTF-8 characters. * The attribute does not support search. The `searchable` field should be unset or set to false. * The max summed total bytes of custom attribute keys and values per product is 5MiB.
        :param Sequence[str] fulfillment_types: Input only. Supported fulfillment types. Valid fulfillment type values include commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned. All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is returned.
        :param str place_id: The place ID for the current set of inventory information.
        :param 'GoogleCloudRetailV2alphaPriceInfoResponse' price_info: Product price and cost information. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "fulfillment_types", fulfillment_types)
        pulumi.set(__self__, "place_id", place_id)
        pulumi.set(__self__, "price_info", price_info)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, str]:
        """
        Additional local inventory attributes, for example, store name, promotion tags, etc. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * At most 30 attributes are allowed. * The key must be a UTF-8 encoded string with a length limit of 32 characters. * The key must match the pattern: `a-zA-Z0-9*`. For example, key0LikeThis or KEY_1_LIKE_THIS. * The attribute values must be of the same type (text or number). * Only 1 value is allowed for each attribute. * For text values, the length limit is 256 UTF-8 characters. * The attribute does not support search. The `searchable` field should be unset or set to false. * The max summed total bytes of custom attribute keys and values per product is 5MiB.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="fulfillmentTypes")
    def fulfillment_types(self) -> Sequence[str]:
        """
        Input only. Supported fulfillment types. Valid fulfillment type values include commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned. All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "fulfillment_types")

    @property
    @pulumi.getter(name="placeId")
    def place_id(self) -> str:
        """
        The place ID for the current set of inventory information.
        """
        return pulumi.get(self, "place_id")

    @property
    @pulumi.getter(name="priceInfo")
    def price_info(self) -> 'outputs.GoogleCloudRetailV2alphaPriceInfoResponse':
        """
        Product price and cost information. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        """
        return pulumi.get(self, "price_info")


@pulumi.output_type
class GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse(dict):
    """
    The price range of all variant Product having the same Product.primary_product_id.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originalPrice":
            suggest = "original_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 original_price: 'outputs.GoogleCloudRetailV2alphaIntervalResponse',
                 price: 'outputs.GoogleCloudRetailV2alphaIntervalResponse'):
        """
        The price range of all variant Product having the same Product.primary_product_id.
        :param 'GoogleCloudRetailV2alphaIntervalResponse' original_price: The inclusive Product.pricing_info.original_price internal of all variant Product having the same Product.primary_product_id.
        :param 'GoogleCloudRetailV2alphaIntervalResponse' price: The inclusive Product.pricing_info.price interval of all variant Product having the same Product.primary_product_id.
        """
        pulumi.set(__self__, "original_price", original_price)
        pulumi.set(__self__, "price", price)

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> 'outputs.GoogleCloudRetailV2alphaIntervalResponse':
        """
        The inclusive Product.pricing_info.original_price internal of all variant Product having the same Product.primary_product_id.
        """
        return pulumi.get(self, "original_price")

    @property
    @pulumi.getter
    def price(self) -> 'outputs.GoogleCloudRetailV2alphaIntervalResponse':
        """
        The inclusive Product.pricing_info.price interval of all variant Product having the same Product.primary_product_id.
        """
        return pulumi.get(self, "price")


@pulumi.output_type
class GoogleCloudRetailV2alphaPriceInfoResponse(dict):
    """
    The price information of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"
        elif key == "originalPrice":
            suggest = "original_price"
        elif key == "priceEffectiveTime":
            suggest = "price_effective_time"
        elif key == "priceExpireTime":
            suggest = "price_expire_time"
        elif key == "priceRange":
            suggest = "price_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaPriceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaPriceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaPriceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cost: float,
                 currency_code: str,
                 original_price: float,
                 price: float,
                 price_effective_time: str,
                 price_expire_time: str,
                 price_range: 'outputs.GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse'):
        """
        The price information of a Product.
        :param float cost: The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        :param str currency_code: The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        :param float original_price: Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        :param float price: Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        :param str price_effective_time: The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        :param str price_expire_time: The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        :param 'GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse' price_range: The price range of all the child Product.Type.VARIANT Products grouped together on the Product.Type.PRIMARY Product. Only populated for Product.Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        pulumi.set(__self__, "cost", cost)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "original_price", original_price)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "price_effective_time", price_effective_time)
        pulumi.set(__self__, "price_expire_time", price_expire_time)
        pulumi.set(__self__, "price_range", price_range)

    @property
    @pulumi.getter
    def cost(self) -> float:
        """
        The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        """
        return pulumi.get(self, "cost")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> float:
        """
        Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "original_price")

    @property
    @pulumi.getter
    def price(self) -> float:
        """
        Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        """
        return pulumi.get(self, "price")

    @property
    @pulumi.getter(name="priceEffectiveTime")
    def price_effective_time(self) -> str:
        """
        The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_effective_time")

    @property
    @pulumi.getter(name="priceExpireTime")
    def price_expire_time(self) -> str:
        """
        The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_expire_time")

    @property
    @pulumi.getter(name="priceRange")
    def price_range(self) -> 'outputs.GoogleCloudRetailV2alphaPriceInfoPriceRangeResponse':
        """
        The price range of all the child Product.Type.VARIANT Products grouped together on the Product.Type.PRIMARY Product. Only populated for Product.Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        return pulumi.get(self, "price_range")


@pulumi.output_type
class GoogleCloudRetailV2alphaProductResponse(dict):
    """
    Product captures all metadata information of items to be recommended or searched.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableQuantity":
            suggest = "available_quantity"
        elif key == "availableTime":
            suggest = "available_time"
        elif key == "collectionMemberIds":
            suggest = "collection_member_ids"
        elif key == "colorInfo":
            suggest = "color_info"
        elif key == "expireTime":
            suggest = "expire_time"
        elif key == "fulfillmentInfo":
            suggest = "fulfillment_info"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "localInventories":
            suggest = "local_inventories"
        elif key == "priceInfo":
            suggest = "price_info"
        elif key == "primaryProductId":
            suggest = "primary_product_id"
        elif key == "publishTime":
            suggest = "publish_time"
        elif key == "retrievableFields":
            suggest = "retrievable_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaProductResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaProductResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaProductResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Mapping[str, str],
                 audience: 'outputs.GoogleCloudRetailV2alphaAudienceResponse',
                 availability: str,
                 available_quantity: int,
                 available_time: str,
                 brands: Sequence[str],
                 categories: Sequence[str],
                 collection_member_ids: Sequence[str],
                 color_info: 'outputs.GoogleCloudRetailV2alphaColorInfoResponse',
                 conditions: Sequence[str],
                 description: str,
                 expire_time: str,
                 fulfillment_info: Sequence['outputs.GoogleCloudRetailV2alphaFulfillmentInfoResponse'],
                 gtin: str,
                 images: Sequence['outputs.GoogleCloudRetailV2alphaImageResponse'],
                 language_code: str,
                 local_inventories: Sequence['outputs.GoogleCloudRetailV2alphaLocalInventoryResponse'],
                 materials: Sequence[str],
                 name: str,
                 patterns: Sequence[str],
                 price_info: 'outputs.GoogleCloudRetailV2alphaPriceInfoResponse',
                 primary_product_id: str,
                 promotions: Sequence['outputs.GoogleCloudRetailV2alphaPromotionResponse'],
                 publish_time: str,
                 rating: 'outputs.GoogleCloudRetailV2alphaRatingResponse',
                 retrievable_fields: str,
                 sizes: Sequence[str],
                 tags: Sequence[str],
                 title: str,
                 ttl: str,
                 type: str,
                 uri: str,
                 variants: Sequence['outputs.GoogleCloudRetailV2alphaProductResponse']):
        """
        Product captures all metadata information of items to be recommended or searched.
        :param Mapping[str, str] attributes: Highly encouraged. Extra product attributes to be included. For example, for products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the attributes here. Features that can take on one of a limited number of possible values. Two types of features can be set are: Textual features. some examples would be the brand/maker of a product, or country of a customer. Numerical features. Some examples would be the height/weight of a product, or age of a customer. For example: `{ "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * Max entries count: 200. * The key must be a UTF-8 encoded string with a length limit of 128 characters. * For indexable attribute, the key must match the pattern: `a-zA-Z0-9*`. For example, `key0LikeThis` or `KEY_1_LIKE_THIS`. * For text attributes, at most 400 values are allowed. Empty values are not allowed. Each value must be a non-empty UTF-8 encoded string with a length limit of 256 characters. * For number attributes, at most 400 values are allowed.
        :param 'GoogleCloudRetailV2alphaAudienceResponse' audience: The target group associated with a given audience (e.g. male, veterans, car owners, musicians, etc.) of the product.
        :param str availability: The online availability of the Product. Default to Availability.IN_STOCK. Corresponding properties: Google Merchant Center property [availability](https://support.google.com/merchants/answer/6324448). Schema.org property [Offer.availability](https://schema.org/availability).
        :param int available_quantity: The available quantity of the item.
        :param str available_time: The timestamp when this Product becomes available for SearchService.Search. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT.
        :param Sequence[str] brands: The brands of the product. A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [brand](https://support.google.com/merchants/answer/6324351). Schema.org property [Product.brand](https://schema.org/brand).
        :param Sequence[str] categories: Product categories. This field is repeated for supporting one product belonging to several parallel categories. Strongly recommended using the full path for better search / recommendation quality. To represent full path of category, use '>' sign to separate different hierarchies. If '>' is part of the category name, replace it with other character(s). For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product otherwise an INVALID_ARGUMENT error is returned. At most 250 values are allowed per Product. Empty values are not allowed. Each value must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property google_product_category. Schema.org property [Product.category] (https://schema.org/category). [mc_google_product_category]: https://support.google.com/merchants/answer/6324436
        :param Sequence[str] collection_member_ids: The id of the collection members when type is Type.COLLECTION. Non-existent product ids are allowed. The type of the members must be either Type.PRIMARY or Type.VARIANT otherwise an INVALID_ARGUMENT error is thrown. Should not set it for other types. A maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is return.
        :param 'GoogleCloudRetailV2alphaColorInfoResponse' color_info: The color of the product. Corresponding properties: Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        :param Sequence[str] conditions: The condition of the product. Strongly encouraged to use the standard values: "new", "refurbished", "used". A maximum of 1 value is allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [condition](https://support.google.com/merchants/answer/6324469). Schema.org property [Offer.itemCondition](https://schema.org/itemCondition).
        :param str description: Product description. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [description](https://support.google.com/merchants/answer/6324468). Schema.org property [Product.description](https://schema.org/description).
        :param str expire_time: The timestamp when this product becomes unavailable for SearchService.Search. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT. In general, we suggest the users to delete the stale products explicitly, instead of using this field to determine staleness. If it is set, the Product is not available for SearchService.Search after expire_time. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts. expire_time must be later than available_time and publish_time, otherwise an INVALID_ARGUMENT error is thrown. Corresponding properties: Google Merchant Center property [expiration_date](https://support.google.com/merchants/answer/6324499).
        :param Sequence['GoogleCloudRetailV2alphaFulfillmentInfoResponse'] fulfillment_info: Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods. All the elements must have distinct FulfillmentInfo.type. Otherwise, an INVALID_ARGUMENT error is returned.
        :param str gtin: The Global Trade Item Number (GTIN) of the product. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [gtin](https://support.google.com/merchants/answer/6324461). Schema.org property [Product.isbn](https://schema.org/isbn), [Product.gtin8](https://schema.org/gtin8), [Product.gtin12](https://schema.org/gtin12), [Product.gtin13](https://schema.org/gtin13), or [Product.gtin14](https://schema.org/gtin14). If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
        :param Sequence['GoogleCloudRetailV2alphaImageResponse'] images: Product images for the product. We highly recommend putting the main image first. A maximum of 300 images are allowed. Corresponding properties: Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        :param str language_code: Language of the title/description and other string attributes. Use language tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). For product prediction, this field is ignored and the model automatically detects the text language. The Product can include text in different languages, but duplicating Products to provide text in multiple languages can result in degraded model performance. For product search this field is in use. It defaults to "en-US" if unset.
        :param Sequence['GoogleCloudRetailV2alphaLocalInventoryResponse'] local_inventories: A list of local inventories specific to different places. This is only available for users who have Retail Search enabled, and it can be managed by ProductService.AddLocalInventories and ProductService.RemoveLocalInventories APIs.
        :param Sequence[str] materials: The material of the product. For example, "leather", "wooden". A maximum of 20 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 200 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [material](https://support.google.com/merchants/answer/6324410). Schema.org property [Product.material](https://schema.org/material).
        :param str name: Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
        :param Sequence[str] patterns: The pattern or graphic print of the product. For example, "striped", "polka dot", "paisley". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [pattern](https://support.google.com/merchants/answer/6324483). Schema.org property [Product.pattern](https://schema.org/pattern).
        :param 'GoogleCloudRetailV2alphaPriceInfoResponse' price_info: Product price and cost information. Corresponding properties: Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        :param str primary_product_id: Variant group identifier. Must be an id, with the same parent branch with this product. Otherwise, an error is thrown. For Type.PRIMARY Products, this field can only be empty or set to the same value as id. For VARIANT Products, this field cannot be empty. A maximum of 2,000 products are allowed to share the same Type.PRIMARY Product. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [item_group_id](https://support.google.com/merchants/answer/6324507). Schema.org property [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
        :param Sequence['GoogleCloudRetailV2alphaPromotionResponse'] promotions: The promotions applied to the product. A maximum of 10 values are allowed per Product. Only Promotion.promotion_id will be used, other fields will be ignored if set.
        :param str publish_time: The timestamp when the product is published by the retailer for the first time, which indicates the freshness of the products. Note that this field is different from available_time, given it purely describes product freshness regardless of when it is available on search and recommendation.
        :param 'GoogleCloudRetailV2alphaRatingResponse' rating: The rating of this product.
        :param str retrievable_fields: Indicates which fields in the Products are returned in SearchResponse. Supported fields for all types: * audience * availability * brands * color_info * conditions * gtin * materials * name * patterns * price_info * rating * sizes * title * uri Supported fields only for Type.PRIMARY and Type.COLLECTION: * categories * description * images Supported fields only for Type.VARIANT: * Only the first image in images To mark attributes as retrievable, include paths of the form "attributes.key" where "key" is the key of a custom attribute, as specified in attributes. For Type.PRIMARY and Type.COLLECTION, the following fields are always returned in SearchResponse by default: * name For Type.VARIANT, the following fields are always returned in by default: * name * color_info The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is returned. Note: Returning more fields in SearchResponse can increase response payload size and serving latency. This field is deprecated. Use the retrievable site-wide control instead.
        :param Sequence[str] sizes: The size of the product. To represent different size systems or size types, consider using this format: [[[size_system:]size_type:]size_value]. For example, in "US:MENS:M", "US" represents size system; "MENS" represents size type; "M" represents size value. In "GIRLS:27", size system is empty; "GIRLS" represents size type; "27" represents size value. In "32 inches", both size system and size type are empty, while size value is "32 inches". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [size](https://support.google.com/merchants/answer/6324492), [size_type](https://support.google.com/merchants/answer/6324497), and [size_system](https://support.google.com/merchants/answer/6324502). Schema.org property [Product.size](https://schema.org/size).
        :param Sequence[str] tags: Custom tags associated with the product. At most 250 values are allowed per Product. This value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. This tag can be used for filtering recommendation results by passing the tag as part of the PredictRequest.filter. Corresponding properties: Google Merchant Center property [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
        :param str title: Product title. This field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [title](https://support.google.com/merchants/answer/6324415). Schema.org property [Product.name](https://schema.org/name).
        :param str ttl: Input only. The TTL (time to live) of the product. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT. In general, we suggest the users to delete the stale products explicitly, instead of using this field to determine staleness. If it is set, it must be a non-negative value, and expire_time is set as current timestamp plus ttl. The derived expire_time is returned in the output and ttl is left blank when retrieving the Product. If it is set, the product is not available for SearchService.Search after current timestamp plus ttl. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts.
        :param str type: Immutable. The type of the product. Default to Catalog.product_level_config.ingestion_product_type if unset.
        :param str uri: Canonical URL directly linking to the product detail page. It is strongly recommended to provide a valid uri for the product, otherwise the service performance could be significantly degraded. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [link](https://support.google.com/merchants/answer/6324416). Schema.org property [Offer.url](https://schema.org/url).
        :param Sequence['GoogleCloudRetailV2alphaProductResponse'] variants: Product variants grouped together on primary product which share similar product attributes. It's automatically grouped by primary_product_id for all the product variants. Only populated for Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "available_quantity", available_quantity)
        pulumi.set(__self__, "available_time", available_time)
        pulumi.set(__self__, "brands", brands)
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "collection_member_ids", collection_member_ids)
        pulumi.set(__self__, "color_info", color_info)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "fulfillment_info", fulfillment_info)
        pulumi.set(__self__, "gtin", gtin)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "local_inventories", local_inventories)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "price_info", price_info)
        pulumi.set(__self__, "primary_product_id", primary_product_id)
        pulumi.set(__self__, "promotions", promotions)
        pulumi.set(__self__, "publish_time", publish_time)
        pulumi.set(__self__, "rating", rating)
        pulumi.set(__self__, "retrievable_fields", retrievable_fields)
        pulumi.set(__self__, "sizes", sizes)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, str]:
        """
        Highly encouraged. Extra product attributes to be included. For example, for products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the attributes here. Features that can take on one of a limited number of possible values. Two types of features can be set are: Textual features. some examples would be the brand/maker of a product, or country of a customer. Numerical features. Some examples would be the height/weight of a product, or age of a customer. For example: `{ "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * Max entries count: 200. * The key must be a UTF-8 encoded string with a length limit of 128 characters. * For indexable attribute, the key must match the pattern: `a-zA-Z0-9*`. For example, `key0LikeThis` or `KEY_1_LIKE_THIS`. * For text attributes, at most 400 values are allowed. Empty values are not allowed. Each value must be a non-empty UTF-8 encoded string with a length limit of 256 characters. * For number attributes, at most 400 values are allowed.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def audience(self) -> 'outputs.GoogleCloudRetailV2alphaAudienceResponse':
        """
        The target group associated with a given audience (e.g. male, veterans, car owners, musicians, etc.) of the product.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def availability(self) -> str:
        """
        The online availability of the Product. Default to Availability.IN_STOCK. Corresponding properties: Google Merchant Center property [availability](https://support.google.com/merchants/answer/6324448). Schema.org property [Offer.availability](https://schema.org/availability).
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> int:
        """
        The available quantity of the item.
        """
        return pulumi.get(self, "available_quantity")

    @property
    @pulumi.getter(name="availableTime")
    def available_time(self) -> str:
        """
        The timestamp when this Product becomes available for SearchService.Search. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT.
        """
        return pulumi.get(self, "available_time")

    @property
    @pulumi.getter
    def brands(self) -> Sequence[str]:
        """
        The brands of the product. A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [brand](https://support.google.com/merchants/answer/6324351). Schema.org property [Product.brand](https://schema.org/brand).
        """
        return pulumi.get(self, "brands")

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Product categories. This field is repeated for supporting one product belonging to several parallel categories. Strongly recommended using the full path for better search / recommendation quality. To represent full path of category, use '>' sign to separate different hierarchies. If '>' is part of the category name, replace it with other character(s). For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product otherwise an INVALID_ARGUMENT error is returned. At most 250 values are allowed per Product. Empty values are not allowed. Each value must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property google_product_category. Schema.org property [Product.category] (https://schema.org/category). [mc_google_product_category]: https://support.google.com/merchants/answer/6324436
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="collectionMemberIds")
    def collection_member_ids(self) -> Sequence[str]:
        """
        The id of the collection members when type is Type.COLLECTION. Non-existent product ids are allowed. The type of the members must be either Type.PRIMARY or Type.VARIANT otherwise an INVALID_ARGUMENT error is thrown. Should not set it for other types. A maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is return.
        """
        return pulumi.get(self, "collection_member_ids")

    @property
    @pulumi.getter(name="colorInfo")
    def color_info(self) -> 'outputs.GoogleCloudRetailV2alphaColorInfoResponse':
        """
        The color of the product. Corresponding properties: Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "color_info")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence[str]:
        """
        The condition of the product. Strongly encouraged to use the standard values: "new", "refurbished", "used". A maximum of 1 value is allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [condition](https://support.google.com/merchants/answer/6324469). Schema.org property [Offer.itemCondition](https://schema.org/itemCondition).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Product description. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [description](https://support.google.com/merchants/answer/6324468). Schema.org property [Product.description](https://schema.org/description).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The timestamp when this product becomes unavailable for SearchService.Search. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT. In general, we suggest the users to delete the stale products explicitly, instead of using this field to determine staleness. If it is set, the Product is not available for SearchService.Search after expire_time. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts. expire_time must be later than available_time and publish_time, otherwise an INVALID_ARGUMENT error is thrown. Corresponding properties: Google Merchant Center property [expiration_date](https://support.google.com/merchants/answer/6324499).
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="fulfillmentInfo")
    def fulfillment_info(self) -> Sequence['outputs.GoogleCloudRetailV2alphaFulfillmentInfoResponse']:
        """
        Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods. All the elements must have distinct FulfillmentInfo.type. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "fulfillment_info")

    @property
    @pulumi.getter
    def gtin(self) -> str:
        """
        The Global Trade Item Number (GTIN) of the product. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [gtin](https://support.google.com/merchants/answer/6324461). Schema.org property [Product.isbn](https://schema.org/isbn), [Product.gtin8](https://schema.org/gtin8), [Product.gtin12](https://schema.org/gtin12), [Product.gtin13](https://schema.org/gtin13), or [Product.gtin14](https://schema.org/gtin14). If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "gtin")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GoogleCloudRetailV2alphaImageResponse']:
        """
        Product images for the product. We highly recommend putting the main image first. A maximum of 300 images are allowed. Corresponding properties: Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Language of the title/description and other string attributes. Use language tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). For product prediction, this field is ignored and the model automatically detects the text language. The Product can include text in different languages, but duplicating Products to provide text in multiple languages can result in degraded model performance. For product search this field is in use. It defaults to "en-US" if unset.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="localInventories")
    def local_inventories(self) -> Sequence['outputs.GoogleCloudRetailV2alphaLocalInventoryResponse']:
        """
        A list of local inventories specific to different places. This is only available for users who have Retail Search enabled, and it can be managed by ProductService.AddLocalInventories and ProductService.RemoveLocalInventories APIs.
        """
        return pulumi.get(self, "local_inventories")

    @property
    @pulumi.getter
    def materials(self) -> Sequence[str]:
        """
        The material of the product. For example, "leather", "wooden". A maximum of 20 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 200 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [material](https://support.google.com/merchants/answer/6324410). Schema.org property [Product.material](https://schema.org/material).
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence[str]:
        """
        The pattern or graphic print of the product. For example, "striped", "polka dot", "paisley". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [pattern](https://support.google.com/merchants/answer/6324483). Schema.org property [Product.pattern](https://schema.org/pattern).
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="priceInfo")
    def price_info(self) -> 'outputs.GoogleCloudRetailV2alphaPriceInfoResponse':
        """
        Product price and cost information. Corresponding properties: Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        """
        return pulumi.get(self, "price_info")

    @property
    @pulumi.getter(name="primaryProductId")
    def primary_product_id(self) -> str:
        """
        Variant group identifier. Must be an id, with the same parent branch with this product. Otherwise, an error is thrown. For Type.PRIMARY Products, this field can only be empty or set to the same value as id. For VARIANT Products, this field cannot be empty. A maximum of 2,000 products are allowed to share the same Type.PRIMARY Product. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [item_group_id](https://support.google.com/merchants/answer/6324507). Schema.org property [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
        """
        return pulumi.get(self, "primary_product_id")

    @property
    @pulumi.getter
    def promotions(self) -> Sequence['outputs.GoogleCloudRetailV2alphaPromotionResponse']:
        """
        The promotions applied to the product. A maximum of 10 values are allowed per Product. Only Promotion.promotion_id will be used, other fields will be ignored if set.
        """
        return pulumi.get(self, "promotions")

    @property
    @pulumi.getter(name="publishTime")
    def publish_time(self) -> str:
        """
        The timestamp when the product is published by the retailer for the first time, which indicates the freshness of the products. Note that this field is different from available_time, given it purely describes product freshness regardless of when it is available on search and recommendation.
        """
        return pulumi.get(self, "publish_time")

    @property
    @pulumi.getter
    def rating(self) -> 'outputs.GoogleCloudRetailV2alphaRatingResponse':
        """
        The rating of this product.
        """
        return pulumi.get(self, "rating")

    @property
    @pulumi.getter(name="retrievableFields")
    def retrievable_fields(self) -> str:
        """
        Indicates which fields in the Products are returned in SearchResponse. Supported fields for all types: * audience * availability * brands * color_info * conditions * gtin * materials * name * patterns * price_info * rating * sizes * title * uri Supported fields only for Type.PRIMARY and Type.COLLECTION: * categories * description * images Supported fields only for Type.VARIANT: * Only the first image in images To mark attributes as retrievable, include paths of the form "attributes.key" where "key" is the key of a custom attribute, as specified in attributes. For Type.PRIMARY and Type.COLLECTION, the following fields are always returned in SearchResponse by default: * name For Type.VARIANT, the following fields are always returned in by default: * name * color_info The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is returned. Note: Returning more fields in SearchResponse can increase response payload size and serving latency. This field is deprecated. Use the retrievable site-wide control instead.
        """
        return pulumi.get(self, "retrievable_fields")

    @property
    @pulumi.getter
    def sizes(self) -> Sequence[str]:
        """
        The size of the product. To represent different size systems or size types, consider using this format: [[[size_system:]size_type:]size_value]. For example, in "US:MENS:M", "US" represents size system; "MENS" represents size type; "M" represents size value. In "GIRLS:27", size system is empty; "GIRLS" represents size type; "27" represents size value. In "32 inches", both size system and size type are empty, while size value is "32 inches". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [size](https://support.google.com/merchants/answer/6324492), [size_type](https://support.google.com/merchants/answer/6324497), and [size_system](https://support.google.com/merchants/answer/6324502). Schema.org property [Product.size](https://schema.org/size).
        """
        return pulumi.get(self, "sizes")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Custom tags associated with the product. At most 250 values are allowed per Product. This value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. This tag can be used for filtering recommendation results by passing the tag as part of the PredictRequest.filter. Corresponding properties: Google Merchant Center property [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Product title. This field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [title](https://support.google.com/merchants/answer/6324415). Schema.org property [Product.name](https://schema.org/name).
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Input only. The TTL (time to live) of the product. Note that this is only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for Type.VARIANT. In general, we suggest the users to delete the stale products explicitly, instead of using this field to determine staleness. If it is set, it must be a non-negative value, and expire_time is set as current timestamp plus ttl. The derived expire_time is returned in the output and ttl is left blank when retrieving the Product. If it is set, the product is not available for SearchService.Search after current timestamp plus ttl. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The type of the product. Default to Catalog.product_level_config.ingestion_product_type if unset.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Canonical URL directly linking to the product detail page. It is strongly recommended to provide a valid uri for the product, otherwise the service performance could be significantly degraded. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [link](https://support.google.com/merchants/answer/6324416). Schema.org property [Offer.url](https://schema.org/url).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def variants(self) -> Sequence['outputs.GoogleCloudRetailV2alphaProductResponse']:
        """
        Product variants grouped together on primary product which share similar product attributes. It's automatically grouped by primary_product_id for all the product variants. Only populated for Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        return pulumi.get(self, "variants")


@pulumi.output_type
class GoogleCloudRetailV2alphaPromotionResponse(dict):
    """
    Promotion specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionId":
            suggest = "promotion_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaPromotionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaPromotionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaPromotionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 promotion_id: str):
        """
        Promotion specification.
        :param str promotion_id: Promotion identifier, which is the final component of name. For example, this field is "free_gift", if name is `projects/*/locations/global/catalogs/default_catalog/promotions/free_gift`. The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Corresponds to Google Merchant Center property [promotion_id](https://support.google.com/merchants/answer/7050148).
        """
        pulumi.set(__self__, "promotion_id", promotion_id)

    @property
    @pulumi.getter(name="promotionId")
    def promotion_id(self) -> str:
        """
        Promotion identifier, which is the final component of name. For example, this field is "free_gift", if name is `projects/*/locations/global/catalogs/default_catalog/promotions/free_gift`. The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Corresponds to Google Merchant Center property [promotion_id](https://support.google.com/merchants/answer/7050148).
        """
        return pulumi.get(self, "promotion_id")


@pulumi.output_type
class GoogleCloudRetailV2alphaRatingResponse(dict):
    """
    The rating of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageRating":
            suggest = "average_rating"
        elif key == "ratingCount":
            suggest = "rating_count"
        elif key == "ratingHistogram":
            suggest = "rating_histogram"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRatingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRatingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRatingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_rating: float,
                 rating_count: int,
                 rating_histogram: Sequence[int]):
        """
        The rating of a Product.
        :param float average_rating: The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        :param int rating_count: The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param Sequence[int] rating_histogram: List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        pulumi.set(__self__, "average_rating", average_rating)
        pulumi.set(__self__, "rating_count", rating_count)
        pulumi.set(__self__, "rating_histogram", rating_histogram)

    @property
    @pulumi.getter(name="averageRating")
    def average_rating(self) -> float:
        """
        The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "average_rating")

    @property
    @pulumi.getter(name="ratingCount")
    def rating_count(self) -> int:
        """
        The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "rating_count")

    @property
    @pulumi.getter(name="ratingHistogram")
    def rating_histogram(self) -> Sequence[int]:
        """
        List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        return pulumi.get(self, "rating_histogram")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleBoostActionResponse(dict):
    """
    A boost action to apply to results matching condition specified above.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productsFilter":
            suggest = "products_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleBoostActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleBoostActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleBoostActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boost: float,
                 products_filter: str):
        """
        A boost action to apply to results matching condition specified above.
        :param float boost: Strength of the condition boost, which must be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big promotion. However, it does not necessarily mean that the boosted item will be the top result at all times, nor that other items will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant items. Setting to -1.0 gives the item a big demotion. However, results that are deeply relevant might still be shown. The item will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored.
        :param str products_filter: The filter can have a max size of 5000 characters. An expression which specifies which products to apply an action to. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        pulumi.set(__self__, "boost", boost)
        pulumi.set(__self__, "products_filter", products_filter)

    @property
    @pulumi.getter
    def boost(self) -> float:
        """
        Strength of the condition boost, which must be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big promotion. However, it does not necessarily mean that the boosted item will be the top result at all times, nor that other items will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant items. Setting to -1.0 gives the item a big demotion. However, results that are deeply relevant might still be shown. The item will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored.
        """
        return pulumi.get(self, "boost")

    @property
    @pulumi.getter(name="productsFilter")
    def products_filter(self) -> str:
        """
        The filter can have a max size of 5000 characters. An expression which specifies which products to apply an action to. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        return pulumi.get(self, "products_filter")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse(dict):
    """
    Prevents `query_term` from being associated with specified terms during search. Example: Don't associate "gShoe" and "cheap".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "doNotAssociateTerms":
            suggest = "do_not_associate_terms"
        elif key == "queryTerms":
            suggest = "query_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 do_not_associate_terms: Sequence[str],
                 query_terms: Sequence[str],
                 terms: Sequence[str]):
        """
        Prevents `query_term` from being associated with specified terms during search. Example: Don't associate "gShoe" and "cheap".
        :param Sequence[str] do_not_associate_terms: Cannot contain duplicates or the query term. Can specify up to 100 terms.
        :param Sequence[str] query_terms: Terms from the search query. Will not consider do_not_associate_terms for search if in search query. Can specify up to 100 terms.
        :param Sequence[str] terms: Will be [deprecated = true] post migration;
        """
        pulumi.set(__self__, "do_not_associate_terms", do_not_associate_terms)
        pulumi.set(__self__, "query_terms", query_terms)
        pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter(name="doNotAssociateTerms")
    def do_not_associate_terms(self) -> Sequence[str]:
        """
        Cannot contain duplicates or the query term. Can specify up to 100 terms.
        """
        return pulumi.get(self, "do_not_associate_terms")

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Sequence[str]:
        """
        Terms from the search query. Will not consider do_not_associate_terms for search if in search query. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @property
    @pulumi.getter
    def terms(self) -> Sequence[str]:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "terms")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleFilterActionResponse(dict):
    """
    * Rule Condition: - No Condition.query_terms provided is a global match. - 1 or more Condition.query_terms provided are combined with OR operator. * Action Input: The request query and filter that are applied to the retrieved products, in addition to any filters already provided with the SearchRequest. The AND operator is used to combine the query's existing filters with the filter rule(s). NOTE: May result in 0 results when filters conflict. * Action Result: Filters the returned objects to be ONLY those that passed the filter.
    """
    def __init__(__self__, *,
                 filter: str):
        """
        * Rule Condition: - No Condition.query_terms provided is a global match. - 1 or more Condition.query_terms provided are combined with OR operator. * Action Input: The request query and filter that are applied to the retrieved products, in addition to any filters already provided with the SearchRequest. The AND operator is used to combine the query's existing filters with the filter rule(s). NOTE: May result in 0 results when filters conflict. * Action Result: Filters the returned objects to be ONLY those that passed the filter.
        :param str filter: A filter to apply on the matching condition results. Supported features: * filter must be set. * Filter syntax is identical to SearchRequest.filter. See more details at the Retail Search [user guide](/retail/search/docs/filter-and-order#filter). * To filter products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        A filter to apply on the matching condition results. Supported features: * filter must be set. * Filter syntax is identical to SearchRequest.filter. See more details at the Retail Search [user guide](/retail/search/docs/filter-and-order#filter). * To filter products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleIgnoreActionResponse(dict):
    """
    Prevents a term in the query from being used in search. Example: Don't search for "shoddy".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreTerms":
            suggest = "ignore_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleIgnoreActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleIgnoreActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleIgnoreActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_terms: Sequence[str]):
        """
        Prevents a term in the query from being used in search. Example: Don't search for "shoddy".
        :param Sequence[str] ignore_terms: Terms to ignore in the search query.
        """
        pulumi.set(__self__, "ignore_terms", ignore_terms)

    @property
    @pulumi.getter(name="ignoreTerms")
    def ignore_terms(self) -> Sequence[str]:
        """
        Terms to ignore in the search query.
        """
        return pulumi.get(self, "ignore_terms")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse(dict):
    """
    Maps a set of terms to a set of synonyms. Set of synonyms will be treated as synonyms of each query term only. `query_terms` will not be treated as synonyms of each other. Example: "sneakers" will use a synonym of "shoes". "shoes" will not use a synonym of "sneakers".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onewayTerms":
            suggest = "oneway_terms"
        elif key == "queryTerms":
            suggest = "query_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oneway_terms: Sequence[str],
                 query_terms: Sequence[str],
                 synonyms: Sequence[str]):
        """
        Maps a set of terms to a set of synonyms. Set of synonyms will be treated as synonyms of each query term only. `query_terms` will not be treated as synonyms of each other. Example: "sneakers" will use a synonym of "shoes". "shoes" will not use a synonym of "sneakers".
        :param Sequence[str] oneway_terms: Will be [deprecated = true] post migration;
        :param Sequence[str] query_terms: Terms from the search query. Will treat synonyms as their synonyms. Not themselves synonyms of the synonyms. Can specify up to 100 terms.
        :param Sequence[str] synonyms: Defines a set of synonyms. Cannot contain duplicates. Can specify up to 100 synonyms.
        """
        pulumi.set(__self__, "oneway_terms", oneway_terms)
        pulumi.set(__self__, "query_terms", query_terms)
        pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter(name="onewayTerms")
    def oneway_terms(self) -> Sequence[str]:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "oneway_terms")

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Sequence[str]:
        """
        Terms from the search query. Will treat synonyms as their synonyms. Not themselves synonyms of the synonyms. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        """
        Defines a set of synonyms. Cannot contain duplicates. Can specify up to 100 synonyms.
        """
        return pulumi.get(self, "synonyms")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleRedirectActionResponse(dict):
    """
    Redirects a shopper to a specific page. * Rule Condition: - Must specify Condition.query_terms. * Action Input: Request Query * Action Result: Redirects shopper to provided uri.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectUri":
            suggest = "redirect_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleRedirectActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleRedirectActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleRedirectActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_uri: str):
        """
        Redirects a shopper to a specific page. * Rule Condition: - Must specify Condition.query_terms. * Action Input: Request Query * Action Result: Redirects shopper to provided uri.
        :param str redirect_uri: URL must have length equal or less than 2000 characters.
        """
        pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> str:
        """
        URL must have length equal or less than 2000 characters.
        """
        return pulumi.get(self, "redirect_uri")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleReplacementActionResponse(dict):
    """
    Replaces a term in the query. Multiple replacement candidates can be specified. All `query_terms` will be replaced with the replacement term. Example: Replace "gShoe" with "google shoe".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryTerms":
            suggest = "query_terms"
        elif key == "replacementTerm":
            suggest = "replacement_term"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleReplacementActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleReplacementActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleReplacementActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_terms: Sequence[str],
                 replacement_term: str,
                 term: str):
        """
        Replaces a term in the query. Multiple replacement candidates can be specified. All `query_terms` will be replaced with the replacement term. Example: Replace "gShoe" with "google shoe".
        :param Sequence[str] query_terms: Terms from the search query. Will be replaced by replacement term. Can specify up to 100 terms.
        :param str replacement_term: Term that will be used for replacement.
        :param str term: Will be [deprecated = true] post migration;
        """
        pulumi.set(__self__, "query_terms", query_terms)
        pulumi.set(__self__, "replacement_term", replacement_term)
        pulumi.set(__self__, "term", term)

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Sequence[str]:
        """
        Terms from the search query. Will be replaced by replacement term. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @property
    @pulumi.getter(name="replacementTerm")
    def replacement_term(self) -> str:
        """
        Term that will be used for replacement.
        """
        return pulumi.get(self, "replacement_term")

    @property
    @pulumi.getter
    def term(self) -> str:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "term")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleResponse(dict):
    """
    A rule is a condition-action pair * A condition defines when a rule is to be triggered. * An action specifies what occurs on that trigger. Currently rules only work for controls with SOLUTION_TYPE_SEARCH.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boostAction":
            suggest = "boost_action"
        elif key == "doNotAssociateAction":
            suggest = "do_not_associate_action"
        elif key == "filterAction":
            suggest = "filter_action"
        elif key == "ignoreAction":
            suggest = "ignore_action"
        elif key == "onewaySynonymsAction":
            suggest = "oneway_synonyms_action"
        elif key == "redirectAction":
            suggest = "redirect_action"
        elif key == "replacementAction":
            suggest = "replacement_action"
        elif key == "twowaySynonymsAction":
            suggest = "twoway_synonyms_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boost_action: 'outputs.GoogleCloudRetailV2alphaRuleBoostActionResponse',
                 condition: 'outputs.GoogleCloudRetailV2alphaConditionResponse',
                 do_not_associate_action: 'outputs.GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse',
                 filter_action: 'outputs.GoogleCloudRetailV2alphaRuleFilterActionResponse',
                 ignore_action: 'outputs.GoogleCloudRetailV2alphaRuleIgnoreActionResponse',
                 oneway_synonyms_action: 'outputs.GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse',
                 redirect_action: 'outputs.GoogleCloudRetailV2alphaRuleRedirectActionResponse',
                 replacement_action: 'outputs.GoogleCloudRetailV2alphaRuleReplacementActionResponse',
                 twoway_synonyms_action: 'outputs.GoogleCloudRetailV2alphaRuleTwowaySynonymsActionResponse'):
        """
        A rule is a condition-action pair * A condition defines when a rule is to be triggered. * An action specifies what occurs on that trigger. Currently rules only work for controls with SOLUTION_TYPE_SEARCH.
        :param 'GoogleCloudRetailV2alphaRuleBoostActionResponse' boost_action: A boost action.
        :param 'GoogleCloudRetailV2alphaConditionResponse' condition: The condition that triggers the rule. If the condition is empty, the rule will always apply.
        :param 'GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse' do_not_associate_action: Prevents term from being associated with other terms.
        :param 'GoogleCloudRetailV2alphaRuleFilterActionResponse' filter_action: Filters results.
        :param 'GoogleCloudRetailV2alphaRuleIgnoreActionResponse' ignore_action: Ignores specific terms from query during search.
        :param 'GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse' oneway_synonyms_action: Treats specific term as a synonym with a group of terms. Group of terms will not be treated as synonyms with the specific term.
        :param 'GoogleCloudRetailV2alphaRuleRedirectActionResponse' redirect_action: Redirects a shopper to a specific page.
        :param 'GoogleCloudRetailV2alphaRuleReplacementActionResponse' replacement_action: Replaces specific terms in the query.
        :param 'GoogleCloudRetailV2alphaRuleTwowaySynonymsActionResponse' twoway_synonyms_action: Treats a set of terms as synonyms of one another.
        """
        pulumi.set(__self__, "boost_action", boost_action)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "do_not_associate_action", do_not_associate_action)
        pulumi.set(__self__, "filter_action", filter_action)
        pulumi.set(__self__, "ignore_action", ignore_action)
        pulumi.set(__self__, "oneway_synonyms_action", oneway_synonyms_action)
        pulumi.set(__self__, "redirect_action", redirect_action)
        pulumi.set(__self__, "replacement_action", replacement_action)
        pulumi.set(__self__, "twoway_synonyms_action", twoway_synonyms_action)

    @property
    @pulumi.getter(name="boostAction")
    def boost_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleBoostActionResponse':
        """
        A boost action.
        """
        return pulumi.get(self, "boost_action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleCloudRetailV2alphaConditionResponse':
        """
        The condition that triggers the rule. If the condition is empty, the rule will always apply.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="doNotAssociateAction")
    def do_not_associate_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleDoNotAssociateActionResponse':
        """
        Prevents term from being associated with other terms.
        """
        return pulumi.get(self, "do_not_associate_action")

    @property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleFilterActionResponse':
        """
        Filters results.
        """
        return pulumi.get(self, "filter_action")

    @property
    @pulumi.getter(name="ignoreAction")
    def ignore_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleIgnoreActionResponse':
        """
        Ignores specific terms from query during search.
        """
        return pulumi.get(self, "ignore_action")

    @property
    @pulumi.getter(name="onewaySynonymsAction")
    def oneway_synonyms_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleOnewaySynonymsActionResponse':
        """
        Treats specific term as a synonym with a group of terms. Group of terms will not be treated as synonyms with the specific term.
        """
        return pulumi.get(self, "oneway_synonyms_action")

    @property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleRedirectActionResponse':
        """
        Redirects a shopper to a specific page.
        """
        return pulumi.get(self, "redirect_action")

    @property
    @pulumi.getter(name="replacementAction")
    def replacement_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleReplacementActionResponse':
        """
        Replaces specific terms in the query.
        """
        return pulumi.get(self, "replacement_action")

    @property
    @pulumi.getter(name="twowaySynonymsAction")
    def twoway_synonyms_action(self) -> 'outputs.GoogleCloudRetailV2alphaRuleTwowaySynonymsActionResponse':
        """
        Treats a set of terms as synonyms of one another.
        """
        return pulumi.get(self, "twoway_synonyms_action")


@pulumi.output_type
class GoogleCloudRetailV2alphaRuleTwowaySynonymsActionResponse(dict):
    """
    Creates a set of terms that will be treated as synonyms of each other. Example: synonyms of "sneakers" and "shoes": * "sneakers" will use a synonym of "shoes". * "shoes" will use a synonym of "sneakers".
    """
    def __init__(__self__, *,
                 synonyms: Sequence[str]):
        """
        Creates a set of terms that will be treated as synonyms of each other. Example: synonyms of "sneakers" and "shoes": * "sneakers" will use a synonym of "shoes". * "shoes" will use a synonym of "sneakers".
        :param Sequence[str] synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms.
        """
        pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        """
        Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms.
        """
        return pulumi.get(self, "synonyms")


@pulumi.output_type
class GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpecResponse(dict):
    """
    The specifications of dynamically generated facets.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        The specifications of dynamically generated facets.
        :param str mode: Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if it's unset.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if it's unset.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse(dict):
    """
    Specifies how a facet is computed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseInsensitive":
            suggest = "case_insensitive"
        elif key == "orderBy":
            suggest = "order_by"
        elif key == "restrictedValues":
            suggest = "restricted_values"
        elif key == "returnMinMax":
            suggest = "return_min_max"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_insensitive: bool,
                 contains: Sequence[str],
                 intervals: Sequence['outputs.GoogleCloudRetailV2alphaIntervalResponse'],
                 key: str,
                 order_by: str,
                 prefixes: Sequence[str],
                 query: str,
                 restricted_values: Sequence[str],
                 return_min_max: bool):
        """
        Specifies how a facet is computed.
        :param bool case_insensitive: True to make facet keys case insensitive when getting faceting values with prefixes or contains; false otherwise.
        :param Sequence[str] contains: Only get facet values that contains the given strings. For example, suppose "categories" has three values "Women > Shoe", "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the "categories" facet will give only "Women > Shoe" and "Men > Shoe". Only supported on textual fields. Maximum is 10.
        :param Sequence['GoogleCloudRetailV2alphaIntervalResponse'] intervals: Set only if values should be bucketized into intervals. Must be set for facets with numerical values. Must not be set for facet with text values. Maximum number of intervals is 30.
        :param str key: Supported textual and numerical facet keys in Product object, over which the facet values are computed. Facet key is case-sensitive. Allowed facet keys when FacetKey.query is not specified: * textual_field = * "brands" * "categories" * "genders" * "ageGroups" * "availability" * "colorFamilies" * "colors" * "sizes" * "materials" * "patterns" * "conditions" * "attributes.key" * "pickupInStore" * "shipToStore" * "sameDayDelivery" * "nextDayDelivery" * "customFulfillment1" * "customFulfillment2" * "customFulfillment3" * "customFulfillment4" * "customFulfillment5" * "inventory(place_id,attributes.key)" * numerical_field = * "price" * "discount" * "rating" * "ratingCount" * "attributes.key" * "inventory(place_id,price)" * "inventory(place_id,original_price)" * "inventory(place_id,attributes.key)"
        :param str order_by: The order in which SearchResponse.Facet.values are returned. Allowed values are: * "count desc", which means order by SearchResponse.Facet.values.count descending. * "value desc", which means order by SearchResponse.Facet.values.value descending. Only applies to textual facets. If not set, textual values are sorted in [natural order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are sorted in the order given by FacetSpec.FacetKey.intervals; FulfillmentInfo.place_ids are sorted in the order given by FacetSpec.FacetKey.restricted_values.
        :param Sequence[str] prefixes: Only get facet values that start with the given string prefix. For example, suppose "categories" has three values "Women > Shoe", "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the "categories" facet will give only "Women > Shoe" and "Women > Dress". Only supported on textual fields. Maximum is 10.
        :param str query: The query that is used to compute facet for the given facet key. When provided, it will override the default behavior of facet computation. The query syntax is the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Notice that there is no limitation on FacetKey.key when query is specified. In the response, SearchResponse.Facet.values.value will be always "1" and SearchResponse.Facet.values.count will be the number of results that match the query. For example, you can set a customized facet for "shipToStore", where FacetKey.key is "customizedShipToStore", and FacetKey.query is "availability: ANY(\\"IN_STOCK\\") AND shipToStore: ANY(\\"123\\")". Then the facet will count the products that are both in stock and ship to store "123".
        :param Sequence[str] restricted_values: Only get facet for the given restricted values. For example, when using "pickupInStore" as key and set restricted values to ["store123", "store456"], only facets for "store123" and "store456" are returned. Only supported on predefined textual fields, custom textual attributes and fulfillments. Maximum is 20. Must be set for the fulfillment facet keys: * pickupInStore * shipToStore * sameDayDelivery * nextDayDelivery * customFulfillment1 * customFulfillment2 * customFulfillment3 * customFulfillment4 * customFulfillment5
        :param bool return_min_max: Returns the min and max value for each numerical facet intervals. Ignored for textual facets.
        """
        pulumi.set(__self__, "case_insensitive", case_insensitive)
        pulumi.set(__self__, "contains", contains)
        pulumi.set(__self__, "intervals", intervals)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "order_by", order_by)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "restricted_values", restricted_values)
        pulumi.set(__self__, "return_min_max", return_min_max)

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> bool:
        """
        True to make facet keys case insensitive when getting faceting values with prefixes or contains; false otherwise.
        """
        return pulumi.get(self, "case_insensitive")

    @property
    @pulumi.getter
    def contains(self) -> Sequence[str]:
        """
        Only get facet values that contains the given strings. For example, suppose "categories" has three values "Women > Shoe", "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the "categories" facet will give only "Women > Shoe" and "Men > Shoe". Only supported on textual fields. Maximum is 10.
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def intervals(self) -> Sequence['outputs.GoogleCloudRetailV2alphaIntervalResponse']:
        """
        Set only if values should be bucketized into intervals. Must be set for facets with numerical values. Must not be set for facet with text values. Maximum number of intervals is 30.
        """
        return pulumi.get(self, "intervals")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Supported textual and numerical facet keys in Product object, over which the facet values are computed. Facet key is case-sensitive. Allowed facet keys when FacetKey.query is not specified: * textual_field = * "brands" * "categories" * "genders" * "ageGroups" * "availability" * "colorFamilies" * "colors" * "sizes" * "materials" * "patterns" * "conditions" * "attributes.key" * "pickupInStore" * "shipToStore" * "sameDayDelivery" * "nextDayDelivery" * "customFulfillment1" * "customFulfillment2" * "customFulfillment3" * "customFulfillment4" * "customFulfillment5" * "inventory(place_id,attributes.key)" * numerical_field = * "price" * "discount" * "rating" * "ratingCount" * "attributes.key" * "inventory(place_id,price)" * "inventory(place_id,original_price)" * "inventory(place_id,attributes.key)"
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> str:
        """
        The order in which SearchResponse.Facet.values are returned. Allowed values are: * "count desc", which means order by SearchResponse.Facet.values.count descending. * "value desc", which means order by SearchResponse.Facet.values.value descending. Only applies to textual facets. If not set, textual values are sorted in [natural order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are sorted in the order given by FacetSpec.FacetKey.intervals; FulfillmentInfo.place_ids are sorted in the order given by FacetSpec.FacetKey.restricted_values.
        """
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def prefixes(self) -> Sequence[str]:
        """
        Only get facet values that start with the given string prefix. For example, suppose "categories" has three values "Women > Shoe", "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the "categories" facet will give only "Women > Shoe" and "Women > Dress". Only supported on textual fields. Maximum is 10.
        """
        return pulumi.get(self, "prefixes")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The query that is used to compute facet for the given facet key. When provided, it will override the default behavior of facet computation. The query syntax is the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Notice that there is no limitation on FacetKey.key when query is specified. In the response, SearchResponse.Facet.values.value will be always "1" and SearchResponse.Facet.values.count will be the number of results that match the query. For example, you can set a customized facet for "shipToStore", where FacetKey.key is "customizedShipToStore", and FacetKey.query is "availability: ANY(\\"IN_STOCK\\") AND shipToStore: ANY(\\"123\\")". Then the facet will count the products that are both in stock and ship to store "123".
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="restrictedValues")
    def restricted_values(self) -> Sequence[str]:
        """
        Only get facet for the given restricted values. For example, when using "pickupInStore" as key and set restricted values to ["store123", "store456"], only facets for "store123" and "store456" are returned. Only supported on predefined textual fields, custom textual attributes and fulfillments. Maximum is 20. Must be set for the fulfillment facet keys: * pickupInStore * shipToStore * sameDayDelivery * nextDayDelivery * customFulfillment1 * customFulfillment2 * customFulfillment3 * customFulfillment4 * customFulfillment5
        """
        return pulumi.get(self, "restricted_values")

    @property
    @pulumi.getter(name="returnMinMax")
    def return_min_max(self) -> bool:
        """
        Returns the min and max value for each numerical facet intervals. Ignored for textual facets.
        """
        return pulumi.get(self, "return_min_max")


@pulumi.output_type
class GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse(dict):
    """
    A facet specification to perform faceted search.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDynamicPosition":
            suggest = "enable_dynamic_position"
        elif key == "excludedFilterKeys":
            suggest = "excluded_filter_keys"
        elif key == "facetKey":
            suggest = "facet_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_dynamic_position: bool,
                 excluded_filter_keys: Sequence[str],
                 facet_key: 'outputs.GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse',
                 limit: int):
        """
        A facet specification to perform faceted search.
        :param bool enable_dynamic_position: Enables dynamic position for this facet. If set to true, the position of this facet among all facets in the response is determined by Google Retail Search. It will be ordered together with dynamic facets if dynamic facets is enabled. If set to false, the position of this facet in the response will be the same as in the request, and it will be ranked before the facets with dynamic position enable and all dynamic facets. For example, you may always want to have rating facet returned in the response, but it's not necessarily to always display the rating facet at the top. In that case, you can set enable_dynamic_position to true so that the position of rating facet in response will be determined by Google Retail Search. Another example, assuming you have the following facets in the request: * "rating", enable_dynamic_position = true * "price", enable_dynamic_position = false * "brands", enable_dynamic_position = false And also you have a dynamic facets enable, which will generate a facet 'gender'. Then the final order of the facets in the response can be ("price", "brands", "rating", "gender") or ("price", "brands", "gender", "rating") depends on how Google Retail Search orders "gender" and "rating" facets. However, notice that "price" and "brands" will always be ranked at 1st and 2nd position since their enable_dynamic_position are false.
        :param Sequence[str] excluded_filter_keys: List of keys to exclude when faceting. By default, FacetKey.key is not excluded from the filter unless it is listed in this field. Listing a facet key in this field allows its values to appear as facet results, even when they are filtered out of search results. Using this field does not affect what search results are returned. For example, suppose there are 100 products with the color facet "Red" and 200 products with the color facet "Blue". A query containing the filter "colorFamilies:ANY("Red")" and having "colorFamilies" as FacetKey.key would by default return only "Red" products in the search results, and also return "Red" with count 100 as the only color facet. Although there are also blue products available, "Blue" would not be shown as an available facet value. If "colorFamilies" is listed in "excludedFilterKeys", then the query returns the facet values "Red" with count 100 and "Blue" with count 200, because the "colorFamilies" key is now excluded from the filter. Because this field doesn't affect search results, the search results are still correctly filtered to return only "Red" products. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned.
        :param 'GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse' facet_key: The facet key specification.
        :param int limit: Maximum of facet values that should be returned for this facet. If unspecified, defaults to 50. The maximum allowed value is 300. Values above 300 will be coerced to 300. If this field is negative, an INVALID_ARGUMENT is returned.
        """
        pulumi.set(__self__, "enable_dynamic_position", enable_dynamic_position)
        pulumi.set(__self__, "excluded_filter_keys", excluded_filter_keys)
        pulumi.set(__self__, "facet_key", facet_key)
        pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter(name="enableDynamicPosition")
    def enable_dynamic_position(self) -> bool:
        """
        Enables dynamic position for this facet. If set to true, the position of this facet among all facets in the response is determined by Google Retail Search. It will be ordered together with dynamic facets if dynamic facets is enabled. If set to false, the position of this facet in the response will be the same as in the request, and it will be ranked before the facets with dynamic position enable and all dynamic facets. For example, you may always want to have rating facet returned in the response, but it's not necessarily to always display the rating facet at the top. In that case, you can set enable_dynamic_position to true so that the position of rating facet in response will be determined by Google Retail Search. Another example, assuming you have the following facets in the request: * "rating", enable_dynamic_position = true * "price", enable_dynamic_position = false * "brands", enable_dynamic_position = false And also you have a dynamic facets enable, which will generate a facet 'gender'. Then the final order of the facets in the response can be ("price", "brands", "rating", "gender") or ("price", "brands", "gender", "rating") depends on how Google Retail Search orders "gender" and "rating" facets. However, notice that "price" and "brands" will always be ranked at 1st and 2nd position since their enable_dynamic_position are false.
        """
        return pulumi.get(self, "enable_dynamic_position")

    @property
    @pulumi.getter(name="excludedFilterKeys")
    def excluded_filter_keys(self) -> Sequence[str]:
        """
        List of keys to exclude when faceting. By default, FacetKey.key is not excluded from the filter unless it is listed in this field. Listing a facet key in this field allows its values to appear as facet results, even when they are filtered out of search results. Using this field does not affect what search results are returned. For example, suppose there are 100 products with the color facet "Red" and 200 products with the color facet "Blue". A query containing the filter "colorFamilies:ANY("Red")" and having "colorFamilies" as FacetKey.key would by default return only "Red" products in the search results, and also return "Red" with count 100 as the only color facet. Although there are also blue products available, "Blue" would not be shown as an available facet value. If "colorFamilies" is listed in "excludedFilterKeys", then the query returns the facet values "Red" with count 100 and "Blue" with count 200, because the "colorFamilies" key is now excluded from the filter. Because this field doesn't affect search results, the search results are still correctly filtered to return only "Red" products. A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "excluded_filter_keys")

    @property
    @pulumi.getter(name="facetKey")
    def facet_key(self) -> 'outputs.GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKeyResponse':
        """
        The facet key specification.
        """
        return pulumi.get(self, "facet_key")

    @property
    @pulumi.getter
    def limit(self) -> int:
        """
        Maximum of facet values that should be returned for this facet. If unspecified, defaults to 50. The maximum allowed value is 300. Values above 300 will be coerced to 300. If this field is negative, an INVALID_ARGUMENT is returned.
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class GoogleCloudRetailV2alphaSearchRequestPersonalizationSpecResponse(dict):
    """
    The specification for personalization.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        The specification for personalization.
        :param str mode: Defaults to Mode.AUTO.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Defaults to Mode.AUTO.
        """
        return pulumi.get(self, "mode")


