# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudRetailV2AudienceArgs',
    'GoogleCloudRetailV2ColorInfoArgs',
    'GoogleCloudRetailV2ConditionQueryTermArgs',
    'GoogleCloudRetailV2ConditionTimeRangeArgs',
    'GoogleCloudRetailV2ConditionArgs',
    'GoogleCloudRetailV2FulfillmentInfoArgs',
    'GoogleCloudRetailV2ImageArgs',
    'GoogleCloudRetailV2PriceInfoArgs',
    'GoogleCloudRetailV2PromotionArgs',
    'GoogleCloudRetailV2RatingArgs',
    'GoogleCloudRetailV2RuleBoostActionArgs',
    'GoogleCloudRetailV2RuleDoNotAssociateActionArgs',
    'GoogleCloudRetailV2RuleFilterActionArgs',
    'GoogleCloudRetailV2RuleIgnoreActionArgs',
    'GoogleCloudRetailV2RuleOnewaySynonymsActionArgs',
    'GoogleCloudRetailV2RuleRedirectActionArgs',
    'GoogleCloudRetailV2RuleReplacementActionArgs',
    'GoogleCloudRetailV2RuleTwowaySynonymsActionArgs',
    'GoogleCloudRetailV2RuleArgs',
    'GoogleCloudRetailV2SearchRequestDynamicFacetSpecArgs',
    'GoogleCloudRetailV2SearchRequestPersonalizationSpecArgs',
]

@pulumi.input_type
class GoogleCloudRetailV2AudienceArgs:
    def __init__(__self__, *,
                 age_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 genders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An intended audience of the Product for whom it's sold.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] age_groups: The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] genders: The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        if age_groups is not None:
            pulumi.set(__self__, "age_groups", age_groups)
        if genders is not None:
            pulumi.set(__self__, "genders", genders)

    @property
    @pulumi.getter(name="ageGroups")
    def age_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        """
        return pulumi.get(self, "age_groups")

    @age_groups.setter
    def age_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "age_groups", value)

    @property
    @pulumi.getter
    def genders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        return pulumi.get(self, "genders")

    @genders.setter
    def genders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "genders", value)


@pulumi.input_type
class GoogleCloudRetailV2ColorInfoArgs:
    def __init__(__self__, *,
                 color_families: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The color information of a Product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] color_families: The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] colors: The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        if color_families is not None:
            pulumi.set(__self__, "color_families", color_families)
        if colors is not None:
            pulumi.set(__self__, "colors", colors)

    @property
    @pulumi.getter(name="colorFamilies")
    def color_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "color_families")

    @color_families.setter
    def color_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "color_families", value)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "colors", value)


@pulumi.input_type
class GoogleCloudRetailV2ConditionQueryTermArgs:
    def __init__(__self__, *,
                 full_match: Optional[pulumi.Input[bool]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Query terms that we want to match on.
        :param pulumi.Input[bool] full_match: Whether this is supposed to be a full or partial match.
        :param pulumi.Input[str] value: The value of the term to match on. Value cannot be empty. Value can have at most 3 terms if specified as a partial match. Each space separated string is considered as one term. For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms and not allowed for a partial match.
        """
        if full_match is not None:
            pulumi.set(__self__, "full_match", full_match)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="fullMatch")
    def full_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this is supposed to be a full or partial match.
        """
        return pulumi.get(self, "full_match")

    @full_match.setter
    def full_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_match", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the term to match on. Value cannot be empty. Value can have at most 3 terms if specified as a partial match. Each space separated string is considered as one term. For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms and not allowed for a partial match.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudRetailV2ConditionTimeRangeArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Used for time-dependent conditions. Example: Want to have rule applied for week long sale.
        :param pulumi.Input[str] end_time: End of time range. Range is inclusive.
        :param pulumi.Input[str] start_time: Start of time range. Range is inclusive.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End of time range. Range is inclusive.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start of time range. Range is inclusive.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class GoogleCloudRetailV2ConditionArgs:
    def __init__(__self__, *,
                 active_time_range: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionTimeRangeArgs']]]] = None,
                 query_terms: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionQueryTermArgs']]]] = None):
        """
        Metadata that is used to define a condition that triggers an action. A valid condition must specify at least one of 'query_terms' or 'products_filter'. If multiple fields are specified, the condition is met if all the fields are satisfied e.g. if a set of query terms and product_filter are set, then only items matching the product_filter for requests with a query matching the query terms wil get boosted.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionTimeRangeArgs']]] active_time_range: Range of time(s) specifying when Condition is active. Condition true if any time range matches.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionQueryTermArgs']]] query_terms: A list (up to 10 entries) of terms to match the query on. If not specified, match all queries. If many query terms are specified, the condition is matched if any of the terms is a match (i.e. using the OR operator).
        """
        if active_time_range is not None:
            pulumi.set(__self__, "active_time_range", active_time_range)
        if query_terms is not None:
            pulumi.set(__self__, "query_terms", query_terms)

    @property
    @pulumi.getter(name="activeTimeRange")
    def active_time_range(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionTimeRangeArgs']]]]:
        """
        Range of time(s) specifying when Condition is active. Condition true if any time range matches.
        """
        return pulumi.get(self, "active_time_range")

    @active_time_range.setter
    def active_time_range(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionTimeRangeArgs']]]]):
        pulumi.set(self, "active_time_range", value)

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionQueryTermArgs']]]]:
        """
        A list (up to 10 entries) of terms to match the query on. If not specified, match all queries. If many query terms are specified, the condition is matched if any of the terms is a match (i.e. using the OR operator).
        """
        return pulumi.get(self, "query_terms")

    @query_terms.setter
    def query_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRetailV2ConditionQueryTermArgs']]]]):
        pulumi.set(self, "query_terms", value)


@pulumi.input_type
class GoogleCloudRetailV2FulfillmentInfoArgs:
    def __init__(__self__, *,
                 place_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] place_ids: The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[str] type: The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        if place_ids is not None:
            pulumi.set(__self__, "place_ids", place_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="placeIds")
    def place_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "place_ids")

    @place_ids.setter
    def place_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "place_ids", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudRetailV2ImageArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 height: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        Product image. Recommendations AI and Retail Search do not use product images to improve prediction and search results. However, product images can be returned in results, and are shown in prediction or search previews in the console.
        :param pulumi.Input[str] uri: URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        :param pulumi.Input[int] height: Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[int] width: Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        pulumi.set(__self__, "uri", uri)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class GoogleCloudRetailV2PriceInfoArgs:
    def __init__(__self__, *,
                 cost: Optional[pulumi.Input[float]] = None,
                 currency_code: Optional[pulumi.Input[str]] = None,
                 original_price: Optional[pulumi.Input[float]] = None,
                 price: Optional[pulumi.Input[float]] = None,
                 price_effective_time: Optional[pulumi.Input[str]] = None,
                 price_expire_time: Optional[pulumi.Input[str]] = None):
        """
        The price information of a Product.
        :param pulumi.Input[float] cost: The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        :param pulumi.Input[str] currency_code: The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        :param pulumi.Input[float] original_price: Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        :param pulumi.Input[float] price: Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        :param pulumi.Input[str] price_effective_time: The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        :param pulumi.Input[str] price_expire_time: The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        if cost is not None:
            pulumi.set(__self__, "cost", cost)
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if original_price is not None:
            pulumi.set(__self__, "original_price", original_price)
        if price is not None:
            pulumi.set(__self__, "price", price)
        if price_effective_time is not None:
            pulumi.set(__self__, "price_effective_time", price_effective_time)
        if price_expire_time is not None:
            pulumi.set(__self__, "price_expire_time", price_expire_time)

    @property
    @pulumi.getter
    def cost(self) -> Optional[pulumi.Input[float]]:
        """
        The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        """
        return pulumi.get(self, "cost")

    @cost.setter
    def cost(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cost", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        """
        return pulumi.get(self, "currency_code")

    @currency_code.setter
    def currency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency_code", value)

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> Optional[pulumi.Input[float]]:
        """
        Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "original_price")

    @original_price.setter
    def original_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "original_price", value)

    @property
    @pulumi.getter
    def price(self) -> Optional[pulumi.Input[float]]:
        """
        Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        """
        return pulumi.get(self, "price")

    @price.setter
    def price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "price", value)

    @property
    @pulumi.getter(name="priceEffectiveTime")
    def price_effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_effective_time")

    @price_effective_time.setter
    def price_effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "price_effective_time", value)

    @property
    @pulumi.getter(name="priceExpireTime")
    def price_expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_expire_time")

    @price_expire_time.setter
    def price_expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "price_expire_time", value)


@pulumi.input_type
class GoogleCloudRetailV2PromotionArgs:
    def __init__(__self__, *,
                 promotion_id: Optional[pulumi.Input[str]] = None):
        """
        Promotion specification.
        :param pulumi.Input[str] promotion_id: Promotion identifier, which is the final component of name. For example, this field is "free_gift", if name is `projects/*/locations/global/catalogs/default_catalog/promotions/free_gift`. The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Corresponds to Google Merchant Center property [promotion_id](https://support.google.com/merchants/answer/7050148).
        """
        if promotion_id is not None:
            pulumi.set(__self__, "promotion_id", promotion_id)

    @property
    @pulumi.getter(name="promotionId")
    def promotion_id(self) -> Optional[pulumi.Input[str]]:
        """
        Promotion identifier, which is the final component of name. For example, this field is "free_gift", if name is `projects/*/locations/global/catalogs/default_catalog/promotions/free_gift`. The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Corresponds to Google Merchant Center property [promotion_id](https://support.google.com/merchants/answer/7050148).
        """
        return pulumi.get(self, "promotion_id")

    @promotion_id.setter
    def promotion_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_id", value)


@pulumi.input_type
class GoogleCloudRetailV2RatingArgs:
    def __init__(__self__, *,
                 average_rating: Optional[pulumi.Input[float]] = None,
                 rating_count: Optional[pulumi.Input[int]] = None,
                 rating_histogram: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The rating of a Product.
        :param pulumi.Input[float] average_rating: The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[int] rating_count: The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] rating_histogram: List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        if average_rating is not None:
            pulumi.set(__self__, "average_rating", average_rating)
        if rating_count is not None:
            pulumi.set(__self__, "rating_count", rating_count)
        if rating_histogram is not None:
            pulumi.set(__self__, "rating_histogram", rating_histogram)

    @property
    @pulumi.getter(name="averageRating")
    def average_rating(self) -> Optional[pulumi.Input[float]]:
        """
        The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "average_rating")

    @average_rating.setter
    def average_rating(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "average_rating", value)

    @property
    @pulumi.getter(name="ratingCount")
    def rating_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "rating_count")

    @rating_count.setter
    def rating_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rating_count", value)

    @property
    @pulumi.getter(name="ratingHistogram")
    def rating_histogram(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        return pulumi.get(self, "rating_histogram")

    @rating_histogram.setter
    def rating_histogram(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "rating_histogram", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleBoostActionArgs:
    def __init__(__self__, *,
                 boost: Optional[pulumi.Input[float]] = None,
                 products_filter: Optional[pulumi.Input[str]] = None):
        """
        A boost action to apply to results matching condition specified above.
        :param pulumi.Input[float] boost: Strength of the condition boost, which must be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big promotion. However, it does not necessarily mean that the boosted item will be the top result at all times, nor that other items will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant items. Setting to -1.0 gives the item a big demotion. However, results that are deeply relevant might still be shown. The item will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored.
        :param pulumi.Input[str] products_filter: The filter can have a max size of 5000 characters. An expression which specifies which products to apply an action to. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        if boost is not None:
            pulumi.set(__self__, "boost", boost)
        if products_filter is not None:
            pulumi.set(__self__, "products_filter", products_filter)

    @property
    @pulumi.getter
    def boost(self) -> Optional[pulumi.Input[float]]:
        """
        Strength of the condition boost, which must be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big promotion. However, it does not necessarily mean that the boosted item will be the top result at all times, nor that other items will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant items. Setting to -1.0 gives the item a big demotion. However, results that are deeply relevant might still be shown. The item will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored.
        """
        return pulumi.get(self, "boost")

    @boost.setter
    def boost(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "boost", value)

    @property
    @pulumi.getter(name="productsFilter")
    def products_filter(self) -> Optional[pulumi.Input[str]]:
        """
        The filter can have a max size of 5000 characters. An expression which specifies which products to apply an action to. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        return pulumi.get(self, "products_filter")

    @products_filter.setter
    def products_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "products_filter", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleDoNotAssociateActionArgs:
    def __init__(__self__, *,
                 do_not_associate_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Prevents `query_term` from being associated with specified terms during search. Example: Don't associate "gShoe" and "cheap".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] do_not_associate_terms: Cannot contain duplicates or the query term. Can specify up to 100 terms.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_terms: Terms from the search query. Will not consider do_not_associate_terms for search if in search query. Can specify up to 100 terms.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] terms: Will be [deprecated = true] post migration;
        """
        if do_not_associate_terms is not None:
            pulumi.set(__self__, "do_not_associate_terms", do_not_associate_terms)
        if query_terms is not None:
            pulumi.set(__self__, "query_terms", query_terms)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter(name="doNotAssociateTerms")
    def do_not_associate_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Cannot contain duplicates or the query term. Can specify up to 100 terms.
        """
        return pulumi.get(self, "do_not_associate_terms")

    @do_not_associate_terms.setter
    def do_not_associate_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "do_not_associate_terms", value)

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Terms from the search query. Will not consider do_not_associate_terms for search if in search query. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @query_terms.setter
    def query_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_terms", value)

    @property
    @pulumi.getter
    def terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "terms", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleFilterActionArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None):
        """
        * Rule Condition: - No Condition.query_terms provided is a global match. - 1 or more Condition.query_terms provided are combined with OR operator. * Action Input: The request query and filter that are applied to the retrieved products, in addition to any filters already provided with the SearchRequest. The AND operator is used to combine the query's existing filters with the filter rule(s). NOTE: May result in 0 results when filters conflict. * Action Result: Filters the returned objects to be ONLY those that passed the filter.
        :param pulumi.Input[str] filter: A filter to apply on the matching condition results. Supported features: * filter must be set. * Filter syntax is identical to SearchRequest.filter. See more details at the Retail Search [user guide](/retail/search/docs/filter-and-order#filter). * To filter products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to apply on the matching condition results. Supported features: * filter must be set. * Filter syntax is identical to SearchRequest.filter. See more details at the Retail Search [user guide](/retail/search/docs/filter-and-order#filter). * To filter products with product ID "product_1" or "product_2", and color "Red" or "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue")) *
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleIgnoreActionArgs:
    def __init__(__self__, *,
                 ignore_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Prevents a term in the query from being used in search. Example: Don't search for "shoddy".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_terms: Terms to ignore in the search query.
        """
        if ignore_terms is not None:
            pulumi.set(__self__, "ignore_terms", ignore_terms)

    @property
    @pulumi.getter(name="ignoreTerms")
    def ignore_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Terms to ignore in the search query.
        """
        return pulumi.get(self, "ignore_terms")

    @ignore_terms.setter
    def ignore_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ignore_terms", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleOnewaySynonymsActionArgs:
    def __init__(__self__, *,
                 oneway_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Maps a set of terms to a set of synonyms. Set of synonyms will be treated as synonyms of each query term only. `query_terms` will not be treated as synonyms of each other. Example: "sneakers" will use a synonym of "shoes". "shoes" will not use a synonym of "sneakers".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oneway_terms: Will be [deprecated = true] post migration;
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_terms: Terms from the search query. Will treat synonyms as their synonyms. Not themselves synonyms of the synonyms. Can specify up to 100 terms.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: Defines a set of synonyms. Cannot contain duplicates. Can specify up to 100 synonyms.
        """
        if oneway_terms is not None:
            pulumi.set(__self__, "oneway_terms", oneway_terms)
        if query_terms is not None:
            pulumi.set(__self__, "query_terms", query_terms)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter(name="onewayTerms")
    def oneway_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "oneway_terms")

    @oneway_terms.setter
    def oneway_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oneway_terms", value)

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Terms from the search query. Will treat synonyms as their synonyms. Not themselves synonyms of the synonyms. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @query_terms.setter
    def query_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_terms", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines a set of synonyms. Cannot contain duplicates. Can specify up to 100 synonyms.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "synonyms", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleRedirectActionArgs:
    def __init__(__self__, *,
                 redirect_uri: Optional[pulumi.Input[str]] = None):
        """
        Redirects a shopper to a specific page. * Rule Condition: - Must specify Condition.query_terms. * Action Input: Request Query * Action Result: Redirects shopper to provided uri.
        :param pulumi.Input[str] redirect_uri: URL must have length equal or less than 2000 characters.
        """
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL must have length equal or less than 2000 characters.
        """
        return pulumi.get(self, "redirect_uri")

    @redirect_uri.setter
    def redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_uri", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleReplacementActionArgs:
    def __init__(__self__, *,
                 query_terms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replacement_term: Optional[pulumi.Input[str]] = None,
                 term: Optional[pulumi.Input[str]] = None):
        """
        Replaces a term in the query. Multiple replacement candidates can be specified. All `query_terms` will be replaced with the replacement term. Example: Replace "gShoe" with "google shoe".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_terms: Terms from the search query. Will be replaced by replacement term. Can specify up to 100 terms.
        :param pulumi.Input[str] replacement_term: Term that will be used for replacement.
        :param pulumi.Input[str] term: Will be [deprecated = true] post migration;
        """
        if query_terms is not None:
            pulumi.set(__self__, "query_terms", query_terms)
        if replacement_term is not None:
            pulumi.set(__self__, "replacement_term", replacement_term)
        if term is not None:
            pulumi.set(__self__, "term", term)

    @property
    @pulumi.getter(name="queryTerms")
    def query_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Terms from the search query. Will be replaced by replacement term. Can specify up to 100 terms.
        """
        return pulumi.get(self, "query_terms")

    @query_terms.setter
    def query_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_terms", value)

    @property
    @pulumi.getter(name="replacementTerm")
    def replacement_term(self) -> Optional[pulumi.Input[str]]:
        """
        Term that will be used for replacement.
        """
        return pulumi.get(self, "replacement_term")

    @replacement_term.setter
    def replacement_term(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replacement_term", value)

    @property
    @pulumi.getter
    def term(self) -> Optional[pulumi.Input[str]]:
        """
        Will be [deprecated = true] post migration;
        """
        return pulumi.get(self, "term")

    @term.setter
    def term(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "term", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleTwowaySynonymsActionArgs:
    def __init__(__self__, *,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Creates a set of terms that will be treated as synonyms of each other. Example: synonyms of "sneakers" and "shoes": * "sneakers" will use a synonym of "shoes". * "shoes" will use a synonym of "sneakers".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms.
        """
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "synonyms", value)


@pulumi.input_type
class GoogleCloudRetailV2RuleArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input['GoogleCloudRetailV2ConditionArgs'],
                 boost_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleBoostActionArgs']] = None,
                 do_not_associate_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleDoNotAssociateActionArgs']] = None,
                 filter_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleFilterActionArgs']] = None,
                 ignore_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleIgnoreActionArgs']] = None,
                 oneway_synonyms_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleOnewaySynonymsActionArgs']] = None,
                 redirect_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleRedirectActionArgs']] = None,
                 replacement_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleReplacementActionArgs']] = None,
                 twoway_synonyms_action: Optional[pulumi.Input['GoogleCloudRetailV2RuleTwowaySynonymsActionArgs']] = None):
        """
        A rule is a condition-action pair * A condition defines when a rule is to be triggered. * An action specifies what occurs on that trigger. Currently rules only work for controls with SOLUTION_TYPE_SEARCH.
        :param pulumi.Input['GoogleCloudRetailV2ConditionArgs'] condition: The condition that triggers the rule. If the condition is empty, the rule will always apply.
        :param pulumi.Input['GoogleCloudRetailV2RuleBoostActionArgs'] boost_action: A boost action.
        :param pulumi.Input['GoogleCloudRetailV2RuleDoNotAssociateActionArgs'] do_not_associate_action: Prevents term from being associated with other terms.
        :param pulumi.Input['GoogleCloudRetailV2RuleFilterActionArgs'] filter_action: Filters results.
        :param pulumi.Input['GoogleCloudRetailV2RuleIgnoreActionArgs'] ignore_action: Ignores specific terms from query during search.
        :param pulumi.Input['GoogleCloudRetailV2RuleOnewaySynonymsActionArgs'] oneway_synonyms_action: Treats specific term as a synonym with a group of terms. Group of terms will not be treated as synonyms with the specific term.
        :param pulumi.Input['GoogleCloudRetailV2RuleRedirectActionArgs'] redirect_action: Redirects a shopper to a specific page.
        :param pulumi.Input['GoogleCloudRetailV2RuleReplacementActionArgs'] replacement_action: Replaces specific terms in the query.
        :param pulumi.Input['GoogleCloudRetailV2RuleTwowaySynonymsActionArgs'] twoway_synonyms_action: Treats a set of terms as synonyms of one another.
        """
        pulumi.set(__self__, "condition", condition)
        if boost_action is not None:
            pulumi.set(__self__, "boost_action", boost_action)
        if do_not_associate_action is not None:
            pulumi.set(__self__, "do_not_associate_action", do_not_associate_action)
        if filter_action is not None:
            pulumi.set(__self__, "filter_action", filter_action)
        if ignore_action is not None:
            pulumi.set(__self__, "ignore_action", ignore_action)
        if oneway_synonyms_action is not None:
            pulumi.set(__self__, "oneway_synonyms_action", oneway_synonyms_action)
        if redirect_action is not None:
            pulumi.set(__self__, "redirect_action", redirect_action)
        if replacement_action is not None:
            pulumi.set(__self__, "replacement_action", replacement_action)
        if twoway_synonyms_action is not None:
            pulumi.set(__self__, "twoway_synonyms_action", twoway_synonyms_action)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['GoogleCloudRetailV2ConditionArgs']:
        """
        The condition that triggers the rule. If the condition is empty, the rule will always apply.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['GoogleCloudRetailV2ConditionArgs']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="boostAction")
    def boost_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleBoostActionArgs']]:
        """
        A boost action.
        """
        return pulumi.get(self, "boost_action")

    @boost_action.setter
    def boost_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleBoostActionArgs']]):
        pulumi.set(self, "boost_action", value)

    @property
    @pulumi.getter(name="doNotAssociateAction")
    def do_not_associate_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleDoNotAssociateActionArgs']]:
        """
        Prevents term from being associated with other terms.
        """
        return pulumi.get(self, "do_not_associate_action")

    @do_not_associate_action.setter
    def do_not_associate_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleDoNotAssociateActionArgs']]):
        pulumi.set(self, "do_not_associate_action", value)

    @property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleFilterActionArgs']]:
        """
        Filters results.
        """
        return pulumi.get(self, "filter_action")

    @filter_action.setter
    def filter_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleFilterActionArgs']]):
        pulumi.set(self, "filter_action", value)

    @property
    @pulumi.getter(name="ignoreAction")
    def ignore_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleIgnoreActionArgs']]:
        """
        Ignores specific terms from query during search.
        """
        return pulumi.get(self, "ignore_action")

    @ignore_action.setter
    def ignore_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleIgnoreActionArgs']]):
        pulumi.set(self, "ignore_action", value)

    @property
    @pulumi.getter(name="onewaySynonymsAction")
    def oneway_synonyms_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleOnewaySynonymsActionArgs']]:
        """
        Treats specific term as a synonym with a group of terms. Group of terms will not be treated as synonyms with the specific term.
        """
        return pulumi.get(self, "oneway_synonyms_action")

    @oneway_synonyms_action.setter
    def oneway_synonyms_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleOnewaySynonymsActionArgs']]):
        pulumi.set(self, "oneway_synonyms_action", value)

    @property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleRedirectActionArgs']]:
        """
        Redirects a shopper to a specific page.
        """
        return pulumi.get(self, "redirect_action")

    @redirect_action.setter
    def redirect_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleRedirectActionArgs']]):
        pulumi.set(self, "redirect_action", value)

    @property
    @pulumi.getter(name="replacementAction")
    def replacement_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleReplacementActionArgs']]:
        """
        Replaces specific terms in the query.
        """
        return pulumi.get(self, "replacement_action")

    @replacement_action.setter
    def replacement_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleReplacementActionArgs']]):
        pulumi.set(self, "replacement_action", value)

    @property
    @pulumi.getter(name="twowaySynonymsAction")
    def twoway_synonyms_action(self) -> Optional[pulumi.Input['GoogleCloudRetailV2RuleTwowaySynonymsActionArgs']]:
        """
        Treats a set of terms as synonyms of one another.
        """
        return pulumi.get(self, "twoway_synonyms_action")

    @twoway_synonyms_action.setter
    def twoway_synonyms_action(self, value: Optional[pulumi.Input['GoogleCloudRetailV2RuleTwowaySynonymsActionArgs']]):
        pulumi.set(self, "twoway_synonyms_action", value)


@pulumi.input_type
class GoogleCloudRetailV2SearchRequestDynamicFacetSpecArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestDynamicFacetSpecMode']] = None):
        """
        The specifications of dynamically generated facets.
        :param pulumi.Input['GoogleCloudRetailV2SearchRequestDynamicFacetSpecMode'] mode: Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if it's unset.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestDynamicFacetSpecMode']]:
        """
        Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if it's unset.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestDynamicFacetSpecMode']]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class GoogleCloudRetailV2SearchRequestPersonalizationSpecArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestPersonalizationSpecMode']] = None):
        """
        The specification for personalization.
        :param pulumi.Input['GoogleCloudRetailV2SearchRequestPersonalizationSpecMode'] mode: Defaults to Mode.AUTO.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestPersonalizationSpecMode']]:
        """
        Defaults to Mode.AUTO.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['GoogleCloudRetailV2SearchRequestPersonalizationSpecMode']]):
        pulumi.set(self, "mode", value)


