# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'InstanceConnectMode',
    'InstanceReadReplicasMode',
    'InstanceSuspensionReasonsItem',
    'InstanceTier',
    'InstanceTransitEncryptionMode',
    'PersistenceConfigPersistenceMode',
    'PersistenceConfigRdbSnapshotPeriod',
    'WeeklyMaintenanceWindowDay',
]


class InstanceConnectMode(str, Enum):
    """
    Optional. The network connect mode of the Redis instance. If not provided, the connect mode defaults to DIRECT_PEERING.
    """
    CONNECT_MODE_UNSPECIFIED = "CONNECT_MODE_UNSPECIFIED"
    """
    Not set.
    """
    DIRECT_PEERING = "DIRECT_PEERING"
    """
    Connect via direct peering to the Memorystore for Redis hosted service.
    """
    PRIVATE_SERVICE_ACCESS = "PRIVATE_SERVICE_ACCESS"
    """
    Connect your Memorystore for Redis instance using Private Service Access. Private services access provides an IP address range for multiple Google Cloud services, including Memorystore.
    """


class InstanceReadReplicasMode(str, Enum):
    """
    Optional. Read replicas mode for the instance. Defaults to READ_REPLICAS_DISABLED.
    """
    READ_REPLICAS_MODE_UNSPECIFIED = "READ_REPLICAS_MODE_UNSPECIFIED"
    """
    If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
    """
    READ_REPLICAS_DISABLED = "READ_REPLICAS_DISABLED"
    """
    If disabled, read endpoint will not be provided and the instance cannot scale up or down the number of replicas.
    """
    READ_REPLICAS_ENABLED = "READ_REPLICAS_ENABLED"
    """
    If enabled, read endpoint will be provided and the instance can scale up and down the number of replicas. Not valid for basic tier.
    """


class InstanceSuspensionReasonsItem(str, Enum):
    SUSPENSION_REASON_UNSPECIFIED = "SUSPENSION_REASON_UNSPECIFIED"
    """
    Not set.
    """
    CUSTOMER_MANAGED_KEY_ISSUE = "CUSTOMER_MANAGED_KEY_ISSUE"
    """
    Something wrong with the CMEK key provided by customer.
    """


class InstanceTier(str, Enum):
    """
    Required. The service tier of the instance.
    """
    TIER_UNSPECIFIED = "TIER_UNSPECIFIED"
    """
    Not set.
    """
    BASIC = "BASIC"
    """
    BASIC tier: standalone instance
    """
    STANDARD_HA = "STANDARD_HA"
    """
    STANDARD_HA tier: highly available primary/replica instances
    """


class InstanceTransitEncryptionMode(str, Enum):
    """
    Optional. The TLS mode of the Redis instance. If not provided, TLS is disabled for the instance.
    """
    TRANSIT_ENCRYPTION_MODE_UNSPECIFIED = "TRANSIT_ENCRYPTION_MODE_UNSPECIFIED"
    """
    Not set.
    """
    SERVER_AUTHENTICATION = "SERVER_AUTHENTICATION"
    """
    Client to Server traffic encryption enabled with server authentication.
    """
    DISABLED = "DISABLED"
    """
    TLS is disabled for the instance.
    """


class PersistenceConfigPersistenceMode(str, Enum):
    """
    Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
    """
    PERSISTENCE_MODE_UNSPECIFIED = "PERSISTENCE_MODE_UNSPECIFIED"
    """
    Not set.
    """
    DISABLED = "DISABLED"
    """
    Persistence is disabled for the instance, and any existing snapshots are deleted.
    """
    RDB = "RDB"
    """
    RDB based Persistence is enabled.
    """


class PersistenceConfigRdbSnapshotPeriod(str, Enum):
    """
    Optional. Period between RDB snapshots. Snapshots will be attempted every period starting from the provided snapshot start time. For example, a start time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45, 18:45, and 00:45 the next day, and so on. If not provided, TWENTY_FOUR_HOURS will be used as default.
    """
    SNAPSHOT_PERIOD_UNSPECIFIED = "SNAPSHOT_PERIOD_UNSPECIFIED"
    """
    Not set.
    """
    ONE_HOUR = "ONE_HOUR"
    """
    Snapshot every 1 hour.
    """
    SIX_HOURS = "SIX_HOURS"
    """
    Snapshot every 6 hours.
    """
    TWELVE_HOURS = "TWELVE_HOURS"
    """
    Snapshot every 12 hours.
    """
    TWENTY_FOUR_HOURS = "TWENTY_FOUR_HOURS"
    """
    Snapshot every 24 hours.
    """


class WeeklyMaintenanceWindowDay(str, Enum):
    """
    Required. The day of week that maintenance updates occur.
    """
    DAY_OF_WEEK_UNSPECIFIED = "DAY_OF_WEEK_UNSPECIFIED"
    """
    The day of the week is unspecified.
    """
    MONDAY = "MONDAY"
    """
    Monday
    """
    TUESDAY = "TUESDAY"
    """
    Tuesday
    """
    WEDNESDAY = "WEDNESDAY"
    """
    Wednesday
    """
    THURSDAY = "THURSDAY"
    """
    Thursday
    """
    FRIDAY = "FRIDAY"
    """
    Friday
    """
    SATURDAY = "SATURDAY"
    """
    Saturday
    """
    SUNDAY = "SUNDAY"
    """
    Sunday
    """
