# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CapacityResponse',
    'DeliveryConfigResponse',
    'ExportConfigResponse',
    'PartitionConfigResponse',
    'PubSubConfigResponse',
    'ReservationConfigResponse',
    'RetentionConfigResponse',
]

@pulumi.output_type
class CapacityResponse(dict):
    """
    The throughput capacity configuration for each partition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMibPerSec":
            suggest = "publish_mib_per_sec"
        elif key == "subscribeMibPerSec":
            suggest = "subscribe_mib_per_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_mib_per_sec: int,
                 subscribe_mib_per_sec: int):
        """
        The throughput capacity configuration for each partition.
        :param int publish_mib_per_sec: Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        :param int subscribe_mib_per_sec: Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 32.
        """
        pulumi.set(__self__, "publish_mib_per_sec", publish_mib_per_sec)
        pulumi.set(__self__, "subscribe_mib_per_sec", subscribe_mib_per_sec)

    @property
    @pulumi.getter(name="publishMibPerSec")
    def publish_mib_per_sec(self) -> int:
        """
        Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
        """
        return pulumi.get(self, "publish_mib_per_sec")

    @property
    @pulumi.getter(name="subscribeMibPerSec")
    def subscribe_mib_per_sec(self) -> int:
        """
        Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 32.
        """
        return pulumi.get(self, "subscribe_mib_per_sec")


@pulumi.output_type
class DeliveryConfigResponse(dict):
    """
    The settings for a subscription's message delivery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryRequirement":
            suggest = "delivery_requirement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_requirement: str):
        """
        The settings for a subscription's message delivery.
        :param str delivery_requirement: The DeliveryRequirement for this subscription.
        """
        pulumi.set(__self__, "delivery_requirement", delivery_requirement)

    @property
    @pulumi.getter(name="deliveryRequirement")
    def delivery_requirement(self) -> str:
        """
        The DeliveryRequirement for this subscription.
        """
        return pulumi.get(self, "delivery_requirement")


@pulumi.output_type
class ExportConfigResponse(dict):
    """
    Configuration for a Pub/Sub Lite subscription that writes messages to a destination. User subscriber clients must not connect to this subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentState":
            suggest = "current_state"
        elif key == "deadLetterTopic":
            suggest = "dead_letter_topic"
        elif key == "desiredState":
            suggest = "desired_state"
        elif key == "pubsubConfig":
            suggest = "pubsub_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_state: str,
                 dead_letter_topic: str,
                 desired_state: str,
                 pubsub_config: 'outputs.PubSubConfigResponse'):
        """
        Configuration for a Pub/Sub Lite subscription that writes messages to a destination. User subscriber clients must not connect to this subscription.
        :param str current_state: The current state of the export, which may be different to the desired state due to errors. This field is output only.
        :param str dead_letter_topic: Optional. The name of an optional Pub/Sub Lite topic to publish messages that can not be exported to the destination. For example, the message can not be published to the Pub/Sub service because it does not satisfy the constraints documented at https://cloud.google.com/pubsub/docs/publisher. Structured like: projects/{project_number}/locations/{location}/topics/{topic_id}. Must be within the same project and location as the subscription. The topic may be changed or removed.
        :param str desired_state: The desired state of this export. Setting this to values other than `ACTIVE` and `PAUSED` will result in an error.
        :param 'PubSubConfigResponse' pubsub_config: Messages are automatically written from the Pub/Sub Lite topic associated with this subscription to a Pub/Sub topic.
        """
        pulumi.set(__self__, "current_state", current_state)
        pulumi.set(__self__, "dead_letter_topic", dead_letter_topic)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "pubsub_config", pubsub_config)

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> str:
        """
        The current state of the export, which may be different to the desired state due to errors. This field is output only.
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter(name="deadLetterTopic")
    def dead_letter_topic(self) -> str:
        """
        Optional. The name of an optional Pub/Sub Lite topic to publish messages that can not be exported to the destination. For example, the message can not be published to the Pub/Sub service because it does not satisfy the constraints documented at https://cloud.google.com/pubsub/docs/publisher. Structured like: projects/{project_number}/locations/{location}/topics/{topic_id}. Must be within the same project and location as the subscription. The topic may be changed or removed.
        """
        return pulumi.get(self, "dead_letter_topic")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        The desired state of this export. Setting this to values other than `ACTIVE` and `PAUSED` will result in an error.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="pubsubConfig")
    def pubsub_config(self) -> 'outputs.PubSubConfigResponse':
        """
        Messages are automatically written from the Pub/Sub Lite topic associated with this subscription to a Pub/Sub topic.
        """
        return pulumi.get(self, "pubsub_config")


@pulumi.output_type
class PartitionConfigResponse(dict):
    """
    The settings for a topic's partitions.
    """
    def __init__(__self__, *,
                 capacity: 'outputs.CapacityResponse',
                 count: str,
                 scale: int):
        """
        The settings for a topic's partitions.
        :param 'CapacityResponse' capacity: The capacity configuration.
        :param str count: The number of partitions in the topic. Must be at least 1. Once a topic has been created the number of partitions can be increased but not decreased. Message ordering is not guaranteed across a topic resize. For more information see https://cloud.google.com/pubsub/lite/docs/topics#scaling_capacity
        :param int scale: DEPRECATED: Use capacity instead which can express a superset of configurations. Every partition in the topic is allocated throughput equivalent to `scale` times the standard partition throughput (4 MiB/s). This is also reflected in the cost of this topic; a topic with `scale` of 2 and count of 10 is charged for 20 partitions. This value must be in the range [1,4].
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def capacity(self) -> 'outputs.CapacityResponse':
        """
        The capacity configuration.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def count(self) -> str:
        """
        The number of partitions in the topic. Must be at least 1. Once a topic has been created the number of partitions can be increased but not decreased. Message ordering is not guaranteed across a topic resize. For more information see https://cloud.google.com/pubsub/lite/docs/topics#scaling_capacity
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def scale(self) -> int:
        """
        DEPRECATED: Use capacity instead which can express a superset of configurations. Every partition in the topic is allocated throughput equivalent to `scale` times the standard partition throughput (4 MiB/s). This is also reflected in the cost of this topic; a topic with `scale` of 2 and count of 10 is charged for 20 partitions. This value must be in the range [1,4].
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class PubSubConfigResponse(dict):
    """
    Configuration for exporting to a Pub/Sub topic.
    """
    def __init__(__self__, *,
                 topic: str):
        """
        Configuration for exporting to a Pub/Sub topic.
        :param str topic: The name of the Pub/Sub topic. Structured like: projects/{project_number}/topics/{topic_id}. The topic may be changed.
        """
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the Pub/Sub topic. Structured like: projects/{project_number}/topics/{topic_id}. The topic may be changed.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class ReservationConfigResponse(dict):
    """
    The settings for this topic's Reservation usage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputReservation":
            suggest = "throughput_reservation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_reservation: str):
        """
        The settings for this topic's Reservation usage.
        :param str throughput_reservation: The Reservation to use for this topic's throughput capacity. Structured like: projects/{project_number}/locations/{location}/reservations/{reservation_id}
        """
        pulumi.set(__self__, "throughput_reservation", throughput_reservation)

    @property
    @pulumi.getter(name="throughputReservation")
    def throughput_reservation(self) -> str:
        """
        The Reservation to use for this topic's throughput capacity. Structured like: projects/{project_number}/locations/{location}/reservations/{reservation_id}
        """
        return pulumi.get(self, "throughput_reservation")


@pulumi.output_type
class RetentionConfigResponse(dict):
    """
    The settings for a topic's message retention.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "perPartitionBytes":
            suggest = "per_partition_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 per_partition_bytes: str,
                 period: str):
        """
        The settings for a topic's message retention.
        :param str per_partition_bytes: The provisioned storage, in bytes, per partition. If the number of bytes stored in any of the topic's partitions grows beyond this value, older messages will be dropped to make room for newer ones, regardless of the value of `period`.
        :param str period: How long a published message is retained. If unset, messages will be retained as long as the bytes retained for each partition is below `per_partition_bytes`.
        """
        pulumi.set(__self__, "per_partition_bytes", per_partition_bytes)
        pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter(name="perPartitionBytes")
    def per_partition_bytes(self) -> str:
        """
        The provisioned storage, in bytes, per partition. If the number of bytes stored in any of the topic's partitions grows beyond this value, older messages will be dropped to make room for newer ones, regardless of the value of `period`.
        """
        return pulumi.get(self, "per_partition_bytes")

    @property
    @pulumi.getter
    def period(self) -> str:
        """
        How long a published message is retained. If unset, messages will be retained as long as the bytes retained for each partition is below `per_partition_bytes`.
        """
        return pulumi.get(self, "period")


