# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'FixedOrPercentArgs',
    'OSPolicyAssignmentInstanceFilterInventoryArgs',
    'OSPolicyAssignmentInstanceFilterArgs',
    'OSPolicyAssignmentLabelSetArgs',
    'OSPolicyAssignmentRolloutArgs',
    'OSPolicyInventoryFilterArgs',
    'OSPolicyOSFilterArgs',
    'OSPolicyResourceExecResourceExecArgs',
    'OSPolicyResourceExecResourceArgs',
    'OSPolicyResourceFileGcsArgs',
    'OSPolicyResourceFileRemoteArgs',
    'OSPolicyResourceFileResourceArgs',
    'OSPolicyResourceFileArgs',
    'OSPolicyResourceGroupArgs',
    'OSPolicyResourcePackageResourceAPTArgs',
    'OSPolicyResourcePackageResourceDebArgs',
    'OSPolicyResourcePackageResourceGooGetArgs',
    'OSPolicyResourcePackageResourceMSIArgs',
    'OSPolicyResourcePackageResourceRPMArgs',
    'OSPolicyResourcePackageResourceYUMArgs',
    'OSPolicyResourcePackageResourceZypperArgs',
    'OSPolicyResourcePackageResourceArgs',
    'OSPolicyResourceRepositoryResourceAptRepositoryArgs',
    'OSPolicyResourceRepositoryResourceGooRepositoryArgs',
    'OSPolicyResourceRepositoryResourceYumRepositoryArgs',
    'OSPolicyResourceRepositoryResourceZypperRepositoryArgs',
    'OSPolicyResourceRepositoryResourceArgs',
    'OSPolicyResourceArgs',
    'OSPolicyArgs',
]

@pulumi.input_type
class FixedOrPercentArgs:
    def __init__(__self__, *,
                 fixed: Optional[pulumi.Input[int]] = None,
                 percent: Optional[pulumi.Input[int]] = None):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param pulumi.Input[int] fixed: Specifies a fixed value.
        :param pulumi.Input[int] percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @fixed.setter
    def fixed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)


@pulumi.input_type
class OSPolicyAssignmentInstanceFilterInventoryArgs:
    def __init__(__self__, *,
                 os_short_name: pulumi.Input[str],
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        VM inventory details.
        :param pulumi.Input[str] os_short_name: The OS short name
        :param pulumi.Input[str] os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> pulumi.Input[str]:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @os_short_name.setter
    def os_short_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_short_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class OSPolicyAssignmentInstanceFilterArgs:
    def __init__(__self__, *,
                 all: Optional[pulumi.Input[bool]] = None,
                 exclusion_labels: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]] = None,
                 inclusion_labels: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]] = None,
                 inventories: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentInstanceFilterInventoryArgs']]]] = None,
                 os_short_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filters to select target VMs for an assignment. If more than one filter criteria is specified below, a VM will be selected if and only if it satisfies all of them.
        :param pulumi.Input[bool] all: Target all VMs in the project. If true, no other criteria is permitted.
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]] exclusion_labels: List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]] inclusion_labels: List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentInstanceFilterInventoryArgs']]] inventories: List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] os_short_names: Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if exclusion_labels is not None:
            pulumi.set(__self__, "exclusion_labels", exclusion_labels)
        if inclusion_labels is not None:
            pulumi.set(__self__, "inclusion_labels", inclusion_labels)
        if inventories is not None:
            pulumi.set(__self__, "inventories", inventories)
        if os_short_names is not None:
            warnings.warn("""Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.""", DeprecationWarning)
            pulumi.log.warn("""os_short_names is deprecated: Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.""")
        if os_short_names is not None:
            pulumi.set(__self__, "os_short_names", os_short_names)

    @property
    @pulumi.getter
    def all(self) -> Optional[pulumi.Input[bool]]:
        """
        Target all VMs in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="exclusionLabels")
    def exclusion_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]]:
        """
        List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "exclusion_labels")

    @exclusion_labels.setter
    def exclusion_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]]):
        pulumi.set(self, "exclusion_labels", value)

    @property
    @pulumi.getter(name="inclusionLabels")
    def inclusion_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]]:
        """
        List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "inclusion_labels")

    @inclusion_labels.setter
    def inclusion_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentLabelSetArgs']]]]):
        pulumi.set(self, "inclusion_labels", value)

    @property
    @pulumi.getter
    def inventories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentInstanceFilterInventoryArgs']]]]:
        """
        List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        return pulumi.get(self, "inventories")

    @inventories.setter
    def inventories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyAssignmentInstanceFilterInventoryArgs']]]]):
        pulumi.set(self, "inventories", value)

    @property
    @pulumi.getter(name="osShortNames")
    def os_short_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.
        """
        return pulumi.get(self, "os_short_names")

    @os_short_names.setter
    def os_short_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "os_short_names", value)


@pulumi.input_type
class OSPolicyAssignmentLabelSetArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Message representing label set. * A label is a key value pair set for a VM. * A LabelSet is a set of labels. * Labels within a LabelSet are ANDed. In other words, a LabelSet is applicable for a VM only if it matches all the labels in the LabelSet. * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will only be applicable for those VMs with both labels present.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class OSPolicyAssignmentRolloutArgs:
    def __init__(__self__, *,
                 disruption_budget: pulumi.Input['FixedOrPercentArgs'],
                 min_wait_duration: pulumi.Input[str]):
        """
        Message to configure the rollout at the zonal level for the OS policy assignment.
        :param pulumi.Input['FixedOrPercentArgs'] disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        :param pulumi.Input[str] min_wait_duration: This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "min_wait_duration", min_wait_duration)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> pulumi.Input['FixedOrPercentArgs']:
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        """
        return pulumi.get(self, "disruption_budget")

    @disruption_budget.setter
    def disruption_budget(self, value: pulumi.Input['FixedOrPercentArgs']):
        pulumi.set(self, "disruption_budget", value)

    @property
    @pulumi.getter(name="minWaitDuration")
    def min_wait_duration(self) -> pulumi.Input[str]:
        """
        This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        return pulumi.get(self, "min_wait_duration")

    @min_wait_duration.setter
    def min_wait_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "min_wait_duration", value)


@pulumi.input_type
class OSPolicyInventoryFilterArgs:
    def __init__(__self__, *,
                 os_short_name: pulumi.Input[str],
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        Filtering criteria to select VMs based on inventory details.
        :param pulumi.Input[str] os_short_name: The OS short name
        :param pulumi.Input[str] os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> pulumi.Input[str]:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @os_short_name.setter
    def os_short_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_short_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class OSPolicyOSFilterArgs:
    def __init__(__self__, *,
                 os_short_name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        Filtering criteria to select VMs based on OS details.
        :param pulumi.Input[str] os_short_name: This should match OS short name emitted by the OS inventory agent. An empty value matches any OS.
        :param pulumi.Input[str] os_version: This value should match the version emitted by the OS inventory agent. Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*`
        """
        if os_short_name is not None:
            pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> Optional[pulumi.Input[str]]:
        """
        This should match OS short name emitted by the OS inventory agent. An empty value matches any OS.
        """
        return pulumi.get(self, "os_short_name")

    @os_short_name.setter
    def os_short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_short_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        This value should match the version emitted by the OS inventory agent. Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*`
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class OSPolicyResourceExecResourceExecArgs:
    def __init__(__self__, *,
                 interpreter: pulumi.Input['OSPolicyResourceExecResourceExecInterpreter'],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file: Optional[pulumi.Input['OSPolicyResourceFileArgs']] = None,
                 output_file_path: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        A file or script to execute.
        :param pulumi.Input['OSPolicyResourceExecResourceExecInterpreter'] interpreter: The script interpreter to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional arguments to pass to the source during execution.
        :param pulumi.Input['OSPolicyResourceFileArgs'] file: A remote or local file.
        :param pulumi.Input[str] output_file_path: Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        :param pulumi.Input[str] script: An inline script. The size of the script is limited to 32KiB.
        """
        pulumi.set(__self__, "interpreter", interpreter)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if output_file_path is not None:
            pulumi.set(__self__, "output_file_path", output_file_path)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def interpreter(self) -> pulumi.Input['OSPolicyResourceExecResourceExecInterpreter']:
        """
        The script interpreter to use.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: pulumi.Input['OSPolicyResourceExecResourceExecInterpreter']):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional arguments to pass to the source during execution.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input['OSPolicyResourceFileArgs']]:
        """
        A remote or local file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input['OSPolicyResourceFileArgs']]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter(name="outputFilePath")
    def output_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        """
        return pulumi.get(self, "output_file_path")

    @output_file_path.setter
    def output_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_file_path", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        An inline script. The size of the script is limited to 32KiB.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class OSPolicyResourceExecResourceArgs:
    def __init__(__self__, *,
                 validate: pulumi.Input['OSPolicyResourceExecResourceExecArgs'],
                 enforce: Optional[pulumi.Input['OSPolicyResourceExecResourceExecArgs']] = None):
        """
        A resource that allows executing scripts on the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both stages accept a script as an argument to execute. When the `ExecResource` is applied by the agent, it first executes the script in the `validate` stage. The `validate` stage can signal that the `ExecResource` is already in the desired state by returning an exit code of `100`. If the `ExecResource` is not in the desired state, it should return an exit code of `101`. Any other exit code returned by this stage is considered an error. If the `ExecResource` is not in the desired state based on the exit code from the `validate` stage, the agent proceeds to execute the script from the `enforce` stage. If the `ExecResource` is already in the desired state, the `enforce` stage will not be run. Similar to `validate` stage, the `enforce` stage should return an exit code of `100` to indicate that the resource in now in its desired state. Any other exit code is considered an error. NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not in desired state` and errors. Because, for example, Powershell will always return an exit code of `0` unless an `exit` statement is provided in the script. So, for reasons of consistency and being explicit, exit codes `100` and `101` were chosen.
        :param pulumi.Input['OSPolicyResourceExecResourceExecArgs'] validate: What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        :param pulumi.Input['OSPolicyResourceExecResourceExecArgs'] enforce: What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        pulumi.set(__self__, "validate", validate)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Input['OSPolicyResourceExecResourceExecArgs']:
        """
        What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: pulumi.Input['OSPolicyResourceExecResourceExecArgs']):
        pulumi.set(self, "validate", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input['OSPolicyResourceExecResourceExecArgs']]:
        """
        What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input['OSPolicyResourceExecResourceExecArgs']]):
        pulumi.set(self, "enforce", value)


@pulumi.input_type
class OSPolicyResourceFileGcsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 object: pulumi.Input[str],
                 generation: Optional[pulumi.Input[str]] = None):
        """
        Specifies a file available as a Cloud Storage Object.
        :param pulumi.Input[str] bucket: Bucket of the Cloud Storage object.
        :param pulumi.Input[str] object: Name of the Cloud Storage object.
        :param pulumi.Input[str] generation: Generation number of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)


@pulumi.input_type
class OSPolicyResourceFileRemoteArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 sha256_checksum: Optional[pulumi.Input[str]] = None):
        """
        Specifies a file available via some URI.
        :param pulumi.Input[str] uri: URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        :param pulumi.Input[str] sha256_checksum: SHA256 checksum of the remote file.
        """
        pulumi.set(__self__, "uri", uri)
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")

    @sha256_checksum.setter
    def sha256_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha256_checksum", value)


@pulumi.input_type
class OSPolicyResourceFileResourceArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 state: pulumi.Input['OSPolicyResourceFileResourceState'],
                 content: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input['OSPolicyResourceFileArgs']] = None,
                 permissions: Optional[pulumi.Input[str]] = None):
        """
        A resource that manages the state of a file.
        :param pulumi.Input[str] path: The absolute path of the file within the VM.
        :param pulumi.Input['OSPolicyResourceFileResourceState'] state: Desired state of the file.
        :param pulumi.Input[str] content: A a file with this content. The size of the content is limited to 32KiB.
        :param pulumi.Input['OSPolicyResourceFileArgs'] file: A remote or local source.
        :param pulumi.Input[str] permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "state", state)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The absolute path of the file within the VM.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input['OSPolicyResourceFileResourceState']:
        """
        Desired state of the file.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input['OSPolicyResourceFileResourceState']):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        A a file with this content. The size of the content is limited to 32KiB.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input['OSPolicyResourceFileArgs']]:
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input['OSPolicyResourceFileArgs']]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class OSPolicyResourceFileArgs:
    def __init__(__self__, *,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 gcs: Optional[pulumi.Input['OSPolicyResourceFileGcsArgs']] = None,
                 local_path: Optional[pulumi.Input[str]] = None,
                 remote: Optional[pulumi.Input['OSPolicyResourceFileRemoteArgs']] = None):
        """
        A remote or local file.
        :param pulumi.Input[bool] allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param pulumi.Input['OSPolicyResourceFileGcsArgs'] gcs: A Cloud Storage object.
        :param pulumi.Input[str] local_path: A local path within the VM to use.
        :param pulumi.Input['OSPolicyResourceFileRemoteArgs'] remote: A generic remote file.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['OSPolicyResourceFileGcsArgs']]:
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['OSPolicyResourceFileGcsArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)

    @property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['OSPolicyResourceFileRemoteArgs']]:
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['OSPolicyResourceFileRemoteArgs']]):
        pulumi.set(self, "remote", value)


@pulumi.input_type
class OSPolicyResourceGroupArgs:
    def __init__(__self__, *,
                 resources: pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceArgs']]],
                 inventory_filters: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyInventoryFilterArgs']]]] = None,
                 os_filter: Optional[pulumi.Input['OSPolicyOSFilterArgs']] = None):
        """
        Resource groups provide a mechanism to group OS policy resources. Resource groups enable OS policy authors to create a single OS policy to be applied to VMs running different operating Systems. When the OS policy is applied to a target VM, the appropriate resource group within the OS policy is selected based on the `OSFilter` specified within the resource group.
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceArgs']]] resources: List of resources configured for this resource group. The resources are executed in the exact order specified here.
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyInventoryFilterArgs']]] inventory_filters: List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        :param pulumi.Input['OSPolicyOSFilterArgs'] os_filter: Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group
        """
        pulumi.set(__self__, "resources", resources)
        if inventory_filters is not None:
            pulumi.set(__self__, "inventory_filters", inventory_filters)
        if os_filter is not None:
            warnings.warn("""Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group""", DeprecationWarning)
            pulumi.log.warn("""os_filter is deprecated: Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group""")
        if os_filter is not None:
            pulumi.set(__self__, "os_filter", os_filter)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceArgs']]]:
        """
        List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceArgs']]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="inventoryFilters")
    def inventory_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyInventoryFilterArgs']]]]:
        """
        List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        """
        return pulumi.get(self, "inventory_filters")

    @inventory_filters.setter
    def inventory_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OSPolicyInventoryFilterArgs']]]]):
        pulumi.set(self, "inventory_filters", value)

    @property
    @pulumi.getter(name="osFilter")
    def os_filter(self) -> Optional[pulumi.Input['OSPolicyOSFilterArgs']]:
        """
        Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group
        """
        return pulumi.get(self, "os_filter")

    @os_filter.setter
    def os_filter(self, value: Optional[pulumi.Input['OSPolicyOSFilterArgs']]):
        pulumi.set(self, "os_filter", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceAPTArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        A package managed by APT. - install: `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove [name]`
        :param pulumi.Input[str] name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Package name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceDebArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['OSPolicyResourceFileArgs'],
                 pull_deps: Optional[pulumi.Input[bool]] = None):
        """
        A deb package file. dpkg packages only support INSTALLED state.
        :param pulumi.Input['OSPolicyResourceFileArgs'] source: A deb package.
        :param pulumi.Input[bool] pull_deps: Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        """
        pulumi.set(__self__, "source", source)
        if pull_deps is not None:
            pulumi.set(__self__, "pull_deps", pull_deps)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['OSPolicyResourceFileArgs']:
        """
        A deb package.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['OSPolicyResourceFileArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        """
        return pulumi.get(self, "pull_deps")

    @pull_deps.setter
    def pull_deps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pull_deps", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceGooGetArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        A package managed by GooGet. - install: `googet -noconfirm install package` - remove: `googet -noconfirm remove package`
        :param pulumi.Input[str] name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Package name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceMSIArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['OSPolicyResourceFileArgs'],
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An MSI package. MSI packages only support INSTALLED state.
        :param pulumi.Input['OSPolicyResourceFileArgs'] source: The MSI package.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] properties: Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        pulumi.set(__self__, "source", source)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['OSPolicyResourceFileArgs']:
        """
        The MSI package.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['OSPolicyResourceFileArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceRPMArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['OSPolicyResourceFileArgs'],
                 pull_deps: Optional[pulumi.Input[bool]] = None):
        """
        An RPM package file. RPM packages only support INSTALLED state.
        :param pulumi.Input['OSPolicyResourceFileArgs'] source: An rpm package.
        :param pulumi.Input[bool] pull_deps: Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        pulumi.set(__self__, "source", source)
        if pull_deps is not None:
            pulumi.set(__self__, "pull_deps", pull_deps)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['OSPolicyResourceFileArgs']:
        """
        An rpm package.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['OSPolicyResourceFileArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        return pulumi.get(self, "pull_deps")

    @pull_deps.setter
    def pull_deps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pull_deps", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceYUMArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        A package managed by YUM. - install: `yum -y install package` - remove: `yum -y remove package`
        :param pulumi.Input[str] name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Package name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceZypperArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        A package managed by Zypper. - install: `zypper -y install package` - remove: `zypper -y rm package`
        :param pulumi.Input[str] name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Package name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OSPolicyResourcePackageResourceArgs:
    def __init__(__self__, *,
                 desired_state: pulumi.Input['OSPolicyResourcePackageResourceDesiredState'],
                 apt: Optional[pulumi.Input['OSPolicyResourcePackageResourceAPTArgs']] = None,
                 deb: Optional[pulumi.Input['OSPolicyResourcePackageResourceDebArgs']] = None,
                 googet: Optional[pulumi.Input['OSPolicyResourcePackageResourceGooGetArgs']] = None,
                 msi: Optional[pulumi.Input['OSPolicyResourcePackageResourceMSIArgs']] = None,
                 rpm: Optional[pulumi.Input['OSPolicyResourcePackageResourceRPMArgs']] = None,
                 yum: Optional[pulumi.Input['OSPolicyResourcePackageResourceYUMArgs']] = None,
                 zypper: Optional[pulumi.Input['OSPolicyResourcePackageResourceZypperArgs']] = None):
        """
        A resource that manages a system package.
        :param pulumi.Input['OSPolicyResourcePackageResourceDesiredState'] desired_state: The desired state the agent should maintain for this package.
        :param pulumi.Input['OSPolicyResourcePackageResourceAPTArgs'] apt: A package managed by Apt.
        :param pulumi.Input['OSPolicyResourcePackageResourceDebArgs'] deb: A deb package file.
        :param pulumi.Input['OSPolicyResourcePackageResourceGooGetArgs'] googet: A package managed by GooGet.
        :param pulumi.Input['OSPolicyResourcePackageResourceMSIArgs'] msi: An MSI package.
        :param pulumi.Input['OSPolicyResourcePackageResourceRPMArgs'] rpm: An rpm package file.
        :param pulumi.Input['OSPolicyResourcePackageResourceYUMArgs'] yum: A package managed by YUM.
        :param pulumi.Input['OSPolicyResourcePackageResourceZypperArgs'] zypper: A package managed by Zypper.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if deb is not None:
            pulumi.set(__self__, "deb", deb)
        if googet is not None:
            pulumi.set(__self__, "googet", googet)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if rpm is not None:
            pulumi.set(__self__, "rpm", rpm)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Input['OSPolicyResourcePackageResourceDesiredState']:
        """
        The desired state the agent should maintain for this package.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: pulumi.Input['OSPolicyResourcePackageResourceDesiredState']):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceAPTArgs']]:
        """
        A package managed by Apt.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceAPTArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def deb(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceDebArgs']]:
        """
        A deb package file.
        """
        return pulumi.get(self, "deb")

    @deb.setter
    def deb(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceDebArgs']]):
        pulumi.set(self, "deb", value)

    @property
    @pulumi.getter
    def googet(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceGooGetArgs']]:
        """
        A package managed by GooGet.
        """
        return pulumi.get(self, "googet")

    @googet.setter
    def googet(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceGooGetArgs']]):
        pulumi.set(self, "googet", value)

    @property
    @pulumi.getter
    def msi(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceMSIArgs']]:
        """
        An MSI package.
        """
        return pulumi.get(self, "msi")

    @msi.setter
    def msi(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceMSIArgs']]):
        pulumi.set(self, "msi", value)

    @property
    @pulumi.getter
    def rpm(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceRPMArgs']]:
        """
        An rpm package file.
        """
        return pulumi.get(self, "rpm")

    @rpm.setter
    def rpm(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceRPMArgs']]):
        pulumi.set(self, "rpm", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceYUMArgs']]:
        """
        A package managed by YUM.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceYUMArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceZypperArgs']]:
        """
        A package managed by Zypper.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceZypperArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class OSPolicyResourceRepositoryResourceAptRepositoryArgs:
    def __init__(__self__, *,
                 archive_type: pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArchiveType'],
                 components: pulumi.Input[Sequence[pulumi.Input[str]]],
                 distribution: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 gpg_key: Optional[pulumi.Input[str]] = None):
        """
        Represents a single apt package repository. These will be added to a repo file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
        :param pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArchiveType'] archive_type: Type of archive files in this repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] components: List of components for this repository. Must contain at least one item.
        :param pulumi.Input[str] distribution: Distribution of this repository.
        :param pulumi.Input[str] uri: URI for this repository.
        :param pulumi.Input[str] gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        pulumi.set(__self__, "archive_type", archive_type)
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "uri", uri)
        if gpg_key is not None:
            pulumi.set(__self__, "gpg_key", gpg_key)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArchiveType']:
        """
        Type of archive files in this repository.
        """
        return pulumi.get(self, "archive_type")

    @archive_type.setter
    def archive_type(self, value: pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArchiveType']):
        pulumi.set(self, "archive_type", value)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Input[str]:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI for this repository.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        return pulumi.get(self, "gpg_key")

    @gpg_key.setter
    def gpg_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key", value)


@pulumi.input_type
class OSPolicyResourceRepositoryResourceGooRepositoryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        Represents a Goo package repository. These are added to a repo file that is managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[str] url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class OSPolicyResourceRepositoryResourceYumRepositoryArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a single yum package repository. These are added to a repo file that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: A one word, unique name for this repository. This is the `repo id` in the yum config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for resource conflicts.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A one word, unique name for this repository. This is the `repo id` in the yum config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for resource conflicts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class OSPolicyResourceRepositoryResourceZypperRepositoryArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a single zypper package repository. These are added to a repo file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class OSPolicyResourceRepositoryResourceArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArgs']] = None,
                 goo: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceGooRepositoryArgs']] = None,
                 yum: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceYumRepositoryArgs']] = None,
                 zypper: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceZypperRepositoryArgs']] = None):
        """
        A resource that manages a package repository.
        :param pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArgs'] apt: An Apt Repository.
        :param pulumi.Input['OSPolicyResourceRepositoryResourceGooRepositoryArgs'] goo: A Goo Repository.
        :param pulumi.Input['OSPolicyResourceRepositoryResourceYumRepositoryArgs'] yum: A Yum Repository.
        :param pulumi.Input['OSPolicyResourceRepositoryResourceZypperRepositoryArgs'] zypper: A Zypper Repository.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArgs']]:
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceAptRepositoryArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['OSPolicyResourceRepositoryResourceGooRepositoryArgs']]:
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceGooRepositoryArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['OSPolicyResourceRepositoryResourceYumRepositoryArgs']]:
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceYumRepositoryArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['OSPolicyResourceRepositoryResourceZypperRepositoryArgs']]:
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceZypperRepositoryArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class OSPolicyResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 exec_: Optional[pulumi.Input['OSPolicyResourceExecResourceArgs']] = None,
                 file: Optional[pulumi.Input['OSPolicyResourceFileResourceArgs']] = None,
                 pkg: Optional[pulumi.Input['OSPolicyResourcePackageResourceArgs']] = None,
                 repository: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceArgs']] = None):
        """
        An OS policy resource is used to define the desired state configuration and provides a specific functionality like installing/removing packages, executing a script etc. The system ensures that resources are always in their desired state by taking necessary actions if they have drifted from their desired state.
        :param pulumi.Input[str] id: The id of the resource with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the OS policy.
        :param pulumi.Input['OSPolicyResourceExecResourceArgs'] exec_: Exec resource
        :param pulumi.Input['OSPolicyResourceFileResourceArgs'] file: File resource
        :param pulumi.Input['OSPolicyResourcePackageResourceArgs'] pkg: Package resource
        :param pulumi.Input['OSPolicyResourceRepositoryResourceArgs'] repository: Package repository resource
        """
        pulumi.set(__self__, "id", id)
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if pkg is not None:
            pulumi.set(__self__, "pkg", pkg)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The id of the resource with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the OS policy.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional[pulumi.Input['OSPolicyResourceExecResourceArgs']]:
        """
        Exec resource
        """
        return pulumi.get(self, "exec_")

    @exec_.setter
    def exec_(self, value: Optional[pulumi.Input['OSPolicyResourceExecResourceArgs']]):
        pulumi.set(self, "exec_", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input['OSPolicyResourceFileResourceArgs']]:
        """
        File resource
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input['OSPolicyResourceFileResourceArgs']]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def pkg(self) -> Optional[pulumi.Input['OSPolicyResourcePackageResourceArgs']]:
        """
        Package resource
        """
        return pulumi.get(self, "pkg")

    @pkg.setter
    def pkg(self, value: Optional[pulumi.Input['OSPolicyResourcePackageResourceArgs']]):
        pulumi.set(self, "pkg", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input['OSPolicyResourceRepositoryResourceArgs']]:
        """
        Package repository resource
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input['OSPolicyResourceRepositoryResourceArgs']]):
        pulumi.set(self, "repository", value)


@pulumi.input_type
class OSPolicyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 mode: pulumi.Input['OSPolicyMode'],
                 resource_groups: pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceGroupArgs']]],
                 allow_no_resource_group_match: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        An OS policy defines the desired state configuration for a VM.
        :param pulumi.Input[str] id: The id of the OS policy with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the assignment.
        :param pulumi.Input['OSPolicyMode'] mode: Policy mode
        :param pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceGroupArgs']]] resource_groups: List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        :param pulumi.Input[bool] allow_no_resource_group_match: This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        :param pulumi.Input[str] description: Policy description. Length of the description is limited to 1024 characters.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "resource_groups", resource_groups)
        if allow_no_resource_group_match is not None:
            pulumi.set(__self__, "allow_no_resource_group_match", allow_no_resource_group_match)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The id of the OS policy with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the assignment.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input['OSPolicyMode']:
        """
        Policy mode
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input['OSPolicyMode']):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceGroupArgs']]]:
        """
        List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        return pulumi.get(self, "resource_groups")

    @resource_groups.setter
    def resource_groups(self, value: pulumi.Input[Sequence[pulumi.Input['OSPolicyResourceGroupArgs']]]):
        pulumi.set(self, "resource_groups", value)

    @property
    @pulumi.getter(name="allowNoResourceGroupMatch")
    def allow_no_resource_group_match(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        """
        return pulumi.get(self, "allow_no_resource_group_match")

    @allow_no_resource_group_match.setter
    def allow_no_resource_group_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_no_resource_group_match", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Policy description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


