# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetInternalRangeResult',
    'AwaitableGetInternalRangeResult',
    'get_internal_range',
    'get_internal_range_output',
]

@pulumi.output_type
class GetInternalRangeResult:
    def __init__(__self__, create_time=None, description=None, ip_cidr_range=None, labels=None, name=None, network=None, overlaps=None, peering=None, prefix_length=None, target_cidr_range=None, update_time=None, usage=None, users=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ip_cidr_range and not isinstance(ip_cidr_range, str):
            raise TypeError("Expected argument 'ip_cidr_range' to be a str")
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if overlaps and not isinstance(overlaps, list):
            raise TypeError("Expected argument 'overlaps' to be a list")
        pulumi.set(__self__, "overlaps", overlaps)
        if peering and not isinstance(peering, str):
            raise TypeError("Expected argument 'peering' to be a str")
        pulumi.set(__self__, "peering", peering)
        if prefix_length and not isinstance(prefix_length, int):
            raise TypeError("Expected argument 'prefix_length' to be a int")
        pulumi.set(__self__, "prefix_length", prefix_length)
        if target_cidr_range and not isinstance(target_cidr_range, list):
            raise TypeError("Expected argument 'target_cidr_range' to be a list")
        pulumi.set(__self__, "target_cidr_range", target_cidr_range)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the internal range was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> str:
        """
        IP range that this internal range defines.
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-defined labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The name of an internal range. Format: projects/{project}/locations/{location}/internalRanges/{internal_range} See: https://google.aip.dev/122#fields-representing-resource-names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The URL or resource ID of the network in which to reserve the internal range. The network cannot be deleted if there are any reserved internal ranges referring to it. Legacy networks are not supported. This can only be specified for a global internal address. Example: - URL: /compute/v1/projects/{project}/global/networks/{resourceId} - ID: network123
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def overlaps(self) -> Sequence[str]:
        """
        Optional. Types of resources that are allowed to overlap with the current internal range.
        """
        return pulumi.get(self, "overlaps")

    @property
    @pulumi.getter
    def peering(self) -> str:
        """
        The type of peering set for this internal range.
        """
        return pulumi.get(self, "peering")

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> int:
        """
        An alternative to ip_cidr_range. Can be set when trying to create a reservation that automatically finds a free range of the given size. If both ip_cidr_range and prefix_length are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter(name="targetCidrRange")
    def target_cidr_range(self) -> Sequence[str]:
        """
        Optional. Can be set to narrow down or pick a different address space while searching for a free range. If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        """
        return pulumi.get(self, "target_cidr_range")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time when the internal range was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        The type of usage set for this internal range.
        """
        return pulumi.get(self, "usage")

    @property
    @pulumi.getter
    def users(self) -> Sequence[str]:
        """
        The list of resources that refer to this internal range. Resources that use the internal range for their range allocation are referred to as users of the range. Other resources mark themselves as users while doing so by creating a reference to this internal range. Having a user, based on this reference, prevents deletion of the internal range that is referred to. Can be empty.
        """
        return pulumi.get(self, "users")


class AwaitableGetInternalRangeResult(GetInternalRangeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalRangeResult(
            create_time=self.create_time,
            description=self.description,
            ip_cidr_range=self.ip_cidr_range,
            labels=self.labels,
            name=self.name,
            network=self.network,
            overlaps=self.overlaps,
            peering=self.peering,
            prefix_length=self.prefix_length,
            target_cidr_range=self.target_cidr_range,
            update_time=self.update_time,
            usage=self.usage,
            users=self.users)


def get_internal_range(internal_range_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalRangeResult:
    """
    Gets details of a single internal range.
    """
    __args__ = dict()
    __args__['internalRangeId'] = internal_range_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:networkconnectivity/v1alpha1:getInternalRange', __args__, opts=opts, typ=GetInternalRangeResult).value

    return AwaitableGetInternalRangeResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        ip_cidr_range=__ret__.ip_cidr_range,
        labels=__ret__.labels,
        name=__ret__.name,
        network=__ret__.network,
        overlaps=__ret__.overlaps,
        peering=__ret__.peering,
        prefix_length=__ret__.prefix_length,
        target_cidr_range=__ret__.target_cidr_range,
        update_time=__ret__.update_time,
        usage=__ret__.usage,
        users=__ret__.users)


@_utilities.lift_output_func(get_internal_range)
def get_internal_range_output(internal_range_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInternalRangeResult]:
    """
    Gets details of a single internal range.
    """
    ...
