# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSnoozeResult',
    'AwaitableGetSnoozeResult',
    'get_snooze',
    'get_snooze_output',
]

@pulumi.output_type
class GetSnoozeResult:
    def __init__(__self__, criteria=None, display_name=None, interval=None, name=None):
        if criteria and not isinstance(criteria, dict):
            raise TypeError("Expected argument 'criteria' to be a dict")
        pulumi.set(__self__, "criteria", criteria)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if interval and not isinstance(interval, dict):
            raise TypeError("Expected argument 'interval' to be a dict")
        pulumi.set(__self__, "interval", interval)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def criteria(self) -> 'outputs.CriteriaResponse':
        """
        This defines the criteria for applying the Snooze. See Criteria for more information.
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A display name for the Snooze. This can be, at most, 512 unicode characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def interval(self) -> 'outputs.TimeIntervalResponse':
        """
        The Snooze will be active from interval.start_time through interval.end_time. interval.start_time cannot be in the past. There is a 15 second clock skew to account for the time it takes for a request to reach the API from the UI.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Snooze. The format is: projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID] The ID of the Snooze will be generated by the system.
        """
        return pulumi.get(self, "name")


class AwaitableGetSnoozeResult(GetSnoozeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnoozeResult(
            criteria=self.criteria,
            display_name=self.display_name,
            interval=self.interval,
            name=self.name)


def get_snooze(project: Optional[str] = None,
               snooze_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnoozeResult:
    """
    Retrieves a Snooze by name.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['snoozeId'] = snooze_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:monitoring/v3:getSnooze', __args__, opts=opts, typ=GetSnoozeResult).value

    return AwaitableGetSnoozeResult(
        criteria=__ret__.criteria,
        display_name=__ret__.display_name,
        interval=__ret__.interval,
        name=__ret__.name)


@_utilities.lift_output_func(get_snooze)
def get_snooze_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                      snooze_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnoozeResult]:
    """
    Retrieves a Snooze by name.
    """
    ...
