# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AggregationArgs',
    'AlertChartArgs',
    'AxisArgs',
    'ChartOptionsArgs',
    'CollapsibleGroupArgs',
    'ColumnLayoutArgs',
    'ColumnSettingsArgs',
    'ColumnArgs',
    'DashboardFilterArgs',
    'DataSetArgs',
    'EmptyArgs',
    'GaugeViewArgs',
    'GridLayoutArgs',
    'LogsPanelArgs',
    'MosaicLayoutArgs',
    'PickTimeSeriesFilterArgs',
    'RatioPartArgs',
    'RowLayoutArgs',
    'RowArgs',
    'ScorecardArgs',
    'SparkChartViewArgs',
    'StatisticalTimeSeriesFilterArgs',
    'TableDataSetArgs',
    'TableDisplayOptionsArgs',
    'TextArgs',
    'ThresholdArgs',
    'TileArgs',
    'TimeSeriesFilterRatioArgs',
    'TimeSeriesFilterArgs',
    'TimeSeriesQueryArgs',
    'TimeSeriesTableArgs',
    'WidgetArgs',
    'XyChartArgs',
]

@pulumi.input_type
class AggregationArgs:
    def __init__(__self__, *,
                 alignment_period: Optional[pulumi.Input[str]] = None,
                 cross_series_reducer: Optional[pulumi.Input['AggregationCrossSeriesReducer']] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 per_series_aligner: Optional[pulumi.Input['AggregationPerSeriesAligner']] = None):
        """
        Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
        :param pulumi.Input[str] alignment_period: The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 2 years, or 104 weeks.
        :param pulumi.Input['AggregationCrossSeriesReducer'] cross_series_reducer: The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        :param pulumi.Input['AggregationPerSeriesAligner'] per_series_aligner: An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[pulumi.Input[str]]:
        """
        The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 2 years, or 104 weeks.
        """
        return pulumi.get(self, "alignment_period")

    @alignment_period.setter
    def alignment_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alignment_period", value)

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[pulumi.Input['AggregationCrossSeriesReducer']]:
        """
        The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "cross_series_reducer")

    @cross_series_reducer.setter
    def cross_series_reducer(self, value: Optional[pulumi.Input['AggregationCrossSeriesReducer']]):
        pulumi.set(self, "cross_series_reducer", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[pulumi.Input['AggregationPerSeriesAligner']]:
        """
        An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "per_series_aligner")

    @per_series_aligner.setter
    def per_series_aligner(self, value: Optional[pulumi.Input['AggregationPerSeriesAligner']]):
        pulumi.set(self, "per_series_aligner", value)


@pulumi.input_type
class AlertChartArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        A chart that displays alert policy data.
        :param pulumi.Input[str] name: The resource name of the alert policy. The format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID] 
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The resource name of the alert policy. The format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID] 
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AxisArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input['AxisScale']] = None):
        """
        A chart axis.
        :param pulumi.Input[str] label: The label of the axis.
        :param pulumi.Input['AxisScale'] scale: The axis scale. By default, a linear scale is used.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The label of the axis.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['AxisScale']]:
        """
        The axis scale. By default, a linear scale is used.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['AxisScale']]):
        pulumi.set(self, "scale", value)


@pulumi.input_type
class ChartOptionsArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['ChartOptionsMode']] = None):
        """
        Options to control visual rendering of a chart.
        :param pulumi.Input['ChartOptionsMode'] mode: The chart mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['ChartOptionsMode']]:
        """
        The chart mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['ChartOptionsMode']]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class CollapsibleGroupArgs:
    def __init__(__self__, *,
                 collapsed: Optional[pulumi.Input[bool]] = None):
        """
        A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        :param pulumi.Input[bool] collapsed: The collapsed state of the widget on first page load.
        """
        if collapsed is not None:
            pulumi.set(__self__, "collapsed", collapsed)

    @property
    @pulumi.getter
    def collapsed(self) -> Optional[pulumi.Input[bool]]:
        """
        The collapsed state of the widget on first page load.
        """
        return pulumi.get(self, "collapsed")

    @collapsed.setter
    def collapsed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "collapsed", value)


@pulumi.input_type
class ColumnLayoutArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]] = None):
        """
        A simplified layout that divides the available space into vertical columns and arranges a set of widgets vertically in each column.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]] columns: The columns of content to display.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]:
        """
        The columns of content to display.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class ColumnSettingsArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[str],
                 visible: pulumi.Input[bool]):
        """
        The persistent settings for a table's columns.
        :param pulumi.Input[str] column: The id of the column.
        :param pulumi.Input[bool] visible: Whether the column should be visible on page load.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "visible", visible)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[str]:
        """
        The id of the column.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def visible(self) -> pulumi.Input[bool]:
        """
        Whether the column should be visible on page load.
        """
        return pulumi.get(self, "visible")

    @visible.setter
    def visible(self, value: pulumi.Input[bool]):
        pulumi.set(self, "visible", value)


@pulumi.input_type
class ColumnArgs:
    def __init__(__self__, *,
                 weight: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]] = None):
        """
        Defines the layout properties and content for a column.
        :param pulumi.Input[str] weight: The relative weight of this column. The column weight is used to adjust the width of columns on the screen (relative to peers). Greater the weight, greater the width of the column on the screen. If omitted, a value of 1 is used while rendering.
        :param pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]] widgets: The display widgets arranged vertically in this column.
        """
        if weight is not None:
            pulumi.set(__self__, "weight", weight)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[str]]:
        """
        The relative weight of this column. The column weight is used to adjust the width of columns on the screen (relative to peers). Greater the weight, greater the width of the column on the screen. If omitted, a value of 1 is used while rendering.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]:
        """
        The display widgets arranged vertically in this column.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.input_type
class DashboardFilterArgs:
    def __init__(__self__, *,
                 label_key: pulumi.Input[str],
                 filter_type: Optional[pulumi.Input['DashboardFilterFilterType']] = None,
                 string_value: Optional[pulumi.Input[str]] = None,
                 template_variable: Optional[pulumi.Input[str]] = None):
        """
        A filter to reduce the amount of data charted in relevant widgets.
        :param pulumi.Input[str] label_key: The key for the label
        :param pulumi.Input['DashboardFilterFilterType'] filter_type: The specified filter type
        :param pulumi.Input[str] string_value: A variable-length string value.
        :param pulumi.Input[str] template_variable: The placeholder text that can be referenced in a filter string or MQL query. If omitted, the dashboard filter will be applied to all relevant widgets in the dashboard.
        """
        pulumi.set(__self__, "label_key", label_key)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)
        if template_variable is not None:
            pulumi.set(__self__, "template_variable", template_variable)

    @property
    @pulumi.getter(name="labelKey")
    def label_key(self) -> pulumi.Input[str]:
        """
        The key for the label
        """
        return pulumi.get(self, "label_key")

    @label_key.setter
    def label_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "label_key", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input['DashboardFilterFilterType']]:
        """
        The specified filter type
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input['DashboardFilterFilterType']]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        A variable-length string value.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)

    @property
    @pulumi.getter(name="templateVariable")
    def template_variable(self) -> Optional[pulumi.Input[str]]:
        """
        The placeholder text that can be referenced in a filter string or MQL query. If omitted, the dashboard filter will be applied to all relevant widgets in the dashboard.
        """
        return pulumi.get(self, "template_variable")

    @template_variable.setter
    def template_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_variable", value)


@pulumi.input_type
class DataSetArgs:
    def __init__(__self__, *,
                 time_series_query: pulumi.Input['TimeSeriesQueryArgs'],
                 legend_template: Optional[pulumi.Input[str]] = None,
                 min_alignment_period: Optional[pulumi.Input[str]] = None,
                 plot_type: Optional[pulumi.Input['DataSetPlotType']] = None,
                 target_axis: Optional[pulumi.Input['DataSetTargetAxis']] = None):
        """
        Groups a time series query definition with charting options.
        :param pulumi.Input['TimeSeriesQueryArgs'] time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        :param pulumi.Input[str] legend_template: A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value.
        :param pulumi.Input[str] min_alignment_period: Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        :param pulumi.Input['DataSetPlotType'] plot_type: How this data should be plotted on the chart.
        :param pulumi.Input['DataSetTargetAxis'] target_axis: Optional. The target axis to use for plotting the metric.
        """
        pulumi.set(__self__, "time_series_query", time_series_query)
        if legend_template is not None:
            pulumi.set(__self__, "legend_template", legend_template)
        if min_alignment_period is not None:
            pulumi.set(__self__, "min_alignment_period", min_alignment_period)
        if plot_type is not None:
            pulumi.set(__self__, "plot_type", plot_type)
        if target_axis is not None:
            pulumi.set(__self__, "target_axis", target_axis)

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> pulumi.Input['TimeSeriesQueryArgs']:
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")

    @time_series_query.setter
    def time_series_query(self, value: pulumi.Input['TimeSeriesQueryArgs']):
        pulumi.set(self, "time_series_query", value)

    @property
    @pulumi.getter(name="legendTemplate")
    def legend_template(self) -> Optional[pulumi.Input[str]]:
        """
        A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value.
        """
        return pulumi.get(self, "legend_template")

    @legend_template.setter
    def legend_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legend_template", value)

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        """
        return pulumi.get(self, "min_alignment_period")

    @min_alignment_period.setter
    def min_alignment_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_alignment_period", value)

    @property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> Optional[pulumi.Input['DataSetPlotType']]:
        """
        How this data should be plotted on the chart.
        """
        return pulumi.get(self, "plot_type")

    @plot_type.setter
    def plot_type(self, value: Optional[pulumi.Input['DataSetPlotType']]):
        pulumi.set(self, "plot_type", value)

    @property
    @pulumi.getter(name="targetAxis")
    def target_axis(self) -> Optional[pulumi.Input['DataSetTargetAxis']]:
        """
        Optional. The target axis to use for plotting the metric.
        """
        return pulumi.get(self, "target_axis")

    @target_axis.setter
    def target_axis(self, value: Optional[pulumi.Input['DataSetTargetAxis']]):
        pulumi.set(self, "target_axis", value)


@pulumi.input_type
class EmptyArgs:
    def __init__(__self__):
        """
        A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } 
        """
        pass


@pulumi.input_type
class GaugeViewArgs:
    def __init__(__self__, *,
                 lower_bound: Optional[pulumi.Input[float]] = None,
                 upper_bound: Optional[pulumi.Input[float]] = None):
        """
        A gauge chart shows where the current value sits within a pre-defined range. The upper and lower bounds should define the possible range of values for the scorecard's query (inclusive).
        :param pulumi.Input[float] lower_bound: The lower bound for this gauge chart. The value of the chart should always be greater than or equal to this.
        :param pulumi.Input[float] upper_bound: The upper bound for this gauge chart. The value of the chart should always be less than or equal to this.
        """
        if lower_bound is not None:
            pulumi.set(__self__, "lower_bound", lower_bound)
        if upper_bound is not None:
            pulumi.set(__self__, "upper_bound", upper_bound)

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> Optional[pulumi.Input[float]]:
        """
        The lower bound for this gauge chart. The value of the chart should always be greater than or equal to this.
        """
        return pulumi.get(self, "lower_bound")

    @lower_bound.setter
    def lower_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "lower_bound", value)

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> Optional[pulumi.Input[float]]:
        """
        The upper bound for this gauge chart. The value of the chart should always be less than or equal to this.
        """
        return pulumi.get(self, "upper_bound")

    @upper_bound.setter
    def upper_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "upper_bound", value)


@pulumi.input_type
class GridLayoutArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]] = None):
        """
        A basic layout divides the available space into vertical columns of equal width and arranges a list of widgets using a row-first strategy.
        :param pulumi.Input[str] columns: The number of columns into which the view's width is divided. If omitted or set to zero, a system default will be used while rendering.
        :param pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]] widgets: The informational elements that are arranged into the columns row-first.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[str]]:
        """
        The number of columns into which the view's width is divided. If omitted or set to zero, a system default will be used while rendering.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]:
        """
        The informational elements that are arranged into the columns row-first.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.input_type
class LogsPanelArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A widget that displays a stream of log.
        :param pulumi.Input[str] filter: A filter that chooses which log entries to return. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries). Only log entries that match the filter are returned. An empty filter matches all log entries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_names: The names of logging resources to collect logs for. Currently only projects are supported. If empty, the widget will default to the host project.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        A filter that chooses which log entries to return. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries). Only log entries that match the filter are returned. An empty filter matches all log entries.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of logging resources to collect logs for. Currently only projects are supported. If empty, the widget will default to the host project.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_names", value)


@pulumi.input_type
class MosaicLayoutArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[int]] = None,
                 tiles: Optional[pulumi.Input[Sequence[pulumi.Input['TileArgs']]]] = None):
        """
        A mosaic layout divides the available space into a grid of blocks, and overlays the grid with tiles. Unlike GridLayout, tiles may span multiple grid blocks and can be placed at arbitrary locations in the grid.
        :param pulumi.Input[int] columns: The number of columns in the mosaic grid. The number of columns must be between 1 and 12, inclusive.
        :param pulumi.Input[Sequence[pulumi.Input['TileArgs']]] tiles: The tiles to display.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if tiles is not None:
            pulumi.set(__self__, "tiles", tiles)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[int]]:
        """
        The number of columns in the mosaic grid. The number of columns must be between 1 and 12, inclusive.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def tiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TileArgs']]]]:
        """
        The tiles to display.
        """
        return pulumi.get(self, "tiles")

    @tiles.setter
    def tiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TileArgs']]]]):
        pulumi.set(self, "tiles", value)


@pulumi.input_type
class PickTimeSeriesFilterArgs:
    def __init__(__self__, *,
                 direction: Optional[pulumi.Input['PickTimeSeriesFilterDirection']] = None,
                 num_time_series: Optional[pulumi.Input[int]] = None,
                 ranking_method: Optional[pulumi.Input['PickTimeSeriesFilterRankingMethod']] = None):
        """
        Describes a ranking-based time series filter. Each input time series is ranked with an aligner. The filter will allow up to num_time_series time series to pass through it, selecting them based on the relative ranking.For example, if ranking_method is METHOD_MEAN,direction is BOTTOM, and num_time_series is 3, then the 3 times series with the lowest mean values will pass through the filter.
        :param pulumi.Input['PickTimeSeriesFilterDirection'] direction: How to use the ranking to select time series that pass through the filter.
        :param pulumi.Input[int] num_time_series: How many time series to allow to pass through the filter.
        :param pulumi.Input['PickTimeSeriesFilterRankingMethod'] ranking_method: ranking_method is applied to each time series independently to produce the value which will be used to compare the time series to other time series.
        """
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if num_time_series is not None:
            pulumi.set(__self__, "num_time_series", num_time_series)
        if ranking_method is not None:
            pulumi.set(__self__, "ranking_method", ranking_method)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input['PickTimeSeriesFilterDirection']]:
        """
        How to use the ranking to select time series that pass through the filter.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input['PickTimeSeriesFilterDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="numTimeSeries")
    def num_time_series(self) -> Optional[pulumi.Input[int]]:
        """
        How many time series to allow to pass through the filter.
        """
        return pulumi.get(self, "num_time_series")

    @num_time_series.setter
    def num_time_series(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_time_series", value)

    @property
    @pulumi.getter(name="rankingMethod")
    def ranking_method(self) -> Optional[pulumi.Input['PickTimeSeriesFilterRankingMethod']]:
        """
        ranking_method is applied to each time series independently to produce the value which will be used to compare the time series to other time series.
        """
        return pulumi.get(self, "ranking_method")

    @ranking_method.setter
    def ranking_method(self, value: Optional[pulumi.Input['PickTimeSeriesFilterRankingMethod']]):
        pulumi.set(self, "ranking_method", value)


@pulumi.input_type
class RatioPartArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 aggregation: Optional[pulumi.Input['AggregationArgs']] = None):
        """
        Describes a query to build the numerator or denominator of a TimeSeriesFilterRatio.
        :param pulumi.Input[str] filter: The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        :param pulumi.Input['AggregationArgs'] aggregation: By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        """
        pulumi.set(__self__, "filter", filter)
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[pulumi.Input['AggregationArgs']]:
        """
        By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: Optional[pulumi.Input['AggregationArgs']]):
        pulumi.set(self, "aggregation", value)


@pulumi.input_type
class RowLayoutArgs:
    def __init__(__self__, *,
                 rows: Optional[pulumi.Input[Sequence[pulumi.Input['RowArgs']]]] = None):
        """
        A simplified layout that divides the available space into rows and arranges a set of widgets horizontally in each row.
        :param pulumi.Input[Sequence[pulumi.Input['RowArgs']]] rows: The rows of content to display.
        """
        if rows is not None:
            pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def rows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RowArgs']]]]:
        """
        The rows of content to display.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RowArgs']]]]):
        pulumi.set(self, "rows", value)


@pulumi.input_type
class RowArgs:
    def __init__(__self__, *,
                 weight: Optional[pulumi.Input[str]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]] = None):
        """
        Defines the layout properties and content for a row.
        :param pulumi.Input[str] weight: The relative weight of this row. The row weight is used to adjust the height of rows on the screen (relative to peers). Greater the weight, greater the height of the row on the screen. If omitted, a value of 1 is used while rendering.
        :param pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]] widgets: The display widgets arranged horizontally in this row.
        """
        if weight is not None:
            pulumi.set(__self__, "weight", weight)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[str]]:
        """
        The relative weight of this row. The row weight is used to adjust the height of rows on the screen (relative to peers). Greater the weight, greater the height of the row on the screen. If omitted, a value of 1 is used while rendering.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]:
        """
        The display widgets arranged horizontally in this row.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.input_type
class ScorecardArgs:
    def __init__(__self__, *,
                 time_series_query: pulumi.Input['TimeSeriesQueryArgs'],
                 gauge_view: Optional[pulumi.Input['GaugeViewArgs']] = None,
                 spark_chart_view: Optional[pulumi.Input['SparkChartViewArgs']] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]] = None):
        """
        A widget showing the latest value of a metric, and how this value relates to one or more thresholds.
        :param pulumi.Input['TimeSeriesQueryArgs'] time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        :param pulumi.Input['GaugeViewArgs'] gauge_view: Will cause the scorecard to show a gauge chart.
        :param pulumi.Input['SparkChartViewArgs'] spark_chart_view: Will cause the scorecard to show a spark chart.
        :param pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]] thresholds: The thresholds used to determine the state of the scorecard given the time series' current value. For an actual value x, the scorecard is in a danger state if x is less than or equal to a danger threshold that triggers below, or greater than or equal to a danger threshold that triggers above. Similarly, if x is above/below a warning threshold that triggers above/below, then the scorecard is in a warning state - unless x also puts it in a danger state. (Danger trumps warning.)As an example, consider a scorecard with the following four thresholds: { value: 90, category: 'DANGER', trigger: 'ABOVE', }, { value: 70, category: 'WARNING', trigger: 'ABOVE', }, { value: 10, category: 'DANGER', trigger: 'BELOW', }, { value: 20, category: 'WARNING', trigger: 'BELOW', } Then: values less than or equal to 10 would put the scorecard in a DANGER state, values greater than 10 but less than or equal to 20 a WARNING state, values strictly between 20 and 70 an OK state, values greater than or equal to 70 but less than 90 a WARNING state, and values greater than or equal to 90 a DANGER state.
        """
        pulumi.set(__self__, "time_series_query", time_series_query)
        if gauge_view is not None:
            pulumi.set(__self__, "gauge_view", gauge_view)
        if spark_chart_view is not None:
            pulumi.set(__self__, "spark_chart_view", spark_chart_view)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> pulumi.Input['TimeSeriesQueryArgs']:
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")

    @time_series_query.setter
    def time_series_query(self, value: pulumi.Input['TimeSeriesQueryArgs']):
        pulumi.set(self, "time_series_query", value)

    @property
    @pulumi.getter(name="gaugeView")
    def gauge_view(self) -> Optional[pulumi.Input['GaugeViewArgs']]:
        """
        Will cause the scorecard to show a gauge chart.
        """
        return pulumi.get(self, "gauge_view")

    @gauge_view.setter
    def gauge_view(self, value: Optional[pulumi.Input['GaugeViewArgs']]):
        pulumi.set(self, "gauge_view", value)

    @property
    @pulumi.getter(name="sparkChartView")
    def spark_chart_view(self) -> Optional[pulumi.Input['SparkChartViewArgs']]:
        """
        Will cause the scorecard to show a spark chart.
        """
        return pulumi.get(self, "spark_chart_view")

    @spark_chart_view.setter
    def spark_chart_view(self, value: Optional[pulumi.Input['SparkChartViewArgs']]):
        pulumi.set(self, "spark_chart_view", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]]:
        """
        The thresholds used to determine the state of the scorecard given the time series' current value. For an actual value x, the scorecard is in a danger state if x is less than or equal to a danger threshold that triggers below, or greater than or equal to a danger threshold that triggers above. Similarly, if x is above/below a warning threshold that triggers above/below, then the scorecard is in a warning state - unless x also puts it in a danger state. (Danger trumps warning.)As an example, consider a scorecard with the following four thresholds: { value: 90, category: 'DANGER', trigger: 'ABOVE', }, { value: 70, category: 'WARNING', trigger: 'ABOVE', }, { value: 10, category: 'DANGER', trigger: 'BELOW', }, { value: 20, category: 'WARNING', trigger: 'BELOW', } Then: values less than or equal to 10 would put the scorecard in a DANGER state, values greater than 10 but less than or equal to 20 a WARNING state, values strictly between 20 and 70 an OK state, values greater than or equal to 70 but less than 90 a WARNING state, and values greater than or equal to 90 a DANGER state.
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)


@pulumi.input_type
class SparkChartViewArgs:
    def __init__(__self__, *,
                 spark_chart_type: pulumi.Input['SparkChartViewSparkChartType'],
                 min_alignment_period: Optional[pulumi.Input[str]] = None):
        """
        A sparkChart is a small chart suitable for inclusion in a table-cell or inline in text. This message contains the configuration for a sparkChart to show up on a Scorecard, showing recent trends of the scorecard's timeseries.
        :param pulumi.Input['SparkChartViewSparkChartType'] spark_chart_type: The type of sparkchart to show in this chartView.
        :param pulumi.Input[str] min_alignment_period: The lower bound on data point frequency in the chart implemented by specifying the minimum alignment period to use in a time series query. For example, if the data is published once every 10 minutes it would not make sense to fetch and align data at one minute intervals. This field is optional and exists only as a hint.
        """
        pulumi.set(__self__, "spark_chart_type", spark_chart_type)
        if min_alignment_period is not None:
            pulumi.set(__self__, "min_alignment_period", min_alignment_period)

    @property
    @pulumi.getter(name="sparkChartType")
    def spark_chart_type(self) -> pulumi.Input['SparkChartViewSparkChartType']:
        """
        The type of sparkchart to show in this chartView.
        """
        return pulumi.get(self, "spark_chart_type")

    @spark_chart_type.setter
    def spark_chart_type(self, value: pulumi.Input['SparkChartViewSparkChartType']):
        pulumi.set(self, "spark_chart_type", value)

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> Optional[pulumi.Input[str]]:
        """
        The lower bound on data point frequency in the chart implemented by specifying the minimum alignment period to use in a time series query. For example, if the data is published once every 10 minutes it would not make sense to fetch and align data at one minute intervals. This field is optional and exists only as a hint.
        """
        return pulumi.get(self, "min_alignment_period")

    @min_alignment_period.setter
    def min_alignment_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_alignment_period", value)


@pulumi.input_type
class StatisticalTimeSeriesFilterArgs:
    def __init__(__self__, *,
                 num_time_series: Optional[pulumi.Input[int]] = None,
                 ranking_method: Optional[pulumi.Input['StatisticalTimeSeriesFilterRankingMethod']] = None):
        """
        A filter that ranks streams based on their statistical relation to other streams in a request. Note: This field is deprecated and completely ignored by the API.
        :param pulumi.Input[int] num_time_series: How many time series to output.
        :param pulumi.Input['StatisticalTimeSeriesFilterRankingMethod'] ranking_method: rankingMethod is applied to a set of time series, and then the produced value for each individual time series is used to compare a given time series to others. These are methods that cannot be applied stream-by-stream, but rather require the full context of a request to evaluate time series.
        """
        if num_time_series is not None:
            pulumi.set(__self__, "num_time_series", num_time_series)
        if ranking_method is not None:
            pulumi.set(__self__, "ranking_method", ranking_method)

    @property
    @pulumi.getter(name="numTimeSeries")
    def num_time_series(self) -> Optional[pulumi.Input[int]]:
        """
        How many time series to output.
        """
        return pulumi.get(self, "num_time_series")

    @num_time_series.setter
    def num_time_series(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_time_series", value)

    @property
    @pulumi.getter(name="rankingMethod")
    def ranking_method(self) -> Optional[pulumi.Input['StatisticalTimeSeriesFilterRankingMethod']]:
        """
        rankingMethod is applied to a set of time series, and then the produced value for each individual time series is used to compare a given time series to others. These are methods that cannot be applied stream-by-stream, but rather require the full context of a request to evaluate time series.
        """
        return pulumi.get(self, "ranking_method")

    @ranking_method.setter
    def ranking_method(self, value: Optional[pulumi.Input['StatisticalTimeSeriesFilterRankingMethod']]):
        pulumi.set(self, "ranking_method", value)


@pulumi.input_type
class TableDataSetArgs:
    def __init__(__self__, *,
                 time_series_query: pulumi.Input['TimeSeriesQueryArgs'],
                 min_alignment_period: Optional[pulumi.Input[str]] = None,
                 table_display_options: Optional[pulumi.Input['TableDisplayOptionsArgs']] = None,
                 table_template: Optional[pulumi.Input[str]] = None):
        """
        Groups a time series query definition with table options.
        :param pulumi.Input['TimeSeriesQueryArgs'] time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        :param pulumi.Input[str] min_alignment_period: Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        :param pulumi.Input['TableDisplayOptionsArgs'] table_display_options: Optional. Table display options for configuring how the table is rendered.
        :param pulumi.Input[str] table_template: Optional. A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value i.e. "${resource.labels.project_id}."
        """
        pulumi.set(__self__, "time_series_query", time_series_query)
        if min_alignment_period is not None:
            pulumi.set(__self__, "min_alignment_period", min_alignment_period)
        if table_display_options is not None:
            pulumi.set(__self__, "table_display_options", table_display_options)
        if table_template is not None:
            pulumi.set(__self__, "table_template", table_template)

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> pulumi.Input['TimeSeriesQueryArgs']:
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")

    @time_series_query.setter
    def time_series_query(self, value: pulumi.Input['TimeSeriesQueryArgs']):
        pulumi.set(self, "time_series_query", value)

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        """
        return pulumi.get(self, "min_alignment_period")

    @min_alignment_period.setter
    def min_alignment_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_alignment_period", value)

    @property
    @pulumi.getter(name="tableDisplayOptions")
    def table_display_options(self) -> Optional[pulumi.Input['TableDisplayOptionsArgs']]:
        """
        Optional. Table display options for configuring how the table is rendered.
        """
        return pulumi.get(self, "table_display_options")

    @table_display_options.setter
    def table_display_options(self, value: Optional[pulumi.Input['TableDisplayOptionsArgs']]):
        pulumi.set(self, "table_display_options", value)

    @property
    @pulumi.getter(name="tableTemplate")
    def table_template(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value i.e. "${resource.labels.project_id}."
        """
        return pulumi.get(self, "table_template")

    @table_template.setter
    def table_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_template", value)


@pulumi.input_type
class TableDisplayOptionsArgs:
    def __init__(__self__, *,
                 shown_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Table display options that can be reused.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] shown_columns: Optional. This field is unused and has been replaced by TimeSeriesTable.column_settings
        """
        if shown_columns is not None:
            pulumi.set(__self__, "shown_columns", shown_columns)

    @property
    @pulumi.getter(name="shownColumns")
    def shown_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. This field is unused and has been replaced by TimeSeriesTable.column_settings
        """
        return pulumi.get(self, "shown_columns")

    @shown_columns.setter
    def shown_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "shown_columns", value)


@pulumi.input_type
class TextArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input['TextFormat']] = None):
        """
        A widget that displays textual content.
        :param pulumi.Input[str] content: The text content to be displayed.
        :param pulumi.Input['TextFormat'] format: How the text content is formatted.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The text content to be displayed.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['TextFormat']]:
        """
        How the text content is formatted.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['TextFormat']]):
        pulumi.set(self, "format", value)


@pulumi.input_type
class ThresholdArgs:
    def __init__(__self__, *,
                 color: Optional[pulumi.Input['ThresholdColor']] = None,
                 direction: Optional[pulumi.Input['ThresholdDirection']] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 target_axis: Optional[pulumi.Input['ThresholdTargetAxis']] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        Defines a threshold for categorizing time series values.
        :param pulumi.Input['ThresholdColor'] color: The state color for this threshold. Color is not allowed in a XyChart.
        :param pulumi.Input['ThresholdDirection'] direction: The direction for the current threshold. Direction is not allowed in a XyChart.
        :param pulumi.Input[str] label: A label for the threshold.
        :param pulumi.Input['ThresholdTargetAxis'] target_axis: The target axis to use for plotting the threshold. Target axis is not allowed in a Scorecard.
        :param pulumi.Input[float] value: The value of the threshold. The value should be defined in the native scale of the metric.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if target_axis is not None:
            pulumi.set(__self__, "target_axis", target_axis)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input['ThresholdColor']]:
        """
        The state color for this threshold. Color is not allowed in a XyChart.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input['ThresholdColor']]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input['ThresholdDirection']]:
        """
        The direction for the current threshold. Direction is not allowed in a XyChart.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input['ThresholdDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label for the threshold.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="targetAxis")
    def target_axis(self) -> Optional[pulumi.Input['ThresholdTargetAxis']]:
        """
        The target axis to use for plotting the threshold. Target axis is not allowed in a Scorecard.
        """
        return pulumi.get(self, "target_axis")

    @target_axis.setter
    def target_axis(self, value: Optional[pulumi.Input['ThresholdTargetAxis']]):
        pulumi.set(self, "target_axis", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The value of the threshold. The value should be defined in the native scale of the metric.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TileArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[int]] = None,
                 widget: Optional[pulumi.Input['WidgetArgs']] = None,
                 width: Optional[pulumi.Input[int]] = None,
                 x_pos: Optional[pulumi.Input[int]] = None,
                 y_pos: Optional[pulumi.Input[int]] = None):
        """
        A single tile in the mosaic. The placement and size of the tile are configurable.
        :param pulumi.Input[int] height: The height of the tile, measured in grid blocks. Tiles must have a minimum height of 1.
        :param pulumi.Input['WidgetArgs'] widget: The informational widget contained in the tile. For example an XyChart.
        :param pulumi.Input[int] width: The width of the tile, measured in grid blocks. Tiles must have a minimum width of 1.
        :param pulumi.Input[int] x_pos: The zero-indexed position of the tile in grid blocks relative to the left edge of the grid. Tiles must be contained within the specified number of columns. x_pos cannot be negative.
        :param pulumi.Input[int] y_pos: The zero-indexed position of the tile in grid blocks relative to the top edge of the grid. y_pos cannot be negative.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if widget is not None:
            pulumi.set(__self__, "widget", widget)
        if width is not None:
            pulumi.set(__self__, "width", width)
        if x_pos is not None:
            pulumi.set(__self__, "x_pos", x_pos)
        if y_pos is not None:
            pulumi.set(__self__, "y_pos", y_pos)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        The height of the tile, measured in grid blocks. Tiles must have a minimum height of 1.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def widget(self) -> Optional[pulumi.Input['WidgetArgs']]:
        """
        The informational widget contained in the tile. For example an XyChart.
        """
        return pulumi.get(self, "widget")

    @widget.setter
    def widget(self, value: Optional[pulumi.Input['WidgetArgs']]):
        pulumi.set(self, "widget", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        The width of the tile, measured in grid blocks. Tiles must have a minimum width of 1.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)

    @property
    @pulumi.getter(name="xPos")
    def x_pos(self) -> Optional[pulumi.Input[int]]:
        """
        The zero-indexed position of the tile in grid blocks relative to the left edge of the grid. Tiles must be contained within the specified number of columns. x_pos cannot be negative.
        """
        return pulumi.get(self, "x_pos")

    @x_pos.setter
    def x_pos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "x_pos", value)

    @property
    @pulumi.getter(name="yPos")
    def y_pos(self) -> Optional[pulumi.Input[int]]:
        """
        The zero-indexed position of the tile in grid blocks relative to the top edge of the grid. y_pos cannot be negative.
        """
        return pulumi.get(self, "y_pos")

    @y_pos.setter
    def y_pos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "y_pos", value)


@pulumi.input_type
class TimeSeriesFilterRatioArgs:
    def __init__(__self__, *,
                 denominator: Optional[pulumi.Input['RatioPartArgs']] = None,
                 numerator: Optional[pulumi.Input['RatioPartArgs']] = None,
                 pick_time_series_filter: Optional[pulumi.Input['PickTimeSeriesFilterArgs']] = None,
                 secondary_aggregation: Optional[pulumi.Input['AggregationArgs']] = None,
                 statistical_time_series_filter: Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']] = None):
        """
        A pair of time series filters that define a ratio computation. The output time series is the pair-wise division of each aligned element from the numerator and denominator time series.
        :param pulumi.Input['RatioPartArgs'] denominator: The denominator of the ratio.
        :param pulumi.Input['RatioPartArgs'] numerator: The numerator of the ratio.
        :param pulumi.Input['PickTimeSeriesFilterArgs'] pick_time_series_filter: Ranking based time series filter.
        :param pulumi.Input['AggregationArgs'] secondary_aggregation: Apply a second aggregation after the ratio is computed.
        :param pulumi.Input['StatisticalTimeSeriesFilterArgs'] statistical_time_series_filter: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        if denominator is not None:
            pulumi.set(__self__, "denominator", denominator)
        if numerator is not None:
            pulumi.set(__self__, "numerator", numerator)
        if pick_time_series_filter is not None:
            pulumi.set(__self__, "pick_time_series_filter", pick_time_series_filter)
        if secondary_aggregation is not None:
            pulumi.set(__self__, "secondary_aggregation", secondary_aggregation)
        if statistical_time_series_filter is not None:
            warnings.warn("""Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.""", DeprecationWarning)
            pulumi.log.warn("""statistical_time_series_filter is deprecated: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.""")
        if statistical_time_series_filter is not None:
            pulumi.set(__self__, "statistical_time_series_filter", statistical_time_series_filter)

    @property
    @pulumi.getter
    def denominator(self) -> Optional[pulumi.Input['RatioPartArgs']]:
        """
        The denominator of the ratio.
        """
        return pulumi.get(self, "denominator")

    @denominator.setter
    def denominator(self, value: Optional[pulumi.Input['RatioPartArgs']]):
        pulumi.set(self, "denominator", value)

    @property
    @pulumi.getter
    def numerator(self) -> Optional[pulumi.Input['RatioPartArgs']]:
        """
        The numerator of the ratio.
        """
        return pulumi.get(self, "numerator")

    @numerator.setter
    def numerator(self, value: Optional[pulumi.Input['RatioPartArgs']]):
        pulumi.set(self, "numerator", value)

    @property
    @pulumi.getter(name="pickTimeSeriesFilter")
    def pick_time_series_filter(self) -> Optional[pulumi.Input['PickTimeSeriesFilterArgs']]:
        """
        Ranking based time series filter.
        """
        return pulumi.get(self, "pick_time_series_filter")

    @pick_time_series_filter.setter
    def pick_time_series_filter(self, value: Optional[pulumi.Input['PickTimeSeriesFilterArgs']]):
        pulumi.set(self, "pick_time_series_filter", value)

    @property
    @pulumi.getter(name="secondaryAggregation")
    def secondary_aggregation(self) -> Optional[pulumi.Input['AggregationArgs']]:
        """
        Apply a second aggregation after the ratio is computed.
        """
        return pulumi.get(self, "secondary_aggregation")

    @secondary_aggregation.setter
    def secondary_aggregation(self, value: Optional[pulumi.Input['AggregationArgs']]):
        pulumi.set(self, "secondary_aggregation", value)

    @property
    @pulumi.getter(name="statisticalTimeSeriesFilter")
    def statistical_time_series_filter(self) -> Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']]:
        """
        Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        return pulumi.get(self, "statistical_time_series_filter")

    @statistical_time_series_filter.setter
    def statistical_time_series_filter(self, value: Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']]):
        pulumi.set(self, "statistical_time_series_filter", value)


@pulumi.input_type
class TimeSeriesFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 aggregation: Optional[pulumi.Input['AggregationArgs']] = None,
                 pick_time_series_filter: Optional[pulumi.Input['PickTimeSeriesFilterArgs']] = None,
                 secondary_aggregation: Optional[pulumi.Input['AggregationArgs']] = None,
                 statistical_time_series_filter: Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']] = None):
        """
        A filter that defines a subset of time series data that is displayed in a widget. Time series data is fetched using the ListTimeSeries (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) method.
        :param pulumi.Input[str] filter: The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        :param pulumi.Input['AggregationArgs'] aggregation: By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        :param pulumi.Input['PickTimeSeriesFilterArgs'] pick_time_series_filter: Ranking based time series filter.
        :param pulumi.Input['AggregationArgs'] secondary_aggregation: Apply a second aggregation after aggregation is applied.
        :param pulumi.Input['StatisticalTimeSeriesFilterArgs'] statistical_time_series_filter: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        pulumi.set(__self__, "filter", filter)
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if pick_time_series_filter is not None:
            pulumi.set(__self__, "pick_time_series_filter", pick_time_series_filter)
        if secondary_aggregation is not None:
            pulumi.set(__self__, "secondary_aggregation", secondary_aggregation)
        if statistical_time_series_filter is not None:
            warnings.warn("""Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.""", DeprecationWarning)
            pulumi.log.warn("""statistical_time_series_filter is deprecated: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.""")
        if statistical_time_series_filter is not None:
            pulumi.set(__self__, "statistical_time_series_filter", statistical_time_series_filter)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[pulumi.Input['AggregationArgs']]:
        """
        By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: Optional[pulumi.Input['AggregationArgs']]):
        pulumi.set(self, "aggregation", value)

    @property
    @pulumi.getter(name="pickTimeSeriesFilter")
    def pick_time_series_filter(self) -> Optional[pulumi.Input['PickTimeSeriesFilterArgs']]:
        """
        Ranking based time series filter.
        """
        return pulumi.get(self, "pick_time_series_filter")

    @pick_time_series_filter.setter
    def pick_time_series_filter(self, value: Optional[pulumi.Input['PickTimeSeriesFilterArgs']]):
        pulumi.set(self, "pick_time_series_filter", value)

    @property
    @pulumi.getter(name="secondaryAggregation")
    def secondary_aggregation(self) -> Optional[pulumi.Input['AggregationArgs']]:
        """
        Apply a second aggregation after aggregation is applied.
        """
        return pulumi.get(self, "secondary_aggregation")

    @secondary_aggregation.setter
    def secondary_aggregation(self, value: Optional[pulumi.Input['AggregationArgs']]):
        pulumi.set(self, "secondary_aggregation", value)

    @property
    @pulumi.getter(name="statisticalTimeSeriesFilter")
    def statistical_time_series_filter(self) -> Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']]:
        """
        Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        return pulumi.get(self, "statistical_time_series_filter")

    @statistical_time_series_filter.setter
    def statistical_time_series_filter(self, value: Optional[pulumi.Input['StatisticalTimeSeriesFilterArgs']]):
        pulumi.set(self, "statistical_time_series_filter", value)


@pulumi.input_type
class TimeSeriesQueryArgs:
    def __init__(__self__, *,
                 prometheus_query: Optional[pulumi.Input[str]] = None,
                 time_series_filter: Optional[pulumi.Input['TimeSeriesFilterArgs']] = None,
                 time_series_filter_ratio: Optional[pulumi.Input['TimeSeriesFilterRatioArgs']] = None,
                 time_series_query_language: Optional[pulumi.Input[str]] = None,
                 unit_override: Optional[pulumi.Input[str]] = None):
        """
        TimeSeriesQuery collects the set of supported methods for querying time series data from the Stackdriver metrics API.
        :param pulumi.Input[str] prometheus_query: A query used to fetch time series with PromQL.
        :param pulumi.Input['TimeSeriesFilterArgs'] time_series_filter: Filter parameters to fetch time series.
        :param pulumi.Input['TimeSeriesFilterRatioArgs'] time_series_filter_ratio: Parameters to fetch a ratio between two time series filters.
        :param pulumi.Input[str] time_series_query_language: A query used to fetch time series with MQL.
        :param pulumi.Input[str] unit_override: The unit of data contained in fetched time series. If non-empty, this unit will override any unit that accompanies fetched data. The format is the same as the unit (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors) field in MetricDescriptor.
        """
        if prometheus_query is not None:
            pulumi.set(__self__, "prometheus_query", prometheus_query)
        if time_series_filter is not None:
            pulumi.set(__self__, "time_series_filter", time_series_filter)
        if time_series_filter_ratio is not None:
            pulumi.set(__self__, "time_series_filter_ratio", time_series_filter_ratio)
        if time_series_query_language is not None:
            pulumi.set(__self__, "time_series_query_language", time_series_query_language)
        if unit_override is not None:
            pulumi.set(__self__, "unit_override", unit_override)

    @property
    @pulumi.getter(name="prometheusQuery")
    def prometheus_query(self) -> Optional[pulumi.Input[str]]:
        """
        A query used to fetch time series with PromQL.
        """
        return pulumi.get(self, "prometheus_query")

    @prometheus_query.setter
    def prometheus_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_query", value)

    @property
    @pulumi.getter(name="timeSeriesFilter")
    def time_series_filter(self) -> Optional[pulumi.Input['TimeSeriesFilterArgs']]:
        """
        Filter parameters to fetch time series.
        """
        return pulumi.get(self, "time_series_filter")

    @time_series_filter.setter
    def time_series_filter(self, value: Optional[pulumi.Input['TimeSeriesFilterArgs']]):
        pulumi.set(self, "time_series_filter", value)

    @property
    @pulumi.getter(name="timeSeriesFilterRatio")
    def time_series_filter_ratio(self) -> Optional[pulumi.Input['TimeSeriesFilterRatioArgs']]:
        """
        Parameters to fetch a ratio between two time series filters.
        """
        return pulumi.get(self, "time_series_filter_ratio")

    @time_series_filter_ratio.setter
    def time_series_filter_ratio(self, value: Optional[pulumi.Input['TimeSeriesFilterRatioArgs']]):
        pulumi.set(self, "time_series_filter_ratio", value)

    @property
    @pulumi.getter(name="timeSeriesQueryLanguage")
    def time_series_query_language(self) -> Optional[pulumi.Input[str]]:
        """
        A query used to fetch time series with MQL.
        """
        return pulumi.get(self, "time_series_query_language")

    @time_series_query_language.setter
    def time_series_query_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_series_query_language", value)

    @property
    @pulumi.getter(name="unitOverride")
    def unit_override(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of data contained in fetched time series. If non-empty, this unit will override any unit that accompanies fetched data. The format is the same as the unit (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors) field in MetricDescriptor.
        """
        return pulumi.get(self, "unit_override")

    @unit_override.setter
    def unit_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit_override", value)


@pulumi.input_type
class TimeSeriesTableArgs:
    def __init__(__self__, *,
                 data_sets: pulumi.Input[Sequence[pulumi.Input['TableDataSetArgs']]],
                 column_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnSettingsArgs']]]] = None,
                 metric_visualization: Optional[pulumi.Input['TimeSeriesTableMetricVisualization']] = None):
        """
        A table that displays time series data.
        :param pulumi.Input[Sequence[pulumi.Input['TableDataSetArgs']]] data_sets: The data displayed in this table.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnSettingsArgs']]] column_settings: Optional. The list of the persistent column settings for the table.
        :param pulumi.Input['TimeSeriesTableMetricVisualization'] metric_visualization: Optional. Store rendering strategy
        """
        pulumi.set(__self__, "data_sets", data_sets)
        if column_settings is not None:
            pulumi.set(__self__, "column_settings", column_settings)
        if metric_visualization is not None:
            pulumi.set(__self__, "metric_visualization", metric_visualization)

    @property
    @pulumi.getter(name="dataSets")
    def data_sets(self) -> pulumi.Input[Sequence[pulumi.Input['TableDataSetArgs']]]:
        """
        The data displayed in this table.
        """
        return pulumi.get(self, "data_sets")

    @data_sets.setter
    def data_sets(self, value: pulumi.Input[Sequence[pulumi.Input['TableDataSetArgs']]]):
        pulumi.set(self, "data_sets", value)

    @property
    @pulumi.getter(name="columnSettings")
    def column_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnSettingsArgs']]]]:
        """
        Optional. The list of the persistent column settings for the table.
        """
        return pulumi.get(self, "column_settings")

    @column_settings.setter
    def column_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnSettingsArgs']]]]):
        pulumi.set(self, "column_settings", value)

    @property
    @pulumi.getter(name="metricVisualization")
    def metric_visualization(self) -> Optional[pulumi.Input['TimeSeriesTableMetricVisualization']]:
        """
        Optional. Store rendering strategy
        """
        return pulumi.get(self, "metric_visualization")

    @metric_visualization.setter
    def metric_visualization(self, value: Optional[pulumi.Input['TimeSeriesTableMetricVisualization']]):
        pulumi.set(self, "metric_visualization", value)


@pulumi.input_type
class WidgetArgs:
    def __init__(__self__, *,
                 alert_chart: Optional[pulumi.Input['AlertChartArgs']] = None,
                 blank: Optional[pulumi.Input['EmptyArgs']] = None,
                 collapsible_group: Optional[pulumi.Input['CollapsibleGroupArgs']] = None,
                 logs_panel: Optional[pulumi.Input['LogsPanelArgs']] = None,
                 scorecard: Optional[pulumi.Input['ScorecardArgs']] = None,
                 text: Optional[pulumi.Input['TextArgs']] = None,
                 time_series_table: Optional[pulumi.Input['TimeSeriesTableArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 xy_chart: Optional[pulumi.Input['XyChartArgs']] = None):
        """
        Widget contains a single dashboard component and configuration of how to present the component in the dashboard.
        :param pulumi.Input['AlertChartArgs'] alert_chart: A chart of alert policy data.
        :param pulumi.Input['EmptyArgs'] blank: A blank space.
        :param pulumi.Input['CollapsibleGroupArgs'] collapsible_group: A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        :param pulumi.Input['LogsPanelArgs'] logs_panel: A widget that shows a stream of logs.
        :param pulumi.Input['ScorecardArgs'] scorecard: A scorecard summarizing time series data.
        :param pulumi.Input['TextArgs'] text: A raw string or markdown displaying textual content.
        :param pulumi.Input['TimeSeriesTableArgs'] time_series_table: A widget that displays time series data in a tabular format.
        :param pulumi.Input[str] title: Optional. The title of the widget.
        :param pulumi.Input['XyChartArgs'] xy_chart: A chart of time series data.
        """
        if alert_chart is not None:
            pulumi.set(__self__, "alert_chart", alert_chart)
        if blank is not None:
            pulumi.set(__self__, "blank", blank)
        if collapsible_group is not None:
            pulumi.set(__self__, "collapsible_group", collapsible_group)
        if logs_panel is not None:
            pulumi.set(__self__, "logs_panel", logs_panel)
        if scorecard is not None:
            pulumi.set(__self__, "scorecard", scorecard)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if time_series_table is not None:
            pulumi.set(__self__, "time_series_table", time_series_table)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if xy_chart is not None:
            pulumi.set(__self__, "xy_chart", xy_chart)

    @property
    @pulumi.getter(name="alertChart")
    def alert_chart(self) -> Optional[pulumi.Input['AlertChartArgs']]:
        """
        A chart of alert policy data.
        """
        return pulumi.get(self, "alert_chart")

    @alert_chart.setter
    def alert_chart(self, value: Optional[pulumi.Input['AlertChartArgs']]):
        pulumi.set(self, "alert_chart", value)

    @property
    @pulumi.getter
    def blank(self) -> Optional[pulumi.Input['EmptyArgs']]:
        """
        A blank space.
        """
        return pulumi.get(self, "blank")

    @blank.setter
    def blank(self, value: Optional[pulumi.Input['EmptyArgs']]):
        pulumi.set(self, "blank", value)

    @property
    @pulumi.getter(name="collapsibleGroup")
    def collapsible_group(self) -> Optional[pulumi.Input['CollapsibleGroupArgs']]:
        """
        A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        """
        return pulumi.get(self, "collapsible_group")

    @collapsible_group.setter
    def collapsible_group(self, value: Optional[pulumi.Input['CollapsibleGroupArgs']]):
        pulumi.set(self, "collapsible_group", value)

    @property
    @pulumi.getter(name="logsPanel")
    def logs_panel(self) -> Optional[pulumi.Input['LogsPanelArgs']]:
        """
        A widget that shows a stream of logs.
        """
        return pulumi.get(self, "logs_panel")

    @logs_panel.setter
    def logs_panel(self, value: Optional[pulumi.Input['LogsPanelArgs']]):
        pulumi.set(self, "logs_panel", value)

    @property
    @pulumi.getter
    def scorecard(self) -> Optional[pulumi.Input['ScorecardArgs']]:
        """
        A scorecard summarizing time series data.
        """
        return pulumi.get(self, "scorecard")

    @scorecard.setter
    def scorecard(self, value: Optional[pulumi.Input['ScorecardArgs']]):
        pulumi.set(self, "scorecard", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['TextArgs']]:
        """
        A raw string or markdown displaying textual content.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['TextArgs']]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter(name="timeSeriesTable")
    def time_series_table(self) -> Optional[pulumi.Input['TimeSeriesTableArgs']]:
        """
        A widget that displays time series data in a tabular format.
        """
        return pulumi.get(self, "time_series_table")

    @time_series_table.setter
    def time_series_table(self, value: Optional[pulumi.Input['TimeSeriesTableArgs']]):
        pulumi.set(self, "time_series_table", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the widget.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="xyChart")
    def xy_chart(self) -> Optional[pulumi.Input['XyChartArgs']]:
        """
        A chart of time series data.
        """
        return pulumi.get(self, "xy_chart")

    @xy_chart.setter
    def xy_chart(self, value: Optional[pulumi.Input['XyChartArgs']]):
        pulumi.set(self, "xy_chart", value)


@pulumi.input_type
class XyChartArgs:
    def __init__(__self__, *,
                 data_sets: pulumi.Input[Sequence[pulumi.Input['DataSetArgs']]],
                 chart_options: Optional[pulumi.Input['ChartOptionsArgs']] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]] = None,
                 timeshift_duration: Optional[pulumi.Input[str]] = None,
                 x_axis: Optional[pulumi.Input['AxisArgs']] = None,
                 y2_axis: Optional[pulumi.Input['AxisArgs']] = None,
                 y_axis: Optional[pulumi.Input['AxisArgs']] = None):
        """
        A chart that displays data on a 2D (X and Y axes) plane.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetArgs']]] data_sets: The data displayed in this chart.
        :param pulumi.Input['ChartOptionsArgs'] chart_options: Display options for the chart.
        :param pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]] thresholds: Threshold lines drawn horizontally across the chart.
        :param pulumi.Input[str] timeshift_duration: The duration used to display a comparison chart. A comparison chart simultaneously shows values from two similar-length time periods (e.g., week-over-week metrics). The duration must be positive, and it can only be applied to charts with data sets of LINE plot type.
        :param pulumi.Input['AxisArgs'] x_axis: The properties applied to the X axis.
        :param pulumi.Input['AxisArgs'] y2_axis: The properties applied to the Y2 axis.
        :param pulumi.Input['AxisArgs'] y_axis: The properties applied to the Y axis.
        """
        pulumi.set(__self__, "data_sets", data_sets)
        if chart_options is not None:
            pulumi.set(__self__, "chart_options", chart_options)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)
        if timeshift_duration is not None:
            pulumi.set(__self__, "timeshift_duration", timeshift_duration)
        if x_axis is not None:
            pulumi.set(__self__, "x_axis", x_axis)
        if y2_axis is not None:
            pulumi.set(__self__, "y2_axis", y2_axis)
        if y_axis is not None:
            pulumi.set(__self__, "y_axis", y_axis)

    @property
    @pulumi.getter(name="dataSets")
    def data_sets(self) -> pulumi.Input[Sequence[pulumi.Input['DataSetArgs']]]:
        """
        The data displayed in this chart.
        """
        return pulumi.get(self, "data_sets")

    @data_sets.setter
    def data_sets(self, value: pulumi.Input[Sequence[pulumi.Input['DataSetArgs']]]):
        pulumi.set(self, "data_sets", value)

    @property
    @pulumi.getter(name="chartOptions")
    def chart_options(self) -> Optional[pulumi.Input['ChartOptionsArgs']]:
        """
        Display options for the chart.
        """
        return pulumi.get(self, "chart_options")

    @chart_options.setter
    def chart_options(self, value: Optional[pulumi.Input['ChartOptionsArgs']]):
        pulumi.set(self, "chart_options", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]]:
        """
        Threshold lines drawn horizontally across the chart.
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter(name="timeshiftDuration")
    def timeshift_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration used to display a comparison chart. A comparison chart simultaneously shows values from two similar-length time periods (e.g., week-over-week metrics). The duration must be positive, and it can only be applied to charts with data sets of LINE plot type.
        """
        return pulumi.get(self, "timeshift_duration")

    @timeshift_duration.setter
    def timeshift_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeshift_duration", value)

    @property
    @pulumi.getter(name="xAxis")
    def x_axis(self) -> Optional[pulumi.Input['AxisArgs']]:
        """
        The properties applied to the X axis.
        """
        return pulumi.get(self, "x_axis")

    @x_axis.setter
    def x_axis(self, value: Optional[pulumi.Input['AxisArgs']]):
        pulumi.set(self, "x_axis", value)

    @property
    @pulumi.getter(name="y2Axis")
    def y2_axis(self) -> Optional[pulumi.Input['AxisArgs']]:
        """
        The properties applied to the Y2 axis.
        """
        return pulumi.get(self, "y2_axis")

    @y2_axis.setter
    def y2_axis(self, value: Optional[pulumi.Input['AxisArgs']]):
        pulumi.set(self, "y2_axis", value)

    @property
    @pulumi.getter(name="yAxis")
    def y_axis(self) -> Optional[pulumi.Input['AxisArgs']]:
        """
        The properties applied to the Y axis.
        """
        return pulumi.get(self, "y_axis")

    @y_axis.setter
    def y_axis(self, value: Optional[pulumi.Input['AxisArgs']]):
        pulumi.set(self, "y_axis", value)


