# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    def __init__(__self__, certificate_status=None, credential_id=None, description=None, display_name=None, name=None, raw_certificate=None, requestor_id=None, valid_end_time=None, valid_start_time=None):
        if certificate_status and not isinstance(certificate_status, str):
            raise TypeError("Expected argument 'certificate_status' to be a str")
        pulumi.set(__self__, "certificate_status", certificate_status)
        if credential_id and not isinstance(credential_id, str):
            raise TypeError("Expected argument 'credential_id' to be a str")
        pulumi.set(__self__, "credential_id", credential_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if raw_certificate and not isinstance(raw_certificate, dict):
            raise TypeError("Expected argument 'raw_certificate' to be a dict")
        pulumi.set(__self__, "raw_certificate", raw_certificate)
        if requestor_id and not isinstance(requestor_id, str):
            raise TypeError("Expected argument 'requestor_id' to be a str")
        pulumi.set(__self__, "requestor_id", requestor_id)
        if valid_end_time and not isinstance(valid_end_time, str):
            raise TypeError("Expected argument 'valid_end_time' to be a str")
        pulumi.set(__self__, "valid_end_time", valid_end_time)
        if valid_start_time and not isinstance(valid_start_time, str):
            raise TypeError("Expected argument 'valid_start_time' to be a str")
        pulumi.set(__self__, "valid_start_time", valid_start_time)

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> str:
        """
        Status of the certificate
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> str:
        """
        Immutable. Credential id that will be used to register with trawler INTERNAL_ONLY
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the certificate
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the certificate
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Auto generated primary key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rawCertificate")
    def raw_certificate(self) -> 'outputs.GoogleCloudIntegrationsV1alphaClientCertificateResponse':
        """
        Input only. Raw client certificate which would be registered with trawler
        """
        return pulumi.get(self, "raw_certificate")

    @property
    @pulumi.getter(name="requestorId")
    def requestor_id(self) -> str:
        """
        Immutable. Requestor ID to be used to register certificate with trawler
        """
        return pulumi.get(self, "requestor_id")

    @property
    @pulumi.getter(name="validEndTime")
    def valid_end_time(self) -> str:
        """
        The timestamp after which certificate will expire
        """
        return pulumi.get(self, "valid_end_time")

    @property
    @pulumi.getter(name="validStartTime")
    def valid_start_time(self) -> str:
        """
        The timestamp after which certificate will be valid
        """
        return pulumi.get(self, "valid_start_time")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_status=self.certificate_status,
            credential_id=self.credential_id,
            description=self.description,
            display_name=self.display_name,
            name=self.name,
            raw_certificate=self.raw_certificate,
            requestor_id=self.requestor_id,
            valid_end_time=self.valid_end_time,
            valid_start_time=self.valid_start_time)


def get_certificate(certificate_id: Optional[str] = None,
                    location: Optional[str] = None,
                    product_id: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Get a certificates in the specified project.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['location'] = location
    __args__['productId'] = product_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:integrations/v1alpha:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_status=__ret__.certificate_status,
        credential_id=__ret__.credential_id,
        description=__ret__.description,
        display_name=__ret__.display_name,
        name=__ret__.name,
        raw_certificate=__ret__.raw_certificate,
        requestor_id=__ret__.requestor_id,
        valid_end_time=__ret__.valid_end_time,
        valid_start_time=__ret__.valid_start_time)


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(certificate_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           product_id: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Get a certificates in the specified project.
    """
    ...
