# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 certificate_status: Optional[pulumi.Input['CertificateCertificateStatus']] = None,
                 credential_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 raw_certificate: Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaClientCertificateArgs']] = None,
                 requestor_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input['CertificateCertificateStatus'] certificate_status: Status of the certificate
        :param pulumi.Input[str] credential_id: Immutable. Credential id that will be used to register with trawler INTERNAL_ONLY
        :param pulumi.Input[str] description: Description of the certificate
        :param pulumi.Input[str] display_name: Name of the certificate
        :param pulumi.Input['GoogleCloudIntegrationsV1alphaClientCertificateArgs'] raw_certificate: Input only. Raw client certificate which would be registered with trawler
        :param pulumi.Input[str] requestor_id: Immutable. Requestor ID to be used to register certificate with trawler
        """
        pulumi.set(__self__, "product_id", product_id)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if raw_certificate is not None:
            pulumi.set(__self__, "raw_certificate", raw_certificate)
        if requestor_id is not None:
            pulumi.set(__self__, "requestor_id", requestor_id)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[pulumi.Input['CertificateCertificateStatus']]:
        """
        Status of the certificate
        """
        return pulumi.get(self, "certificate_status")

    @certificate_status.setter
    def certificate_status(self, value: Optional[pulumi.Input['CertificateCertificateStatus']]):
        pulumi.set(self, "certificate_status", value)

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Credential id that will be used to register with trawler INTERNAL_ONLY
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the certificate
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the certificate
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rawCertificate")
    def raw_certificate(self) -> Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaClientCertificateArgs']]:
        """
        Input only. Raw client certificate which would be registered with trawler
        """
        return pulumi.get(self, "raw_certificate")

    @raw_certificate.setter
    def raw_certificate(self, value: Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaClientCertificateArgs']]):
        pulumi.set(self, "raw_certificate", value)

    @property
    @pulumi.getter(name="requestorId")
    def requestor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Requestor ID to be used to register certificate with trawler
        """
        return pulumi.get(self, "requestor_id")

    @requestor_id.setter
    def requestor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requestor_id", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_status: Optional[pulumi.Input['CertificateCertificateStatus']] = None,
                 credential_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 raw_certificate: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaClientCertificateArgs']]] = None,
                 requestor_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new certificate. The certificate will be registered to the trawler service and will be encrypted using cloud KMS and stored in Spanner Returns the certificate.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['CertificateCertificateStatus'] certificate_status: Status of the certificate
        :param pulumi.Input[str] credential_id: Immutable. Credential id that will be used to register with trawler INTERNAL_ONLY
        :param pulumi.Input[str] description: Description of the certificate
        :param pulumi.Input[str] display_name: Name of the certificate
        :param pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaClientCertificateArgs']] raw_certificate: Input only. Raw client certificate which would be registered with trawler
        :param pulumi.Input[str] requestor_id: Immutable. Requestor ID to be used to register certificate with trawler
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new certificate. The certificate will be registered to the trawler service and will be encrypted using cloud KMS and stored in Spanner Returns the certificate.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_status: Optional[pulumi.Input['CertificateCertificateStatus']] = None,
                 credential_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 raw_certificate: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaClientCertificateArgs']]] = None,
                 requestor_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["certificate_status"] = certificate_status
            __props__.__dict__["credential_id"] = credential_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["location"] = location
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["project"] = project
            __props__.__dict__["raw_certificate"] = raw_certificate
            __props__.__dict__["requestor_id"] = requestor_id
            __props__.__dict__["name"] = None
            __props__.__dict__["valid_end_time"] = None
            __props__.__dict__["valid_start_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "product_id", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Certificate, __self__).__init__(
            'google-native:integrations/v1alpha:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CertificateArgs.__new__(CertificateArgs)

        __props__.__dict__["certificate_status"] = None
        __props__.__dict__["credential_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["raw_certificate"] = None
        __props__.__dict__["requestor_id"] = None
        __props__.__dict__["valid_end_time"] = None
        __props__.__dict__["valid_start_time"] = None
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> pulumi.Output[str]:
        """
        Status of the certificate
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[str]:
        """
        Immutable. Credential id that will be used to register with trawler INTERNAL_ONLY
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the certificate
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name of the certificate
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Auto generated primary key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="rawCertificate")
    def raw_certificate(self) -> pulumi.Output['outputs.GoogleCloudIntegrationsV1alphaClientCertificateResponse']:
        """
        Input only. Raw client certificate which would be registered with trawler
        """
        return pulumi.get(self, "raw_certificate")

    @property
    @pulumi.getter(name="requestorId")
    def requestor_id(self) -> pulumi.Output[str]:
        """
        Immutable. Requestor ID to be used to register certificate with trawler
        """
        return pulumi.get(self, "requestor_id")

    @property
    @pulumi.getter(name="validEndTime")
    def valid_end_time(self) -> pulumi.Output[str]:
        """
        The timestamp after which certificate will expire
        """
        return pulumi.get(self, "valid_end_time")

    @property
    @pulumi.getter(name="validStartTime")
    def valid_start_time(self) -> pulumi.Output[str]:
        """
        The timestamp after which certificate will be valid
        """
        return pulumi.get(self, "valid_start_time")

