# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AuthConfigArgs', 'AuthConfig']

@pulumi.input_type
class AuthConfigArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 client_certificate_encrypted_private_key: Optional[pulumi.Input[str]] = None,
                 client_certificate_passphrase: Optional[pulumi.Input[str]] = None,
                 client_certificate_ssl_certificate: Optional[pulumi.Input[str]] = None,
                 creator_email: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input['AuthConfigCredentialType']] = None,
                 decrypted_credential: Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaCredentialArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[pulumi.Input[str]] = None,
                 expiry_notification_duration: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_valid_time: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['AuthConfigState']] = None,
                 valid_time: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input['AuthConfigVisibility']] = None):
        """
        The set of arguments for constructing a AuthConfig resource.
        :param pulumi.Input[str] certificate_id: Certificate id for client certificate
        :param pulumi.Input[str] client_certificate_encrypted_private_key: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        :param pulumi.Input[str] client_certificate_passphrase: 'passphrase' should be left unset if private key is not encrypted. Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        :param pulumi.Input[str] client_certificate_ssl_certificate: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        :param pulumi.Input[str] creator_email: The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input['AuthConfigCredentialType'] credential_type: Credential type of the encrypted credential.
        :param pulumi.Input['GoogleCloudIntegrationsV1alphaCredentialArgs'] decrypted_credential: Raw auth credentials.
        :param pulumi.Input[str] description: A description of the auth config.
        :param pulumi.Input[str] display_name: The name of the auth config.
        :param pulumi.Input[str] encrypted_credential: Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expiry_notification_duration: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        :param pulumi.Input[str] last_modifier_email: The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[str] name: Resource name of the SFDC instance projects/{project}/locations/{location}/authConfigs/{authConfig}.
        :param pulumi.Input[str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        :param pulumi.Input[str] reason: The reason / details of the current status.
        :param pulumi.Input['AuthConfigState'] state: The status of the auth config.
        :param pulumi.Input[str] valid_time: The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        :param pulumi.Input['AuthConfigVisibility'] visibility: The visibility of the auth config.
        """
        pulumi.set(__self__, "product_id", product_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if client_certificate_encrypted_private_key is not None:
            pulumi.set(__self__, "client_certificate_encrypted_private_key", client_certificate_encrypted_private_key)
        if client_certificate_passphrase is not None:
            pulumi.set(__self__, "client_certificate_passphrase", client_certificate_passphrase)
        if client_certificate_ssl_certificate is not None:
            pulumi.set(__self__, "client_certificate_ssl_certificate", client_certificate_ssl_certificate)
        if creator_email is not None:
            pulumi.set(__self__, "creator_email", creator_email)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if decrypted_credential is not None:
            pulumi.set(__self__, "decrypted_credential", decrypted_credential)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if expiry_notification_duration is not None:
            pulumi.set(__self__, "expiry_notification_duration", expiry_notification_duration)
        if last_modifier_email is not None:
            pulumi.set(__self__, "last_modifier_email", last_modifier_email)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_valid_time is not None:
            pulumi.set(__self__, "override_valid_time", override_valid_time)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if valid_time is not None:
            pulumi.set(__self__, "valid_time", valid_time)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate id for client certificate
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="clientCertificateEncryptedPrivateKey")
    def client_certificate_encrypted_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        """
        return pulumi.get(self, "client_certificate_encrypted_private_key")

    @client_certificate_encrypted_private_key.setter
    def client_certificate_encrypted_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_encrypted_private_key", value)

    @property
    @pulumi.getter(name="clientCertificatePassphrase")
    def client_certificate_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        'passphrase' should be left unset if private key is not encrypted. Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        return pulumi.get(self, "client_certificate_passphrase")

    @client_certificate_passphrase.setter
    def client_certificate_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_passphrase", value)

    @property
    @pulumi.getter(name="clientCertificateSslCertificate")
    def client_certificate_ssl_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        """
        return pulumi.get(self, "client_certificate_ssl_certificate")

    @client_certificate_ssl_certificate.setter
    def client_certificate_ssl_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_ssl_certificate", value)

    @property
    @pulumi.getter(name="creatorEmail")
    def creator_email(self) -> Optional[pulumi.Input[str]]:
        """
        The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "creator_email")

    @creator_email.setter
    def creator_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator_email", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input['AuthConfigCredentialType']]:
        """
        Credential type of the encrypted credential.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input['AuthConfigCredentialType']]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="decryptedCredential")
    def decrypted_credential(self) -> Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaCredentialArgs']]:
        """
        Raw auth credentials.
        """
        return pulumi.get(self, "decrypted_credential")

    @decrypted_credential.setter
    def decrypted_credential(self, value: Optional[pulumi.Input['GoogleCloudIntegrationsV1alphaCredentialArgs']]):
        pulumi.set(self, "decrypted_credential", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the auth config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the auth config.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[pulumi.Input[str]]:
        """
        Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="expiryNotificationDuration")
    def expiry_notification_duration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        """
        return pulumi.get(self, "expiry_notification_duration")

    @expiry_notification_duration.setter
    def expiry_notification_duration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expiry_notification_duration", value)

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> Optional[pulumi.Input[str]]:
        """
        The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @last_modifier_email.setter
    def last_modifier_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modifier_email", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of the SFDC instance projects/{project}/locations/{location}/authConfigs/{authConfig}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overrideValidTime")
    def override_valid_time(self) -> Optional[pulumi.Input[str]]:
        """
        User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        """
        return pulumi.get(self, "override_valid_time")

    @override_valid_time.setter
    def override_valid_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_valid_time", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason / details of the current status.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['AuthConfigState']]:
        """
        The status of the auth config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['AuthConfigState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="validTime")
    def valid_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        """
        return pulumi.get(self, "valid_time")

    @valid_time.setter
    def valid_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_time", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input['AuthConfigVisibility']]:
        """
        The visibility of the auth config.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input['AuthConfigVisibility']]):
        pulumi.set(self, "visibility", value)


class AuthConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 client_certificate_encrypted_private_key: Optional[pulumi.Input[str]] = None,
                 client_certificate_passphrase: Optional[pulumi.Input[str]] = None,
                 client_certificate_ssl_certificate: Optional[pulumi.Input[str]] = None,
                 creator_email: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input['AuthConfigCredentialType']] = None,
                 decrypted_credential: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaCredentialArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[pulumi.Input[str]] = None,
                 expiry_notification_duration: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_valid_time: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['AuthConfigState']] = None,
                 valid_time: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input['AuthConfigVisibility']] = None,
                 __props__=None):
        """
        Creates an auth config record. Fetch corresponding credentials for specific auth types, e.g. access token for OAuth 2.0, JWT token for JWT. Encrypt the auth config with Cloud KMS and store the encrypted credentials in Spanner. Returns the encrypted auth config.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: Certificate id for client certificate
        :param pulumi.Input[str] client_certificate_encrypted_private_key: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        :param pulumi.Input[str] client_certificate_passphrase: 'passphrase' should be left unset if private key is not encrypted. Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        :param pulumi.Input[str] client_certificate_ssl_certificate: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        :param pulumi.Input[str] creator_email: The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input['AuthConfigCredentialType'] credential_type: Credential type of the encrypted credential.
        :param pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaCredentialArgs']] decrypted_credential: Raw auth credentials.
        :param pulumi.Input[str] description: A description of the auth config.
        :param pulumi.Input[str] display_name: The name of the auth config.
        :param pulumi.Input[str] encrypted_credential: Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expiry_notification_duration: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        :param pulumi.Input[str] last_modifier_email: The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[str] name: Resource name of the SFDC instance projects/{project}/locations/{location}/authConfigs/{authConfig}.
        :param pulumi.Input[str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        :param pulumi.Input[str] reason: The reason / details of the current status.
        :param pulumi.Input['AuthConfigState'] state: The status of the auth config.
        :param pulumi.Input[str] valid_time: The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        :param pulumi.Input['AuthConfigVisibility'] visibility: The visibility of the auth config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an auth config record. Fetch corresponding credentials for specific auth types, e.g. access token for OAuth 2.0, JWT token for JWT. Encrypt the auth config with Cloud KMS and store the encrypted credentials in Spanner. Returns the encrypted auth config.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AuthConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 client_certificate_encrypted_private_key: Optional[pulumi.Input[str]] = None,
                 client_certificate_passphrase: Optional[pulumi.Input[str]] = None,
                 client_certificate_ssl_certificate: Optional[pulumi.Input[str]] = None,
                 creator_email: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input['AuthConfigCredentialType']] = None,
                 decrypted_credential: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIntegrationsV1alphaCredentialArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encrypted_credential: Optional[pulumi.Input[str]] = None,
                 expiry_notification_duration: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_valid_time: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['AuthConfigState']] = None,
                 valid_time: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input['AuthConfigVisibility']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthConfigArgs.__new__(AuthConfigArgs)

            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["client_certificate_encrypted_private_key"] = client_certificate_encrypted_private_key
            __props__.__dict__["client_certificate_passphrase"] = client_certificate_passphrase
            __props__.__dict__["client_certificate_ssl_certificate"] = client_certificate_ssl_certificate
            __props__.__dict__["creator_email"] = creator_email
            __props__.__dict__["credential_type"] = credential_type
            __props__.__dict__["decrypted_credential"] = decrypted_credential
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encrypted_credential"] = encrypted_credential
            __props__.__dict__["expiry_notification_duration"] = expiry_notification_duration
            __props__.__dict__["last_modifier_email"] = last_modifier_email
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["override_valid_time"] = override_valid_time
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["project"] = project
            __props__.__dict__["reason"] = reason
            __props__.__dict__["state"] = state
            __props__.__dict__["valid_time"] = valid_time
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "product_id", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AuthConfig, __self__).__init__(
            'google-native:integrations/v1alpha:AuthConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AuthConfig':
        """
        Get an existing AuthConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AuthConfigArgs.__new__(AuthConfigArgs)

        __props__.__dict__["certificate_id"] = None
        __props__.__dict__["client_certificate_encrypted_private_key"] = None
        __props__.__dict__["client_certificate_passphrase"] = None
        __props__.__dict__["client_certificate_ssl_certificate"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["creator_email"] = None
        __props__.__dict__["credential_type"] = None
        __props__.__dict__["decrypted_credential"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["encrypted_credential"] = None
        __props__.__dict__["expiry_notification_duration"] = None
        __props__.__dict__["last_modifier_email"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["override_valid_time"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["reason"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["valid_time"] = None
        __props__.__dict__["visibility"] = None
        return AuthConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        Certificate id for client certificate
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="clientCertificateEncryptedPrivateKey")
    def client_certificate_encrypted_private_key(self) -> pulumi.Output[Optional[str]]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        """
        return pulumi.get(self, "client_certificate_encrypted_private_key")

    @property
    @pulumi.getter(name="clientCertificatePassphrase")
    def client_certificate_passphrase(self) -> pulumi.Output[Optional[str]]:
        """
        'passphrase' should be left unset if private key is not encrypted. Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        return pulumi.get(self, "client_certificate_passphrase")

    @property
    @pulumi.getter(name="clientCertificateSslCertificate")
    def client_certificate_ssl_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines. For example, -----BEGIN CERTIFICATE----- MIICTTCCAbagAwIBAgIJAPT0tSKNxan/MA0GCSqGSIb3DQEBCwUAMCoxFzAVBgNV BAoTDkdvb2dsZSBURVNUSU5HMQ8wDQYDVQQDEwZ0ZXN0Q0EwHhcNMTUwMTAxMDAw MDAwWhcNMjUwMTAxMDAwMDAwWjAuMRcwFQYDVQQKEw5Hb29nbGUgVEVTVElORzET MBEGA1UEAwwKam9lQGJhbmFuYTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA vDYFgMgxi5W488d9J7UpCInl0NXmZQpJDEHE4hvkaRlH7pnC71H0DLt0/3zATRP1 JzY2+eqBmbGl4/sgZKYv8UrLnNyQNUTsNx1iZAfPUflf5FwgVsai8BM0pUciq1NB xD429VFcrGZNucvFLh72RuRFIKH8WUpiK/iZNFkWhZ0CAwEAAaN3MHUwDgYDVR0P AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAMBgNVHRMB Af8EAjAAMBkGA1UdDgQSBBCVgnFBCWgL/iwCqnGrhTPQMBsGA1UdIwQUMBKAEKey Um2o4k2WiEVA0ldQvNYwDQYJKoZIhvcNAQELBQADgYEAYK986R4E3L1v+Q6esBtW JrUwA9UmJRSQr0N5w3o9XzarU37/bkjOP0Fw0k/A6Vv1n3vlciYfBFaBIam1qRHr 5dMsYf4CZS6w50r7hyzqyrwDoyNxkLnd2PdcHT/sym1QmflsjEs7pejtnohO6N2H wQW6M0H7Zt8claGRla4fKkg= -----END CERTIFICATE-----
        """
        return pulumi.get(self, "client_certificate_ssl_certificate")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the auth config is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="creatorEmail")
    def creator_email(self) -> pulumi.Output[str]:
        """
        The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "creator_email")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[str]:
        """
        Credential type of the encrypted credential.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="decryptedCredential")
    def decrypted_credential(self) -> pulumi.Output['outputs.GoogleCloudIntegrationsV1alphaCredentialResponse']:
        """
        Raw auth credentials.
        """
        return pulumi.get(self, "decrypted_credential")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the auth config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The name of the auth config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> pulumi.Output[str]:
        """
        Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="expiryNotificationDuration")
    def expiry_notification_duration(self) -> pulumi.Output[Sequence[str]]:
        """
        User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        """
        return pulumi.get(self, "expiry_notification_duration")

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> pulumi.Output[str]:
        """
        The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of the SFDC instance projects/{project}/locations/{location}/authConfigs/{authConfig}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overrideValidTime")
    def override_valid_time(self) -> pulumi.Output[str]:
        """
        User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        """
        return pulumi.get(self, "override_valid_time")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[str]:
        """
        The reason / details of the current status.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The status of the auth config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the auth config is modified.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validTime")
    def valid_time(self) -> pulumi.Output[str]:
        """
        The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        """
        return pulumi.get(self, "valid_time")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[str]:
        """
        The visibility of the auth config.
        """
        return pulumi.get(self, "visibility")

