# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['DestGroupArgs', 'DestGroup']

@pulumi.input_type
class DestGroupArgs:
    def __init__(__self__, *,
                 tunnel_dest_group_id: pulumi.Input[str],
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DestGroup resource.
        :param pulumi.Input[str] tunnel_dest_group_id: Required. The ID to use for the TunnelDestGroup, which becomes the final component of the resource name. This value must be 4-63 characters, and valid characters are `[a-z]-`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: Unordered list. List of CIDRs that this group applies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fqdns: Unordered list. List of FQDNs that this group applies to.
        :param pulumi.Input[str] name: Immutable. Identifier for the TunnelDestGroup. Must be unique within the project and contain only lower case letters (a-z) and dashes (-).
        """
        pulumi.set(__self__, "tunnel_dest_group_id", tunnel_dest_group_id)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="tunnelDestGroupId")
    def tunnel_dest_group_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the TunnelDestGroup, which becomes the final component of the resource name. This value must be 4-63 characters, and valid characters are `[a-z]-`.
        """
        return pulumi.get(self, "tunnel_dest_group_id")

    @tunnel_dest_group_id.setter
    def tunnel_dest_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tunnel_dest_group_id", value)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Unordered list. List of CIDRs that this group applies to.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Unordered list. List of FQDNs that this group applies to.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fqdns", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Identifier for the TunnelDestGroup. Must be unique within the project and contain only lower case letters (a-z) and dashes (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class DestGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tunnel_dest_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new TunnelDestGroup.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: Unordered list. List of CIDRs that this group applies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fqdns: Unordered list. List of FQDNs that this group applies to.
        :param pulumi.Input[str] name: Immutable. Identifier for the TunnelDestGroup. Must be unique within the project and contain only lower case letters (a-z) and dashes (-).
        :param pulumi.Input[str] tunnel_dest_group_id: Required. The ID to use for the TunnelDestGroup, which becomes the final component of the resource name. This value must be 4-63 characters, and valid characters are `[a-z]-`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DestGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new TunnelDestGroup.

        :param str resource_name: The name of the resource.
        :param DestGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DestGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tunnel_dest_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DestGroupArgs.__new__(DestGroupArgs)

            __props__.__dict__["cidrs"] = cidrs
            __props__.__dict__["fqdns"] = fqdns
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if tunnel_dest_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_dest_group_id'")
            __props__.__dict__["tunnel_dest_group_id"] = tunnel_dest_group_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "tunnel_dest_group_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DestGroup, __self__).__init__(
            'google-native:iap/v1:DestGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DestGroup':
        """
        Get an existing DestGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DestGroupArgs.__new__(DestGroupArgs)

        __props__.__dict__["cidrs"] = None
        __props__.__dict__["fqdns"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["tunnel_dest_group_id"] = None
        return DestGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        Unordered list. List of CIDRs that this group applies to.
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[Sequence[str]]:
        """
        Unordered list. List of FQDNs that this group applies to.
        """
        return pulumi.get(self, "fqdns")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. Identifier for the TunnelDestGroup. Must be unique within the project and contain only lower case letters (a-z) and dashes (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tunnelDestGroupId")
    def tunnel_dest_group_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the TunnelDestGroup, which becomes the final component of the resource name. This value must be 4-63 characters, and valid characters are `[a-z]-`.
        """
        return pulumi.get(self, "tunnel_dest_group_id")

