# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActionArgs',
    'AnnotationConfigArgs',
    'AnnotationSourceArgs',
    'AttributeArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'BoundingPolyArgs',
    'CharacterMaskConfigArgs',
    'CharacterMaskFieldArgs',
    'CleanDescriptorsOptionArgs',
    'CleanTextFieldArgs',
    'CleanTextTagArgs',
    'CloudHealthcareSourceArgs',
    'ContextualDeidConfigArgs',
    'CryptoHashConfigArgs',
    'CryptoHashFieldArgs',
    'DateShiftConfigArgs',
    'DateShiftFieldArgs',
    'DeidentifiedStoreDestinationArgs',
    'DeidentifyConfigArgs',
    'DeidentifyOperationMetadataArgs',
    'DeleteTagArgs',
    'DicomConfigArgs',
    'DicomTagConfigArgs',
    'ExprArgs',
    'FhirConfigArgs',
    'FhirFieldConfigArgs',
    'FhirNotificationConfigArgs',
    'FhirOutputArgs',
    'FieldMetadataArgs',
    'FieldArgs',
    'GoogleCloudHealthcareV1beta1ConsentPolicyArgs',
    'GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs',
    'GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs',
    'GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs',
    'GoogleCloudHealthcareV1beta1DicomStreamConfigArgs',
    'GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs',
    'Hl7SchemaConfigArgs',
    'Hl7TypesConfigArgs',
    'Hl7V2NotificationConfigArgs',
    'ImageAnnotationArgs',
    'ImageConfigArgs',
    'ImageArgs',
    'InfoTypeTransformationArgs',
    'KeepExtensionsConfigArgs',
    'KeepFieldArgs',
    'KeepTagArgs',
    'KmsWrappedCryptoKeyArgs',
    'NotificationConfigArgs',
    'OptionsArgs',
    'ParserConfigArgs',
    'PatientIdArgs',
    'RecurseTagArgs',
    'RedactConfigArgs',
    'RegenUidTagArgs',
    'RemoveFieldArgs',
    'RemoveTagArgs',
    'ReplaceWithInfoTypeConfigArgs',
    'ResetTagArgs',
    'ResourceAnnotationArgs',
    'SchemaConfigArgs',
    'SchemaPackageArgs',
    'SchematizedDataArgs',
    'SearchConfigArgs',
    'SearchParameterArgs',
    'SensitiveTextAnnotationArgs',
    'SignatureArgs',
    'StreamConfigArgs',
    'TagFilterListArgs',
    'TextConfigArgs',
    'TimePartitioningArgs',
    'TypeArgs',
    'ValidationConfigArgs',
    'VersionSourceArgs',
    'VertexArgs',
]

@pulumi.input_type
class ActionArgs:
    def __init__(__self__, *,
                 clean_image_tag: Optional[pulumi.Input['ImageConfigArgs']] = None,
                 clean_text_tag: Optional[pulumi.Input['CleanTextTagArgs']] = None,
                 delete_tag: Optional[pulumi.Input['DeleteTagArgs']] = None,
                 keep_tag: Optional[pulumi.Input['KeepTagArgs']] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 recurse_tag: Optional[pulumi.Input['RecurseTagArgs']] = None,
                 regen_uid_tag: Optional[pulumi.Input['RegenUidTagArgs']] = None,
                 remove_tag: Optional[pulumi.Input['RemoveTagArgs']] = None,
                 reset_tag: Optional[pulumi.Input['ResetTagArgs']] = None):
        """
        Specifies a selection of tags and an `Action` to apply to each one.
        :param pulumi.Input['ImageConfigArgs'] clean_image_tag: Inspect image and transform sensitive burnt-in text. Doesn't apply to elements nested in a sequence, which revert to `Keep`. Supported [tags](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html): PixelData
        :param pulumi.Input['CleanTextTagArgs'] clean_text_tag: Inspect text and transform sensitive text. Configurable via TextConfig. Supported Value Representations: AE, LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
        :param pulumi.Input['DeleteTagArgs'] delete_tag: Delete tag.
        :param pulumi.Input['KeepTagArgs'] keep_tag: Keep tag unchanged.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Select all tags with the listed tag IDs, names, or Value Representations (VRs). Examples: ID: "00100010" Keyword: "PatientName" VR: "PN"
        :param pulumi.Input['RecurseTagArgs'] recurse_tag: Recursively apply DICOM de-id to tags nested in a sequence. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): SQ
        :param pulumi.Input['RegenUidTagArgs'] regen_uid_tag: Replace UID with a new generated UID. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): UI
        :param pulumi.Input['RemoveTagArgs'] remove_tag: Replace with empty tag.
        :param pulumi.Input['ResetTagArgs'] reset_tag: Reset tag to a placeholder value.
        """
        if clean_image_tag is not None:
            pulumi.set(__self__, "clean_image_tag", clean_image_tag)
        if clean_text_tag is not None:
            pulumi.set(__self__, "clean_text_tag", clean_text_tag)
        if delete_tag is not None:
            pulumi.set(__self__, "delete_tag", delete_tag)
        if keep_tag is not None:
            pulumi.set(__self__, "keep_tag", keep_tag)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if recurse_tag is not None:
            pulumi.set(__self__, "recurse_tag", recurse_tag)
        if regen_uid_tag is not None:
            pulumi.set(__self__, "regen_uid_tag", regen_uid_tag)
        if remove_tag is not None:
            pulumi.set(__self__, "remove_tag", remove_tag)
        if reset_tag is not None:
            pulumi.set(__self__, "reset_tag", reset_tag)

    @property
    @pulumi.getter(name="cleanImageTag")
    def clean_image_tag(self) -> Optional[pulumi.Input['ImageConfigArgs']]:
        """
        Inspect image and transform sensitive burnt-in text. Doesn't apply to elements nested in a sequence, which revert to `Keep`. Supported [tags](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html): PixelData
        """
        return pulumi.get(self, "clean_image_tag")

    @clean_image_tag.setter
    def clean_image_tag(self, value: Optional[pulumi.Input['ImageConfigArgs']]):
        pulumi.set(self, "clean_image_tag", value)

    @property
    @pulumi.getter(name="cleanTextTag")
    def clean_text_tag(self) -> Optional[pulumi.Input['CleanTextTagArgs']]:
        """
        Inspect text and transform sensitive text. Configurable via TextConfig. Supported Value Representations: AE, LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
        """
        return pulumi.get(self, "clean_text_tag")

    @clean_text_tag.setter
    def clean_text_tag(self, value: Optional[pulumi.Input['CleanTextTagArgs']]):
        pulumi.set(self, "clean_text_tag", value)

    @property
    @pulumi.getter(name="deleteTag")
    def delete_tag(self) -> Optional[pulumi.Input['DeleteTagArgs']]:
        """
        Delete tag.
        """
        return pulumi.get(self, "delete_tag")

    @delete_tag.setter
    def delete_tag(self, value: Optional[pulumi.Input['DeleteTagArgs']]):
        pulumi.set(self, "delete_tag", value)

    @property
    @pulumi.getter(name="keepTag")
    def keep_tag(self) -> Optional[pulumi.Input['KeepTagArgs']]:
        """
        Keep tag unchanged.
        """
        return pulumi.get(self, "keep_tag")

    @keep_tag.setter
    def keep_tag(self, value: Optional[pulumi.Input['KeepTagArgs']]):
        pulumi.set(self, "keep_tag", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Select all tags with the listed tag IDs, names, or Value Representations (VRs). Examples: ID: "00100010" Keyword: "PatientName" VR: "PN"
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="recurseTag")
    def recurse_tag(self) -> Optional[pulumi.Input['RecurseTagArgs']]:
        """
        Recursively apply DICOM de-id to tags nested in a sequence. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): SQ
        """
        return pulumi.get(self, "recurse_tag")

    @recurse_tag.setter
    def recurse_tag(self, value: Optional[pulumi.Input['RecurseTagArgs']]):
        pulumi.set(self, "recurse_tag", value)

    @property
    @pulumi.getter(name="regenUidTag")
    def regen_uid_tag(self) -> Optional[pulumi.Input['RegenUidTagArgs']]:
        """
        Replace UID with a new generated UID. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): UI
        """
        return pulumi.get(self, "regen_uid_tag")

    @regen_uid_tag.setter
    def regen_uid_tag(self, value: Optional[pulumi.Input['RegenUidTagArgs']]):
        pulumi.set(self, "regen_uid_tag", value)

    @property
    @pulumi.getter(name="removeTag")
    def remove_tag(self) -> Optional[pulumi.Input['RemoveTagArgs']]:
        """
        Replace with empty tag.
        """
        return pulumi.get(self, "remove_tag")

    @remove_tag.setter
    def remove_tag(self, value: Optional[pulumi.Input['RemoveTagArgs']]):
        pulumi.set(self, "remove_tag", value)

    @property
    @pulumi.getter(name="resetTag")
    def reset_tag(self) -> Optional[pulumi.Input['ResetTagArgs']]:
        """
        Reset tag to a placeholder value.
        """
        return pulumi.get(self, "reset_tag")

    @reset_tag.setter
    def reset_tag(self, value: Optional[pulumi.Input['ResetTagArgs']]):
        pulumi.set(self, "reset_tag", value)


@pulumi.input_type
class AnnotationConfigArgs:
    def __init__(__self__, *,
                 annotation_store_name: Optional[pulumi.Input[str]] = None,
                 store_quote: Optional[pulumi.Input[bool]] = None):
        """
        Specifies how to store annotations during de-identification operation.
        :param pulumi.Input[str] annotation_store_name: The name of the annotation store, in the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`). * The destination annotation store must be in the same project as the source data. De-identifying data across multiple projects is not supported. * The destination annotation store must exist when using DeidentifyDicomStore or DeidentifyFhirStore. DeidentifyDataset automatically creates the destination annotation store.
        :param pulumi.Input[bool] store_quote: If set to true, the sensitive texts are included in SensitiveTextAnnotation of Annotation.
        """
        if annotation_store_name is not None:
            pulumi.set(__self__, "annotation_store_name", annotation_store_name)
        if store_quote is not None:
            pulumi.set(__self__, "store_quote", store_quote)

    @property
    @pulumi.getter(name="annotationStoreName")
    def annotation_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the annotation store, in the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`). * The destination annotation store must be in the same project as the source data. De-identifying data across multiple projects is not supported. * The destination annotation store must exist when using DeidentifyDicomStore or DeidentifyFhirStore. DeidentifyDataset automatically creates the destination annotation store.
        """
        return pulumi.get(self, "annotation_store_name")

    @annotation_store_name.setter
    def annotation_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_store_name", value)

    @property
    @pulumi.getter(name="storeQuote")
    def store_quote(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the sensitive texts are included in SensitiveTextAnnotation of Annotation.
        """
        return pulumi.get(self, "store_quote")

    @store_quote.setter
    def store_quote(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "store_quote", value)


@pulumi.input_type
class AnnotationSourceArgs:
    def __init__(__self__, *,
                 cloud_healthcare_source: Optional[pulumi.Input['CloudHealthcareSourceArgs']] = None):
        """
        AnnotationSource holds the source information of the annotation.
        :param pulumi.Input['CloudHealthcareSourceArgs'] cloud_healthcare_source: Cloud Healthcare API resource.
        """
        if cloud_healthcare_source is not None:
            pulumi.set(__self__, "cloud_healthcare_source", cloud_healthcare_source)

    @property
    @pulumi.getter(name="cloudHealthcareSource")
    def cloud_healthcare_source(self) -> Optional[pulumi.Input['CloudHealthcareSourceArgs']]:
        """
        Cloud Healthcare API resource.
        """
        return pulumi.get(self, "cloud_healthcare_source")

    @cloud_healthcare_source.setter
    def cloud_healthcare_source(self, value: Optional[pulumi.Input['CloudHealthcareSourceArgs']]):
        pulumi.set(self, "cloud_healthcare_source", value)


@pulumi.input_type
class AttributeArgs:
    def __init__(__self__, *,
                 attribute_definition_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
        :param pulumi.Input[str] attribute_definition_id: Indicates the name of an attribute defined in the consent store.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        if attribute_definition_id is not None:
            pulumi.set(__self__, "attribute_definition_id", attribute_definition_id)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="attributeDefinitionId")
    def attribute_definition_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the name of an attribute defined in the consent store.
        """
        return pulumi.get(self, "attribute_definition_id")

    @attribute_definition_id.setter
    def attribute_definition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute_definition_id", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BoundingPolyArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 vertices: Optional[pulumi.Input[Sequence[pulumi.Input['VertexArgs']]]] = None):
        """
        A bounding polygon for the detected image annotation.
        :param pulumi.Input[str] label: A description of this polygon.
        :param pulumi.Input[Sequence[pulumi.Input['VertexArgs']]] vertices: List of the vertices of this polygon.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if vertices is not None:
            pulumi.set(__self__, "vertices", vertices)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A description of this polygon.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def vertices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VertexArgs']]]]:
        """
        List of the vertices of this polygon.
        """
        return pulumi.get(self, "vertices")

    @vertices.setter
    def vertices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VertexArgs']]]]):
        pulumi.set(self, "vertices", value)


@pulumi.input_type
class CharacterMaskConfigArgs:
    def __init__(__self__, *,
                 masking_character: Optional[pulumi.Input[str]] = None):
        """
        Mask a string by replacing its characters with a fixed character.
        :param pulumi.Input[str] masking_character: Character to mask the sensitive values. If not supplied, defaults to "*".
        """
        if masking_character is not None:
            pulumi.set(__self__, "masking_character", masking_character)

    @property
    @pulumi.getter(name="maskingCharacter")
    def masking_character(self) -> Optional[pulumi.Input[str]]:
        """
        Character to mask the sensitive values. If not supplied, defaults to "*".
        """
        return pulumi.get(self, "masking_character")

    @masking_character.setter
    def masking_character(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "masking_character", value)


@pulumi.input_type
class CharacterMaskFieldArgs:
    def __init__(__self__):
        """
        Replace field value with masking character. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        pass


@pulumi.input_type
class CleanDescriptorsOptionArgs:
    def __init__(__self__):
        """
        This option is based on the DICOM Standard's [Clean Descriptors Option](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/sect_E.3.5.html), and the `CleanText` `Action` is applied to all the specified fields. When cleaning text, the process attempts to transform phrases matching any of the tags marked for removal (action codes D, Z, X, and U) in the [Basic Profile](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter_E.html). These contextual phrases are replaced with the token "[CTX]". This option uses an additional `InfoType` during inspection.
        """
        pass


@pulumi.input_type
class CleanTextFieldArgs:
    def __init__(__self__):
        """
        Inspect text and transform sensitive text. Configure using `TextConfig`. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Date, DateTime, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        pass


@pulumi.input_type
class CleanTextTagArgs:
    def __init__(__self__):
        """
        Inspect text and transform sensitive text. Configurable using `TextConfig`. Supported [Value Representations] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): AE, LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
        """
        pass


@pulumi.input_type
class CloudHealthcareSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Cloud Healthcare API resource.
        :param pulumi.Input[str] name: Full path of a Cloud Healthcare API resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of a Cloud Healthcare API resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ContextualDeidConfigArgs:
    def __init__(__self__):
        """
        The fields that aren't marked `Keep` or `CleanText` in the `BASIC` profile are collected into a contextual phrase list. For fields marked `CleanText`, the process attempts to transform phrases matching these contextual entries. These contextual phrases are replaced with the token "[CTX]". This feature uses an additional InfoType during inspection.
        """
        pass


@pulumi.input_type
class CryptoHashConfigArgs:
    def __init__(__self__, *,
                 crypto_key: Optional[pulumi.Input[str]] = None,
                 kms_wrapped: Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']] = None):
        """
        Pseudonymization method that generates surrogates via cryptographic hashing. Uses SHA-256. Outputs a base64-encoded representation of the hashed output. For example, `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`.
        :param pulumi.Input[str] crypto_key: An AES 128/192/256 bit key. Causes the hash to be computed based on this key. A default key is generated for each Deidentify operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        :param pulumi.Input['KmsWrappedCryptoKeyArgs'] kms_wrapped: KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        if crypto_key is not None:
            pulumi.set(__self__, "crypto_key", crypto_key)
        if kms_wrapped is not None:
            pulumi.set(__self__, "kms_wrapped", kms_wrapped)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> Optional[pulumi.Input[str]]:
        """
        An AES 128/192/256 bit key. Causes the hash to be computed based on this key. A default key is generated for each Deidentify operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        """
        return pulumi.get(self, "crypto_key")

    @crypto_key.setter
    def crypto_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key", value)

    @property
    @pulumi.getter(name="kmsWrapped")
    def kms_wrapped(self) -> Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']]:
        """
        KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        return pulumi.get(self, "kms_wrapped")

    @kms_wrapped.setter
    def kms_wrapped(self, value: Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']]):
        pulumi.set(self, "kms_wrapped", value)


@pulumi.input_type
class CryptoHashFieldArgs:
    def __init__(__self__):
        """
        Replace field value with a hash of that value. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        pass


@pulumi.input_type
class DateShiftConfigArgs:
    def __init__(__self__, *,
                 crypto_key: Optional[pulumi.Input[str]] = None,
                 kms_wrapped: Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']] = None):
        """
        Shift a date forward or backward in time by a random amount which is consistent for a given patient and crypto key combination.
        :param pulumi.Input[str] crypto_key: An AES 128/192/256 bit key. The date shift is computed based on this key and the patient ID. If the patient ID is empty for a DICOM resource, the date shift is computed based on this key and the study instance UID. If `crypto_key` is not set, then `kms_wrapped` is used to calculate the date shift. If neither is set, a default key is generated for each de-identify operation. Must not be set if `kms_wrapped` is set.
        :param pulumi.Input['KmsWrappedCryptoKeyArgs'] kms_wrapped: KMS wrapped key. If `kms_wrapped` is not set, then `crypto_key` is used to calculate the date shift. If neither is set, a default key is generated for each de-identify operation. Must not be set if `crypto_key` is set.
        """
        if crypto_key is not None:
            pulumi.set(__self__, "crypto_key", crypto_key)
        if kms_wrapped is not None:
            pulumi.set(__self__, "kms_wrapped", kms_wrapped)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> Optional[pulumi.Input[str]]:
        """
        An AES 128/192/256 bit key. The date shift is computed based on this key and the patient ID. If the patient ID is empty for a DICOM resource, the date shift is computed based on this key and the study instance UID. If `crypto_key` is not set, then `kms_wrapped` is used to calculate the date shift. If neither is set, a default key is generated for each de-identify operation. Must not be set if `kms_wrapped` is set.
        """
        return pulumi.get(self, "crypto_key")

    @crypto_key.setter
    def crypto_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_key", value)

    @property
    @pulumi.getter(name="kmsWrapped")
    def kms_wrapped(self) -> Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']]:
        """
        KMS wrapped key. If `kms_wrapped` is not set, then `crypto_key` is used to calculate the date shift. If neither is set, a default key is generated for each de-identify operation. Must not be set if `crypto_key` is set.
        """
        return pulumi.get(self, "kms_wrapped")

    @kms_wrapped.setter
    def kms_wrapped(self, value: Optional[pulumi.Input['KmsWrappedCryptoKeyArgs']]):
        pulumi.set(self, "kms_wrapped", value)


@pulumi.input_type
class DateShiftFieldArgs:
    def __init__(__self__):
        """
        Shift the date by a randomized number of days. See [date shifting](https://cloud.google.com/dlp/docs/concepts-date-shifting) for more information. Supported [types](https://www.hl7.org/fhir/datatypes.html): Date, DateTime
        """
        pass


@pulumi.input_type
class DeidentifiedStoreDestinationArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DeidentifyConfigArgs']] = None,
                 store: Optional[pulumi.Input[str]] = None):
        """
        Contains configuration for streaming de-identified FHIR export.
        :param pulumi.Input['DeidentifyConfigArgs'] config: The configuration to use when de-identifying resources that are added to this store.
        :param pulumi.Input[str] store: The full resource name of a Cloud Healthcare FHIR store, for example, `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if store is not None:
            pulumi.set(__self__, "store", store)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeidentifyConfigArgs']]:
        """
        The configuration to use when de-identifying resources that are added to this store.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeidentifyConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def store(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of a Cloud Healthcare FHIR store, for example, `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
        """
        return pulumi.get(self, "store")

    @store.setter
    def store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "store", value)


@pulumi.input_type
class DeidentifyConfigArgs:
    def __init__(__self__, *,
                 annotation: Optional[pulumi.Input['AnnotationConfigArgs']] = None,
                 dicom: Optional[pulumi.Input['DicomConfigArgs']] = None,
                 dicom_tag_config: Optional[pulumi.Input['DicomTagConfigArgs']] = None,
                 fhir: Optional[pulumi.Input['FhirConfigArgs']] = None,
                 fhir_field_config: Optional[pulumi.Input['FhirFieldConfigArgs']] = None,
                 image: Optional[pulumi.Input['ImageConfigArgs']] = None,
                 operation_metadata: Optional[pulumi.Input['DeidentifyOperationMetadataArgs']] = None,
                 text: Optional[pulumi.Input['TextConfigArgs']] = None):
        """
        Configures de-id options specific to different types of content. Each submessage customizes the handling of an https://tools.ietf.org/html/rfc6838 media type or subtype. Configs are applied in a nested manner at runtime.
        :param pulumi.Input['AnnotationConfigArgs'] annotation: Configures how annotations, meaning that the location and infoType of sensitive information findings, are created during de-identification. If unspecified, no annotations are created.
        :param pulumi.Input['DicomConfigArgs'] dicom: Configures de-id of application/DICOM content. Deprecated. Use `dicom_tag_config` instead.
        :param pulumi.Input['DicomTagConfigArgs'] dicom_tag_config: Configures de-id of application/DICOM content.
        :param pulumi.Input['FhirConfigArgs'] fhir: Configures de-id of application/FHIR content. Deprecated. Use `fhir_field_config` instead.
        :param pulumi.Input['FhirFieldConfigArgs'] fhir_field_config: Configures de-id of application/FHIR content.
        :param pulumi.Input['ImageConfigArgs'] image: Configures the de-identification of image pixels in the source_dataset. Deprecated. Use `dicom_tag_config.options.clean_image` instead.
        :param pulumi.Input['DeidentifyOperationMetadataArgs'] operation_metadata: Details about the work the de-identify operation performed.
        :param pulumi.Input['TextConfigArgs'] text: Configures de-identification of text wherever it is found in the source_dataset.
        """
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if dicom is not None:
            warnings.warn("""Configures de-id of application/DICOM content. Deprecated. Use `dicom_tag_config` instead.""", DeprecationWarning)
            pulumi.log.warn("""dicom is deprecated: Configures de-id of application/DICOM content. Deprecated. Use `dicom_tag_config` instead.""")
        if dicom is not None:
            pulumi.set(__self__, "dicom", dicom)
        if dicom_tag_config is not None:
            pulumi.set(__self__, "dicom_tag_config", dicom_tag_config)
        if fhir is not None:
            warnings.warn("""Configures de-id of application/FHIR content. Deprecated. Use `fhir_field_config` instead.""", DeprecationWarning)
            pulumi.log.warn("""fhir is deprecated: Configures de-id of application/FHIR content. Deprecated. Use `fhir_field_config` instead.""")
        if fhir is not None:
            pulumi.set(__self__, "fhir", fhir)
        if fhir_field_config is not None:
            pulumi.set(__self__, "fhir_field_config", fhir_field_config)
        if image is not None:
            warnings.warn("""Configures the de-identification of image pixels in the source_dataset. Deprecated. Use `dicom_tag_config.options.clean_image` instead.""", DeprecationWarning)
            pulumi.log.warn("""image is deprecated: Configures the de-identification of image pixels in the source_dataset. Deprecated. Use `dicom_tag_config.options.clean_image` instead.""")
        if image is not None:
            pulumi.set(__self__, "image", image)
        if operation_metadata is not None:
            pulumi.set(__self__, "operation_metadata", operation_metadata)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input['AnnotationConfigArgs']]:
        """
        Configures how annotations, meaning that the location and infoType of sensitive information findings, are created during de-identification. If unspecified, no annotations are created.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input['AnnotationConfigArgs']]):
        pulumi.set(self, "annotation", value)

    @property
    @pulumi.getter
    def dicom(self) -> Optional[pulumi.Input['DicomConfigArgs']]:
        """
        Configures de-id of application/DICOM content. Deprecated. Use `dicom_tag_config` instead.
        """
        return pulumi.get(self, "dicom")

    @dicom.setter
    def dicom(self, value: Optional[pulumi.Input['DicomConfigArgs']]):
        pulumi.set(self, "dicom", value)

    @property
    @pulumi.getter(name="dicomTagConfig")
    def dicom_tag_config(self) -> Optional[pulumi.Input['DicomTagConfigArgs']]:
        """
        Configures de-id of application/DICOM content.
        """
        return pulumi.get(self, "dicom_tag_config")

    @dicom_tag_config.setter
    def dicom_tag_config(self, value: Optional[pulumi.Input['DicomTagConfigArgs']]):
        pulumi.set(self, "dicom_tag_config", value)

    @property
    @pulumi.getter
    def fhir(self) -> Optional[pulumi.Input['FhirConfigArgs']]:
        """
        Configures de-id of application/FHIR content. Deprecated. Use `fhir_field_config` instead.
        """
        return pulumi.get(self, "fhir")

    @fhir.setter
    def fhir(self, value: Optional[pulumi.Input['FhirConfigArgs']]):
        pulumi.set(self, "fhir", value)

    @property
    @pulumi.getter(name="fhirFieldConfig")
    def fhir_field_config(self) -> Optional[pulumi.Input['FhirFieldConfigArgs']]:
        """
        Configures de-id of application/FHIR content.
        """
        return pulumi.get(self, "fhir_field_config")

    @fhir_field_config.setter
    def fhir_field_config(self, value: Optional[pulumi.Input['FhirFieldConfigArgs']]):
        pulumi.set(self, "fhir_field_config", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageConfigArgs']]:
        """
        Configures the de-identification of image pixels in the source_dataset. Deprecated. Use `dicom_tag_config.options.clean_image` instead.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageConfigArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="operationMetadata")
    def operation_metadata(self) -> Optional[pulumi.Input['DeidentifyOperationMetadataArgs']]:
        """
        Details about the work the de-identify operation performed.
        """
        return pulumi.get(self, "operation_metadata")

    @operation_metadata.setter
    def operation_metadata(self, value: Optional[pulumi.Input['DeidentifyOperationMetadataArgs']]):
        pulumi.set(self, "operation_metadata", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['TextConfigArgs']]:
        """
        Configures de-identification of text wherever it is found in the source_dataset.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['TextConfigArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class DeidentifyOperationMetadataArgs:
    def __init__(__self__, *,
                 fhir_output: Optional[pulumi.Input['FhirOutputArgs']] = None):
        """
        Details about the work the de-identify operation performed.
        :param pulumi.Input['FhirOutputArgs'] fhir_output: Details about the FHIR store to write the output to.
        """
        if fhir_output is not None:
            pulumi.set(__self__, "fhir_output", fhir_output)

    @property
    @pulumi.getter(name="fhirOutput")
    def fhir_output(self) -> Optional[pulumi.Input['FhirOutputArgs']]:
        """
        Details about the FHIR store to write the output to.
        """
        return pulumi.get(self, "fhir_output")

    @fhir_output.setter
    def fhir_output(self, value: Optional[pulumi.Input['FhirOutputArgs']]):
        pulumi.set(self, "fhir_output", value)


@pulumi.input_type
class DeleteTagArgs:
    def __init__(__self__):
        """
        Delete tag.
        """
        pass


@pulumi.input_type
class DicomConfigArgs:
    def __init__(__self__, *,
                 filter_profile: Optional[pulumi.Input['DicomConfigFilterProfile']] = None,
                 keep_list: Optional[pulumi.Input['TagFilterListArgs']] = None,
                 remove_list: Optional[pulumi.Input['TagFilterListArgs']] = None,
                 skip_id_redaction: Optional[pulumi.Input[bool]] = None):
        """
        Specifies the parameters needed for de-identification of DICOM stores.
        :param pulumi.Input['DicomConfigFilterProfile'] filter_profile: Tag filtering profile that determines which tags to keep/remove.
        :param pulumi.Input['TagFilterListArgs'] keep_list: List of tags to keep. Remove all other tags.
        :param pulumi.Input['TagFilterListArgs'] remove_list: List of tags to remove. Keep all other tags.
        :param pulumi.Input[bool] skip_id_redaction: If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped directly to an individual out of context, given access to the original images, or to a database of the original images containing the UIDs, it would be possible to recover the individual's identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
        """
        if filter_profile is not None:
            pulumi.set(__self__, "filter_profile", filter_profile)
        if keep_list is not None:
            pulumi.set(__self__, "keep_list", keep_list)
        if remove_list is not None:
            pulumi.set(__self__, "remove_list", remove_list)
        if skip_id_redaction is not None:
            pulumi.set(__self__, "skip_id_redaction", skip_id_redaction)

    @property
    @pulumi.getter(name="filterProfile")
    def filter_profile(self) -> Optional[pulumi.Input['DicomConfigFilterProfile']]:
        """
        Tag filtering profile that determines which tags to keep/remove.
        """
        return pulumi.get(self, "filter_profile")

    @filter_profile.setter
    def filter_profile(self, value: Optional[pulumi.Input['DicomConfigFilterProfile']]):
        pulumi.set(self, "filter_profile", value)

    @property
    @pulumi.getter(name="keepList")
    def keep_list(self) -> Optional[pulumi.Input['TagFilterListArgs']]:
        """
        List of tags to keep. Remove all other tags.
        """
        return pulumi.get(self, "keep_list")

    @keep_list.setter
    def keep_list(self, value: Optional[pulumi.Input['TagFilterListArgs']]):
        pulumi.set(self, "keep_list", value)

    @property
    @pulumi.getter(name="removeList")
    def remove_list(self) -> Optional[pulumi.Input['TagFilterListArgs']]:
        """
        List of tags to remove. Keep all other tags.
        """
        return pulumi.get(self, "remove_list")

    @remove_list.setter
    def remove_list(self, value: Optional[pulumi.Input['TagFilterListArgs']]):
        pulumi.set(self, "remove_list", value)

    @property
    @pulumi.getter(name="skipIdRedaction")
    def skip_id_redaction(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped directly to an individual out of context, given access to the original images, or to a database of the original images containing the UIDs, it would be possible to recover the individual's identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
        """
        return pulumi.get(self, "skip_id_redaction")

    @skip_id_redaction.setter
    def skip_id_redaction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_id_redaction", value)


@pulumi.input_type
class DicomTagConfigArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ActionArgs']]]] = None,
                 options: Optional[pulumi.Input['OptionsArgs']] = None,
                 profile_type: Optional[pulumi.Input['DicomTagConfigProfileType']] = None):
        """
        Specifies the parameters needed for the de-identification of DICOM stores.
        :param pulumi.Input[Sequence[pulumi.Input['ActionArgs']]] actions: Specifies custom tag selections and `Actions` to apply to them. Overrides `options` and `profile`. Conflicting `Actions` are applied in the order given.
        :param pulumi.Input['OptionsArgs'] options: Specifies additional options to apply, overriding the base `profile`.
        :param pulumi.Input['DicomTagConfigProfileType'] profile_type: Base profile type for handling DICOM tags.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if profile_type is not None:
            pulumi.set(__self__, "profile_type", profile_type)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionArgs']]]]:
        """
        Specifies custom tag selections and `Actions` to apply to them. Overrides `options` and `profile`. Conflicting `Actions` are applied in the order given.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['OptionsArgs']]:
        """
        Specifies additional options to apply, overriding the base `profile`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['OptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[pulumi.Input['DicomTagConfigProfileType']]:
        """
        Base profile type for handling DICOM tags.
        """
        return pulumi.get(self, "profile_type")

    @profile_type.setter
    def profile_type(self, value: Optional[pulumi.Input['DicomTagConfigProfileType']]):
        pulumi.set(self, "profile_type", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FhirConfigArgs:
    def __init__(__self__, *,
                 default_keep_extensions: Optional[pulumi.Input[bool]] = None,
                 field_metadata_list: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMetadataArgs']]]] = None):
        """
        Specifies how to handle de-identification of a FHIR store.
        :param pulumi.Input[bool] default_keep_extensions: The behaviour for handling FHIR extensions that aren't otherwise specified for de-identification. If true, all extensions are preserved during de-identification by default. If false or unspecified, all extensions are removed during de-identification by default.
        :param pulumi.Input[Sequence[pulumi.Input['FieldMetadataArgs']]] field_metadata_list: Specifies FHIR paths to match and how to transform them. Any field that is not matched by a FieldMetadata is passed through to the output dataset unmodified. All extensions will be processed according to `default_keep_extensions`. If a field can be matched by more than one FieldMetadata, the first FieldMetadata.Action is applied.
        """
        if default_keep_extensions is not None:
            pulumi.set(__self__, "default_keep_extensions", default_keep_extensions)
        if field_metadata_list is not None:
            pulumi.set(__self__, "field_metadata_list", field_metadata_list)

    @property
    @pulumi.getter(name="defaultKeepExtensions")
    def default_keep_extensions(self) -> Optional[pulumi.Input[bool]]:
        """
        The behaviour for handling FHIR extensions that aren't otherwise specified for de-identification. If true, all extensions are preserved during de-identification by default. If false or unspecified, all extensions are removed during de-identification by default.
        """
        return pulumi.get(self, "default_keep_extensions")

    @default_keep_extensions.setter
    def default_keep_extensions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_keep_extensions", value)

    @property
    @pulumi.getter(name="fieldMetadataList")
    def field_metadata_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldMetadataArgs']]]]:
        """
        Specifies FHIR paths to match and how to transform them. Any field that is not matched by a FieldMetadata is passed through to the output dataset unmodified. All extensions will be processed according to `default_keep_extensions`. If a field can be matched by more than one FieldMetadata, the first FieldMetadata.Action is applied.
        """
        return pulumi.get(self, "field_metadata_list")

    @field_metadata_list.setter
    def field_metadata_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMetadataArgs']]]]):
        pulumi.set(self, "field_metadata_list", value)


@pulumi.input_type
class FhirFieldConfigArgs:
    def __init__(__self__, *,
                 field_metadata_list: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs']]]] = None,
                 options: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs']] = None,
                 profile_type: Optional[pulumi.Input['FhirFieldConfigProfileType']] = None):
        """
        Specifies how to handle the de-identification of a FHIR store.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs']]] field_metadata_list: Specifies FHIR paths to match and how to transform them. Any field that is not matched by a `FieldMetadata` is passed through to the output dataset unmodified. All extensions will be processed according to `keep_extensions`. If a field can be matched by more than one `FieldMetadata`, the first `FieldMetadata.Action` is applied. Overrides `options` and `profile`.
        :param pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs'] options: Specifies additional options, overriding the base `profile`.
        :param pulumi.Input['FhirFieldConfigProfileType'] profile_type: Base profile type for handling FHIR fields.
        """
        if field_metadata_list is not None:
            pulumi.set(__self__, "field_metadata_list", field_metadata_list)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if profile_type is not None:
            pulumi.set(__self__, "profile_type", profile_type)

    @property
    @pulumi.getter(name="fieldMetadataList")
    def field_metadata_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs']]]]:
        """
        Specifies FHIR paths to match and how to transform them. Any field that is not matched by a `FieldMetadata` is passed through to the output dataset unmodified. All extensions will be processed according to `keep_extensions`. If a field can be matched by more than one `FieldMetadata`, the first `FieldMetadata.Action` is applied. Overrides `options` and `profile`.
        """
        return pulumi.get(self, "field_metadata_list")

    @field_metadata_list.setter
    def field_metadata_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs']]]]):
        pulumi.set(self, "field_metadata_list", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs']]:
        """
        Specifies additional options, overriding the base `profile`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[pulumi.Input['FhirFieldConfigProfileType']]:
        """
        Base profile type for handling FHIR fields.
        """
        return pulumi.get(self, "profile_type")

    @profile_type.setter
    def profile_type(self, value: Optional[pulumi.Input['FhirFieldConfigProfileType']]):
        pulumi.set(self, "profile_type", value)


@pulumi.input_type
class FhirNotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub_topic: Optional[pulumi.Input[str]] = None,
                 send_full_resource: Optional[pulumi.Input[bool]] = None):
        """
        Contains the configuration for FHIR notifications.
        :param pulumi.Input[str] pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-api/docs/how-tos/logging).
        :param pulumi.Input[bool] send_full_resource: Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation. Note that setting this to true does not guarantee that all resources will be sent in the format of full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full resource as a separate operation.
        """
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if send_full_resource is not None:
            pulumi.set(__self__, "send_full_resource", send_full_resource)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-api/docs/how-tos/logging).
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter(name="sendFullResource")
    def send_full_resource(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation. Note that setting this to true does not guarantee that all resources will be sent in the format of full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full resource as a separate operation.
        """
        return pulumi.get(self, "send_full_resource")

    @send_full_resource.setter
    def send_full_resource(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_full_resource", value)


@pulumi.input_type
class FhirOutputArgs:
    def __init__(__self__, *,
                 fhir_store: Optional[pulumi.Input[str]] = None):
        """
        Details about the FHIR store to write the output to.
        :param pulumi.Input[str] fhir_store: Name of the output FHIR store, which must already exist. You must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set `enable_update_create` to true. The destination store must use FHIR version R4. Writing these resources will consume FHIR operations quota from the project containing the source data. De-identify operation metadata is only generated for DICOM de-identification operations.
        """
        if fhir_store is not None:
            pulumi.set(__self__, "fhir_store", fhir_store)

    @property
    @pulumi.getter(name="fhirStore")
    def fhir_store(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the output FHIR store, which must already exist. You must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set `enable_update_create` to true. The destination store must use FHIR version R4. Writing these resources will consume FHIR operations quota from the project containing the source data. De-identify operation metadata is only generated for DICOM de-identification operations.
        """
        return pulumi.get(self, "fhir_store")

    @fhir_store.setter
    def fhir_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fhir_store", value)


@pulumi.input_type
class FieldMetadataArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['FieldMetadataAction']] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies FHIR paths to match, and how to handle de-identification of matching fields.
        :param pulumi.Input['FieldMetadataAction'] action: Deidentify action for one field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partial matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined. For example, "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName(for example HumanName.given, HumanName.family) can be omitted.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['FieldMetadataAction']]:
        """
        Deidentify action for one field.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['FieldMetadataAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partial matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined. For example, "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName(for example HumanName.given, HumanName.family) can be omitted.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class FieldArgs:
    def __init__(__self__, *,
                 max_occurs: Optional[pulumi.Input[int]] = None,
                 min_occurs: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A (sub) field of a type.
        :param pulumi.Input[int] max_occurs: The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        :param pulumi.Input[int] min_occurs: The minimum number of times this field must be present/repeated.
        :param pulumi.Input[str] name: The name of the field. For example, "PID-1" or just "1".
        :param pulumi.Input[str] table: The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        :param pulumi.Input[str] type: The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        if max_occurs is not None:
            pulumi.set(__self__, "max_occurs", max_occurs)
        if min_occurs is not None:
            pulumi.set(__self__, "min_occurs", min_occurs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="maxOccurs")
    def max_occurs(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        """
        return pulumi.get(self, "max_occurs")

    @max_occurs.setter
    def max_occurs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_occurs", value)

    @property
    @pulumi.getter(name="minOccurs")
    def min_occurs(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of times this field must be present/repeated.
        """
        return pulumi.get(self, "min_occurs")

    @min_occurs.setter
    def min_occurs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_occurs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field. For example, "PID-1" or just "1".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1ConsentPolicyArgs:
    def __init__(__self__, *,
                 authorization_rule: pulumi.Input['ExprArgs'],
                 resource_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]] = None):
        """
        Represents a user's consent in terms of the resources that can be accessed and under what conditions.
        :param pulumi.Input['ExprArgs'] authorization_rule: The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        :param pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]] resource_attributes: The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        pulumi.set(__self__, "authorization_rule", authorization_rule)
        if resource_attributes is not None:
            pulumi.set(__self__, "resource_attributes", resource_attributes)

    @property
    @pulumi.getter(name="authorizationRule")
    def authorization_rule(self) -> pulumi.Input['ExprArgs']:
        """
        The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        """
        return pulumi.get(self, "authorization_rule")

    @authorization_rule.setter
    def authorization_rule(self, value: pulumi.Input['ExprArgs']):
        pulumi.set(self, "authorization_rule", value)

    @property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]]:
        """
        The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        return pulumi.get(self, "resource_attributes")

    @resource_attributes.setter
    def resource_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]]):
        pulumi.set(self, "resource_attributes", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1DeidentifyFieldMetadataArgs:
    def __init__(__self__, *,
                 character_mask_field: Optional[pulumi.Input['CharacterMaskFieldArgs']] = None,
                 clean_text_field: Optional[pulumi.Input['CleanTextFieldArgs']] = None,
                 crypto_hash_field: Optional[pulumi.Input['CryptoHashFieldArgs']] = None,
                 date_shift_field: Optional[pulumi.Input['DateShiftFieldArgs']] = None,
                 keep_field: Optional[pulumi.Input['KeepFieldArgs']] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remove_field: Optional[pulumi.Input['RemoveFieldArgs']] = None):
        """
        Specifies the FHIR paths to match and how to handle the de-identification of matching fields.
        :param pulumi.Input['CharacterMaskFieldArgs'] character_mask_field: Replace the field's value with a masking character. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        :param pulumi.Input['CleanTextFieldArgs'] clean_text_field: Inspect the field's text and transform sensitive text. Configure using `TextConfig`. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Date, DateTime, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        :param pulumi.Input['CryptoHashFieldArgs'] crypto_hash_field: Replace field value with a hash of that value. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        :param pulumi.Input['DateShiftFieldArgs'] date_shift_field: Shift the date by a randomized number of days. See [date shifting](https://cloud.google.com/dlp/docs/concepts-date-shifting) for more information. Supported [types](https://www.hl7.org/fhir/datatypes.html): Date, DateTime
        :param pulumi.Input['KeepFieldArgs'] keep_field: Keep the field unchanged.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partialkk matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined, for example "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported [types](https://www.hl7.org/fhir/datatypes.html) are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName (for example HumanName.given, HumanName.family) can be omitted.
        :param pulumi.Input['RemoveFieldArgs'] remove_field: Remove the field.
        """
        if character_mask_field is not None:
            pulumi.set(__self__, "character_mask_field", character_mask_field)
        if clean_text_field is not None:
            pulumi.set(__self__, "clean_text_field", clean_text_field)
        if crypto_hash_field is not None:
            pulumi.set(__self__, "crypto_hash_field", crypto_hash_field)
        if date_shift_field is not None:
            pulumi.set(__self__, "date_shift_field", date_shift_field)
        if keep_field is not None:
            pulumi.set(__self__, "keep_field", keep_field)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if remove_field is not None:
            pulumi.set(__self__, "remove_field", remove_field)

    @property
    @pulumi.getter(name="characterMaskField")
    def character_mask_field(self) -> Optional[pulumi.Input['CharacterMaskFieldArgs']]:
        """
        Replace the field's value with a masking character. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        return pulumi.get(self, "character_mask_field")

    @character_mask_field.setter
    def character_mask_field(self, value: Optional[pulumi.Input['CharacterMaskFieldArgs']]):
        pulumi.set(self, "character_mask_field", value)

    @property
    @pulumi.getter(name="cleanTextField")
    def clean_text_field(self) -> Optional[pulumi.Input['CleanTextFieldArgs']]:
        """
        Inspect the field's text and transform sensitive text. Configure using `TextConfig`. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Date, DateTime, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        return pulumi.get(self, "clean_text_field")

    @clean_text_field.setter
    def clean_text_field(self, value: Optional[pulumi.Input['CleanTextFieldArgs']]):
        pulumi.set(self, "clean_text_field", value)

    @property
    @pulumi.getter(name="cryptoHashField")
    def crypto_hash_field(self) -> Optional[pulumi.Input['CryptoHashFieldArgs']]:
        """
        Replace field value with a hash of that value. Supported [types](https://www.hl7.org/fhir/datatypes.html): Code, Decimal, HumanName, Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml
        """
        return pulumi.get(self, "crypto_hash_field")

    @crypto_hash_field.setter
    def crypto_hash_field(self, value: Optional[pulumi.Input['CryptoHashFieldArgs']]):
        pulumi.set(self, "crypto_hash_field", value)

    @property
    @pulumi.getter(name="dateShiftField")
    def date_shift_field(self) -> Optional[pulumi.Input['DateShiftFieldArgs']]:
        """
        Shift the date by a randomized number of days. See [date shifting](https://cloud.google.com/dlp/docs/concepts-date-shifting) for more information. Supported [types](https://www.hl7.org/fhir/datatypes.html): Date, DateTime
        """
        return pulumi.get(self, "date_shift_field")

    @date_shift_field.setter
    def date_shift_field(self, value: Optional[pulumi.Input['DateShiftFieldArgs']]):
        pulumi.set(self, "date_shift_field", value)

    @property
    @pulumi.getter(name="keepField")
    def keep_field(self) -> Optional[pulumi.Input['KeepFieldArgs']]:
        """
        Keep the field unchanged.
        """
        return pulumi.get(self, "keep_field")

    @keep_field.setter
    def keep_field(self, value: Optional[pulumi.Input['KeepFieldArgs']]):
        pulumi.set(self, "keep_field", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partialkk matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined, for example "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported [types](https://www.hl7.org/fhir/datatypes.html) are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName (for example HumanName.given, HumanName.family) can be omitted.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="removeField")
    def remove_field(self) -> Optional[pulumi.Input['RemoveFieldArgs']]:
        """
        Remove the field.
        """
        return pulumi.get(self, "remove_field")

    @remove_field.setter
    def remove_field(self, value: Optional[pulumi.Input['RemoveFieldArgs']]):
        pulumi.set(self, "remove_field", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1DeidentifyOptionsArgs:
    def __init__(__self__, *,
                 character_mask_config: Optional[pulumi.Input['CharacterMaskConfigArgs']] = None,
                 contextual_deid: Optional[pulumi.Input['ContextualDeidConfigArgs']] = None,
                 crypto_hash_config: Optional[pulumi.Input['CryptoHashConfigArgs']] = None,
                 date_shift_config: Optional[pulumi.Input['DateShiftConfigArgs']] = None,
                 keep_extensions: Optional[pulumi.Input['KeepExtensionsConfigArgs']] = None):
        """
        Specifies additional options to apply to the base `profile`.
        :param pulumi.Input['CharacterMaskConfigArgs'] character_mask_config: Character mask config for `CharacterMaskField` `FieldMetadatas`.
        :param pulumi.Input['ContextualDeidConfigArgs'] contextual_deid: Configure contextual de-id.
        :param pulumi.Input['CryptoHashConfigArgs'] crypto_hash_config: Crypo hash config for `CharacterMaskField` `FieldMetadatas`.
        :param pulumi.Input['DateShiftConfigArgs'] date_shift_config: Date shifting config for `CharacterMaskField` `FieldMetadatas`.
        :param pulumi.Input['KeepExtensionsConfigArgs'] keep_extensions: Configure keeping extensions by default.
        """
        if character_mask_config is not None:
            pulumi.set(__self__, "character_mask_config", character_mask_config)
        if contextual_deid is not None:
            pulumi.set(__self__, "contextual_deid", contextual_deid)
        if crypto_hash_config is not None:
            pulumi.set(__self__, "crypto_hash_config", crypto_hash_config)
        if date_shift_config is not None:
            pulumi.set(__self__, "date_shift_config", date_shift_config)
        if keep_extensions is not None:
            pulumi.set(__self__, "keep_extensions", keep_extensions)

    @property
    @pulumi.getter(name="characterMaskConfig")
    def character_mask_config(self) -> Optional[pulumi.Input['CharacterMaskConfigArgs']]:
        """
        Character mask config for `CharacterMaskField` `FieldMetadatas`.
        """
        return pulumi.get(self, "character_mask_config")

    @character_mask_config.setter
    def character_mask_config(self, value: Optional[pulumi.Input['CharacterMaskConfigArgs']]):
        pulumi.set(self, "character_mask_config", value)

    @property
    @pulumi.getter(name="contextualDeid")
    def contextual_deid(self) -> Optional[pulumi.Input['ContextualDeidConfigArgs']]:
        """
        Configure contextual de-id.
        """
        return pulumi.get(self, "contextual_deid")

    @contextual_deid.setter
    def contextual_deid(self, value: Optional[pulumi.Input['ContextualDeidConfigArgs']]):
        pulumi.set(self, "contextual_deid", value)

    @property
    @pulumi.getter(name="cryptoHashConfig")
    def crypto_hash_config(self) -> Optional[pulumi.Input['CryptoHashConfigArgs']]:
        """
        Crypo hash config for `CharacterMaskField` `FieldMetadatas`.
        """
        return pulumi.get(self, "crypto_hash_config")

    @crypto_hash_config.setter
    def crypto_hash_config(self, value: Optional[pulumi.Input['CryptoHashConfigArgs']]):
        pulumi.set(self, "crypto_hash_config", value)

    @property
    @pulumi.getter(name="dateShiftConfig")
    def date_shift_config(self) -> Optional[pulumi.Input['DateShiftConfigArgs']]:
        """
        Date shifting config for `CharacterMaskField` `FieldMetadatas`.
        """
        return pulumi.get(self, "date_shift_config")

    @date_shift_config.setter
    def date_shift_config(self, value: Optional[pulumi.Input['DateShiftConfigArgs']]):
        pulumi.set(self, "date_shift_config", value)

    @property
    @pulumi.getter(name="keepExtensions")
    def keep_extensions(self) -> Optional[pulumi.Input['KeepExtensionsConfigArgs']]:
        """
        Configure keeping extensions by default.
        """
        return pulumi.get(self, "keep_extensions")

    @keep_extensions.setter
    def keep_extensions(self, value: Optional[pulumi.Input['KeepExtensionsConfigArgs']]):
        pulumi.set(self, "keep_extensions", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs:
    def __init__(__self__, *,
                 force: Optional[pulumi.Input[bool]] = None,
                 table_uri: Optional[pulumi.Input[str]] = None,
                 write_disposition: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationWriteDisposition']] = None):
        """
        The BigQuery table where the server writes output.
        :param pulumi.Input[bool] force: Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param pulumi.Input[str] table_uri: BigQuery URI to a table, up to 2000 characters long, in the format `bq://projectId.bqDatasetId.tableId`
        :param pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationWriteDisposition'] write_disposition: Determines whether the existing table in the destination is to be overwritten or appended to. If a write_disposition is specified, the `force` parameter is ignored.
        """
        if force is not None:
            pulumi.set(__self__, "force", force)
        if table_uri is not None:
            pulumi.set(__self__, "table_uri", table_uri)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="tableUri")
    def table_uri(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery URI to a table, up to 2000 characters long, in the format `bq://projectId.bqDatasetId.tableId`
        """
        return pulumi.get(self, "table_uri")

    @table_uri.setter
    def table_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_uri", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationWriteDisposition']]:
        """
        Determines whether the existing table in the destination is to be overwritten or appended to. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationWriteDisposition']]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1DicomStreamConfigArgs:
    def __init__(__self__, *,
                 bigquery_destination: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs']] = None):
        """
        StreamConfig specifies configuration for a streaming DICOM export.
        :param pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs'] bigquery_destination: Results are appended to this table. The server creates a new table in the given BigQuery dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to your BigQuery table, you must give the Cloud Healthcare API service account the bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM store resides in. To get the project number, go to the Cloud Console Dashboard. It is recommended to not have a custom schema in the destination table which could conflict with the schema created by the Cloud Healthcare API. Instance deletions are not applied to the destination table. The destination's table schema will be automatically updated in case a new instance's data is incompatible with the current schema. The schema should not be updated manually as this can cause incompatibilies that cannot be resolved automatically. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        if bigquery_destination is not None:
            pulumi.set(__self__, "bigquery_destination", bigquery_destination)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs']]:
        """
        Results are appended to this table. The server creates a new table in the given BigQuery dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to your BigQuery table, you must give the Cloud Healthcare API service account the bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM store resides in. To get the project number, go to the Cloud Console Dashboard. It is recommended to not have a custom schema in the destination table which could conflict with the schema created by the Cloud Healthcare API. Instance deletions are not applied to the destination table. The destination's table schema will be automatically updated in case a new instance's data is incompatible with the current schema. The schema should not be updated manually as this can cause incompatibilies that cannot be resolved automatically. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")

    @bigquery_destination.setter
    def bigquery_destination(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1DicomBigQueryDestinationArgs']]):
        pulumi.set(self, "bigquery_destination", value)


@pulumi.input_type
class GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs:
    def __init__(__self__, *,
                 dataset_uri: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 schema_config: Optional[pulumi.Input['SchemaConfigArgs']] = None,
                 write_disposition: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationWriteDisposition']] = None):
        """
        The configuration for exporting to BigQuery.
        :param pulumi.Input[str] dataset_uri: BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        :param pulumi.Input[bool] force: Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param pulumi.Input['SchemaConfigArgs'] schema_config: The configuration for the exported BigQuery schema.
        :param pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationWriteDisposition'] write_disposition: Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        if dataset_uri is not None:
            pulumi.set(__self__, "dataset_uri", dataset_uri)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if schema_config is not None:
            pulumi.set(__self__, "schema_config", schema_config)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="datasetUri")
    def dataset_uri(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        """
        return pulumi.get(self, "dataset_uri")

    @dataset_uri.setter
    def dataset_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_uri", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="schemaConfig")
    def schema_config(self) -> Optional[pulumi.Input['SchemaConfigArgs']]:
        """
        The configuration for the exported BigQuery schema.
        """
        return pulumi.get(self, "schema_config")

    @schema_config.setter
    def schema_config(self, value: Optional[pulumi.Input['SchemaConfigArgs']]):
        pulumi.set(self, "schema_config", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationWriteDisposition']]:
        """
        Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationWriteDisposition']]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class Hl7SchemaConfigArgs:
    def __init__(__self__, *,
                 message_schema_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]] = None):
        """
        Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] message_schema_configs: Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        :param pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]] version: Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        if message_schema_configs is not None:
            pulumi.set(__self__, "message_schema_configs", message_schema_configs)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="messageSchemaConfigs")
    def message_schema_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        """
        return pulumi.get(self, "message_schema_configs")

    @message_schema_configs.setter
    def message_schema_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "message_schema_configs", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]:
        """
        Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class Hl7TypesConfigArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]] = None):
        """
        Root config for HL7v2 datatype definitions for a specific HL7v2 version.
        :param pulumi.Input[Sequence[pulumi.Input['TypeArgs']]] type: The HL7v2 type definitions.
        :param pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]] version: The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]:
        """
        The HL7v2 type definitions.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]:
        """
        The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class Hl7V2NotificationConfigArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None):
        """
        Specifies where and whether to send notifications upon changes to a data store.
        :param pulumi.Input[str] filter: Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. Fields/functions available for filtering are: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        :param pulumi.Input[str] pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. Fields/functions available for filtering are: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)


@pulumi.input_type
class ImageAnnotationArgs:
    def __init__(__self__, *,
                 bounding_polys: Optional[pulumi.Input[Sequence[pulumi.Input['BoundingPolyArgs']]]] = None,
                 frame_index: Optional[pulumi.Input[int]] = None):
        """
        Image annotation.
        :param pulumi.Input[Sequence[pulumi.Input['BoundingPolyArgs']]] bounding_polys: The list of polygons outlining the sensitive regions in the image.
        :param pulumi.Input[int] frame_index: 0-based index of the image frame. For example, an image frame in a DICOM instance.
        """
        if bounding_polys is not None:
            pulumi.set(__self__, "bounding_polys", bounding_polys)
        if frame_index is not None:
            pulumi.set(__self__, "frame_index", frame_index)

    @property
    @pulumi.getter(name="boundingPolys")
    def bounding_polys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BoundingPolyArgs']]]]:
        """
        The list of polygons outlining the sensitive regions in the image.
        """
        return pulumi.get(self, "bounding_polys")

    @bounding_polys.setter
    def bounding_polys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BoundingPolyArgs']]]]):
        pulumi.set(self, "bounding_polys", value)

    @property
    @pulumi.getter(name="frameIndex")
    def frame_index(self) -> Optional[pulumi.Input[int]]:
        """
        0-based index of the image frame. For example, an image frame in a DICOM instance.
        """
        return pulumi.get(self, "frame_index")

    @frame_index.setter
    def frame_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frame_index", value)


@pulumi.input_type
class ImageConfigArgs:
    def __init__(__self__, *,
                 additional_info_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclude_info_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_redaction_mode: Optional[pulumi.Input['ImageConfigTextRedactionMode']] = None):
        """
        Specifies how to handle de-identification of image pixels.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_info_types: Additional InfoTypes to redact in the images in addition to those used by `text_redaction_mode`. Can only be used when `text_redaction_mode` is set to `REDACT_SENSITIVE_TEXT`, `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS` or `TEXT_REDACTION_MODE_UNSPECIFIED`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_info_types: InfoTypes to skip redacting, overriding those used by `text_redaction_mode`. Can only be used when `text_redaction_mode` is set to `REDACT_SENSITIVE_TEXT` or `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS`.
        :param pulumi.Input['ImageConfigTextRedactionMode'] text_redaction_mode: Determines how to redact text from image.
        """
        if additional_info_types is not None:
            pulumi.set(__self__, "additional_info_types", additional_info_types)
        if exclude_info_types is not None:
            pulumi.set(__self__, "exclude_info_types", exclude_info_types)
        if text_redaction_mode is not None:
            pulumi.set(__self__, "text_redaction_mode", text_redaction_mode)

    @property
    @pulumi.getter(name="additionalInfoTypes")
    def additional_info_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional InfoTypes to redact in the images in addition to those used by `text_redaction_mode`. Can only be used when `text_redaction_mode` is set to `REDACT_SENSITIVE_TEXT`, `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS` or `TEXT_REDACTION_MODE_UNSPECIFIED`.
        """
        return pulumi.get(self, "additional_info_types")

    @additional_info_types.setter
    def additional_info_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_info_types", value)

    @property
    @pulumi.getter(name="excludeInfoTypes")
    def exclude_info_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        InfoTypes to skip redacting, overriding those used by `text_redaction_mode`. Can only be used when `text_redaction_mode` is set to `REDACT_SENSITIVE_TEXT` or `REDACT_SENSITIVE_TEXT_CLEAN_DESCRIPTORS`.
        """
        return pulumi.get(self, "exclude_info_types")

    @exclude_info_types.setter
    def exclude_info_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_info_types", value)

    @property
    @pulumi.getter(name="textRedactionMode")
    def text_redaction_mode(self) -> Optional[pulumi.Input['ImageConfigTextRedactionMode']]:
        """
        Determines how to redact text from image.
        """
        return pulumi.get(self, "text_redaction_mode")

    @text_redaction_mode.setter
    def text_redaction_mode(self, value: Optional[pulumi.Input['ImageConfigTextRedactionMode']]):
        pulumi.set(self, "text_redaction_mode", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 gcs_uri: Optional[pulumi.Input[str]] = None,
                 raw_bytes: Optional[pulumi.Input[str]] = None):
        """
        Raw bytes representing consent artifact content.
        :param pulumi.Input[str] gcs_uri: Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        :param pulumi.Input[str] raw_bytes: Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        if gcs_uri is not None:
            pulumi.set(__self__, "gcs_uri", gcs_uri)
        if raw_bytes is not None:
            pulumi.set(__self__, "raw_bytes", raw_bytes)

    @property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        """
        return pulumi.get(self, "gcs_uri")

    @gcs_uri.setter
    def gcs_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcs_uri", value)

    @property
    @pulumi.getter(name="rawBytes")
    def raw_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        return pulumi.get(self, "raw_bytes")

    @raw_bytes.setter
    def raw_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_bytes", value)


@pulumi.input_type
class InfoTypeTransformationArgs:
    def __init__(__self__, *,
                 character_mask_config: Optional[pulumi.Input['CharacterMaskConfigArgs']] = None,
                 crypto_hash_config: Optional[pulumi.Input['CryptoHashConfigArgs']] = None,
                 date_shift_config: Optional[pulumi.Input['DateShiftConfigArgs']] = None,
                 info_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redact_config: Optional[pulumi.Input['RedactConfigArgs']] = None,
                 replace_with_info_type_config: Optional[pulumi.Input['ReplaceWithInfoTypeConfigArgs']] = None):
        """
        A transformation to apply to text that is identified as a specific info_type.
        :param pulumi.Input['CharacterMaskConfigArgs'] character_mask_config: Config for character mask.
        :param pulumi.Input['CryptoHashConfigArgs'] crypto_hash_config: Config for crypto hash.
        :param pulumi.Input['DateShiftConfigArgs'] date_shift_config: Config for date shift.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] info_types: `InfoTypes` to apply this transformation to. If this is not specified, this transformation becomes the default transformation, and is used for any `info_type` that is not specified in another transformation.
        :param pulumi.Input['RedactConfigArgs'] redact_config: Config for text redaction.
        :param pulumi.Input['ReplaceWithInfoTypeConfigArgs'] replace_with_info_type_config: Config for replace with InfoType.
        """
        if character_mask_config is not None:
            pulumi.set(__self__, "character_mask_config", character_mask_config)
        if crypto_hash_config is not None:
            pulumi.set(__self__, "crypto_hash_config", crypto_hash_config)
        if date_shift_config is not None:
            pulumi.set(__self__, "date_shift_config", date_shift_config)
        if info_types is not None:
            pulumi.set(__self__, "info_types", info_types)
        if redact_config is not None:
            pulumi.set(__self__, "redact_config", redact_config)
        if replace_with_info_type_config is not None:
            pulumi.set(__self__, "replace_with_info_type_config", replace_with_info_type_config)

    @property
    @pulumi.getter(name="characterMaskConfig")
    def character_mask_config(self) -> Optional[pulumi.Input['CharacterMaskConfigArgs']]:
        """
        Config for character mask.
        """
        return pulumi.get(self, "character_mask_config")

    @character_mask_config.setter
    def character_mask_config(self, value: Optional[pulumi.Input['CharacterMaskConfigArgs']]):
        pulumi.set(self, "character_mask_config", value)

    @property
    @pulumi.getter(name="cryptoHashConfig")
    def crypto_hash_config(self) -> Optional[pulumi.Input['CryptoHashConfigArgs']]:
        """
        Config for crypto hash.
        """
        return pulumi.get(self, "crypto_hash_config")

    @crypto_hash_config.setter
    def crypto_hash_config(self, value: Optional[pulumi.Input['CryptoHashConfigArgs']]):
        pulumi.set(self, "crypto_hash_config", value)

    @property
    @pulumi.getter(name="dateShiftConfig")
    def date_shift_config(self) -> Optional[pulumi.Input['DateShiftConfigArgs']]:
        """
        Config for date shift.
        """
        return pulumi.get(self, "date_shift_config")

    @date_shift_config.setter
    def date_shift_config(self, value: Optional[pulumi.Input['DateShiftConfigArgs']]):
        pulumi.set(self, "date_shift_config", value)

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `InfoTypes` to apply this transformation to. If this is not specified, this transformation becomes the default transformation, and is used for any `info_type` that is not specified in another transformation.
        """
        return pulumi.get(self, "info_types")

    @info_types.setter
    def info_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "info_types", value)

    @property
    @pulumi.getter(name="redactConfig")
    def redact_config(self) -> Optional[pulumi.Input['RedactConfigArgs']]:
        """
        Config for text redaction.
        """
        return pulumi.get(self, "redact_config")

    @redact_config.setter
    def redact_config(self, value: Optional[pulumi.Input['RedactConfigArgs']]):
        pulumi.set(self, "redact_config", value)

    @property
    @pulumi.getter(name="replaceWithInfoTypeConfig")
    def replace_with_info_type_config(self) -> Optional[pulumi.Input['ReplaceWithInfoTypeConfigArgs']]:
        """
        Config for replace with InfoType.
        """
        return pulumi.get(self, "replace_with_info_type_config")

    @replace_with_info_type_config.setter
    def replace_with_info_type_config(self, value: Optional[pulumi.Input['ReplaceWithInfoTypeConfigArgs']]):
        pulumi.set(self, "replace_with_info_type_config", value)


@pulumi.input_type
class KeepExtensionsConfigArgs:
    def __init__(__self__):
        """
        The behaviour for handling FHIR extensions that aren't otherwise specified for de-identification. If provided, all extensions are preserved during de-identification by default. If unspecified, all extensions are removed during de-identification by default.
        """
        pass


@pulumi.input_type
class KeepFieldArgs:
    def __init__(__self__):
        """
        Keep field unchanged.
        """
        pass


@pulumi.input_type
class KeepTagArgs:
    def __init__(__self__):
        """
        Keep tag unchanged.
        """
        pass


@pulumi.input_type
class KmsWrappedCryptoKeyArgs:
    def __init__(__self__, *,
                 crypto_key: pulumi.Input[str],
                 wrapped_key: pulumi.Input[str]):
        """
        Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit key. The key must grant the Cloud IAM permission `cloudkms.cryptoKeyVersions.useToDecrypt` to the project's Cloud Healthcare Service Agent service account. For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs/create-wrapped-key).
        :param pulumi.Input[str] crypto_key: The resource name of the KMS CryptoKey to use for unwrapping. For example, `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
        :param pulumi.Input[str] wrapped_key: The wrapped data crypto key.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "wrapped_key", wrapped_key)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> pulumi.Input[str]:
        """
        The resource name of the KMS CryptoKey to use for unwrapping. For example, `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
        """
        return pulumi.get(self, "crypto_key")

    @crypto_key.setter
    def crypto_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "crypto_key", value)

    @property
    @pulumi.getter(name="wrappedKey")
    def wrapped_key(self) -> pulumi.Input[str]:
        """
        The wrapped data crypto key.
        """
        return pulumi.get(self, "wrapped_key")

    @wrapped_key.setter
    def wrapped_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "wrapped_key", value)


@pulumi.input_type
class NotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub_topic: Optional[pulumi.Input[str]] = None,
                 send_for_bulk_import: Optional[pulumi.Input[bool]] = None):
        """
        Specifies where to send notifications upon changes to a data store.
        :param pulumi.Input[str] pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        :param pulumi.Input[bool] send_for_bulk_import: Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if send_for_bulk_import is not None:
            pulumi.set(__self__, "send_for_bulk_import", send_for_bulk_import)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter(name="sendForBulkImport")
    def send_for_bulk_import(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        return pulumi.get(self, "send_for_bulk_import")

    @send_for_bulk_import.setter
    def send_for_bulk_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_for_bulk_import", value)


@pulumi.input_type
class OptionsArgs:
    def __init__(__self__, *,
                 clean_descriptors: Optional[pulumi.Input['CleanDescriptorsOptionArgs']] = None,
                 clean_image: Optional[pulumi.Input['ImageConfigArgs']] = None,
                 primary_ids: Optional[pulumi.Input['OptionsPrimaryIds']] = None):
        """
        Specifies additional options to apply to the base profile.
        :param pulumi.Input['CleanDescriptorsOptionArgs'] clean_descriptors: Set Clean Descriptors Option.
        :param pulumi.Input['ImageConfigArgs'] clean_image: Apply `Action.clean_image` to [`PixelData`](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html) as configured.
        :param pulumi.Input['OptionsPrimaryIds'] primary_ids: Set `Action` for [`StudyInstanceUID`, `SeriesInstanceUID`, `SOPInstanceUID`, and `MediaStorageSOPInstanceUID`](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html).
        """
        if clean_descriptors is not None:
            pulumi.set(__self__, "clean_descriptors", clean_descriptors)
        if clean_image is not None:
            pulumi.set(__self__, "clean_image", clean_image)
        if primary_ids is not None:
            pulumi.set(__self__, "primary_ids", primary_ids)

    @property
    @pulumi.getter(name="cleanDescriptors")
    def clean_descriptors(self) -> Optional[pulumi.Input['CleanDescriptorsOptionArgs']]:
        """
        Set Clean Descriptors Option.
        """
        return pulumi.get(self, "clean_descriptors")

    @clean_descriptors.setter
    def clean_descriptors(self, value: Optional[pulumi.Input['CleanDescriptorsOptionArgs']]):
        pulumi.set(self, "clean_descriptors", value)

    @property
    @pulumi.getter(name="cleanImage")
    def clean_image(self) -> Optional[pulumi.Input['ImageConfigArgs']]:
        """
        Apply `Action.clean_image` to [`PixelData`](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html) as configured.
        """
        return pulumi.get(self, "clean_image")

    @clean_image.setter
    def clean_image(self, value: Optional[pulumi.Input['ImageConfigArgs']]):
        pulumi.set(self, "clean_image", value)

    @property
    @pulumi.getter(name="primaryIds")
    def primary_ids(self) -> Optional[pulumi.Input['OptionsPrimaryIds']]:
        """
        Set `Action` for [`StudyInstanceUID`, `SeriesInstanceUID`, `SOPInstanceUID`, and `MediaStorageSOPInstanceUID`](http://dicom.nema.org/medical/dicom/2018e/output/chtml/part06/chapter_6.html).
        """
        return pulumi.get(self, "primary_ids")

    @primary_ids.setter
    def primary_ids(self, value: Optional[pulumi.Input['OptionsPrimaryIds']]):
        pulumi.set(self, "primary_ids", value)


@pulumi.input_type
class ParserConfigArgs:
    def __init__(__self__, *,
                 allow_null_header: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input['SchemaPackageArgs']] = None,
                 segment_terminator: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['ParserConfigVersion']] = None):
        """
        The configuration for the parser. It determines how the server parses the messages.
        :param pulumi.Input[bool] allow_null_header: Determines whether messages with no header are allowed.
        :param pulumi.Input['SchemaPackageArgs'] schema: Schemas used to parse messages in this store, if schematized parsing is desired.
        :param pulumi.Input[str] segment_terminator: Byte(s) to use as the segment terminator. If this is unset, '\\r' is used as segment terminator, matching the HL7 version 2 specification.
        :param pulumi.Input['ParserConfigVersion'] version: Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        if allow_null_header is not None:
            pulumi.set(__self__, "allow_null_header", allow_null_header)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="allowNullHeader")
    def allow_null_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether messages with no header are allowed.
        """
        return pulumi.get(self, "allow_null_header")

    @allow_null_header.setter
    def allow_null_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_null_header", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['SchemaPackageArgs']]:
        """
        Schemas used to parse messages in this store, if schematized parsing is desired.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['SchemaPackageArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[pulumi.Input[str]]:
        """
        Byte(s) to use as the segment terminator. If this is unset, '\\r' is used as segment terminator, matching the HL7 version 2 specification.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['ParserConfigVersion']]:
        """
        Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['ParserConfigVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PatientIdArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A patient identifier and associated type.
        :param pulumi.Input[str] type: ID type. For example, MRN or NHS.
        :param pulumi.Input[str] value: The patient's unique identifier.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        ID type. For example, MRN or NHS.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The patient's unique identifier.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RecurseTagArgs:
    def __init__(__self__):
        """
        Recursively apply DICOM de-id to tags nested in a sequence. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): SQ
        """
        pass


@pulumi.input_type
class RedactConfigArgs:
    def __init__(__self__):
        """
        Define how to redact sensitive values. Default behaviour is erase. For example, "My name is Jane." becomes "My name is ."
        """
        pass


@pulumi.input_type
class RegenUidTagArgs:
    def __init__(__self__):
        """
        Replace UID with a new generated UID. Supported [Value Representation] (http://dicom.nema.org/medical/dicom/2018e/output/chtml/part05/sect_6.2.html#table_6.2-1): UI
        """
        pass


@pulumi.input_type
class RemoveFieldArgs:
    def __init__(__self__):
        """
        Remove field.
        """
        pass


@pulumi.input_type
class RemoveTagArgs:
    def __init__(__self__):
        """
        Replace with empty tag.
        """
        pass


@pulumi.input_type
class ReplaceWithInfoTypeConfigArgs:
    def __init__(__self__):
        """
        When using the INSPECT_AND_TRANSFORM action, each match is replaced with the name of the info_type. For example, "My name is Jane" becomes "My name is [PERSON_NAME]." The TRANSFORM action is equivalent to redacting.
        """
        pass


@pulumi.input_type
class ResetTagArgs:
    def __init__(__self__):
        """
        Reset tag to a placeholder value.
        """
        pass


@pulumi.input_type
class ResourceAnnotationArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None):
        """
        Resource level annotation.
        :param pulumi.Input[str] label: A description of the annotation record.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the annotation record.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class SchemaConfigArgs:
    def __init__(__self__, *,
                 last_updated_partition_config: Optional[pulumi.Input['TimePartitioningArgs']] = None,
                 recursive_structure_depth: Optional[pulumi.Input[str]] = None,
                 schema_type: Optional[pulumi.Input['SchemaConfigSchemaType']] = None):
        """
        Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
        :param pulumi.Input['TimePartitioningArgs'] last_updated_partition_config: The configuration for exported BigQuery tables to be partitioned by FHIR resource's last updated time column.
        :param pulumi.Input[str] recursive_structure_depth: The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        :param pulumi.Input['SchemaConfigSchemaType'] schema_type: Specifies the output schema type. Schema type is required.
        """
        if last_updated_partition_config is not None:
            pulumi.set(__self__, "last_updated_partition_config", last_updated_partition_config)
        if recursive_structure_depth is not None:
            pulumi.set(__self__, "recursive_structure_depth", recursive_structure_depth)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="lastUpdatedPartitionConfig")
    def last_updated_partition_config(self) -> Optional[pulumi.Input['TimePartitioningArgs']]:
        """
        The configuration for exported BigQuery tables to be partitioned by FHIR resource's last updated time column.
        """
        return pulumi.get(self, "last_updated_partition_config")

    @last_updated_partition_config.setter
    def last_updated_partition_config(self, value: Optional[pulumi.Input['TimePartitioningArgs']]):
        pulumi.set(self, "last_updated_partition_config", value)

    @property
    @pulumi.getter(name="recursiveStructureDepth")
    def recursive_structure_depth(self) -> Optional[pulumi.Input[str]]:
        """
        The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        """
        return pulumi.get(self, "recursive_structure_depth")

    @recursive_structure_depth.setter
    def recursive_structure_depth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recursive_structure_depth", value)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[pulumi.Input['SchemaConfigSchemaType']]:
        """
        Specifies the output schema type. Schema type is required.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: Optional[pulumi.Input['SchemaConfigSchemaType']]):
        pulumi.set(self, "schema_type", value)


@pulumi.input_type
class SchemaPackageArgs:
    def __init__(__self__, *,
                 ignore_min_occurs: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]] = None,
                 schematized_parsing_type: Optional[pulumi.Input['SchemaPackageSchematizedParsingType']] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]] = None,
                 unexpected_segment_handling: Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']] = None):
        """
        A schema package contains a set of schemas and type definitions.
        :param pulumi.Input[bool] ignore_min_occurs: Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        :param pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]] schemas: Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        :param pulumi.Input['SchemaPackageSchematizedParsingType'] schematized_parsing_type: Determines how messages that fail to parse are handled.
        :param pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]] types: Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        :param pulumi.Input['SchemaPackageUnexpectedSegmentHandling'] unexpected_segment_handling: Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        if ignore_min_occurs is not None:
            pulumi.set(__self__, "ignore_min_occurs", ignore_min_occurs)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if schematized_parsing_type is not None:
            pulumi.set(__self__, "schematized_parsing_type", schematized_parsing_type)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if unexpected_segment_handling is not None:
            pulumi.set(__self__, "unexpected_segment_handling", unexpected_segment_handling)

    @property
    @pulumi.getter(name="ignoreMinOccurs")
    def ignore_min_occurs(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        """
        return pulumi.get(self, "ignore_min_occurs")

    @ignore_min_occurs.setter
    def ignore_min_occurs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_min_occurs", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]]:
        """
        Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="schematizedParsingType")
    def schematized_parsing_type(self) -> Optional[pulumi.Input['SchemaPackageSchematizedParsingType']]:
        """
        Determines how messages that fail to parse are handled.
        """
        return pulumi.get(self, "schematized_parsing_type")

    @schematized_parsing_type.setter
    def schematized_parsing_type(self, value: Optional[pulumi.Input['SchemaPackageSchematizedParsingType']]):
        pulumi.set(self, "schematized_parsing_type", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]]:
        """
        Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]]):
        pulumi.set(self, "types", value)

    @property
    @pulumi.getter(name="unexpectedSegmentHandling")
    def unexpected_segment_handling(self) -> Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']]:
        """
        Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        return pulumi.get(self, "unexpected_segment_handling")

    @unexpected_segment_handling.setter
    def unexpected_segment_handling(self, value: Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']]):
        pulumi.set(self, "unexpected_segment_handling", value)


@pulumi.input_type
class SchematizedDataArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input[str]] = None):
        """
        The content of an HL7v2 message in a structured format as specified by a schema.
        :param pulumi.Input[str] data: JSON output of the parser.
        :param pulumi.Input[str] error: The error output of the parser.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        JSON output of the parser.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        The error output of the parser.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)


@pulumi.input_type
class SearchConfigArgs:
    def __init__(__self__, *,
                 search_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['SearchParameterArgs']]]] = None):
        """
        Contains the configuration for FHIR search.
        :param pulumi.Input[Sequence[pulumi.Input['SearchParameterArgs']]] search_parameters: A list of search parameters in this FHIR store that are used to configure this FHIR store.
        """
        if search_parameters is not None:
            pulumi.set(__self__, "search_parameters", search_parameters)

    @property
    @pulumi.getter(name="searchParameters")
    def search_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchParameterArgs']]]]:
        """
        A list of search parameters in this FHIR store that are used to configure this FHIR store.
        """
        return pulumi.get(self, "search_parameters")

    @search_parameters.setter
    def search_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchParameterArgs']]]]):
        pulumi.set(self, "search_parameters", value)


@pulumi.input_type
class SearchParameterArgs:
    def __init__(__self__, *,
                 canonical_url: Optional[pulumi.Input[str]] = None,
                 parameter: Optional[pulumi.Input[str]] = None):
        """
        Contains the versioned name and the URL for one SearchParameter.
        :param pulumi.Input[str] canonical_url: The canonical url of the search parameter resource.
        :param pulumi.Input[str] parameter: The versioned name of the search parameter resource. The format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/_history/{version-id} For fhir stores with disable_resource_versioning=true, the format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/
        """
        if canonical_url is not None:
            pulumi.set(__self__, "canonical_url", canonical_url)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical url of the search parameter resource.
        """
        return pulumi.get(self, "canonical_url")

    @canonical_url.setter
    def canonical_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_url", value)

    @property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input[str]]:
        """
        The versioned name of the search parameter resource. The format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/_history/{version-id} For fhir stores with disable_resource_versioning=true, the format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter", value)


@pulumi.input_type
class SensitiveTextAnnotationArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A TextAnnotation specifies a text range that includes sensitive information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] details: Maps from a resource slice. For example, FHIR resource field path to a set of sensitive text findings. For example, Appointment.Narrative text1 --> {findings_1, findings_2, findings_3}
        """
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Maps from a resource slice. For example, FHIR resource field path to a set of sensitive text findings. For example, Appointment.Narrative text1 --> {findings_1, findings_2, findings_3}
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "details", value)


@pulumi.input_type
class SignatureArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[str],
                 image: Optional[pulumi.Input['ImageArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 signature_time: Optional[pulumi.Input[str]] = None):
        """
        User signature.
        :param pulumi.Input[str] user_id: User's UUID provided by the client.
        :param pulumi.Input['ImageArgs'] image: Optional. An image of the user's signature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        :param pulumi.Input[str] signature_time: Optional. Timestamp of the signature.
        """
        pulumi.set(__self__, "user_id", user_id)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if signature_time is not None:
            pulumi.set(__self__, "signature_time", signature_time)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageArgs']]:
        """
        Optional. An image of the user's signature.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="signatureTime")
    def signature_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Timestamp of the signature.
        """
        return pulumi.get(self, "signature_time")

    @signature_time.setter
    def signature_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_time", value)


@pulumi.input_type
class StreamConfigArgs:
    def __init__(__self__, *,
                 bigquery_destination: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs']] = None,
                 deidentified_store_destination: Optional[pulumi.Input['DeidentifiedStoreDestinationArgs']] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains configuration for streaming FHIR export.
        :param pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs'] bigquery_destination: The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data will not be streamed. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param pulumi.Input['DeidentifiedStoreDestinationArgs'] deidentified_store_destination: The destination FHIR store for de-identified resources. After this field is added, all subsequent creates/updates/patches to the source store will be de-identified using the provided configuration and applied to the destination store. Importing resources to the source store will not trigger the streaming. If the source store already contains resources when this option is enabled, those resources will not be copied to the destination store unless they are subsequently updated. This may result in invalid references in the destination store. Before adding this config, you must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set enable_update_create to true. The destination store must have disable_referential_integrity set to true. If a resource cannot be de-identified, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        if bigquery_destination is not None:
            pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if deidentified_store_destination is not None:
            pulumi.set(__self__, "deidentified_store_destination", deidentified_store_destination)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs']]:
        """
        The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data will not be streamed. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")

    @bigquery_destination.setter
    def bigquery_destination(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1beta1FhirBigQueryDestinationArgs']]):
        pulumi.set(self, "bigquery_destination", value)

    @property
    @pulumi.getter(name="deidentifiedStoreDestination")
    def deidentified_store_destination(self) -> Optional[pulumi.Input['DeidentifiedStoreDestinationArgs']]:
        """
        The destination FHIR store for de-identified resources. After this field is added, all subsequent creates/updates/patches to the source store will be de-identified using the provided configuration and applied to the destination store. Importing resources to the source store will not trigger the streaming. If the source store already contains resources when this option is enabled, those resources will not be copied to the destination store unless they are subsequently updated. This may result in invalid references in the destination store. Before adding this config, you must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set enable_update_create to true. The destination store must have disable_referential_integrity set to true. If a resource cannot be de-identified, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "deidentified_store_destination")

    @deidentified_store_destination.setter
    def deidentified_store_destination(self, value: Optional[pulumi.Input['DeidentifiedStoreDestinationArgs']]):
        pulumi.set(self, "deidentified_store_destination", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types", value)


@pulumi.input_type
class TagFilterListArgs:
    def __init__(__self__, *,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        List of tags to be filtered.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory Structuring Elements, as defined at: http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be provided by "Keyword" or "Tag". For example, "PatientID", "00100010".
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory Structuring Elements, as defined at: http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be provided by "Keyword" or "Tag". For example, "PatientID", "00100010".
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class TextConfigArgs:
    def __init__(__self__, *,
                 additional_transformations: Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]] = None,
                 exclude_info_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_type: Optional[pulumi.Input['TextConfigProfileType']] = None,
                 transformations: Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]] = None):
        """
        Configures how to transform sensitive text `InfoTypes`.
        :param pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]] additional_transformations: Additional transformations to apply to the detected data, overriding `profile`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_info_types: InfoTypes to skip transforming, overriding `profile`.
        :param pulumi.Input['TextConfigProfileType'] profile_type: Base profile type for text transformation.
        :param pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]] transformations: The transformations to apply to the detected data. Deprecated. Use `additional_transformations` instead.
        """
        if additional_transformations is not None:
            pulumi.set(__self__, "additional_transformations", additional_transformations)
        if exclude_info_types is not None:
            pulumi.set(__self__, "exclude_info_types", exclude_info_types)
        if profile_type is not None:
            pulumi.set(__self__, "profile_type", profile_type)
        if transformations is not None:
            warnings.warn("""The transformations to apply to the detected data. Deprecated. Use `additional_transformations` instead.""", DeprecationWarning)
            pulumi.log.warn("""transformations is deprecated: The transformations to apply to the detected data. Deprecated. Use `additional_transformations` instead.""")
        if transformations is not None:
            pulumi.set(__self__, "transformations", transformations)

    @property
    @pulumi.getter(name="additionalTransformations")
    def additional_transformations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]]:
        """
        Additional transformations to apply to the detected data, overriding `profile`.
        """
        return pulumi.get(self, "additional_transformations")

    @additional_transformations.setter
    def additional_transformations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]]):
        pulumi.set(self, "additional_transformations", value)

    @property
    @pulumi.getter(name="excludeInfoTypes")
    def exclude_info_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        InfoTypes to skip transforming, overriding `profile`.
        """
        return pulumi.get(self, "exclude_info_types")

    @exclude_info_types.setter
    def exclude_info_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_info_types", value)

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[pulumi.Input['TextConfigProfileType']]:
        """
        Base profile type for text transformation.
        """
        return pulumi.get(self, "profile_type")

    @profile_type.setter
    def profile_type(self, value: Optional[pulumi.Input['TextConfigProfileType']]):
        pulumi.set(self, "profile_type", value)

    @property
    @pulumi.getter
    def transformations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]]:
        """
        The transformations to apply to the detected data. Deprecated. Use `additional_transformations` instead.
        """
        return pulumi.get(self, "transformations")

    @transformations.setter
    def transformations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfoTypeTransformationArgs']]]]):
        pulumi.set(self, "transformations", value)


@pulumi.input_type
class TimePartitioningArgs:
    def __init__(__self__, *,
                 expiration_ms: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['TimePartitioningType']] = None):
        """
        Configuration for FHIR BigQuery time-partitioned tables.
        :param pulumi.Input[str] expiration_ms: Number of milliseconds for which to keep the storage for a partition.
        :param pulumi.Input['TimePartitioningType'] type: Type of partitioning.
        """
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[pulumi.Input[str]]:
        """
        Number of milliseconds for which to keep the storage for a partition.
        """
        return pulumi.get(self, "expiration_ms")

    @expiration_ms.setter
    def expiration_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_ms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['TimePartitioningType']]:
        """
        Type of partitioning.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['TimePartitioningType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primitive: Optional[pulumi.Input['TypePrimitive']] = None):
        """
        A type definition for some HL7v2 type (incl. Segments and Datatypes).
        :param pulumi.Input[Sequence[pulumi.Input['FieldArgs']]] fields: The (sub) fields this type has (if not primitive).
        :param pulumi.Input[str] name: The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        :param pulumi.Input['TypePrimitive'] primitive: If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primitive is not None:
            pulumi.set(__self__, "primitive", primitive)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]:
        """
        The (sub) fields this type has (if not primitive).
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primitive(self) -> Optional[pulumi.Input['TypePrimitive']]:
        """
        If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        return pulumi.get(self, "primitive")

    @primitive.setter
    def primitive(self, value: Optional[pulumi.Input['TypePrimitive']]):
        pulumi.set(self, "primitive", value)


@pulumi.input_type
class ValidationConfigArgs:
    def __init__(__self__, *,
                 disable_fhirpath_validation: Optional[pulumi.Input[bool]] = None,
                 disable_profile_validation: Optional[pulumi.Input[bool]] = None,
                 disable_reference_type_validation: Optional[pulumi.Input[bool]] = None,
                 disable_required_field_validation: Optional[pulumi.Input[bool]] = None,
                 enabled_implementation_guides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains the configuration for FHIR profiles and validation.
        :param pulumi.Input[bool] disable_fhirpath_validation: Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[bool] disable_profile_validation: Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against StructureDefinitions in this FHIR store.
        :param pulumi.Input[bool] disable_reference_type_validation: Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[bool] disable_required_field_validation: Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_implementation_guides: A list of ImplementationGuide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        if disable_fhirpath_validation is not None:
            pulumi.set(__self__, "disable_fhirpath_validation", disable_fhirpath_validation)
        if disable_profile_validation is not None:
            pulumi.set(__self__, "disable_profile_validation", disable_profile_validation)
        if disable_reference_type_validation is not None:
            pulumi.set(__self__, "disable_reference_type_validation", disable_reference_type_validation)
        if disable_required_field_validation is not None:
            pulumi.set(__self__, "disable_required_field_validation", disable_required_field_validation)
        if enabled_implementation_guides is not None:
            pulumi.set(__self__, "enabled_implementation_guides", enabled_implementation_guides)

    @property
    @pulumi.getter(name="disableFhirpathValidation")
    def disable_fhirpath_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_fhirpath_validation")

    @disable_fhirpath_validation.setter
    def disable_fhirpath_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_fhirpath_validation", value)

    @property
    @pulumi.getter(name="disableProfileValidation")
    def disable_profile_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against StructureDefinitions in this FHIR store.
        """
        return pulumi.get(self, "disable_profile_validation")

    @disable_profile_validation.setter
    def disable_profile_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_profile_validation", value)

    @property
    @pulumi.getter(name="disableReferenceTypeValidation")
    def disable_reference_type_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_reference_type_validation")

    @disable_reference_type_validation.setter
    def disable_reference_type_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_reference_type_validation", value)

    @property
    @pulumi.getter(name="disableRequiredFieldValidation")
    def disable_required_field_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_required_field_validation")

    @disable_required_field_validation.setter
    def disable_required_field_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_required_field_validation", value)

    @property
    @pulumi.getter(name="enabledImplementationGuides")
    def enabled_implementation_guides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ImplementationGuide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        return pulumi.get(self, "enabled_implementation_guides")

    @enabled_implementation_guides.setter
    def enabled_implementation_guides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_implementation_guides", value)


@pulumi.input_type
class VersionSourceArgs:
    def __init__(__self__, *,
                 msh_field: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes a selector for extracting and matching an MSH field to a value.
        :param pulumi.Input[str] msh_field: The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        :param pulumi.Input[str] value: The value to match with the field. For example, "My Application Name" or "2.3".
        """
        if msh_field is not None:
            pulumi.set(__self__, "msh_field", msh_field)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="mshField")
    def msh_field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        """
        return pulumi.get(self, "msh_field")

    @msh_field.setter
    def msh_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msh_field", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to match with the field. For example, "My Application Name" or "2.3".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VertexArgs:
    def __init__(__self__, *,
                 x: Optional[pulumi.Input[float]] = None,
                 y: Optional[pulumi.Input[float]] = None):
        """
        A 2D coordinate in an image. The origin is the top-left.
        :param pulumi.Input[float] x: X coordinate.
        :param pulumi.Input[float] y: Y coordinate.
        """
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> Optional[pulumi.Input[float]]:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> Optional[pulumi.Input[float]]:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "y", value)


