# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AnthosObservabilityFeatureSpecArgs',
    'AnthosObservabilityMembershipSpecArgs',
    'AppDevExperienceFeatureSpecArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'CommonFeatureSpecArgs',
    'CommonFleetDefaultMemberConfigSpecArgs',
    'ExprArgs',
    'FleetObservabilityFeatureSpecArgs',
    'IdentityServiceAuthMethodArgs',
    'IdentityServiceAzureADConfigArgs',
    'IdentityServiceGoogleConfigArgs',
    'IdentityServiceMembershipSpecArgs',
    'IdentityServiceOidcConfigArgs',
    'MultiClusterIngressFeatureSpecArgs',
]

@pulumi.input_type
class AnthosObservabilityFeatureSpecArgs:
    def __init__(__self__, *,
                 default_membership_spec: Optional[pulumi.Input['AnthosObservabilityMembershipSpecArgs']] = None):
        """
        **Anthos Observability**: Spec
        :param pulumi.Input['AnthosObservabilityMembershipSpecArgs'] default_membership_spec: Default membership spec for unconfigured memberships
        """
        if default_membership_spec is not None:
            pulumi.set(__self__, "default_membership_spec", default_membership_spec)

    @property
    @pulumi.getter(name="defaultMembershipSpec")
    def default_membership_spec(self) -> Optional[pulumi.Input['AnthosObservabilityMembershipSpecArgs']]:
        """
        Default membership spec for unconfigured memberships
        """
        return pulumi.get(self, "default_membership_spec")

    @default_membership_spec.setter
    def default_membership_spec(self, value: Optional[pulumi.Input['AnthosObservabilityMembershipSpecArgs']]):
        pulumi.set(self, "default_membership_spec", value)


@pulumi.input_type
class AnthosObservabilityMembershipSpecArgs:
    def __init__(__self__, *,
                 do_not_optimize_metrics: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_on_applications: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        **Anthosobservability**: Per-Membership Feature spec.
        :param pulumi.Input[bool] do_not_optimize_metrics: Use full of metrics rather than optimized metrics. See https://cloud.google.com/anthos/clusters/docs/on-prem/1.8/concepts/logging-and-monitoring#optimized_metrics_default_metrics
        :param pulumi.Input[bool] enable_stackdriver_on_applications: Enable collecting and reporting metrics and logs from user apps.
        :param pulumi.Input[str] version: the version of stackdriver operator used by this feature
        """
        if do_not_optimize_metrics is not None:
            pulumi.set(__self__, "do_not_optimize_metrics", do_not_optimize_metrics)
        if enable_stackdriver_on_applications is not None:
            pulumi.set(__self__, "enable_stackdriver_on_applications", enable_stackdriver_on_applications)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="doNotOptimizeMetrics")
    def do_not_optimize_metrics(self) -> Optional[pulumi.Input[bool]]:
        """
        Use full of metrics rather than optimized metrics. See https://cloud.google.com/anthos/clusters/docs/on-prem/1.8/concepts/logging-and-monitoring#optimized_metrics_default_metrics
        """
        return pulumi.get(self, "do_not_optimize_metrics")

    @do_not_optimize_metrics.setter
    def do_not_optimize_metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "do_not_optimize_metrics", value)

    @property
    @pulumi.getter(name="enableStackdriverOnApplications")
    def enable_stackdriver_on_applications(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable collecting and reporting metrics and logs from user apps.
        """
        return pulumi.get(self, "enable_stackdriver_on_applications")

    @enable_stackdriver_on_applications.setter
    def enable_stackdriver_on_applications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_on_applications", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        the version of stackdriver operator used by this feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class AppDevExperienceFeatureSpecArgs:
    def __init__(__self__):
        """
        Spec for App Dev Experience Feature.
        """
        pass


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CommonFeatureSpecArgs:
    def __init__(__self__, *,
                 anthosobservability: Optional[pulumi.Input['AnthosObservabilityFeatureSpecArgs']] = None,
                 appdevexperience: Optional[pulumi.Input['AppDevExperienceFeatureSpecArgs']] = None,
                 fleetobservability: Optional[pulumi.Input['FleetObservabilityFeatureSpecArgs']] = None,
                 multiclusteringress: Optional[pulumi.Input['MultiClusterIngressFeatureSpecArgs']] = None):
        """
        CommonFeatureSpec contains Hub-wide configuration information
        :param pulumi.Input['AnthosObservabilityFeatureSpecArgs'] anthosobservability: Anthos Observability spec
        :param pulumi.Input['AppDevExperienceFeatureSpecArgs'] appdevexperience: Appdevexperience specific spec.
        :param pulumi.Input['FleetObservabilityFeatureSpecArgs'] fleetobservability: FleetObservability feature spec.
        :param pulumi.Input['MultiClusterIngressFeatureSpecArgs'] multiclusteringress: Multicluster Ingress-specific spec.
        """
        if anthosobservability is not None:
            pulumi.set(__self__, "anthosobservability", anthosobservability)
        if appdevexperience is not None:
            pulumi.set(__self__, "appdevexperience", appdevexperience)
        if fleetobservability is not None:
            pulumi.set(__self__, "fleetobservability", fleetobservability)
        if multiclusteringress is not None:
            pulumi.set(__self__, "multiclusteringress", multiclusteringress)

    @property
    @pulumi.getter
    def anthosobservability(self) -> Optional[pulumi.Input['AnthosObservabilityFeatureSpecArgs']]:
        """
        Anthos Observability spec
        """
        return pulumi.get(self, "anthosobservability")

    @anthosobservability.setter
    def anthosobservability(self, value: Optional[pulumi.Input['AnthosObservabilityFeatureSpecArgs']]):
        pulumi.set(self, "anthosobservability", value)

    @property
    @pulumi.getter
    def appdevexperience(self) -> Optional[pulumi.Input['AppDevExperienceFeatureSpecArgs']]:
        """
        Appdevexperience specific spec.
        """
        return pulumi.get(self, "appdevexperience")

    @appdevexperience.setter
    def appdevexperience(self, value: Optional[pulumi.Input['AppDevExperienceFeatureSpecArgs']]):
        pulumi.set(self, "appdevexperience", value)

    @property
    @pulumi.getter
    def fleetobservability(self) -> Optional[pulumi.Input['FleetObservabilityFeatureSpecArgs']]:
        """
        FleetObservability feature spec.
        """
        return pulumi.get(self, "fleetobservability")

    @fleetobservability.setter
    def fleetobservability(self, value: Optional[pulumi.Input['FleetObservabilityFeatureSpecArgs']]):
        pulumi.set(self, "fleetobservability", value)

    @property
    @pulumi.getter
    def multiclusteringress(self) -> Optional[pulumi.Input['MultiClusterIngressFeatureSpecArgs']]:
        """
        Multicluster Ingress-specific spec.
        """
        return pulumi.get(self, "multiclusteringress")

    @multiclusteringress.setter
    def multiclusteringress(self, value: Optional[pulumi.Input['MultiClusterIngressFeatureSpecArgs']]):
        pulumi.set(self, "multiclusteringress", value)


@pulumi.input_type
class CommonFleetDefaultMemberConfigSpecArgs:
    def __init__(__self__, *,
                 identityservice: Optional[pulumi.Input['IdentityServiceMembershipSpecArgs']] = None):
        """
        CommonFleetDefaultMemberConfigSpec contains default configuration information for memberships of a fleet
        :param pulumi.Input['IdentityServiceMembershipSpecArgs'] identityservice: Identity Service-specific spec.
        """
        if identityservice is not None:
            pulumi.set(__self__, "identityservice", identityservice)

    @property
    @pulumi.getter
    def identityservice(self) -> Optional[pulumi.Input['IdentityServiceMembershipSpecArgs']]:
        """
        Identity Service-specific spec.
        """
        return pulumi.get(self, "identityservice")

    @identityservice.setter
    def identityservice(self, value: Optional[pulumi.Input['IdentityServiceMembershipSpecArgs']]):
        pulumi.set(self, "identityservice", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FleetObservabilityFeatureSpecArgs:
    def __init__(__self__):
        """
        **Fleet Observability**: The Hub-wide input for the FleetObservability feature.
        """
        pass


@pulumi.input_type
class IdentityServiceAuthMethodArgs:
    def __init__(__self__, *,
                 azuread_config: Optional[pulumi.Input['IdentityServiceAzureADConfigArgs']] = None,
                 google_config: Optional[pulumi.Input['IdentityServiceGoogleConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oidc_config: Optional[pulumi.Input['IdentityServiceOidcConfigArgs']] = None,
                 proxy: Optional[pulumi.Input[str]] = None):
        """
        Configuration of an auth method for a member/cluster. Only one authentication method (e.g., OIDC and LDAP) can be set per AuthMethod.
        :param pulumi.Input['IdentityServiceAzureADConfigArgs'] azuread_config: AzureAD specific Configuration.
        :param pulumi.Input['IdentityServiceGoogleConfigArgs'] google_config: GoogleConfig specific configuration
        :param pulumi.Input[str] name: Identifier for auth config.
        :param pulumi.Input['IdentityServiceOidcConfigArgs'] oidc_config: OIDC specific configuration.
        :param pulumi.Input[str] proxy: Proxy server address to use for auth method.
        """
        if azuread_config is not None:
            pulumi.set(__self__, "azuread_config", azuread_config)
        if google_config is not None:
            pulumi.set(__self__, "google_config", google_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_config is not None:
            pulumi.set(__self__, "oidc_config", oidc_config)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)

    @property
    @pulumi.getter(name="azureadConfig")
    def azuread_config(self) -> Optional[pulumi.Input['IdentityServiceAzureADConfigArgs']]:
        """
        AzureAD specific Configuration.
        """
        return pulumi.get(self, "azuread_config")

    @azuread_config.setter
    def azuread_config(self, value: Optional[pulumi.Input['IdentityServiceAzureADConfigArgs']]):
        pulumi.set(self, "azuread_config", value)

    @property
    @pulumi.getter(name="googleConfig")
    def google_config(self) -> Optional[pulumi.Input['IdentityServiceGoogleConfigArgs']]:
        """
        GoogleConfig specific configuration
        """
        return pulumi.get(self, "google_config")

    @google_config.setter
    def google_config(self, value: Optional[pulumi.Input['IdentityServiceGoogleConfigArgs']]):
        pulumi.set(self, "google_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for auth config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oidcConfig")
    def oidc_config(self) -> Optional[pulumi.Input['IdentityServiceOidcConfigArgs']]:
        """
        OIDC specific configuration.
        """
        return pulumi.get(self, "oidc_config")

    @oidc_config.setter
    def oidc_config(self, value: Optional[pulumi.Input['IdentityServiceOidcConfigArgs']]):
        pulumi.set(self, "oidc_config", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy server address to use for auth method.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy", value)


@pulumi.input_type
class IdentityServiceAzureADConfigArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 kubectl_redirect_uri: Optional[pulumi.Input[str]] = None,
                 tenant: Optional[pulumi.Input[str]] = None):
        """
        Configuration for the AzureAD Auth flow.
        :param pulumi.Input[str] client_id: ID for the registered client application that makes authentication requests to the Azure AD identity provider.
        :param pulumi.Input[str] client_secret: Input only. Unencrypted AzureAD client secret will be passed to the GKE Hub CLH.
        :param pulumi.Input[str] kubectl_redirect_uri: The redirect URL that kubectl uses for authorization.
        :param pulumi.Input[str] tenant: Kind of Azure AD account to be authenticated. Supported values are or for accounts belonging to a specific tenant.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if kubectl_redirect_uri is not None:
            pulumi.set(__self__, "kubectl_redirect_uri", kubectl_redirect_uri)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID for the registered client application that makes authentication requests to the Azure AD identity provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Unencrypted AzureAD client secret will be passed to the GKE Hub CLH.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="kubectlRedirectUri")
    def kubectl_redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect URL that kubectl uses for authorization.
        """
        return pulumi.get(self, "kubectl_redirect_uri")

    @kubectl_redirect_uri.setter
    def kubectl_redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubectl_redirect_uri", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of Azure AD account to be authenticated. Supported values are or for accounts belonging to a specific tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant", value)


@pulumi.input_type
class IdentityServiceGoogleConfigArgs:
    def __init__(__self__, *,
                 disable: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Google Plugin Auth flow.
        :param pulumi.Input[bool] disable: Disable automatic configuration of Google Plugin on supported platforms.
        """
        if disable is not None:
            pulumi.set(__self__, "disable", disable)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable automatic configuration of Google Plugin on supported platforms.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)


@pulumi.input_type
class IdentityServiceMembershipSpecArgs:
    def __init__(__self__, *,
                 auth_methods: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityServiceAuthMethodArgs']]]] = None):
        """
        **Anthos Identity Service**: Configuration for a single Membership.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityServiceAuthMethodArgs']]] auth_methods: A member may support multiple auth methods.
        """
        if auth_methods is not None:
            pulumi.set(__self__, "auth_methods", auth_methods)

    @property
    @pulumi.getter(name="authMethods")
    def auth_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityServiceAuthMethodArgs']]]]:
        """
        A member may support multiple auth methods.
        """
        return pulumi.get(self, "auth_methods")

    @auth_methods.setter
    def auth_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityServiceAuthMethodArgs']]]]):
        pulumi.set(self, "auth_methods", value)


@pulumi.input_type
class IdentityServiceOidcConfigArgs:
    def __init__(__self__, *,
                 certificate_authority_data: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 deploy_cloud_console_proxy: Optional[pulumi.Input[bool]] = None,
                 enable_access_token: Optional[pulumi.Input[bool]] = None,
                 extra_params: Optional[pulumi.Input[str]] = None,
                 group_prefix: Optional[pulumi.Input[str]] = None,
                 groups_claim: Optional[pulumi.Input[str]] = None,
                 issuer_uri: Optional[pulumi.Input[str]] = None,
                 kubectl_redirect_uri: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[str]] = None,
                 user_claim: Optional[pulumi.Input[str]] = None,
                 user_prefix: Optional[pulumi.Input[str]] = None):
        """
        Configuration for OIDC Auth flow.
        :param pulumi.Input[str] certificate_authority_data: PEM-encoded CA for OIDC provider.
        :param pulumi.Input[str] client_id: ID for OIDC client application.
        :param pulumi.Input[str] client_secret: Input only. Unencrypted OIDC client secret will be passed to the GKE Hub CLH.
        :param pulumi.Input[bool] deploy_cloud_console_proxy: Flag to denote if reverse proxy is used to connect to auth provider. This flag should be set to true when provider is not reachable by Google Cloud Console.
        :param pulumi.Input[bool] enable_access_token: Enable access token.
        :param pulumi.Input[str] extra_params: Comma-separated list of key-value pairs.
        :param pulumi.Input[str] group_prefix: Prefix to prepend to group name.
        :param pulumi.Input[str] groups_claim: Claim in OIDC ID token that holds group information.
        :param pulumi.Input[str] issuer_uri: URI for the OIDC provider. This should point to the level below .well-known/openid-configuration.
        :param pulumi.Input[str] kubectl_redirect_uri: Registered redirect uri to redirect users going through OAuth flow using kubectl plugin.
        :param pulumi.Input[str] scopes: Comma-separated list of identifiers.
        :param pulumi.Input[str] user_claim: Claim in OIDC ID token that holds username.
        :param pulumi.Input[str] user_prefix: Prefix to prepend to user name.
        """
        if certificate_authority_data is not None:
            pulumi.set(__self__, "certificate_authority_data", certificate_authority_data)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deploy_cloud_console_proxy is not None:
            pulumi.set(__self__, "deploy_cloud_console_proxy", deploy_cloud_console_proxy)
        if enable_access_token is not None:
            pulumi.set(__self__, "enable_access_token", enable_access_token)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if group_prefix is not None:
            pulumi.set(__self__, "group_prefix", group_prefix)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if kubectl_redirect_uri is not None:
            pulumi.set(__self__, "kubectl_redirect_uri", kubectl_redirect_uri)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if user_claim is not None:
            pulumi.set(__self__, "user_claim", user_claim)
        if user_prefix is not None:
            pulumi.set(__self__, "user_prefix", user_prefix)

    @property
    @pulumi.getter(name="certificateAuthorityData")
    def certificate_authority_data(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded CA for OIDC provider.
        """
        return pulumi.get(self, "certificate_authority_data")

    @certificate_authority_data.setter
    def certificate_authority_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority_data", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID for OIDC client application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Unencrypted OIDC client secret will be passed to the GKE Hub CLH.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="deployCloudConsoleProxy")
    def deploy_cloud_console_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to denote if reverse proxy is used to connect to auth provider. This flag should be set to true when provider is not reachable by Google Cloud Console.
        """
        return pulumi.get(self, "deploy_cloud_console_proxy")

    @deploy_cloud_console_proxy.setter
    def deploy_cloud_console_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_cloud_console_proxy", value)

    @property
    @pulumi.getter(name="enableAccessToken")
    def enable_access_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable access token.
        """
        return pulumi.get(self, "enable_access_token")

    @enable_access_token.setter
    def enable_access_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_token", value)

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of key-value pairs.
        """
        return pulumi.get(self, "extra_params")

    @extra_params.setter
    def extra_params(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_params", value)

    @property
    @pulumi.getter(name="groupPrefix")
    def group_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to prepend to group name.
        """
        return pulumi.get(self, "group_prefix")

    @group_prefix.setter
    def group_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_prefix", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[str]]:
        """
        Claim in OIDC ID token that holds group information.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for the OIDC provider. This should point to the level below .well-known/openid-configuration.
        """
        return pulumi.get(self, "issuer_uri")

    @issuer_uri.setter
    def issuer_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_uri", value)

    @property
    @pulumi.getter(name="kubectlRedirectUri")
    def kubectl_redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Registered redirect uri to redirect users going through OAuth flow using kubectl plugin.
        """
        return pulumi.get(self, "kubectl_redirect_uri")

    @kubectl_redirect_uri.setter
    def kubectl_redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubectl_redirect_uri", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of identifiers.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> Optional[pulumi.Input[str]]:
        """
        Claim in OIDC ID token that holds username.
        """
        return pulumi.get(self, "user_claim")

    @user_claim.setter
    def user_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_claim", value)

    @property
    @pulumi.getter(name="userPrefix")
    def user_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to prepend to user name.
        """
        return pulumi.get(self, "user_prefix")

    @user_prefix.setter
    def user_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_prefix", value)


@pulumi.input_type
class MultiClusterIngressFeatureSpecArgs:
    def __init__(__self__, *,
                 billing: Optional[pulumi.Input['MultiClusterIngressFeatureSpecBilling']] = None,
                 config_membership: Optional[pulumi.Input[str]] = None):
        """
        **Multi-cluster Ingress**: The configuration for the MultiClusterIngress feature.
        :param pulumi.Input['MultiClusterIngressFeatureSpecBilling'] billing: Deprecated: This field will be ignored and should not be set. Customer's billing structure.
        :param pulumi.Input[str] config_membership: Fully-qualified Membership name which hosts the MultiClusterIngress CRD. Example: `projects/foo-proj/locations/global/memberships/bar`
        """
        if billing is not None:
            warnings.warn("""Deprecated: This field will be ignored and should not be set. Customer's billing structure.""", DeprecationWarning)
            pulumi.log.warn("""billing is deprecated: Deprecated: This field will be ignored and should not be set. Customer's billing structure.""")
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if config_membership is not None:
            pulumi.set(__self__, "config_membership", config_membership)

    @property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['MultiClusterIngressFeatureSpecBilling']]:
        """
        Deprecated: This field will be ignored and should not be set. Customer's billing structure.
        """
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['MultiClusterIngressFeatureSpecBilling']]):
        pulumi.set(self, "billing", value)

    @property
    @pulumi.getter(name="configMembership")
    def config_membership(self) -> Optional[pulumi.Input[str]]:
        """
        Fully-qualified Membership name which hosts the MultiClusterIngress CRD. Example: `projects/foo-proj/locations/global/memberships/bar`
        """
        return pulumi.get(self, "config_membership")

    @config_membership.setter
    def config_membership(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_membership", value)


