# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BackupConfigArgs',
    'BindingArgs',
    'ClusterResourceRestoreScopeArgs',
    'EncryptionKeyArgs',
    'ExprArgs',
    'GroupKindArgs',
    'NamespacedNamesArgs',
    'NamespacedNameArgs',
    'NamespacesArgs',
    'RestoreConfigArgs',
    'RetentionPolicyArgs',
    'ScheduleArgs',
    'SubstitutionRuleArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BackupConfigArgs:
    def __init__(__self__, *,
                 all_namespaces: Optional[pulumi.Input[bool]] = None,
                 encryption_key: Optional[pulumi.Input['EncryptionKeyArgs']] = None,
                 include_secrets: Optional[pulumi.Input[bool]] = None,
                 include_volume_data: Optional[pulumi.Input[bool]] = None,
                 selected_applications: Optional[pulumi.Input['NamespacedNamesArgs']] = None,
                 selected_namespaces: Optional[pulumi.Input['NamespacesArgs']] = None):
        """
        BackupConfig defines the configuration of Backups created via this BackupPlan.
        :param pulumi.Input[bool] all_namespaces: If True, include all namespaced resources
        :param pulumi.Input['EncryptionKeyArgs'] encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config" portion (the Kubernetes resources) of Backups created via this plan. Default (empty): Config backup artifacts will not be encrypted.
        :param pulumi.Input[bool] include_secrets: This flag specifies whether Kubernetes Secret resources should be included when they fall into the scope of Backups. Default: False
        :param pulumi.Input[bool] include_volume_data: This flag specifies whether volume data should be backed up when PVCs are included in the scope of a Backup. Default: False
        :param pulumi.Input['NamespacedNamesArgs'] selected_applications: If set, include just the resources referenced by the listed ProtectedApplications.
        :param pulumi.Input['NamespacesArgs'] selected_namespaces: If set, include just the resources in the listed namespaces.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if include_secrets is not None:
            pulumi.set(__self__, "include_secrets", include_secrets)
        if include_volume_data is not None:
            pulumi.set(__self__, "include_volume_data", include_volume_data)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, include all namespaced resources
        """
        return pulumi.get(self, "all_namespaces")

    @all_namespaces.setter
    def all_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_namespaces", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['EncryptionKeyArgs']]:
        """
        This defines a customer managed encryption key that will be used to encrypt the "config" portion (the Kubernetes resources) of Backups created via this plan. Default (empty): Config backup artifacts will not be encrypted.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['EncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether Kubernetes Secret resources should be included when they fall into the scope of Backups. Default: False
        """
        return pulumi.get(self, "include_secrets")

    @include_secrets.setter
    def include_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_secrets", value)

    @property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether volume data should be backed up when PVCs are included in the scope of a Backup. Default: False
        """
        return pulumi.get(self, "include_volume_data")

    @include_volume_data.setter
    def include_volume_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_volume_data", value)

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional[pulumi.Input['NamespacedNamesArgs']]:
        """
        If set, include just the resources referenced by the listed ProtectedApplications.
        """
        return pulumi.get(self, "selected_applications")

    @selected_applications.setter
    def selected_applications(self, value: Optional[pulumi.Input['NamespacedNamesArgs']]):
        pulumi.set(self, "selected_applications", value)

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional[pulumi.Input['NamespacesArgs']]:
        """
        If set, include just the resources in the listed namespaces.
        """
        return pulumi.get(self, "selected_namespaces")

    @selected_namespaces.setter
    def selected_namespaces(self, value: Optional[pulumi.Input['NamespacesArgs']]):
        pulumi.set(self, "selected_namespaces", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ClusterResourceRestoreScopeArgs:
    def __init__(__self__, *,
                 selected_group_kinds: Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]] = None):
        """
        Identifies the cluster-scoped resources to restore from the Backup.
        :param pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]] selected_group_kinds: A list of "types" of cluster-scoped resources to be restored from the Backup. An empty list means that NO cluster-scoped resources will be restored. Note that Namespaces and PersistentVolume restoration is handled separately and is not governed by this field.
        """
        if selected_group_kinds is not None:
            pulumi.set(__self__, "selected_group_kinds", selected_group_kinds)

    @property
    @pulumi.getter(name="selectedGroupKinds")
    def selected_group_kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]]:
        """
        A list of "types" of cluster-scoped resources to be restored from the Backup. An empty list means that NO cluster-scoped resources will be restored. Note that Namespaces and PersistentVolume restoration is handled separately and is not governed by this field.
        """
        return pulumi.get(self, "selected_group_kinds")

    @selected_group_kinds.setter
    def selected_group_kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]]):
        pulumi.set(self, "selected_group_kinds", value)


@pulumi.input_type
class EncryptionKeyArgs:
    def __init__(__self__, *,
                 gcp_kms_encryption_key: Optional[pulumi.Input[str]] = None):
        """
        Defined a customer managed encryption key that will be used to encrypt Backup artifacts.
        :param pulumi.Input[str] gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: `projects/*/locations/*/keyRings/*/cryptoKeys/*`
        """
        if gcp_kms_encryption_key is not None:
            pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud KMS encryption key. Format: `projects/*/locations/*/keyRings/*/cryptoKeys/*`
        """
        return pulumi.get(self, "gcp_kms_encryption_key")

    @gcp_kms_encryption_key.setter
    def gcp_kms_encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_kms_encryption_key", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GroupKindArgs:
    def __init__(__self__, *,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_kind: Optional[pulumi.Input[str]] = None):
        """
        This is a direct map to the Kubernetes GroupKind type [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind) and is used for identifying specific "types" of resources to restore.
        :param pulumi.Input[str] resource_group: API group string of a Kubernetes resource, e.g. "apiextensions.k8s.io", "storage.k8s.io", etc. Note: use empty string for core API group
        :param pulumi.Input[str] resource_kind: Kind of a Kubernetes resource, e.g. "CustomResourceDefinition", "StorageClass", etc.
        """
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        API group string of a Kubernetes resource, e.g. "apiextensions.k8s.io", "storage.k8s.io", etc. Note: use empty string for core API group
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of a Kubernetes resource, e.g. "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)


@pulumi.input_type
class NamespacedNamesArgs:
    def __init__(__self__, *,
                 namespaced_names: Optional[pulumi.Input[Sequence[pulumi.Input['NamespacedNameArgs']]]] = None):
        """
        A list of namespaced Kubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['NamespacedNameArgs']]] namespaced_names: A list of namespaced Kubernetes resources.
        """
        if namespaced_names is not None:
            pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespacedNameArgs']]]]:
        """
        A list of namespaced Kubernetes resources.
        """
        return pulumi.get(self, "namespaced_names")

    @namespaced_names.setter
    def namespaced_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespacedNameArgs']]]]):
        pulumi.set(self, "namespaced_names", value)


@pulumi.input_type
class NamespacedNameArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        A reference to a namespaced resource in Kubernetes.
        :param pulumi.Input[str] name: The name of the Kubernetes resource.
        :param pulumi.Input[str] namespace: The Namespace of the Kubernetes resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Kubernetes resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Namespace of the Kubernetes resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class NamespacesArgs:
    def __init__(__self__, *,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A list of Kubernetes Namespaces
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: A list of Kubernetes Namespaces
        """
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Kubernetes Namespaces
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)


@pulumi.input_type
class RestoreConfigArgs:
    def __init__(__self__, *,
                 all_namespaces: Optional[pulumi.Input[bool]] = None,
                 cluster_resource_conflict_policy: Optional[pulumi.Input['RestoreConfigClusterResourceConflictPolicy']] = None,
                 cluster_resource_restore_scope: Optional[pulumi.Input['ClusterResourceRestoreScopeArgs']] = None,
                 namespaced_resource_restore_mode: Optional[pulumi.Input['RestoreConfigNamespacedResourceRestoreMode']] = None,
                 selected_applications: Optional[pulumi.Input['NamespacedNamesArgs']] = None,
                 selected_namespaces: Optional[pulumi.Input['NamespacesArgs']] = None,
                 substitution_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SubstitutionRuleArgs']]]] = None,
                 volume_data_restore_policy: Optional[pulumi.Input['RestoreConfigVolumeDataRestorePolicy']] = None):
        """
        Configuration of a restore. Next id: 9
        :param pulumi.Input[bool] all_namespaces: Restore all namespaced resources in the Backup if set to "True". Specifying this field to "False" is an error.
        :param pulumi.Input['RestoreConfigClusterResourceConflictPolicy'] cluster_resource_conflict_policy: Defines the behavior for handling the situation where cluster-scoped resources being restored already exist in the target cluster. This MUST be set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if cluster_resource_restore_scope is not empty.
        :param pulumi.Input['ClusterResourceRestoreScopeArgs'] cluster_resource_restore_scope: Identifies the cluster-scoped resources to restore from the Backup. Not specifying it means NO cluster resource will be restored.
        :param pulumi.Input['RestoreConfigNamespacedResourceRestoreMode'] namespaced_resource_restore_mode: Defines the behavior for handling the situation where sets of namespaced resources being restored already exist in the target cluster. This MUST be set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
        :param pulumi.Input['NamespacedNamesArgs'] selected_applications: A list of selected ProtectedApplications to restore. The listed ProtectedApplications and all the resources to which they refer will be restored.
        :param pulumi.Input['NamespacesArgs'] selected_namespaces: A list of selected Namespaces to restore from the Backup. The listed Namespaces and all resources contained in them will be restored.
        :param pulumi.Input[Sequence[pulumi.Input['SubstitutionRuleArgs']]] substitution_rules: A list of transformation rules to be applied against Kubernetes resources as they are selected for restoration from a Backup. Rules are executed in order defined - this order matters, as changes made by a rule may impact the filtering logic of subsequent rules. An empty list means no substitution will occur.
        :param pulumi.Input['RestoreConfigVolumeDataRestorePolicy'] volume_data_restore_policy: Specifies the mechanism to be used to restore volume data. Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as NO_VOLUME_DATA_RESTORATION).
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if cluster_resource_conflict_policy is not None:
            pulumi.set(__self__, "cluster_resource_conflict_policy", cluster_resource_conflict_policy)
        if cluster_resource_restore_scope is not None:
            pulumi.set(__self__, "cluster_resource_restore_scope", cluster_resource_restore_scope)
        if namespaced_resource_restore_mode is not None:
            pulumi.set(__self__, "namespaced_resource_restore_mode", namespaced_resource_restore_mode)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)
        if substitution_rules is not None:
            pulumi.set(__self__, "substitution_rules", substitution_rules)
        if volume_data_restore_policy is not None:
            pulumi.set(__self__, "volume_data_restore_policy", volume_data_restore_policy)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        Restore all namespaced resources in the Backup if set to "True". Specifying this field to "False" is an error.
        """
        return pulumi.get(self, "all_namespaces")

    @all_namespaces.setter
    def all_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_namespaces", value)

    @property
    @pulumi.getter(name="clusterResourceConflictPolicy")
    def cluster_resource_conflict_policy(self) -> Optional[pulumi.Input['RestoreConfigClusterResourceConflictPolicy']]:
        """
        Defines the behavior for handling the situation where cluster-scoped resources being restored already exist in the target cluster. This MUST be set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if cluster_resource_restore_scope is not empty.
        """
        return pulumi.get(self, "cluster_resource_conflict_policy")

    @cluster_resource_conflict_policy.setter
    def cluster_resource_conflict_policy(self, value: Optional[pulumi.Input['RestoreConfigClusterResourceConflictPolicy']]):
        pulumi.set(self, "cluster_resource_conflict_policy", value)

    @property
    @pulumi.getter(name="clusterResourceRestoreScope")
    def cluster_resource_restore_scope(self) -> Optional[pulumi.Input['ClusterResourceRestoreScopeArgs']]:
        """
        Identifies the cluster-scoped resources to restore from the Backup. Not specifying it means NO cluster resource will be restored.
        """
        return pulumi.get(self, "cluster_resource_restore_scope")

    @cluster_resource_restore_scope.setter
    def cluster_resource_restore_scope(self, value: Optional[pulumi.Input['ClusterResourceRestoreScopeArgs']]):
        pulumi.set(self, "cluster_resource_restore_scope", value)

    @property
    @pulumi.getter(name="namespacedResourceRestoreMode")
    def namespaced_resource_restore_mode(self) -> Optional[pulumi.Input['RestoreConfigNamespacedResourceRestoreMode']]:
        """
        Defines the behavior for handling the situation where sets of namespaced resources being restored already exist in the target cluster. This MUST be set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
        """
        return pulumi.get(self, "namespaced_resource_restore_mode")

    @namespaced_resource_restore_mode.setter
    def namespaced_resource_restore_mode(self, value: Optional[pulumi.Input['RestoreConfigNamespacedResourceRestoreMode']]):
        pulumi.set(self, "namespaced_resource_restore_mode", value)

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional[pulumi.Input['NamespacedNamesArgs']]:
        """
        A list of selected ProtectedApplications to restore. The listed ProtectedApplications and all the resources to which they refer will be restored.
        """
        return pulumi.get(self, "selected_applications")

    @selected_applications.setter
    def selected_applications(self, value: Optional[pulumi.Input['NamespacedNamesArgs']]):
        pulumi.set(self, "selected_applications", value)

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional[pulumi.Input['NamespacesArgs']]:
        """
        A list of selected Namespaces to restore from the Backup. The listed Namespaces and all resources contained in them will be restored.
        """
        return pulumi.get(self, "selected_namespaces")

    @selected_namespaces.setter
    def selected_namespaces(self, value: Optional[pulumi.Input['NamespacesArgs']]):
        pulumi.set(self, "selected_namespaces", value)

    @property
    @pulumi.getter(name="substitutionRules")
    def substitution_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubstitutionRuleArgs']]]]:
        """
        A list of transformation rules to be applied against Kubernetes resources as they are selected for restoration from a Backup. Rules are executed in order defined - this order matters, as changes made by a rule may impact the filtering logic of subsequent rules. An empty list means no substitution will occur.
        """
        return pulumi.get(self, "substitution_rules")

    @substitution_rules.setter
    def substitution_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubstitutionRuleArgs']]]]):
        pulumi.set(self, "substitution_rules", value)

    @property
    @pulumi.getter(name="volumeDataRestorePolicy")
    def volume_data_restore_policy(self) -> Optional[pulumi.Input['RestoreConfigVolumeDataRestorePolicy']]:
        """
        Specifies the mechanism to be used to restore volume data. Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as NO_VOLUME_DATA_RESTORATION).
        """
        return pulumi.get(self, "volume_data_restore_policy")

    @volume_data_restore_policy.setter
    def volume_data_restore_policy(self, value: Optional[pulumi.Input['RestoreConfigVolumeDataRestorePolicy']]):
        pulumi.set(self, "volume_data_restore_policy", value)


@pulumi.input_type
class RetentionPolicyArgs:
    def __init__(__self__, *,
                 backup_delete_lock_days: Optional[pulumi.Input[int]] = None,
                 backup_retain_days: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None):
        """
        RetentionPolicy defines a Backup retention policy for a BackupPlan.
        :param pulumi.Input[int] backup_delete_lock_days: Minimum age for Backups created via this BackupPlan (in days). This field MUST be an integer value between 0-90 (inclusive). A Backup created under this BackupPlan will NOT be deletable until it reaches Backup's (create_time + backup_delete_lock_days). Updating this field of a BackupPlan does NOT affect existing Backups under it. Backups created AFTER a successful update will inherit the new value. Default: 0 (no delete blocking)
        :param pulumi.Input[int] backup_retain_days: The default maximum age of a Backup created via this BackupPlan. This field MUST be an integer value >= 0 and <= 365. If specified, a Backup created under this BackupPlan will be automatically deleted after its age reaches (create_time + backup_retain_days). If not specified, Backups created under this BackupPlan will NOT be subject to automatic deletion. Updating this field does NOT affect existing Backups under it. Backups created AFTER a successful update will automatically pick up the new value. NOTE: backup_retain_days must be >= backup_delete_lock_days. If cron_schedule is defined, then this must be <= 360 * the creation interval. Default: 0 (no automatic deletion)
        :param pulumi.Input[bool] locked: This flag denotes whether the retention policy of this BackupPlan is locked. If set to True, no further update is allowed on this policy, including the `locked` field itself. Default: False
        """
        if backup_delete_lock_days is not None:
            pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        if backup_retain_days is not None:
            pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)

    @property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age for Backups created via this BackupPlan (in days). This field MUST be an integer value between 0-90 (inclusive). A Backup created under this BackupPlan will NOT be deletable until it reaches Backup's (create_time + backup_delete_lock_days). Updating this field of a BackupPlan does NOT affect existing Backups under it. Backups created AFTER a successful update will inherit the new value. Default: 0 (no delete blocking)
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @backup_delete_lock_days.setter
    def backup_delete_lock_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_delete_lock_days", value)

    @property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> Optional[pulumi.Input[int]]:
        """
        The default maximum age of a Backup created via this BackupPlan. This field MUST be an integer value >= 0 and <= 365. If specified, a Backup created under this BackupPlan will be automatically deleted after its age reaches (create_time + backup_retain_days). If not specified, Backups created under this BackupPlan will NOT be subject to automatic deletion. Updating this field does NOT affect existing Backups under it. Backups created AFTER a successful update will automatically pick up the new value. NOTE: backup_retain_days must be >= backup_delete_lock_days. If cron_schedule is defined, then this must be <= 360 * the creation interval. Default: 0 (no automatic deletion)
        """
        return pulumi.get(self, "backup_retain_days")

    @backup_retain_days.setter
    def backup_retain_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retain_days", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked. If set to True, no further update is allowed on this policy, including the `locked` field itself. Default: False
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None):
        """
        Schedule defines scheduling parameters for automatically creating Backups via this BackupPlan.
        :param pulumi.Input[str] cron_schedule: A standard [cron](https://wikipedia.com/wiki/cron) string that defines a repeating schedule for creating Backups via this BackupPlan. If this is defined, then backup_retain_days must also be defined. Default (empty): no automatic backup creation will occur.
        :param pulumi.Input[bool] paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan. Default: False
        """
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A standard [cron](https://wikipedia.com/wiki/cron) string that defines a repeating schedule for creating Backups via this BackupPlan. If this is defined, then backup_retain_days must also be defined. Default (empty): no automatic backup creation will occur.
        """
        return pulumi.get(self, "cron_schedule")

    @cron_schedule.setter
    def cron_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_schedule", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan. Default: False
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)


@pulumi.input_type
class SubstitutionRuleArgs:
    def __init__(__self__, *,
                 target_json_path: pulumi.Input[str],
                 new_value: Optional[pulumi.Input[str]] = None,
                 original_value_pattern: Optional[pulumi.Input[str]] = None,
                 target_group_kinds: Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]] = None,
                 target_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A transformation rule to be applied against Kubernetes resources as they are selected for restoration from a Backup. A rule contains both filtering logic (which resources are subject to substitution) and substitution logic.
        :param pulumi.Input[str] target_json_path: This is a [JSONPath] (https://kubernetes.io/docs/reference/kubectl/jsonpath/) expression that matches specific fields of candidate resources and it operates as both a filtering parameter (resources that are not matched with this expression will not be candidates for substitution) as well as a field identifier (identifies exactly which fields out of the candidate resources will be modified).
        :param pulumi.Input[str] new_value: This is the new value to set for any fields that pass the filtering and selection criteria. To remove a value from a Kubernetes resource, either leave this field unspecified, or set it to the empty string ("").
        :param pulumi.Input[str] original_value_pattern: (Filtering parameter) This is a [regular expression] (https://en.wikipedia.org/wiki/Regular_expression) that is compared against the fields matched by the target_json_path expression (and must also have passed the previous filters). Substitution will not be performed against fields whose value does not match this expression. If this field is NOT specified, then ALL fields matched by the target_json_path expression will undergo substitution. Note that an empty (e.g., "", rather than unspecified) value for for this field will only match empty fields.
        :param pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]] target_group_kinds: (Filtering parameter) Any resource subject to substitution must belong to one of the listed "types". If this field is not provided, no type filtering will be performed (all resources of all types matching previous filtering parameters will be candidates for substitution).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_namespaces: (Filtering parameter) Any resource subject to substitution must be contained within one of the listed Kubernetes Namespace in the Backup. If this field is not provided, no namespace filtering will be performed (all resources in all Namespaces, including all cluster-scoped resources, will be candidates for substitution). To mix cluster-scoped and namespaced resources in the same rule, use an empty string ("") as one of the target namespaces.
        """
        pulumi.set(__self__, "target_json_path", target_json_path)
        if new_value is not None:
            pulumi.set(__self__, "new_value", new_value)
        if original_value_pattern is not None:
            pulumi.set(__self__, "original_value_pattern", original_value_pattern)
        if target_group_kinds is not None:
            pulumi.set(__self__, "target_group_kinds", target_group_kinds)
        if target_namespaces is not None:
            pulumi.set(__self__, "target_namespaces", target_namespaces)

    @property
    @pulumi.getter(name="targetJsonPath")
    def target_json_path(self) -> pulumi.Input[str]:
        """
        This is a [JSONPath] (https://kubernetes.io/docs/reference/kubectl/jsonpath/) expression that matches specific fields of candidate resources and it operates as both a filtering parameter (resources that are not matched with this expression will not be candidates for substitution) as well as a field identifier (identifies exactly which fields out of the candidate resources will be modified).
        """
        return pulumi.get(self, "target_json_path")

    @target_json_path.setter
    def target_json_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_json_path", value)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> Optional[pulumi.Input[str]]:
        """
        This is the new value to set for any fields that pass the filtering and selection criteria. To remove a value from a Kubernetes resource, either leave this field unspecified, or set it to the empty string ("").
        """
        return pulumi.get(self, "new_value")

    @new_value.setter
    def new_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_value", value)

    @property
    @pulumi.getter(name="originalValuePattern")
    def original_value_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Filtering parameter) This is a [regular expression] (https://en.wikipedia.org/wiki/Regular_expression) that is compared against the fields matched by the target_json_path expression (and must also have passed the previous filters). Substitution will not be performed against fields whose value does not match this expression. If this field is NOT specified, then ALL fields matched by the target_json_path expression will undergo substitution. Note that an empty (e.g., "", rather than unspecified) value for for this field will only match empty fields.
        """
        return pulumi.get(self, "original_value_pattern")

    @original_value_pattern.setter
    def original_value_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_value_pattern", value)

    @property
    @pulumi.getter(name="targetGroupKinds")
    def target_group_kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]]:
        """
        (Filtering parameter) Any resource subject to substitution must belong to one of the listed "types". If this field is not provided, no type filtering will be performed (all resources of all types matching previous filtering parameters will be candidates for substitution).
        """
        return pulumi.get(self, "target_group_kinds")

    @target_group_kinds.setter
    def target_group_kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupKindArgs']]]]):
        pulumi.set(self, "target_group_kinds", value)

    @property
    @pulumi.getter(name="targetNamespaces")
    def target_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Filtering parameter) Any resource subject to substitution must be contained within one of the listed Kubernetes Namespace in the Backup. If this field is not provided, no namespace filtering will be performed (all resources in all Namespaces, including all cluster-scoped resources, will be candidates for substitution). To mix cluster-scoped and namespaced resources in the same rule, use an empty string ("") as one of the target namespaces.
        """
        return pulumi.get(self, "target_namespaces")

    @target_namespaces.setter
    def target_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_namespaces", value)


