# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['VersionArgs', 'Version']

@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[str],
                 config: Optional[pulumi.Input['ServingConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 size_bytes: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Version resource.
        :param pulumi.Input['ServingConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels used for extra metadata and/or filtering.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        :param pulumi.Input[str] size_bytes: The self-reported size of the version. This value is used for a pre-emptive quota check for legacy version uploads.
        :param pulumi.Input[str] version_id: A unique id for the new version. This is was only specified for legacy version creations, and should be blank.
        """
        pulumi.set(__self__, "site_id", site_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ServingConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ServingConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels used for extra metadata and/or filtering.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The self-reported size of the version. This value is used for a pre-emptive quota check for legacy version uploads.
        """
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_bytes", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique id for the new version. This is was only specified for legacy version creations, and should be blank.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class Version(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['ServingConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 size_bytes: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new version for the specified site.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServingConfigArgs']] config: The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels used for extra metadata and/or filtering.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        :param pulumi.Input[str] size_bytes: The self-reported size of the version. This value is used for a pre-emptive quota check for legacy version uploads.
        :param pulumi.Input[str] version_id: A unique id for the new version. This is was only specified for legacy version creations, and should be blank.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new version for the specified site.

        :param str resource_name: The name of the resource.
        :param VersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['ServingConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 size_bytes: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VersionArgs.__new__(VersionArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["size_bytes"] = size_bytes
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["create_user"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["delete_user"] = None
            __props__.__dict__["file_count"] = None
            __props__.__dict__["finalize_time"] = None
            __props__.__dict__["finalize_user"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version_bytes"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "site_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Version, __self__).__init__(
            'google-native:firebasehosting/v1beta1:Version',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Version':
        """
        Get an existing Version resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VersionArgs.__new__(VersionArgs)

        __props__.__dict__["config"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["create_user"] = None
        __props__.__dict__["delete_time"] = None
        __props__.__dict__["delete_user"] = None
        __props__.__dict__["file_count"] = None
        __props__.__dict__["finalize_time"] = None
        __props__.__dict__["finalize_user"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["site_id"] = None
        __props__.__dict__["size_bytes"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["version_bytes"] = None
        __props__.__dict__["version_id"] = None
        return Version(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ServingConfigResponse']:
        """
        The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which the version was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createUser")
    def create_user(self) -> pulumi.Output['outputs.ActingUserResponse']:
        """
        Identifies the user who created the version.
        """
        return pulumi.get(self, "create_user")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        The time at which the version was `DELETED`.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> pulumi.Output['outputs.ActingUserResponse']:
        """
        Identifies the user who `DELETED` the version.
        """
        return pulumi.get(self, "delete_user")

    @property
    @pulumi.getter(name="fileCount")
    def file_count(self) -> pulumi.Output[str]:
        """
        The total number of files associated with the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "file_count")

    @property
    @pulumi.getter(name="finalizeTime")
    def finalize_time(self) -> pulumi.Output[str]:
        """
        The time at which the version was `FINALIZED`.
        """
        return pulumi.get(self, "finalize_time")

    @property
    @pulumi.getter(name="finalizeUser")
    def finalize_user(self) -> pulumi.Output['outputs.ActingUserResponse']:
        """
        Identifies the user who `FINALIZED` the version.
        """
        return pulumi.get(self, "finalize_user")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The labels used for extra metadata and/or filtering.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> pulumi.Output[Optional[str]]:
        """
        The self-reported size of the version. This value is used for a pre-emptive quota check for legacy version uploads.
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="versionBytes")
    def version_bytes(self) -> pulumi.Output[str]:
        """
        The total stored bytesize of the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "version_bytes")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique id for the new version. This is was only specified for legacy version creations, and should be blank.
        """
        return pulumi.get(self, "version_id")

