# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetVersionResult',
    'AwaitableGetVersionResult',
    'get_version',
    'get_version_output',
]

@pulumi.output_type
class GetVersionResult:
    def __init__(__self__, config=None, create_time=None, create_user=None, delete_time=None, delete_user=None, file_count=None, finalize_time=None, finalize_user=None, labels=None, name=None, status=None, version_bytes=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if create_user and not isinstance(create_user, dict):
            raise TypeError("Expected argument 'create_user' to be a dict")
        pulumi.set(__self__, "create_user", create_user)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if delete_user and not isinstance(delete_user, dict):
            raise TypeError("Expected argument 'delete_user' to be a dict")
        pulumi.set(__self__, "delete_user", delete_user)
        if file_count and not isinstance(file_count, str):
            raise TypeError("Expected argument 'file_count' to be a str")
        pulumi.set(__self__, "file_count", file_count)
        if finalize_time and not isinstance(finalize_time, str):
            raise TypeError("Expected argument 'finalize_time' to be a str")
        pulumi.set(__self__, "finalize_time", finalize_time)
        if finalize_user and not isinstance(finalize_user, dict):
            raise TypeError("Expected argument 'finalize_user' to be a dict")
        pulumi.set(__self__, "finalize_user", finalize_user)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if version_bytes and not isinstance(version_bytes, str):
            raise TypeError("Expected argument 'version_bytes' to be a str")
        pulumi.set(__self__, "version_bytes", version_bytes)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.ServingConfigResponse':
        """
        The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the version was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createUser")
    def create_user(self) -> 'outputs.ActingUserResponse':
        """
        Identifies the user who created the version.
        """
        return pulumi.get(self, "create_user")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        The time at which the version was `DELETED`.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> 'outputs.ActingUserResponse':
        """
        Identifies the user who `DELETED` the version.
        """
        return pulumi.get(self, "delete_user")

    @property
    @pulumi.getter(name="fileCount")
    def file_count(self) -> str:
        """
        The total number of files associated with the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "file_count")

    @property
    @pulumi.getter(name="finalizeTime")
    def finalize_time(self) -> str:
        """
        The time at which the version was `FINALIZED`.
        """
        return pulumi.get(self, "finalize_time")

    @property
    @pulumi.getter(name="finalizeUser")
    def finalize_user(self) -> 'outputs.ActingUserResponse':
        """
        Identifies the user who `FINALIZED` the version.
        """
        return pulumi.get(self, "finalize_user")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels used for extra metadata and/or filtering.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="versionBytes")
    def version_bytes(self) -> str:
        """
        The total stored bytesize of the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "version_bytes")


class AwaitableGetVersionResult(GetVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVersionResult(
            config=self.config,
            create_time=self.create_time,
            create_user=self.create_user,
            delete_time=self.delete_time,
            delete_user=self.delete_user,
            file_count=self.file_count,
            finalize_time=self.finalize_time,
            finalize_user=self.finalize_user,
            labels=self.labels,
            name=self.name,
            status=self.status,
            version_bytes=self.version_bytes)


def get_version(project: Optional[str] = None,
                site_id: Optional[str] = None,
                version_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVersionResult:
    """
    Get the specified version that has been created for the specified site. This can include versions that were created for the default `live` channel or for any active preview channels for the specified site.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['siteId'] = site_id
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:firebasehosting/v1beta1:getVersion', __args__, opts=opts, typ=GetVersionResult).value

    return AwaitableGetVersionResult(
        config=__ret__.config,
        create_time=__ret__.create_time,
        create_user=__ret__.create_user,
        delete_time=__ret__.delete_time,
        delete_user=__ret__.delete_user,
        file_count=__ret__.file_count,
        finalize_time=__ret__.finalize_time,
        finalize_user=__ret__.finalize_user,
        labels=__ret__.labels,
        name=__ret__.name,
        status=__ret__.status,
        version_bytes=__ret__.version_bytes)


@_utilities.lift_output_func(get_version)
def get_version_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                       site_id: Optional[pulumi.Input[str]] = None,
                       version_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVersionResult]:
    """
    Get the specified version that has been created for the specified site. This can include versions that were created for the default `live` channel or for any active preview channels for the specified site.
    """
    ...
