# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetReleaseResult',
    'AwaitableGetReleaseResult',
    'get_release',
    'get_release_output',
]

@pulumi.output_type
class GetReleaseResult:
    def __init__(__self__, message=None, name=None, release_time=None, release_user=None, type=None, version=None):
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if release_time and not isinstance(release_time, str):
            raise TypeError("Expected argument 'release_time' to be a str")
        pulumi.set(__self__, "release_time", release_time)
        if release_user and not isinstance(release_user, dict):
            raise TypeError("Expected argument 'release_user' to be a dict")
        pulumi.set(__self__, "release_user", release_user)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, dict):
            raise TypeError("Expected argument 'version' to be a dict")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The deploy description when the release was created. The value can be up to 512 characters.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier for the release, in either of the following formats: - sites/SITE_ID/releases/RELEASE_ID - sites/SITE_ID/channels/CHANNEL_ID/releases/RELEASE_ID This name is provided in the response body when you call [`releases.create`](sites.releases/create) or [`channels.releases.create`](sites.channels.releases/create).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> str:
        """
        The time at which the version is set to be public.
        """
        return pulumi.get(self, "release_time")

    @property
    @pulumi.getter(name="releaseUser")
    def release_user(self) -> 'outputs.ActingUserResponse':
        """
        Identifies the user who created the release.
        """
        return pulumi.get(self, "release_user")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Explains the reason for the release. Specify a value for this field only when creating a `SITE_DISABLE` type release.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The configuration and content that was released.
        """
        return pulumi.get(self, "version")


class AwaitableGetReleaseResult(GetReleaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReleaseResult(
            message=self.message,
            name=self.name,
            release_time=self.release_time,
            release_user=self.release_user,
            type=self.type,
            version=self.version)


def get_release(channel_id: Optional[str] = None,
                project: Optional[str] = None,
                release_id: Optional[str] = None,
                site_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReleaseResult:
    """
    Gets the specified release for a site or channel. When used to get a release for a site, this can get releases for both the default `live` channel and any active preview channels for the specified site.
    """
    __args__ = dict()
    __args__['channelId'] = channel_id
    __args__['project'] = project
    __args__['releaseId'] = release_id
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:firebasehosting/v1beta1:getRelease', __args__, opts=opts, typ=GetReleaseResult).value

    return AwaitableGetReleaseResult(
        message=__ret__.message,
        name=__ret__.name,
        release_time=__ret__.release_time,
        release_user=__ret__.release_user,
        type=__ret__.type,
        version=__ret__.version)


@_utilities.lift_output_func(get_release)
def get_release_output(channel_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       release_id: Optional[pulumi.Input[str]] = None,
                       site_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReleaseResult]:
    """
    Gets the specified release for a site or channel. When used to get a release for a site, this can get releases for both the default `live` channel and any active preview channels for the specified site.
    """
    ...
