# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CloudRunRewriteArgs',
    'DomainRedirectArgs',
    'HeaderArgs',
    'I18nConfigArgs',
    'RedirectArgs',
    'RewriteArgs',
    'ServingConfigArgs',
]

@pulumi.input_type
class CloudRunRewriteArgs:
    def __init__(__self__, *,
                 service_id: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        A configured rewrite that directs requests to a Cloud Run service. If the Cloud Run service does not exist when setting or updating your Firebase Hosting configuration, then the request fails. Any errors from the Cloud Run service are passed to the end user (for example, if you delete a service, any requests directed to that service receive a `404` error).
        :param pulumi.Input[str] service_id: User-defined ID of the Cloud Run service.
        :param pulumi.Input[str] region: Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        pulumi.set(__self__, "service_id", service_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        User-defined ID of the Cloud Run service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class DomainRedirectArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 type: pulumi.Input['DomainRedirectType']):
        """
        Defines the behavior of a domain-level redirect. Domain redirects preserve the path of the redirect but replace the requested domain with the one specified in the redirect configuration.
        :param pulumi.Input[str] domain_name: The domain name to redirect to.
        :param pulumi.Input['DomainRedirectType'] type: The redirect status code.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The domain name to redirect to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DomainRedirectType']:
        """
        The redirect status code.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DomainRedirectType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HeaderArgs:
    def __init__(__self__, *,
                 headers: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 glob: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        A [`Header`](https://firebase.google.com/docs/hosting/full-config#headers) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: The additional headers to add to the response.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        pulumi.set(__self__, "headers", headers)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        The additional headers to add to the response.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class I18nConfigArgs:
    def __init__(__self__, *,
                 root: pulumi.Input[str]):
        """
        If provided, i18n rewrites are enabled.
        :param pulumi.Input[str] root: The user-supplied path where country and language specific content will be looked for within the public directory.
        """
        pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def root(self) -> pulumi.Input[str]:
        """
        The user-supplied path where country and language specific content will be looked for within the public directory.
        """
        return pulumi.get(self, "root")

    @root.setter
    def root(self, value: pulumi.Input[str]):
        pulumi.set(self, "root", value)


@pulumi.input_type
class RedirectArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 status_code: pulumi.Input[int],
                 glob: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        A [`Redirect`](https://firebase.google.com/docs/hosting/full-config#redirects) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        :param pulumi.Input[str] location: The value to put in the HTTP location header of the response. The location can contain capture group values from the pattern using a `:` prefix to identify the segment and an optional `*` to capture the rest of the URL. For example: "glob": "/:capture*", "statusCode": 301, "location": "https://example.com/foo/:capture"
        :param pulumi.Input[int] status_code: The status HTTP code to return in the response. It must be a valid 3xx status code.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "status_code", status_code)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The value to put in the HTTP location header of the response. The location can contain capture group values from the pattern using a `:` prefix to identify the segment and an optional `*` to capture the rest of the URL. For example: "glob": "/:capture*", "statusCode": 301, "location": "https://example.com/foo/:capture"
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[int]:
        """
        The status HTTP code to return in the response. It must be a valid 3xx status code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class RewriteArgs:
    def __init__(__self__, *,
                 dynamic_links: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 function_region: Optional[pulumi.Input[str]] = None,
                 glob: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None,
                 run: Optional[pulumi.Input['CloudRunRewriteArgs']] = None):
        """
        A [`Rewrite`](https://firebase.google.com/docs/hosting/full-config#rewrites) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        :param pulumi.Input[bool] dynamic_links: The request will be forwarded to Firebase Dynamic Links.
        :param pulumi.Input[str] function: The function to proxy requests to. Must match the exported function name exactly.
        :param pulumi.Input[str] function_region: Optional. Specify a Cloud region for rewritten Functions invocations. If not provided, defaults to us-central1.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[str] path: The URL path to rewrite the request to.
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        :param pulumi.Input['CloudRunRewriteArgs'] run: The request will be forwarded to Cloud Run.
        """
        if dynamic_links is not None:
            pulumi.set(__self__, "dynamic_links", dynamic_links)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if function_region is not None:
            pulumi.set(__self__, "function_region", function_region)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @property
    @pulumi.getter(name="dynamicLinks")
    def dynamic_links(self) -> Optional[pulumi.Input[bool]]:
        """
        The request will be forwarded to Firebase Dynamic Links.
        """
        return pulumi.get(self, "dynamic_links")

    @dynamic_links.setter
    def dynamic_links(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_links", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        The function to proxy requests to. Must match the exported function name exactly.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="functionRegion")
    def function_region(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specify a Cloud region for rewritten Functions invocations. If not provided, defaults to us-central1.
        """
        return pulumi.get(self, "function_region")

    @function_region.setter
    def function_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_region", value)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL path to rewrite the request to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['CloudRunRewriteArgs']]:
        """
        The request will be forwarded to Cloud Run.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['CloudRunRewriteArgs']]):
        pulumi.set(self, "run", value)


@pulumi.input_type
class ServingConfigArgs:
    def __init__(__self__, *,
                 app_association: Optional[pulumi.Input['ServingConfigAppAssociation']] = None,
                 clean_urls: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]] = None,
                 i18n: Optional[pulumi.Input['I18nConfigArgs']] = None,
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]] = None,
                 rewrites: Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]] = None,
                 trailing_slash_behavior: Optional[pulumi.Input['ServingConfigTrailingSlashBehavior']] = None):
        """
        The configuration for how incoming requests to a site should be routed and processed before serving content. The URL request paths are matched against the specified URL patterns in the configuration, then Hosting applies the applicable configuration according to a specific [priority order](https://firebase.google.com/docs/hosting/full-config#hosting_priority_order).
        :param pulumi.Input['ServingConfigAppAssociation'] app_association: How to handle well known App Association files.
        :param pulumi.Input[bool] clean_urls: Defines whether to drop the file extension from uploaded files.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]] headers: An array of objects, where each object specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        :param pulumi.Input['I18nConfigArgs'] i18n: Optional. Defines i18n rewrite behavior.
        :param pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]] redirects: An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        :param pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]] rewrites: An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        :param pulumi.Input['ServingConfigTrailingSlashBehavior'] trailing_slash_behavior: Defines how to handle a trailing slash in the URL path.
        """
        if app_association is not None:
            pulumi.set(__self__, "app_association", app_association)
        if clean_urls is not None:
            pulumi.set(__self__, "clean_urls", clean_urls)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if i18n is not None:
            pulumi.set(__self__, "i18n", i18n)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)
        if rewrites is not None:
            pulumi.set(__self__, "rewrites", rewrites)
        if trailing_slash_behavior is not None:
            pulumi.set(__self__, "trailing_slash_behavior", trailing_slash_behavior)

    @property
    @pulumi.getter(name="appAssociation")
    def app_association(self) -> Optional[pulumi.Input['ServingConfigAppAssociation']]:
        """
        How to handle well known App Association files.
        """
        return pulumi.get(self, "app_association")

    @app_association.setter
    def app_association(self, value: Optional[pulumi.Input['ServingConfigAppAssociation']]):
        pulumi.set(self, "app_association", value)

    @property
    @pulumi.getter(name="cleanUrls")
    def clean_urls(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether to drop the file extension from uploaded files.
        """
        return pulumi.get(self, "clean_urls")

    @clean_urls.setter
    def clean_urls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clean_urls", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]]:
        """
        An array of objects, where each object specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def i18n(self) -> Optional[pulumi.Input['I18nConfigArgs']]:
        """
        Optional. Defines i18n rewrite behavior.
        """
        return pulumi.get(self, "i18n")

    @i18n.setter
    def i18n(self, value: Optional[pulumi.Input['I18nConfigArgs']]):
        pulumi.set(self, "i18n", value)

    @property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]]:
        """
        An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]]):
        pulumi.set(self, "redirects", value)

    @property
    @pulumi.getter
    def rewrites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]]:
        """
        An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        """
        return pulumi.get(self, "rewrites")

    @rewrites.setter
    def rewrites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]]):
        pulumi.set(self, "rewrites", value)

    @property
    @pulumi.getter(name="trailingSlashBehavior")
    def trailing_slash_behavior(self) -> Optional[pulumi.Input['ServingConfigTrailingSlashBehavior']]:
        """
        Defines how to handle a trailing slash in the URL path.
        """
        return pulumi.get(self, "trailing_slash_behavior")

    @trailing_slash_behavior.setter
    def trailing_slash_behavior(self, value: Optional[pulumi.Input['ServingConfigTrailingSlashBehavior']]):
        pulumi.set(self, "trailing_slash_behavior", value)


