# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'DomainRedirectType',
    'ReleaseType',
    'ServingConfigAppAssociation',
    'ServingConfigTrailingSlashBehavior',
    'VersionStatus',
]


class DomainRedirectType(str, Enum):
    """
    Required. The redirect status code.
    """
    REDIRECT_TYPE_UNSPECIFIED = "REDIRECT_TYPE_UNSPECIFIED"
    """
    The default redirect type; should not be intentionlly used.
    """
    MOVED_PERMANENTLY = "MOVED_PERMANENTLY"
    """
    The redirect will respond with an HTTP status code of `301 Moved Permanently`.
    """


class ReleaseType(str, Enum):
    """
    Explains the reason for the release. Specify a value for this field only when creating a `SITE_DISABLE` type release.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    An unspecified type. Indicates that a version was released. This is the default value when no other `type` is explicitly specified.
    """
    DEPLOY = "DEPLOY"
    """
    A version was uploaded to Firebase Hosting and released.
    """
    ROLLBACK = "ROLLBACK"
    """
    The release points back to a previously deployed version.
    """
    SITE_DISABLE = "SITE_DISABLE"
    """
    The release prevents the site from serving content. Firebase Hosting acts as if the site never existed.
    """


class ServingConfigAppAssociation(str, Enum):
    """
    How to handle well known App Association files.
    """
    AUTO = "AUTO"
    """
    The app association files will be automatically created from the apps that exist in the Firebase project.
    """
    NONE = "NONE"
    """
    No special handling of the app association files will occur, these paths will result in a 404 unless caught with a Rewrite.
    """


class ServingConfigTrailingSlashBehavior(str, Enum):
    """
    Defines how to handle a trailing slash in the URL path.
    """
    TRAILING_SLASH_BEHAVIOR_UNSPECIFIED = "TRAILING_SLASH_BEHAVIOR_UNSPECIFIED"
    """
    No behavior is specified. Files are served at their exact location only, and trailing slashes are only added to directory indexes.
    """
    ADD = "ADD"
    """
    Trailing slashes are _added_ to directory indexes as well as to any URL path not ending in a file extension.
    """
    REMOVE = "REMOVE"
    """
    Trailing slashes are _removed_ from directory indexes as well as from any URL path not ending in a file extension.
    """


class VersionStatus(str, Enum):
    """
    The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
    """
    VERSION_STATUS_UNSPECIFIED = "VERSION_STATUS_UNSPECIFIED"
    """
    The default status; should not be intentionally used.
    """
    CREATED = "CREATED"
    """
    The version has been created, and content is currently being added to the version.
    """
    FINALIZED = "FINALIZED"
    """
    All content has been added to the version, and the version can no longer be changed.
    """
    DELETED = "DELETED"
    """
    The version has been deleted.
    """
    ABANDONED = "ABANDONED"
    """
    The version was not updated to `FINALIZED` within 12 hours and was automatically deleted.
    """
    EXPIRED = "EXPIRED"
    """
    The version is outside the site-configured limit for the number of retained versions, so the version's content is scheduled for deletion.
    """
    CLONING = "CLONING"
    """
    The version is being cloned from another version. All content is still being copied over.
    """
