# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetAndroidAppResult',
    'AwaitableGetAndroidAppResult',
    'get_android_app',
    'get_android_app_output',
]

@pulumi.output_type
class GetAndroidAppResult:
    def __init__(__self__, api_key_id=None, app_id=None, display_name=None, etag=None, expire_time=None, name=None, package_name=None, project=None, sha1_hashes=None, sha256_hashes=None, state=None):
        if api_key_id and not isinstance(api_key_id, str):
            raise TypeError("Expected argument 'api_key_id' to be a str")
        pulumi.set(__self__, "api_key_id", api_key_id)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if sha1_hashes and not isinstance(sha1_hashes, list):
            raise TypeError("Expected argument 'sha1_hashes' to be a list")
        pulumi.set(__self__, "sha1_hashes", sha1_hashes)
        if sha256_hashes and not isinstance(sha256_hashes, list):
            raise TypeError("Expected argument 'sha256_hashes' to be a list")
        pulumi.set(__self__, "sha256_hashes", sha256_hashes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> str:
        """
        The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the `AndroidApp`. Be aware that this value is the UID of the API key, _not_ the [`keyString`](https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string) of the API key. The `keyString` is the value that can be found in the App's [configuration artifact](../../rest/v1beta1/projects.androidApps/getConfig). If `api_key_id` is not set in requests to [`androidApps.Create`](../../rest/v1beta1/projects.androidApps/create), then Firebase automatically associates an `api_key_id` with the `AndroidApp`. This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned. In patch requests, `api_key_id` cannot be set to an empty value, and the new UID must have no restrictions or only have restrictions that are valid for the associated `AndroidApp`. We recommend using the [Google Cloud Console](https://console.cloud.google.com/apis/credentials) to manage API keys.
        """
        return pulumi.get(self, "api_key_id")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        Immutable. The globally unique, Firebase-assigned identifier for the `AndroidApp`. This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-assigned display name for the `AndroidApp`.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        This checksum is computed by the server based on the value of other fields, and it may be sent with update requests to ensure the client has an up-to-date value before proceeding. Learn more about `etag` in Google's [AIP-154 standard](https://google.aip.dev/154#declarative-friendly-resources). This etag is strongly validated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Timestamp of when the App will be considered expired and cannot be undeleted. This value is only provided if the App is in the `DELETED` state.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the AndroidApp, in the format: projects/ PROJECT_IDENTIFIER/androidApps/APP_ID * PROJECT_IDENTIFIER: the parent Project's [`ProjectNumber`](../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or its [`ProjectId`](../projects#FirebaseProject.FIELDS.project_id). Learn more about using project identifiers in Google's [AIP 2510 standard](https://google.aip.dev/cloud/2510). Note that the value for PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID: the globally unique, Firebase-assigned identifier for the App (see [`appId`](../projects.androidApps#AndroidApp.FIELDS.app_id)).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> str:
        """
        Immutable. The canonical package name of the Android app as would appear in the Google Play Developer Console.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Immutable. A user-assigned unique identifier of the parent FirebaseProject for the `AndroidApp`.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sha1Hashes")
    def sha1_hashes(self) -> Sequence[str]:
        """
        The SHA1 certificate hashes for the AndroidApp.
        """
        return pulumi.get(self, "sha1_hashes")

    @property
    @pulumi.getter(name="sha256Hashes")
    def sha256_hashes(self) -> Sequence[str]:
        """
        The SHA256 certificate hashes for the AndroidApp.
        """
        return pulumi.get(self, "sha256_hashes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the App.
        """
        return pulumi.get(self, "state")


class AwaitableGetAndroidAppResult(GetAndroidAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAndroidAppResult(
            api_key_id=self.api_key_id,
            app_id=self.app_id,
            display_name=self.display_name,
            etag=self.etag,
            expire_time=self.expire_time,
            name=self.name,
            package_name=self.package_name,
            project=self.project,
            sha1_hashes=self.sha1_hashes,
            sha256_hashes=self.sha256_hashes,
            state=self.state)


def get_android_app(android_app_id: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAndroidAppResult:
    """
    Gets the specified AndroidApp.
    """
    __args__ = dict()
    __args__['androidAppId'] = android_app_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:firebase/v1beta1:getAndroidApp', __args__, opts=opts, typ=GetAndroidAppResult).value

    return AwaitableGetAndroidAppResult(
        api_key_id=__ret__.api_key_id,
        app_id=__ret__.app_id,
        display_name=__ret__.display_name,
        etag=__ret__.etag,
        expire_time=__ret__.expire_time,
        name=__ret__.name,
        package_name=__ret__.package_name,
        project=__ret__.project,
        sha1_hashes=__ret__.sha1_hashes,
        sha256_hashes=__ret__.sha256_hashes,
        state=__ret__.state)


@_utilities.lift_output_func(get_android_app)
def get_android_app_output(android_app_id: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAndroidAppResult]:
    """
    Gets the specified AndroidApp.
    """
    ...
