# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'InstanceProtocol',
    'InstanceTier',
    'NetworkConfigConnectMode',
    'NetworkConfigModesItem',
    'NfsExportOptionsAccessMode',
    'NfsExportOptionsSquashMode',
]


class InstanceProtocol(str, Enum):
    """
    Immutable. The protocol indicates the access protocol for all shares in the instance. This field is immutable and it cannot be changed after the instance has been created. Default value: `NFS_V3`.
    """
    FILE_PROTOCOL_UNSPECIFIED = "FILE_PROTOCOL_UNSPECIFIED"
    """
    FILE_PROTOCOL_UNSPECIFIED serves a "not set" default value when a FileProtocol is a separate field in a message.
    """
    NFS_V3 = "NFS_V3"
    """
    NFS 3.0.
    """
    NFS_V41 = "NFS_V4_1"
    """
    NFS 4.1.
    """


class InstanceTier(str, Enum):
    """
    The service tier of the instance.
    """
    TIER_UNSPECIFIED = "TIER_UNSPECIFIED"
    """
    Not set.
    """
    STANDARD = "STANDARD"
    """
    STANDARD tier. BASIC_HDD is the preferred term for this tier.
    """
    PREMIUM = "PREMIUM"
    """
    PREMIUM tier. BASIC_SSD is the preferred term for this tier.
    """
    BASIC_HDD = "BASIC_HDD"
    """
    BASIC instances offer a maximum capacity of 63.9 TB. BASIC_HDD is an alias for STANDARD Tier, offering economical performance backed by HDD.
    """
    BASIC_SSD = "BASIC_SSD"
    """
    BASIC instances offer a maximum capacity of 63.9 TB. BASIC_SSD is an alias for PREMIUM Tier, and offers improved performance backed by SSD.
    """
    HIGH_SCALE_SSD = "HIGH_SCALE_SSD"
    """
    HIGH_SCALE instances offer expanded capacity and performance scaling capabilities.
    """
    ENTERPRISE = "ENTERPRISE"
    """
    ENTERPRISE instances offer the features and availability needed for mission-critical workloads.
    """


class NetworkConfigConnectMode(str, Enum):
    """
    The network connect mode of the Filestore instance. If not provided, the connect mode defaults to DIRECT_PEERING.
    """
    CONNECT_MODE_UNSPECIFIED = "CONNECT_MODE_UNSPECIFIED"
    """
    ConnectMode not set.
    """
    DIRECT_PEERING = "DIRECT_PEERING"
    """
    Connect via direct peering to the Filestore service.
    """
    PRIVATE_SERVICE_ACCESS = "PRIVATE_SERVICE_ACCESS"
    """
    Connect to your Filestore instance using Private Service Access. Private services access provides an IP address range for multiple Google Cloud services, including Filestore.
    """


class NetworkConfigModesItem(str, Enum):
    ADDRESS_MODE_UNSPECIFIED = "ADDRESS_MODE_UNSPECIFIED"
    """
    Internet protocol not set.
    """
    MODE_IPV4 = "MODE_IPV4"
    """
    Use the IPv4 internet protocol.
    """


class NfsExportOptionsAccessMode(str, Enum):
    """
    Either READ_ONLY, for allowing only read requests on the exported directory, or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
    """
    ACCESS_MODE_UNSPECIFIED = "ACCESS_MODE_UNSPECIFIED"
    """
    AccessMode not set.
    """
    READ_ONLY = "READ_ONLY"
    """
    The client can only read the file share.
    """
    READ_WRITE = "READ_WRITE"
    """
    The client can read and write the file share (default).
    """


class NfsExportOptionsSquashMode(str, Enum):
    """
    Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH, for not allowing root access. The default is NO_ROOT_SQUASH.
    """
    SQUASH_MODE_UNSPECIFIED = "SQUASH_MODE_UNSPECIFIED"
    """
    SquashMode not set.
    """
    NO_ROOT_SQUASH = "NO_ROOT_SQUASH"
    """
    The Root user has root access to the file share (default).
    """
    ROOT_SQUASH = "ROOT_SQUASH"
    """
    The Root user has squashed access to the anonymous uid/gid.
    """
