# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetProcessorResult',
    'AwaitableGetProcessorResult',
    'get_processor',
    'get_processor_output',
]

@pulumi.output_type
class GetProcessorResult:
    def __init__(__self__, create_time=None, default_processor_version=None, display_name=None, kms_key_name=None, name=None, process_endpoint=None, state=None, type=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if default_processor_version and not isinstance(default_processor_version, str):
            raise TypeError("Expected argument 'default_processor_version' to be a str")
        pulumi.set(__self__, "default_processor_version", default_processor_version)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if process_endpoint and not isinstance(process_endpoint, str):
            raise TypeError("Expected argument 'process_endpoint' to be a str")
        pulumi.set(__self__, "process_endpoint", process_endpoint)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time the processor was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="defaultProcessorVersion")
    def default_processor_version(self) -> str:
        """
        The default processor version.
        """
        return pulumi.get(self, "default_processor_version")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the processor.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The KMS key used for encryption/decryption in CMEK scenarios. See https://cloud.google.com/security-key-management.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name of the processor. Format: `projects/{project}/locations/{location}/processors/{processor}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="processEndpoint")
    def process_endpoint(self) -> str:
        """
        Immutable. The http endpoint that can be called to invoke processing.
        """
        return pulumi.get(self, "process_endpoint")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the processor.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The processor type, e.g., `OCR_PROCESSOR`, `INVOICE_PROCESSOR`, etc. To get a list of processors types, see FetchProcessorTypes.
        """
        return pulumi.get(self, "type")


class AwaitableGetProcessorResult(GetProcessorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProcessorResult(
            create_time=self.create_time,
            default_processor_version=self.default_processor_version,
            display_name=self.display_name,
            kms_key_name=self.kms_key_name,
            name=self.name,
            process_endpoint=self.process_endpoint,
            state=self.state,
            type=self.type)


def get_processor(location: Optional[str] = None,
                  processor_id: Optional[str] = None,
                  project: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProcessorResult:
    """
    Gets a processor detail.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['processorId'] = processor_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:documentai/v1:getProcessor', __args__, opts=opts, typ=GetProcessorResult).value

    return AwaitableGetProcessorResult(
        create_time=__ret__.create_time,
        default_processor_version=__ret__.default_processor_version,
        display_name=__ret__.display_name,
        kms_key_name=__ret__.kms_key_name,
        name=__ret__.name,
        process_endpoint=__ret__.process_endpoint,
        state=__ret__.state,
        type=__ret__.type)


@_utilities.lift_output_func(get_processor)
def get_processor_output(location: Optional[pulumi.Input[str]] = None,
                         processor_id: Optional[pulumi.Input[str]] = None,
                         project: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProcessorResult]:
    """
    Gets a processor detail.
    """
    ...
