# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['DocumentArgs', 'Document']

@pulumi.input_type
class DocumentArgs:
    def __init__(__self__, *,
                 branch_id: pulumi.Input[str],
                 data_store_id: pulumi.Input[str],
                 document_id: pulumi.Input[str],
                 schema_id: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 json_data: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_document_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 struct_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Document resource.
        :param pulumi.Input[str] document_id: Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Documents with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[str] schema_id: The identifier of the schema located in the same data store.
        :param pulumi.Input[str] id: Immutable. The identifier of the document. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        :param pulumi.Input[str] json_data: The JSON string representation of the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        :param pulumi.Input[str] name: Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[str] parent_document_id: The identifier of the parent document. Currently supports at most two level document hierarchy. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] struct_data: The structured JSON data for the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        pulumi.set(__self__, "branch_id", branch_id)
        pulumi.set(__self__, "data_store_id", data_store_id)
        pulumi.set(__self__, "document_id", document_id)
        pulumi.set(__self__, "schema_id", schema_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if json_data is not None:
            pulumi.set(__self__, "json_data", json_data)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_document_id is not None:
            pulumi.set(__self__, "parent_document_id", parent_document_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if struct_data is not None:
            pulumi.set(__self__, "struct_data", struct_data)

    @property
    @pulumi.getter(name="branchId")
    def branch_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "branch_id")

    @branch_id.setter
    def branch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "branch_id", value)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_store_id", value)

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Documents with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "document_id")

    @document_id.setter
    def document_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "document_id", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> pulumi.Input[str]:
        """
        The identifier of the schema located in the same data store.
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The identifier of the document. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="jsonData")
    def json_data(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON string representation of the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "json_data")

    @json_data.setter
    def json_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_data", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentDocumentId")
    def parent_document_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the parent document. Currently supports at most two level document hierarchy. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        """
        return pulumi.get(self, "parent_document_id")

    @parent_document_id.setter
    def parent_document_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_document_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="structData")
    def struct_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The structured JSON data for the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "struct_data")

    @struct_data.setter
    def struct_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "struct_data", value)


class Document(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_id: Optional[pulumi.Input[str]] = None,
                 data_store_id: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 json_data: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_document_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema_id: Optional[pulumi.Input[str]] = None,
                 struct_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a Document.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] document_id: Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Documents with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        :param pulumi.Input[str] id: Immutable. The identifier of the document. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        :param pulumi.Input[str] json_data: The JSON string representation of the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        :param pulumi.Input[str] name: Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[str] parent_document_id: The identifier of the parent document. Currently supports at most two level document hierarchy. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        :param pulumi.Input[str] schema_id: The identifier of the schema located in the same data store.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] struct_data: The structured JSON data for the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DocumentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Document.

        :param str resource_name: The name of the resource.
        :param DocumentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DocumentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_id: Optional[pulumi.Input[str]] = None,
                 data_store_id: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 json_data: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_document_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema_id: Optional[pulumi.Input[str]] = None,
                 struct_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DocumentArgs.__new__(DocumentArgs)

            if branch_id is None and not opts.urn:
                raise TypeError("Missing required property 'branch_id'")
            __props__.__dict__["branch_id"] = branch_id
            if data_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_id'")
            __props__.__dict__["data_store_id"] = data_store_id
            if document_id is None and not opts.urn:
                raise TypeError("Missing required property 'document_id'")
            __props__.__dict__["document_id"] = document_id
            __props__.__dict__["id"] = id
            __props__.__dict__["json_data"] = json_data
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_document_id"] = parent_document_id
            __props__.__dict__["project"] = project
            if schema_id is None and not opts.urn:
                raise TypeError("Missing required property 'schema_id'")
            __props__.__dict__["schema_id"] = schema_id
            __props__.__dict__["struct_data"] = struct_data
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["branch_id", "data_store_id", "document_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Document, __self__).__init__(
            'google-native:discoveryengine/v1beta:Document',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Document':
        """
        Get an existing Document resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DocumentArgs.__new__(DocumentArgs)

        __props__.__dict__["branch_id"] = None
        __props__.__dict__["data_store_id"] = None
        __props__.__dict__["document_id"] = None
        __props__.__dict__["json_data"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parent_document_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["schema_id"] = None
        __props__.__dict__["struct_data"] = None
        return Document(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchId")
    def branch_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "branch_id")

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Documents with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "document_id")

    @property
    @pulumi.getter(name="jsonData")
    def json_data(self) -> pulumi.Output[str]:
        """
        The JSON string representation of the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "json_data")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentDocumentId")
    def parent_document_id(self) -> pulumi.Output[str]:
        """
        The identifier of the parent document. Currently supports at most two level document hierarchy. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
        """
        return pulumi.get(self, "parent_document_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> pulumi.Output[str]:
        """
        The identifier of the schema located in the same data store.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="structData")
    def struct_data(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The structured JSON data for the document. It should conform to the registered schema or an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "struct_data")

