# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSecuritySettingResult',
    'AwaitableGetSecuritySettingResult',
    'get_security_setting',
    'get_security_setting_output',
]

@pulumi.output_type
class GetSecuritySettingResult:
    def __init__(__self__, audio_export_settings=None, deidentify_template=None, display_name=None, insights_export_settings=None, inspect_template=None, name=None, purge_data_types=None, redaction_scope=None, redaction_strategy=None, retention_window_days=None):
        if audio_export_settings and not isinstance(audio_export_settings, dict):
            raise TypeError("Expected argument 'audio_export_settings' to be a dict")
        pulumi.set(__self__, "audio_export_settings", audio_export_settings)
        if deidentify_template and not isinstance(deidentify_template, str):
            raise TypeError("Expected argument 'deidentify_template' to be a str")
        pulumi.set(__self__, "deidentify_template", deidentify_template)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if insights_export_settings and not isinstance(insights_export_settings, dict):
            raise TypeError("Expected argument 'insights_export_settings' to be a dict")
        pulumi.set(__self__, "insights_export_settings", insights_export_settings)
        if inspect_template and not isinstance(inspect_template, str):
            raise TypeError("Expected argument 'inspect_template' to be a str")
        pulumi.set(__self__, "inspect_template", inspect_template)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if purge_data_types and not isinstance(purge_data_types, list):
            raise TypeError("Expected argument 'purge_data_types' to be a list")
        pulumi.set(__self__, "purge_data_types", purge_data_types)
        if redaction_scope and not isinstance(redaction_scope, str):
            raise TypeError("Expected argument 'redaction_scope' to be a str")
        pulumi.set(__self__, "redaction_scope", redaction_scope)
        if redaction_strategy and not isinstance(redaction_strategy, str):
            raise TypeError("Expected argument 'redaction_strategy' to be a str")
        pulumi.set(__self__, "redaction_strategy", redaction_strategy)
        if retention_window_days and not isinstance(retention_window_days, int):
            raise TypeError("Expected argument 'retention_window_days' to be a int")
        pulumi.set(__self__, "retention_window_days", retention_window_days)

    @property
    @pulumi.getter(name="audioExportSettings")
    def audio_export_settings(self) -> 'outputs.GoogleCloudDialogflowCxV3SecuritySettingsAudioExportSettingsResponse':
        """
        Controls audio export settings for post-conversation analytics when ingesting audio to conversations via Participants.AnalyzeContent or Participants.StreamingAnalyzeContent. If retention_strategy is set to REMOVE_AFTER_CONVERSATION or audio_export_settings.gcs_bucket is empty, audio export is disabled. If audio export is enabled, audio is recorded and saved to audio_export_settings.gcs_bucket, subject to retention policy of audio_export_settings.gcs_bucket. This setting won't effect audio input for implicit sessions via Sessions.DetectIntent or Sessions.StreamingDetectIntent.
        """
        return pulumi.get(self, "audio_export_settings")

    @property
    @pulumi.getter(name="deidentifyTemplate")
    def deidentify_template(self) -> str:
        """
        [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. The `DLP De-identify Templates Reader` role is needed on the Dialogflow service identity service account (has the form `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`) for your agent's project. If empty, Dialogflow replaces sensitive info with `[redacted]` text. The template name will have one of the following formats: `projects//locations//deidentifyTemplates/` OR `organizations//locations//deidentifyTemplates/` Note: `deidentify_template` must be located in the same region as the `SecuritySettings`.
        """
        return pulumi.get(self, "deidentify_template")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the security settings, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="insightsExportSettings")
    def insights_export_settings(self) -> 'outputs.GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettingsResponse':
        """
        Controls conversation exporting settings to Insights after conversation is completed. If retention_strategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
        """
        return pulumi.get(self, "insights_export_settings")

    @property
    @pulumi.getter(name="inspectTemplate")
    def inspect_template(self) -> str:
        """
        [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. The `DLP Inspect Templates Reader` role is needed on the Dialogflow service identity service account (has the form `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`) for your agent's project. If empty, we use the default DLP inspect config. The template name will have one of the following formats: `projects//locations//inspectTemplates/` OR `organizations//locations//inspectTemplates/` Note: `inspect_template` must be located in the same region as the `SecuritySettings`.
        """
        return pulumi.get(self, "inspect_template")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the settings. Required for the SecuritySettingsService.UpdateSecuritySettings method. SecuritySettingsService.CreateSecuritySettings populates the name automatically. Format: `projects//locations//securitySettings/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purgeDataTypes")
    def purge_data_types(self) -> Sequence[str]:
        """
        List of types of data to remove when retention settings triggers purge.
        """
        return pulumi.get(self, "purge_data_types")

    @property
    @pulumi.getter(name="redactionScope")
    def redaction_scope(self) -> str:
        """
        Defines the data for which Dialogflow applies redaction. Dialogflow does not redact data that it does not have access to – for example, Cloud logging.
        """
        return pulumi.get(self, "redaction_scope")

    @property
    @pulumi.getter(name="redactionStrategy")
    def redaction_strategy(self) -> str:
        """
        Strategy that defines how we do redaction.
        """
        return pulumi.get(self, "redaction_strategy")

    @property
    @pulumi.getter(name="retentionWindowDays")
    def retention_window_days(self) -> int:
        """
        Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
        """
        return pulumi.get(self, "retention_window_days")


class AwaitableGetSecuritySettingResult(GetSecuritySettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecuritySettingResult(
            audio_export_settings=self.audio_export_settings,
            deidentify_template=self.deidentify_template,
            display_name=self.display_name,
            insights_export_settings=self.insights_export_settings,
            inspect_template=self.inspect_template,
            name=self.name,
            purge_data_types=self.purge_data_types,
            redaction_scope=self.redaction_scope,
            redaction_strategy=self.redaction_strategy,
            retention_window_days=self.retention_window_days)


def get_security_setting(location: Optional[str] = None,
                         project: Optional[str] = None,
                         security_setting_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecuritySettingResult:
    """
    Retrieves the specified SecuritySettings. The returned settings may be stale by up to 1 minute.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['securitySettingId'] = security_setting_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dialogflow/v3:getSecuritySetting', __args__, opts=opts, typ=GetSecuritySettingResult).value

    return AwaitableGetSecuritySettingResult(
        audio_export_settings=__ret__.audio_export_settings,
        deidentify_template=__ret__.deidentify_template,
        display_name=__ret__.display_name,
        insights_export_settings=__ret__.insights_export_settings,
        inspect_template=__ret__.inspect_template,
        name=__ret__.name,
        purge_data_types=__ret__.purge_data_types,
        redaction_scope=__ret__.redaction_scope,
        redaction_strategy=__ret__.redaction_strategy,
        retention_window_days=__ret__.retention_window_days)


@_utilities.lift_output_func(get_security_setting)
def get_security_setting_output(location: Optional[pulumi.Input[str]] = None,
                                project: Optional[pulumi.Input[Optional[str]]] = None,
                                security_setting_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecuritySettingResult]:
    """
    Retrieves the specified SecuritySettings. The returned settings may be stale by up to 1 minute.
    """
    ...
