# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNodeGroupResult',
    'AwaitableGetNodeGroupResult',
    'get_node_group',
    'get_node_group_output',
]

@pulumi.output_type
class GetNodeGroupResult:
    def __init__(__self__, labels=None, name=None, node_group_config=None, roles=None):
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_group_config and not isinstance(node_group_config, dict):
            raise TypeError("Expected argument 'node_group_config' to be a dict")
        pulumi.set(__self__, "node_group_config", node_group_config)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Node group labels. Label keys must consist of from 1 to 63 characters and conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values can be empty. If specified, they must consist of from 1 to 63 characters and conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). The node group must have no more than 32 labelsn.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Node group resource name (https://aip.dev/122).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeGroupConfig")
    def node_group_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The node group instance group configuration.
        """
        return pulumi.get(self, "node_group_config")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        Node group roles.
        """
        return pulumi.get(self, "roles")


class AwaitableGetNodeGroupResult(GetNodeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeGroupResult(
            labels=self.labels,
            name=self.name,
            node_group_config=self.node_group_config,
            roles=self.roles)


def get_node_group(cluster_id: Optional[str] = None,
                   node_group_id: Optional[str] = None,
                   project: Optional[str] = None,
                   region_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeGroupResult:
    """
    Gets the resource representation for a node group in a cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['nodeGroupId'] = node_group_id
    __args__['project'] = project
    __args__['regionId'] = region_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataproc/v1:getNodeGroup', __args__, opts=opts, typ=GetNodeGroupResult).value

    return AwaitableGetNodeGroupResult(
        labels=__ret__.labels,
        name=__ret__.name,
        node_group_config=__ret__.node_group_config,
        roles=__ret__.roles)


@_utilities.lift_output_func(get_node_group)
def get_node_group_output(cluster_id: Optional[pulumi.Input[str]] = None,
                          node_group_id: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          region_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodeGroupResult]:
    """
    Gets the resource representation for a node group in a cluster.
    """
    ...
