# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EntityArgs', 'Entity']

@pulumi.input_type
class EntityArgs:
    def __init__(__self__, *,
                 asset: pulumi.Input[str],
                 data_path: pulumi.Input[str],
                 format: pulumi.Input['GoogleCloudDataplexV1StorageFormatArgs'],
                 id: pulumi.Input[str],
                 lake_id: pulumi.Input[str],
                 schema: pulumi.Input['GoogleCloudDataplexV1SchemaArgs'],
                 system: pulumi.Input['EntitySystem'],
                 type: pulumi.Input['EntityType'],
                 data_path_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Entity resource.
        :param pulumi.Input[str] asset: Immutable. The ID of the asset associated with the storage location containing the entity data. The entity must be with in the same zone with the asset.
        :param pulumi.Input[str] data_path: Immutable. The storage path of the entity data. For Cloud Storage data, this is the fully-qualified path to the entity, such as gs://bucket/path/to/data. For BigQuery data, this is the name of the table resource, such as projects/project_id/datasets/dataset_id/tables/table_id.
        :param pulumi.Input['GoogleCloudDataplexV1StorageFormatArgs'] format: Identifies the storage format of the entity data. It does not apply to entities with data stored in BigQuery.
        :param pulumi.Input[str] id: A user-provided entity ID. It is mutable, and will be used as the published table name. Specifying a new ID in an update entity request will override the existing value. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores. Must begin with a letter and consist of 256 or fewer characters.
        :param pulumi.Input['GoogleCloudDataplexV1SchemaArgs'] schema: The description of the data structure and layout. The schema is not included in list responses. It is only included in SCHEMA and FULL entity views of a GetEntity response.
        :param pulumi.Input['EntitySystem'] system: Immutable. Identifies the storage system of the entity data.
        :param pulumi.Input['EntityType'] type: Immutable. The type of entity.
        :param pulumi.Input[str] data_path_pattern: Optional. The set of items within the data path constituting the data in the entity, represented as a glob path. Example: gs://bucket/path/to/data/**/*.csv.
        :param pulumi.Input[str] description: Optional. User friendly longer description text. Must be shorter than or equal to 1024 characters.
        :param pulumi.Input[str] display_name: Optional. Display name must be shorter than or equal to 256 characters.
        :param pulumi.Input[str] etag: Optional. The etag associated with the entity, which can be retrieved with a GetEntity request. Required for update and delete requests.
        :param pulumi.Input[bool] validate_only: Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        pulumi.set(__self__, "asset", asset)
        pulumi.set(__self__, "data_path", data_path)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lake_id", lake_id)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "system", system)
        pulumi.set(__self__, "type", type)
        if data_path_pattern is not None:
            pulumi.set(__self__, "data_path_pattern", data_path_pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def asset(self) -> pulumi.Input[str]:
        """
        Immutable. The ID of the asset associated with the storage location containing the entity data. The entity must be with in the same zone with the asset.
        """
        return pulumi.get(self, "asset")

    @asset.setter
    def asset(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset", value)

    @property
    @pulumi.getter(name="dataPath")
    def data_path(self) -> pulumi.Input[str]:
        """
        Immutable. The storage path of the entity data. For Cloud Storage data, this is the fully-qualified path to the entity, such as gs://bucket/path/to/data. For BigQuery data, this is the name of the table resource, such as projects/project_id/datasets/dataset_id/tables/table_id.
        """
        return pulumi.get(self, "data_path")

    @data_path.setter
    def data_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_path", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input['GoogleCloudDataplexV1StorageFormatArgs']:
        """
        Identifies the storage format of the entity data. It does not apply to entities with data stored in BigQuery.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input['GoogleCloudDataplexV1StorageFormatArgs']):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A user-provided entity ID. It is mutable, and will be used as the published table name. Specifying a new ID in an update entity request will override the existing value. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores. Must begin with a letter and consist of 256 or fewer characters.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "lake_id")

    @lake_id.setter
    def lake_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "lake_id", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input['GoogleCloudDataplexV1SchemaArgs']:
        """
        The description of the data structure and layout. The schema is not included in list responses. It is only included in SCHEMA and FULL entity views of a GetEntity response.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input['GoogleCloudDataplexV1SchemaArgs']):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def system(self) -> pulumi.Input['EntitySystem']:
        """
        Immutable. Identifies the storage system of the entity data.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: pulumi.Input['EntitySystem']):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['EntityType']:
        """
        Immutable. The type of entity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['EntityType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dataPathPattern")
    def data_path_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The set of items within the data path constituting the data in the entity, represented as a glob path. Example: gs://bucket/path/to/data/**/*.csv.
        """
        return pulumi.get(self, "data_path_pattern")

    @data_path_pattern.setter
    def data_path_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_path_pattern", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User friendly longer description text. Must be shorter than or equal to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Display name must be shorter than or equal to 256 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The etag associated with the entity, which can be retrieved with a GetEntity request. Required for update and delete requests.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_only", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Entity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset: Optional[pulumi.Input[str]] = None,
                 data_path: Optional[pulumi.Input[str]] = None,
                 data_path_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1StorageFormatArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lake_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1SchemaArgs']]] = None,
                 system: Optional[pulumi.Input['EntitySystem']] = None,
                 type: Optional[pulumi.Input['EntityType']] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a metadata entity.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] asset: Immutable. The ID of the asset associated with the storage location containing the entity data. The entity must be with in the same zone with the asset.
        :param pulumi.Input[str] data_path: Immutable. The storage path of the entity data. For Cloud Storage data, this is the fully-qualified path to the entity, such as gs://bucket/path/to/data. For BigQuery data, this is the name of the table resource, such as projects/project_id/datasets/dataset_id/tables/table_id.
        :param pulumi.Input[str] data_path_pattern: Optional. The set of items within the data path constituting the data in the entity, represented as a glob path. Example: gs://bucket/path/to/data/**/*.csv.
        :param pulumi.Input[str] description: Optional. User friendly longer description text. Must be shorter than or equal to 1024 characters.
        :param pulumi.Input[str] display_name: Optional. Display name must be shorter than or equal to 256 characters.
        :param pulumi.Input[str] etag: Optional. The etag associated with the entity, which can be retrieved with a GetEntity request. Required for update and delete requests.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1StorageFormatArgs']] format: Identifies the storage format of the entity data. It does not apply to entities with data stored in BigQuery.
        :param pulumi.Input[str] id: A user-provided entity ID. It is mutable, and will be used as the published table name. Specifying a new ID in an update entity request will override the existing value. The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores. Must begin with a letter and consist of 256 or fewer characters.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1SchemaArgs']] schema: The description of the data structure and layout. The schema is not included in list responses. It is only included in SCHEMA and FULL entity views of a GetEntity response.
        :param pulumi.Input['EntitySystem'] system: Immutable. Identifies the storage system of the entity data.
        :param pulumi.Input['EntityType'] type: Immutable. The type of entity.
        :param pulumi.Input[bool] validate_only: Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a metadata entity.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param EntityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset: Optional[pulumi.Input[str]] = None,
                 data_path: Optional[pulumi.Input[str]] = None,
                 data_path_pattern: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1StorageFormatArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lake_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDataplexV1SchemaArgs']]] = None,
                 system: Optional[pulumi.Input['EntitySystem']] = None,
                 type: Optional[pulumi.Input['EntityType']] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntityArgs.__new__(EntityArgs)

            if asset is None and not opts.urn:
                raise TypeError("Missing required property 'asset'")
            __props__.__dict__["asset"] = asset
            if data_path is None and not opts.urn:
                raise TypeError("Missing required property 'data_path'")
            __props__.__dict__["data_path"] = data_path
            __props__.__dict__["data_path_pattern"] = data_path_pattern
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["etag"] = etag
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            if id is None and not opts.urn:
                raise TypeError("Missing required property 'id'")
            __props__.__dict__["id"] = id
            if lake_id is None and not opts.urn:
                raise TypeError("Missing required property 'lake_id'")
            __props__.__dict__["lake_id"] = lake_id
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if system is None and not opts.urn:
                raise TypeError("Missing required property 'system'")
            __props__.__dict__["system"] = system
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["validate_only"] = validate_only
            __props__.__dict__["zone"] = zone
            __props__.__dict__["access"] = None
            __props__.__dict__["catalog_entry"] = None
            __props__.__dict__["compatibility"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["lake_id", "location", "project", "zone"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Entity, __self__).__init__(
            'google-native:dataplex/v1:Entity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Entity':
        """
        Get an existing Entity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EntityArgs.__new__(EntityArgs)

        __props__.__dict__["access"] = None
        __props__.__dict__["asset"] = None
        __props__.__dict__["catalog_entry"] = None
        __props__.__dict__["compatibility"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["data_path"] = None
        __props__.__dict__["data_path_pattern"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["format"] = None
        __props__.__dict__["lake_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["system"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["validate_only"] = None
        __props__.__dict__["zone"] = None
        return Entity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1StorageAccessResponse']:
        """
        Identifies the access mechanism to the entity. Not user settable.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def asset(self) -> pulumi.Output[str]:
        """
        Immutable. The ID of the asset associated with the storage location containing the entity data. The entity must be with in the same zone with the asset.
        """
        return pulumi.get(self, "asset")

    @property
    @pulumi.getter(name="catalogEntry")
    def catalog_entry(self) -> pulumi.Output[str]:
        """
        The name of the associated Data Catalog entry.
        """
        return pulumi.get(self, "catalog_entry")

    @property
    @pulumi.getter
    def compatibility(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1EntityCompatibilityStatusResponse']:
        """
        Metadata stores that the entity is compatible with.
        """
        return pulumi.get(self, "compatibility")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the entity was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataPath")
    def data_path(self) -> pulumi.Output[str]:
        """
        Immutable. The storage path of the entity data. For Cloud Storage data, this is the fully-qualified path to the entity, such as gs://bucket/path/to/data. For BigQuery data, this is the name of the table resource, such as projects/project_id/datasets/dataset_id/tables/table_id.
        """
        return pulumi.get(self, "data_path")

    @property
    @pulumi.getter(name="dataPathPattern")
    def data_path_pattern(self) -> pulumi.Output[str]:
        """
        Optional. The set of items within the data path constituting the data in the entity, represented as a glob path. Example: gs://bucket/path/to/data/**/*.csv.
        """
        return pulumi.get(self, "data_path_pattern")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. User friendly longer description text. Must be shorter than or equal to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Optional. Display name must be shorter than or equal to 256 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Optional. The etag associated with the entity, which can be retrieved with a GetEntity request. Required for update and delete requests.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1StorageFormatResponse']:
        """
        Identifies the storage format of the entity data. It does not apply to entities with data stored in BigQuery.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the entity, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output['outputs.GoogleCloudDataplexV1SchemaResponse']:
        """
        The description of the data structure and layout. The schema is not included in list responses. It is only included in SCHEMA and FULL entity views of a GetEntity response.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[str]:
        """
        Immutable. Identifies the storage system of the entity data.
        """
        return pulumi.get(self, "system")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Immutable. The type of entity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System generated unique ID for the Entity. This ID will be different if the Entity is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the entity was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Only validate the request, but do not perform mutations. The default is false.
        """
        return pulumi.get(self, "validate_only")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        return pulumi.get(self, "zone")

