# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs',
    'GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs',
    'GoogleCloudDataplexV1AssetDiscoverySpecArgs',
    'GoogleCloudDataplexV1AssetResourceSpecArgs',
    'GoogleCloudDataplexV1ContentNotebookArgs',
    'GoogleCloudDataplexV1ContentSqlScriptArgs',
    'GoogleCloudDataplexV1DataAccessSpecArgs',
    'GoogleCloudDataplexV1DataAttributeBindingPathArgs',
    'GoogleCloudDataplexV1DataProfileSpecArgs',
    'GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs',
    'GoogleCloudDataplexV1DataQualityRuleArgs',
    'GoogleCloudDataplexV1DataQualitySpecArgs',
    'GoogleCloudDataplexV1DataScanExecutionSpecArgs',
    'GoogleCloudDataplexV1DataSourceArgs',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecArgs',
    'GoogleCloudDataplexV1EnvironmentSessionSpecArgs',
    'GoogleCloudDataplexV1LakeMetastoreArgs',
    'GoogleCloudDataplexV1ResourceAccessSpecArgs',
    'GoogleCloudDataplexV1SchemaPartitionFieldArgs',
    'GoogleCloudDataplexV1SchemaSchemaFieldArgs',
    'GoogleCloudDataplexV1SchemaArgs',
    'GoogleCloudDataplexV1StorageFormatCsvOptionsArgs',
    'GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs',
    'GoogleCloudDataplexV1StorageFormatJsonOptionsArgs',
    'GoogleCloudDataplexV1StorageFormatArgs',
    'GoogleCloudDataplexV1TaskExecutionSpecArgs',
    'GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs',
    'GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs',
    'GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs',
    'GoogleCloudDataplexV1TaskInfrastructureSpecArgs',
    'GoogleCloudDataplexV1TaskNotebookTaskConfigArgs',
    'GoogleCloudDataplexV1TaskSparkTaskConfigArgs',
    'GoogleCloudDataplexV1TaskTriggerSpecArgs',
    'GoogleCloudDataplexV1TriggerOnDemandArgs',
    'GoogleCloudDataplexV1TriggerScheduleArgs',
    'GoogleCloudDataplexV1TriggerArgs',
    'GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs',
    'GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs',
    'GoogleCloudDataplexV1ZoneDiscoverySpecArgs',
    'GoogleCloudDataplexV1ZoneResourceSpecArgs',
    'GoogleIamV1AuditConfigArgs',
    'GoogleIamV1AuditLogConfigArgs',
    'GoogleIamV1BindingArgs',
    'GoogleTypeExprArgs',
]

@pulumi.input_type
class GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 disable_type_inference: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 header_rows: Optional[pulumi.Input[int]] = None):
        """
        Describe CSV and similar semi-structured data formats.
        :param pulumi.Input[str] delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param pulumi.Input[bool] disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param pulumi.Input[int] header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if header_rows is not None:
            pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @disable_type_inference.setter
    def disable_type_inference(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_type_inference", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")

    @header_rows.setter
    def header_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "header_rows", value)


@pulumi.input_type
class GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs:
    def __init__(__self__, *,
                 disable_type_inference: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None):
        """
        Describe JSON data format.
        :param pulumi.Input[bool] disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @disable_type_inference.setter
    def disable_type_inference(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_type_inference", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)


@pulumi.input_type
class GoogleCloudDataplexV1AssetDiscoverySpecArgs:
    def __init__(__self__, *,
                 csv_options: Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 json_options: Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs']] = None,
                 schedule: Optional[pulumi.Input[str]] = None):
        """
        Settings to manage the metadata discovery and publishing for an asset.
        :param pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs'] csv_options: Optional. Configuration for CSV data.
        :param pulumi.Input[bool] enabled: Optional. Whether discovery is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs'] json_options: Optional. Configuration for Json data.
        :param pulumi.Input[str] schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
        """
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_patterns is not None:
            pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        if include_patterns is not None:
            pulumi.set(__self__, "include_patterns", include_patterns)
        if json_options is not None:
            pulumi.set(__self__, "json_options", json_options)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs']]:
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @csv_options.setter
    def csv_options(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsArgs']]):
        pulumi.set(self, "csv_options", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @exclude_patterns.setter
    def exclude_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_patterns", value)

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @include_patterns.setter
    def include_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_patterns", value)

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs']]:
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @json_options.setter
    def json_options(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsArgs']]):
        pulumi.set(self, "json_options", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class GoogleCloudDataplexV1AssetResourceSpecArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecType'],
                 name: Optional[pulumi.Input[str]] = None,
                 read_access_mode: Optional[pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecReadAccessMode']] = None):
        """
        Identifies the cloud resource that is referenced by this asset.
        :param pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecType'] type: Immutable. Type of resource.
        :param pulumi.Input[str] name: Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: projects/{project_number}/buckets/{bucket_id} projects/{project_number}/datasets/{dataset_id}
        :param pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecReadAccessMode'] read_access_mode: Optional. Determines how read permissions are handled for each asset and their associated tables. Only available to storage buckets assets.
        """
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_access_mode is not None:
            pulumi.set(__self__, "read_access_mode", read_access_mode)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecType']:
        """
        Immutable. Type of resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: projects/{project_number}/buckets/{bucket_id} projects/{project_number}/datasets/{dataset_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readAccessMode")
    def read_access_mode(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecReadAccessMode']]:
        """
        Optional. Determines how read permissions are handled for each asset and their associated tables. Only available to storage buckets assets.
        """
        return pulumi.get(self, "read_access_mode")

    @read_access_mode.setter
    def read_access_mode(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1AssetResourceSpecReadAccessMode']]):
        pulumi.set(self, "read_access_mode", value)


@pulumi.input_type
class GoogleCloudDataplexV1ContentNotebookArgs:
    def __init__(__self__, *,
                 kernel_type: pulumi.Input['GoogleCloudDataplexV1ContentNotebookKernelType']):
        """
        Configuration for Notebook content.
        :param pulumi.Input['GoogleCloudDataplexV1ContentNotebookKernelType'] kernel_type: Kernel Type of the notebook.
        """
        pulumi.set(__self__, "kernel_type", kernel_type)

    @property
    @pulumi.getter(name="kernelType")
    def kernel_type(self) -> pulumi.Input['GoogleCloudDataplexV1ContentNotebookKernelType']:
        """
        Kernel Type of the notebook.
        """
        return pulumi.get(self, "kernel_type")

    @kernel_type.setter
    def kernel_type(self, value: pulumi.Input['GoogleCloudDataplexV1ContentNotebookKernelType']):
        pulumi.set(self, "kernel_type", value)


@pulumi.input_type
class GoogleCloudDataplexV1ContentSqlScriptArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptEngine']):
        """
        Configuration for the Sql Script content.
        :param pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptEngine'] engine: Query Engine to be used for the Sql Query.
        """
        pulumi.set(__self__, "engine", engine)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptEngine']:
        """
        Query Engine to be used for the Sql Query.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input['GoogleCloudDataplexV1ContentSqlScriptEngine']):
        pulumi.set(self, "engine", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataAccessSpecArgs:
    def __init__(__self__, *,
                 readers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DataAccessSpec holds the access control configuration to be enforced on data stored within resources (eg: rows, columns in BigQuery Tables). When associated with data, the data is only accessible to principals explicitly granted access through the DataAccessSpec. Principals with access to the containing resource are not implicitly granted access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readers: Optional. The format of strings follows the pattern followed by IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}. The set of principals to be granted reader role on data stored within resources.
        """
        if readers is not None:
            pulumi.set(__self__, "readers", readers)

    @property
    @pulumi.getter
    def readers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The format of strings follows the pattern followed by IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}. The set of principals to be granted reader role on data stored within resources.
        """
        return pulumi.get(self, "readers")

    @readers.setter
    def readers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "readers", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataAttributeBindingPathArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a subresource of a given resource, and associated bindings with it.
        :param pulumi.Input[str] name: The name identifier of the path. Nested columns should be of the form: 'country.state.city'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributes: Optional. List of attributes to be associated with the path of the resource, provided in the form: projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
        """
        pulumi.set(__self__, "name", name)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name identifier of the path. Nested columns should be of the form: 'country.state.city'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. List of attributes to be associated with the path of the resource, provided in the form: projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataProfileSpecArgs:
    def __init__(__self__):
        """
        DataProfileScan related setting.
        """
        pass


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs:
    def __init__(__self__):
        """
        Evaluates whether each column value is null.
        """
        pass


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs:
    def __init__(__self__, *,
                 max_value: Optional[pulumi.Input[str]] = None,
                 min_value: Optional[pulumi.Input[str]] = None,
                 strict_max_enabled: Optional[pulumi.Input[bool]] = None,
                 strict_min_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Evaluates whether each column value lies between a specified range.
        :param pulumi.Input[str] max_value: Optional. The maximum column value allowed for a row to pass this validation. At least one of min_value and max_value need to be provided.
        :param pulumi.Input[str] min_value: Optional. The minimum column value allowed for a row to pass this validation. At least one of min_value and max_value need to be provided.
        :param pulumi.Input[bool] strict_max_enabled: Optional. Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.Only relevant if a max_value has been defined. Default = false.
        :param pulumi.Input[bool] strict_min_enabled: Optional. Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.Only relevant if a min_value has been defined. Default = false.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The maximum column value allowed for a row to pass this validation. At least one of min_value and max_value need to be provided.
        """
        return pulumi.get(self, "max_value")

    @max_value.setter
    def max_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_value", value)

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The minimum column value allowed for a row to pass this validation. At least one of min_value and max_value need to be provided.
        """
        return pulumi.get(self, "min_value")

    @min_value.setter
    def min_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_value", value)

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.Only relevant if a max_value has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @strict_max_enabled.setter
    def strict_max_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_max_enabled", value)

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.Only relevant if a min_value has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")

    @strict_min_enabled.setter
    def strict_min_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_min_enabled", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs:
    def __init__(__self__, *,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        Evaluates whether each column value matches a specified regex.
        :param pulumi.Input[str] regex: A regular expression the column value is expected to match.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression the column value is expected to match.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs:
    def __init__(__self__, *,
                 sql_expression: Optional[pulumi.Input[str]] = None):
        """
        Evaluates whether each row passes the specified condition.The SQL expression needs to use BigQuery standard SQL syntax and should produce a boolean value per row as the result.Example: col1 >= 0 AND col2 < 10
        :param pulumi.Input[str] sql_expression: The SQL expression.
        """
        if sql_expression is not None:
            pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")

    @sql_expression.setter
    def sql_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_expression", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Evaluates whether each column value is contained by a specified set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Expected values for the column value.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Expected values for the column value.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs:
    def __init__(__self__, *,
                 max_value: Optional[pulumi.Input[str]] = None,
                 min_value: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationStatistic']] = None,
                 strict_max_enabled: Optional[pulumi.Input[bool]] = None,
                 strict_min_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Evaluates whether the column aggregate statistic lies between a specified range.
        :param pulumi.Input[str] max_value: The maximum column statistic value allowed for a row to pass this validation.At least one of min_value and max_value need to be provided.
        :param pulumi.Input[str] min_value: The minimum column statistic value allowed for a row to pass this validation.At least one of min_value and max_value need to be provided.
        :param pulumi.Input[bool] strict_max_enabled: Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.Only relevant if a max_value has been defined. Default = false.
        :param pulumi.Input[bool] strict_min_enabled: Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.Only relevant if a min_value has been defined. Default = false.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum column statistic value allowed for a row to pass this validation.At least one of min_value and max_value need to be provided.
        """
        return pulumi.get(self, "max_value")

    @max_value.setter
    def max_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_value", value)

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum column statistic value allowed for a row to pass this validation.At least one of min_value and max_value need to be provided.
        """
        return pulumi.get(self, "min_value")

    @min_value.setter
    def min_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_value", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationStatistic']]:
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationStatistic']]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.Only relevant if a max_value has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @strict_max_enabled.setter
    def strict_max_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_max_enabled", value)

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.Only relevant if a min_value has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")

    @strict_min_enabled.setter
    def strict_min_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_min_enabled", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs:
    def __init__(__self__, *,
                 sql_expression: Optional[pulumi.Input[str]] = None):
        """
        Evaluates whether the provided expression is true.The SQL expression needs to use BigQuery standard SQL syntax and should produce a scalar boolean result.Example: MIN(col1) >= 0
        :param pulumi.Input[str] sql_expression: The SQL expression.
        """
        if sql_expression is not None:
            pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")

    @sql_expression.setter
    def sql_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_expression", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs:
    def __init__(__self__):
        """
        Evaluates whether the column has duplicates.
        """
        pass


@pulumi.input_type
class GoogleCloudDataplexV1DataQualityRuleArgs:
    def __init__(__self__, *,
                 dimension: pulumi.Input[str],
                 column: Optional[pulumi.Input[str]] = None,
                 ignore_null: Optional[pulumi.Input[bool]] = None,
                 non_null_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs']] = None,
                 range_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs']] = None,
                 regex_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs']] = None,
                 row_condition_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs']] = None,
                 set_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs']] = None,
                 statistic_range_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs']] = None,
                 table_condition_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs']] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 uniqueness_expectation: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs']] = None):
        """
        A rule captures data quality intent about a data source.
        :param pulumi.Input[str] dimension: The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are "COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"
        :param pulumi.Input[str] column: Optional. The unnested column which this rule is evaluated against.
        :param pulumi.Input[bool] ignore_null: Optional. Rows with null values will automatically fail a rule, unless ignore_null is true. In that case, such null rows are trivially considered passing.Only applicable to ColumnMap rules.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs'] non_null_expectation: ColumnMap rule which evaluates whether each column value is null.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs'] range_expectation: ColumnMap rule which evaluates whether each column value lies between a specified range.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs'] regex_expectation: ColumnMap rule which evaluates whether each column value matches a specified regex.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs'] row_condition_expectation: Table rule which evaluates whether each row passes the specified condition.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs'] set_expectation: ColumnMap rule which evaluates whether each column value is contained by a specified set.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs'] statistic_range_expectation: ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs'] table_condition_expectation: Table rule which evaluates whether the provided expression is true.
        :param pulumi.Input[float] threshold: Optional. The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of 0.0, 1.0.0 indicates default value (i.e. 1.0).
        :param pulumi.Input['GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs'] uniqueness_expectation: ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        pulumi.set(__self__, "dimension", dimension)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if ignore_null is not None:
            pulumi.set(__self__, "ignore_null", ignore_null)
        if non_null_expectation is not None:
            pulumi.set(__self__, "non_null_expectation", non_null_expectation)
        if range_expectation is not None:
            pulumi.set(__self__, "range_expectation", range_expectation)
        if regex_expectation is not None:
            pulumi.set(__self__, "regex_expectation", regex_expectation)
        if row_condition_expectation is not None:
            pulumi.set(__self__, "row_condition_expectation", row_condition_expectation)
        if set_expectation is not None:
            pulumi.set(__self__, "set_expectation", set_expectation)
        if statistic_range_expectation is not None:
            pulumi.set(__self__, "statistic_range_expectation", statistic_range_expectation)
        if table_condition_expectation is not None:
            pulumi.set(__self__, "table_condition_expectation", table_condition_expectation)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if uniqueness_expectation is not None:
            pulumi.set(__self__, "uniqueness_expectation", uniqueness_expectation)

    @property
    @pulumi.getter
    def dimension(self) -> pulumi.Input[str]:
        """
        The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are "COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"
        """
        return pulumi.get(self, "dimension")

    @dimension.setter
    def dimension(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension", value)

    @property
    @pulumi.getter
    def column(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The unnested column which this rule is evaluated against.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="ignoreNull")
    def ignore_null(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Rows with null values will automatically fail a rule, unless ignore_null is true. In that case, such null rows are trivially considered passing.Only applicable to ColumnMap rules.
        """
        return pulumi.get(self, "ignore_null")

    @ignore_null.setter
    def ignore_null(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_null", value)

    @property
    @pulumi.getter(name="nonNullExpectation")
    def non_null_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs']]:
        """
        ColumnMap rule which evaluates whether each column value is null.
        """
        return pulumi.get(self, "non_null_expectation")

    @non_null_expectation.setter
    def non_null_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleNonNullExpectationArgs']]):
        pulumi.set(self, "non_null_expectation", value)

    @property
    @pulumi.getter(name="rangeExpectation")
    def range_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs']]:
        """
        ColumnMap rule which evaluates whether each column value lies between a specified range.
        """
        return pulumi.get(self, "range_expectation")

    @range_expectation.setter
    def range_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRangeExpectationArgs']]):
        pulumi.set(self, "range_expectation", value)

    @property
    @pulumi.getter(name="regexExpectation")
    def regex_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs']]:
        """
        ColumnMap rule which evaluates whether each column value matches a specified regex.
        """
        return pulumi.get(self, "regex_expectation")

    @regex_expectation.setter
    def regex_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRegexExpectationArgs']]):
        pulumi.set(self, "regex_expectation", value)

    @property
    @pulumi.getter(name="rowConditionExpectation")
    def row_condition_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs']]:
        """
        Table rule which evaluates whether each row passes the specified condition.
        """
        return pulumi.get(self, "row_condition_expectation")

    @row_condition_expectation.setter
    def row_condition_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleRowConditionExpectationArgs']]):
        pulumi.set(self, "row_condition_expectation", value)

    @property
    @pulumi.getter(name="setExpectation")
    def set_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs']]:
        """
        ColumnMap rule which evaluates whether each column value is contained by a specified set.
        """
        return pulumi.get(self, "set_expectation")

    @set_expectation.setter
    def set_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleSetExpectationArgs']]):
        pulumi.set(self, "set_expectation", value)

    @property
    @pulumi.getter(name="statisticRangeExpectation")
    def statistic_range_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs']]:
        """
        ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
        """
        return pulumi.get(self, "statistic_range_expectation")

    @statistic_range_expectation.setter
    def statistic_range_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationArgs']]):
        pulumi.set(self, "statistic_range_expectation", value)

    @property
    @pulumi.getter(name="tableConditionExpectation")
    def table_condition_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs']]:
        """
        Table rule which evaluates whether the provided expression is true.
        """
        return pulumi.get(self, "table_condition_expectation")

    @table_condition_expectation.setter
    def table_condition_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleTableConditionExpectationArgs']]):
        pulumi.set(self, "table_condition_expectation", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of 0.0, 1.0.0 indicates default value (i.e. 1.0).
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="uniquenessExpectation")
    def uniqueness_expectation(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs']]:
        """
        ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        return pulumi.get(self, "uniqueness_expectation")

    @uniqueness_expectation.setter
    def uniqueness_expectation(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleUniquenessExpectationArgs']]):
        pulumi.set(self, "uniqueness_expectation", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataQualitySpecArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleArgs']]]] = None):
        """
        DataQualityScan related setting.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleArgs']]] rules: The list of rules to evaluate against a data source. At least one rule is required.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleArgs']]]]:
        """
        The list of rules to evaluate against a data source. At least one rule is required.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1DataQualityRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataScanExecutionSpecArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerArgs']] = None):
        """
        DataScan execution settings.
        :param pulumi.Input[str] field: Immutable. The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time.If not specified, a data scan will run for all data in the table.
        :param pulumi.Input['GoogleCloudDataplexV1TriggerArgs'] trigger: Optional. Spec related to how often and when a scan should be triggered.If not specified, the default is OnDemand, which means the scan will not run until the user calls RunDataScan API.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time.If not specified, a data scan will run for all data in the table.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TriggerArgs']]:
        """
        Optional. Spec related to how often and when a scan should be triggered.If not specified, the default is OnDemand, which means the scan will not run until the user calls RunDataScan API.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class GoogleCloudDataplexV1DataSourceArgs:
    def __init__(__self__, *,
                 entity: Optional[pulumi.Input[str]] = None):
        """
        The data source for DataScan.
        :param pulumi.Input[str] entity: Immutable. The Dataplex entity that represents the data source (e.g. BigQuery table) for DataScan, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The Dataplex entity that represents the data source (e.g. BigQuery table) for DataScan, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)


@pulumi.input_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 node_count: Optional[pulumi.Input[int]] = None):
        """
        Compute resources associated with the analyze interactive workloads.
        :param pulumi.Input[int] disk_size_gb: Optional. Size in GB of the disk. Default is 100 GB.
        :param pulumi.Input[int] max_node_count: Optional. Max configurable nodes. If max_node_count > node_count, then auto-scaling is enabled.
        :param pulumi.Input[int] node_count: Optional. Total number of nodes in the sessions created for this environment.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Size in GB of the disk. Default is 100 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Max configurable nodes. If max_node_count > node_count, then auto-scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Total number of nodes in the sessions created for this environment.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)


@pulumi.input_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs:
    def __init__(__self__, *,
                 image_version: pulumi.Input[str],
                 java_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Software Runtime Configuration to run Analyze.
        :param pulumi.Input[str] image_version: Dataplex Image version.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] java_libraries: Optional. List of Java jars to be included in the runtime environment. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. Spark properties to provide configuration for use in sessions created for this environment. The properties to set on daemon config files. Property keys are specified in prefix:property format. The prefix must be "spark".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] python_packages: Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        pulumi.set(__self__, "image_version", image_version)
        if java_libraries is not None:
            pulumi.set(__self__, "java_libraries", java_libraries)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_packages is not None:
            pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> pulumi.Input[str]:
        """
        Dataplex Image version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="javaLibraries")
    def java_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. List of Java jars to be included in the runtime environment. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        """
        return pulumi.get(self, "java_libraries")

    @java_libraries.setter
    def java_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "java_libraries", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Spark properties to provide configuration for use in sessions created for this environment. The properties to set on daemon config files. Property keys are specified in prefix:property format. The prefix must be "spark".
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        return pulumi.get(self, "python_packages")

    @python_packages.setter
    def python_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "python_packages", value)


@pulumi.input_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecArgs:
    def __init__(__self__, *,
                 os_image: pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs'],
                 compute: Optional[pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs']] = None):
        """
        Configuration for the underlying infrastructure used to run workloads.
        :param pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs'] os_image: Software Runtime Configuration for analyze interactive workloads.
        :param pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs'] compute: Optional. Compute resources needed for analyze interactive workloads.
        """
        pulumi.set(__self__, "os_image", os_image)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs']:
        """
        Software Runtime Configuration for analyze interactive workloads.
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeArgs']):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs']]:
        """
        Optional. Compute resources needed for analyze interactive workloads.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesArgs']]):
        pulumi.set(self, "compute", value)


@pulumi.input_type
class GoogleCloudDataplexV1EnvironmentSessionSpecArgs:
    def __init__(__self__, *,
                 enable_fast_startup: Optional[pulumi.Input[bool]] = None,
                 max_idle_duration: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enable_fast_startup: Optional. If True, this causes sessions to be pre-created and available for faster startup to enable interactive exploration use-cases. This defaults to False to avoid additional billed charges. These can only be set to True for the environment with name set to "default", and with default configuration.
        :param pulumi.Input[str] max_idle_duration: Optional. The idle time configuration of the session. The session will be auto-terminated at the end of this period.
        """
        if enable_fast_startup is not None:
            pulumi.set(__self__, "enable_fast_startup", enable_fast_startup)
        if max_idle_duration is not None:
            pulumi.set(__self__, "max_idle_duration", max_idle_duration)

    @property
    @pulumi.getter(name="enableFastStartup")
    def enable_fast_startup(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If True, this causes sessions to be pre-created and available for faster startup to enable interactive exploration use-cases. This defaults to False to avoid additional billed charges. These can only be set to True for the environment with name set to "default", and with default configuration.
        """
        return pulumi.get(self, "enable_fast_startup")

    @enable_fast_startup.setter
    def enable_fast_startup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fast_startup", value)

    @property
    @pulumi.getter(name="maxIdleDuration")
    def max_idle_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The idle time configuration of the session. The session will be auto-terminated at the end of this period.
        """
        return pulumi.get(self, "max_idle_duration")

    @max_idle_duration.setter
    def max_idle_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_idle_duration", value)


@pulumi.input_type
class GoogleCloudDataplexV1LakeMetastoreArgs:
    def __init__(__self__, *,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Settings to manage association of Dataproc Metastore with a lake.
        :param pulumi.Input[str] service: Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: projects/{project_id}/locations/{location_id}/services/{service_id}
        """
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: projects/{project_id}/locations/{location_id}/services/{service_id}
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class GoogleCloudDataplexV1ResourceAccessSpecArgs:
    def __init__(__self__, *,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 readers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 writers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourceAccessSpec holds the access control configuration to be enforced on the resources, for example, Cloud Storage bucket, BigQuery dataset, BigQuery table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] owners: Optional. The set of principals to be granted owner role on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readers: Optional. The format of strings follows the pattern followed by IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}. The set of principals to be granted reader role on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] writers: Optional. The set of principals to be granted writer role on the resource.
        """
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if readers is not None:
            pulumi.set(__self__, "readers", readers)
        if writers is not None:
            pulumi.set(__self__, "writers", writers)

    @property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of principals to be granted owner role on the resource.
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "owners", value)

    @property
    @pulumi.getter
    def readers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The format of strings follows the pattern followed by IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}. The set of principals to be granted reader role on the resource.
        """
        return pulumi.get(self, "readers")

    @readers.setter
    def readers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "readers", value)

    @property
    @pulumi.getter
    def writers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of principals to be granted writer role on the resource.
        """
        return pulumi.get(self, "writers")

    @writers.setter
    def writers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "writers", value)


@pulumi.input_type
class GoogleCloudDataplexV1SchemaPartitionFieldArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldType']):
        """
        Represents a key field within the entity's partition structure. You could have up to 20 partition fields, but only the first 10 partitions have the filtering ability due to performance consideration. Note: Partition fields are immutable.
        :param pulumi.Input[str] name: Partition field name must consist of letters, numbers, and underscores only, with a maximum of length of 256 characters, and must begin with a letter or underscore..
        :param pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldType'] type: Immutable. The type of field.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Partition field name must consist of letters, numbers, and underscores only, with a maximum of length of 256 characters, and must begin with a letter or underscore..
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldType']:
        """
        Immutable. The type of field.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDataplexV1SchemaSchemaFieldArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldMode'],
                 name: pulumi.Input[str],
                 type: pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldType'],
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]] = None):
        """
        Represents a column field within a table schema.
        :param pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldMode'] mode: Additional field semantics.
        :param pulumi.Input[str] name: The name of the field. Must contain only letters, numbers and underscores, with a maximum length of 767 characters, and must begin with a letter or underscore.
        :param pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldType'] type: The type of field.
        :param pulumi.Input[str] description: Optional. User friendly field description. Must be less than or equal to 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]] fields: Optional. Any nested field for complex types.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldMode']:
        """
        Additional field semantics.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldMode']):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the field. Must contain only letters, numbers and underscores, with a maximum length of 767 characters, and must begin with a letter or underscore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldType']:
        """
        The type of field.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User friendly field description. Must be less than or equal to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]]:
        """
        Optional. Any nested field for complex types.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]]):
        pulumi.set(self, "fields", value)


@pulumi.input_type
class GoogleCloudDataplexV1SchemaArgs:
    def __init__(__self__, *,
                 user_managed: pulumi.Input[bool],
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]] = None,
                 partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldArgs']]]] = None,
                 partition_style: Optional[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionStyle']] = None):
        """
        Schema information describing the structure and layout of the data.
        :param pulumi.Input[bool] user_managed: Set to true if user-managed or false if managed by Dataplex. The default is false (managed by Dataplex). Set to falseto enable Dataplex discovery to update the schema. including new data discovery, schema inference, and schema evolution. Users retain the ability to input and edit the schema. Dataplex treats schema input by the user as though produced by a previous Dataplex discovery operation, and it will evolve the schema and take action based on that treatment. Set to true to fully manage the entity schema. This setting guarantees that Dataplex will not change schema fields.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]] fields: Optional. The sequence of fields describing data in table entities. Note: BigQuery SchemaFields are immutable.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldArgs']]] partition_fields: Optional. The sequence of fields describing the partition structure in entities. If this field is empty, there are no partitions within the data.
        :param pulumi.Input['GoogleCloudDataplexV1SchemaPartitionStyle'] partition_style: Optional. The structure of paths containing partition data within the entity.
        """
        pulumi.set(__self__, "user_managed", user_managed)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if partition_fields is not None:
            pulumi.set(__self__, "partition_fields", partition_fields)
        if partition_style is not None:
            pulumi.set(__self__, "partition_style", partition_style)

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> pulumi.Input[bool]:
        """
        Set to true if user-managed or false if managed by Dataplex. The default is false (managed by Dataplex). Set to falseto enable Dataplex discovery to update the schema. including new data discovery, schema inference, and schema evolution. Users retain the ability to input and edit the schema. Dataplex treats schema input by the user as though produced by a previous Dataplex discovery operation, and it will evolve the schema and take action based on that treatment. Set to true to fully manage the entity schema. This setting guarantees that Dataplex will not change schema fields.
        """
        return pulumi.get(self, "user_managed")

    @user_managed.setter
    def user_managed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "user_managed", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]]:
        """
        Optional. The sequence of fields describing data in table entities. Note: BigQuery SchemaFields are immutable.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaSchemaFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="partitionFields")
    def partition_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldArgs']]]]:
        """
        Optional. The sequence of fields describing the partition structure in entities. If this field is empty, there are no partitions within the data.
        """
        return pulumi.get(self, "partition_fields")

    @partition_fields.setter
    def partition_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionFieldArgs']]]]):
        pulumi.set(self, "partition_fields", value)

    @property
    @pulumi.getter(name="partitionStyle")
    def partition_style(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionStyle']]:
        """
        Optional. The structure of paths containing partition data within the entity.
        """
        return pulumi.get(self, "partition_style")

    @partition_style.setter
    def partition_style(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1SchemaPartitionStyle']]):
        pulumi.set(self, "partition_style", value)


@pulumi.input_type
class GoogleCloudDataplexV1StorageFormatCsvOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 header_rows: Optional[pulumi.Input[int]] = None,
                 quote: Optional[pulumi.Input[str]] = None):
        """
        Describes CSV and similar semi-structured data formats.
        :param pulumi.Input[str] delimiter: Optional. The delimiter used to separate values. Defaults to ','.
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
        :param pulumi.Input[int] header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows. Defaults to 0.
        :param pulumi.Input[str] quote: Optional. The character used to quote column values. Accepts '"' (double quotation mark) or ''' (single quotation mark). Defaults to '"' (double quotation mark) if unspecified.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if header_rows is not None:
            pulumi.set(__self__, "header_rows", header_rows)
        if quote is not None:
            pulumi.set(__self__, "quote", quote)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The delimiter used to separate values. Defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows. Defaults to 0.
        """
        return pulumi.get(self, "header_rows")

    @header_rows.setter
    def header_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "header_rows", value)

    @property
    @pulumi.getter
    def quote(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character used to quote column values. Accepts '"' (double quotation mark) or ''' (single quotation mark). Defaults to '"' (double quotation mark) if unspecified.
        """
        return pulumi.get(self, "quote")

    @quote.setter
    def quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote", value)


@pulumi.input_type
class GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs:
    def __init__(__self__, *,
                 metadata_location: Optional[pulumi.Input[str]] = None):
        """
        Describes Iceberg data format.
        :param pulumi.Input[str] metadata_location: Optional. The location of where the iceberg metadata is present, must be within the table path
        """
        if metadata_location is not None:
            pulumi.set(__self__, "metadata_location", metadata_location)

    @property
    @pulumi.getter(name="metadataLocation")
    def metadata_location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The location of where the iceberg metadata is present, must be within the table path
        """
        return pulumi.get(self, "metadata_location")

    @metadata_location.setter
    def metadata_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_location", value)


@pulumi.input_type
class GoogleCloudDataplexV1StorageFormatJsonOptionsArgs:
    def __init__(__self__, *,
                 encoding: Optional[pulumi.Input[str]] = None):
        """
        Describes JSON data format.
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not specified.
        """
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not specified.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)


@pulumi.input_type
class GoogleCloudDataplexV1StorageFormatArgs:
    def __init__(__self__, *,
                 mime_type: pulumi.Input[str],
                 compression_format: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCompressionFormat']] = None,
                 csv: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCsvOptionsArgs']] = None,
                 iceberg: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs']] = None,
                 json: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatJsonOptionsArgs']] = None):
        """
        Describes the format of the data within its storage location.
        :param pulumi.Input[str] mime_type: The mime type descriptor for the data. Must match the pattern {type}/{subtype}. Supported values: application/x-parquet application/x-avro application/x-orc application/x-tfrecord application/x-parquet+iceberg application/x-avro+iceberg application/x-orc+iceberg application/json application/{subtypes} text/csv text/ image/{image subtype} video/{video subtype} audio/{audio subtype}
        :param pulumi.Input['GoogleCloudDataplexV1StorageFormatCompressionFormat'] compression_format: Optional. The compression type associated with the stored data. If unspecified, the data is uncompressed.
        :param pulumi.Input['GoogleCloudDataplexV1StorageFormatCsvOptionsArgs'] csv: Optional. Additional information about CSV formatted data.
        :param pulumi.Input['GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs'] iceberg: Optional. Additional information about iceberg tables.
        :param pulumi.Input['GoogleCloudDataplexV1StorageFormatJsonOptionsArgs'] json: Optional. Additional information about CSV formatted data.
        """
        pulumi.set(__self__, "mime_type", mime_type)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if iceberg is not None:
            pulumi.set(__self__, "iceberg", iceberg)
        if json is not None:
            pulumi.set(__self__, "json", json)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> pulumi.Input[str]:
        """
        The mime type descriptor for the data. Must match the pattern {type}/{subtype}. Supported values: application/x-parquet application/x-avro application/x-orc application/x-tfrecord application/x-parquet+iceberg application/x-avro+iceberg application/x-orc+iceberg application/json application/{subtypes} text/csv text/ image/{image subtype} video/{video subtype} audio/{audio subtype}
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "mime_type", value)

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCompressionFormat']]:
        """
        Optional. The compression type associated with the stored data. If unspecified, the data is uncompressed.
        """
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCompressionFormat']]):
        pulumi.set(self, "compression_format", value)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCsvOptionsArgs']]:
        """
        Optional. Additional information about CSV formatted data.
        """
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatCsvOptionsArgs']]):
        pulumi.set(self, "csv", value)

    @property
    @pulumi.getter
    def iceberg(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs']]:
        """
        Optional. Additional information about iceberg tables.
        """
        return pulumi.get(self, "iceberg")

    @iceberg.setter
    def iceberg(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatIcebergOptionsArgs']]):
        pulumi.set(self, "iceberg", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatJsonOptionsArgs']]:
        """
        Optional. Additional information about CSV formatted data.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1StorageFormatJsonOptionsArgs']]):
        pulumi.set(self, "json", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskExecutionSpecArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input[str],
                 args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 max_job_execution_lifetime: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Execution related settings, like retry and service_account.
        :param pulumi.Input[str] service_account: Service account to use to execute a task. If not provided, the default Compute service account for the project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] args: Optional. The arguments to pass to the task. The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${task_id} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument.
        :param pulumi.Input[str] kms_key: Optional. The Cloud KMS key to use for encryption, of the form: projects/{project_number}/locations/{location_id}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
        :param pulumi.Input[str] max_job_execution_lifetime: Optional. The maximum duration after which the job execution is expired.
        :param pulumi.Input[str] project: Optional. The project in which jobs are run. By default, the project containing the Lake is used. If a project is provided, the ExecutionSpec.service_account must belong to this project.
        """
        pulumi.set(__self__, "service_account", service_account)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if max_job_execution_lifetime is not None:
            pulumi.set(__self__, "max_job_execution_lifetime", max_job_execution_lifetime)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[str]:
        """
        Service account to use to execute a task. If not provided, the default Compute service account for the project is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the task. The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${task_id} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud KMS key to use for encryption, of the form: projects/{project_number}/locations/{location_id}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="maxJobExecutionLifetime")
    def max_job_execution_lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The maximum duration after which the job execution is expired.
        """
        return pulumi.get(self, "max_job_execution_lifetime")

    @max_job_execution_lifetime.setter
    def max_job_execution_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_job_execution_lifetime", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The project in which jobs are run. By default, the project containing the Lake is used. If a project is provided, the ExecutionSpec.service_account must belong to this project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs:
    def __init__(__self__, *,
                 executors_count: Optional[pulumi.Input[int]] = None,
                 max_executors_count: Optional[pulumi.Input[int]] = None):
        """
        Batch compute resources associated with the task.
        :param pulumi.Input[int] executors_count: Optional. Total number of job executors. Executor Count should be between 2 and 100. Default=2
        :param pulumi.Input[int] max_executors_count: Optional. Max configurable executors. If max_executors_count > executors_count, then auto-scaling is enabled. Max Executor Count should be between 2 and 1000. Default=1000
        """
        if executors_count is not None:
            pulumi.set(__self__, "executors_count", executors_count)
        if max_executors_count is not None:
            pulumi.set(__self__, "max_executors_count", max_executors_count)

    @property
    @pulumi.getter(name="executorsCount")
    def executors_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Total number of job executors. Executor Count should be between 2 and 100. Default=2
        """
        return pulumi.get(self, "executors_count")

    @executors_count.setter
    def executors_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "executors_count", value)

    @property
    @pulumi.getter(name="maxExecutorsCount")
    def max_executors_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Max configurable executors. If max_executors_count > executors_count, then auto-scaling is enabled. Max Executor Count should be between 2 and 1000. Default=1000
        """
        return pulumi.get(self, "max_executors_count")

    @max_executors_count.setter
    def max_executors_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_executors_count", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs:
    def __init__(__self__, *,
                 image: Optional[pulumi.Input[str]] = None,
                 java_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Container Image Runtime Configuration used with Batch execution.
        :param pulumi.Input[str] image: Optional. Container image to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] java_jars: Optional. A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] python_packages: Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        if image is not None:
            pulumi.set(__self__, "image", image)
        if java_jars is not None:
            pulumi.set(__self__, "java_jars", java_jars)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_packages is not None:
            pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Container image to use.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="javaJars")
    def java_jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        """
        return pulumi.get(self, "java_jars")

    @java_jars.setter
    def java_jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "java_jars", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        return pulumi.get(self, "python_packages")

    @python_packages.setter
    def python_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "python_packages", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs:
    def __init__(__self__, *,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sub_network: Optional[pulumi.Input[str]] = None):
        """
        Cloud VPC Network used to run the infrastructure.
        :param pulumi.Input[str] network: Optional. The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: Optional. List of network tags to apply to the job.
        :param pulumi.Input[str] sub_network: Optional. The Cloud VPC sub-network in which the job is run.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if sub_network is not None:
            pulumi.set(__self__, "sub_network", sub_network)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. List of network tags to apply to the job.
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter(name="subNetwork")
    def sub_network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud VPC sub-network in which the job is run.
        """
        return pulumi.get(self, "sub_network")

    @sub_network.setter
    def sub_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_network", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskInfrastructureSpecArgs:
    def __init__(__self__, *,
                 batch: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs']] = None,
                 container_image: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs']] = None,
                 vpc_network: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs']] = None):
        """
        Configuration for the underlying infrastructure used to run workloads.
        :param pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs'] batch: Compute resources needed for a Task when using Dataproc Serverless.
        :param pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs'] container_image: Container Image Runtime Configuration.
        :param pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs'] vpc_network: Vpc network.
        """
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if vpc_network is not None:
            pulumi.set(__self__, "vpc_network", vpc_network)

    @property
    @pulumi.getter
    def batch(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs']]:
        """
        Compute resources needed for a Task when using Dataproc Serverless.
        """
        return pulumi.get(self, "batch")

    @batch.setter
    def batch(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesArgs']]):
        pulumi.set(self, "batch", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs']]:
        """
        Container Image Runtime Configuration.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeArgs']]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="vpcNetwork")
    def vpc_network(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs']]:
        """
        Vpc network.
        """
        return pulumi.get(self, "vpc_network")

    @vpc_network.setter
    def vpc_network(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkArgs']]):
        pulumi.set(self, "vpc_network", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskNotebookTaskConfigArgs:
    def __init__(__self__, *,
                 notebook: pulumi.Input[str],
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 infrastructure_spec: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']] = None):
        """
        Config for running scheduled notebooks.
        :param pulumi.Input[str] notebook: Path to input notebook. This can be the Cloud Storage URI of the notebook file or the path to a Notebook Content. The execution args are accessible as environment variables (TASK_key=value).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        :param pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs'] infrastructure_spec: Optional. Infrastructure specification for the execution.
        """
        pulumi.set(__self__, "notebook", notebook)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if infrastructure_spec is not None:
            pulumi.set(__self__, "infrastructure_spec", infrastructure_spec)

    @property
    @pulumi.getter
    def notebook(self) -> pulumi.Input[str]:
        """
        Path to input notebook. This can be the Cloud Storage URI of the notebook file or the path to a Notebook Content. The execution args are accessible as environment variables (TASK_key=value).
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: pulumi.Input[str]):
        pulumi.set(self, "notebook", value)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="infrastructureSpec")
    def infrastructure_spec(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']]:
        """
        Optional. Infrastructure specification for the execution.
        """
        return pulumi.get(self, "infrastructure_spec")

    @infrastructure_spec.setter
    def infrastructure_spec(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']]):
        pulumi.set(self, "infrastructure_spec", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskSparkTaskConfigArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 infrastructure_spec: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 python_script_file: Optional[pulumi.Input[str]] = None,
                 sql_script: Optional[pulumi.Input[str]] = None,
                 sql_script_file: Optional[pulumi.Input[str]] = None):
        """
        User-specified config for running a Spark task.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        :param pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs'] infrastructure_spec: Optional. Infrastructure specification for the execution.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param pulumi.Input[str] main_jar_file_uri: The Cloud Storage URI of the jar file that contains the main class. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param pulumi.Input[str] python_script_file: The Gcloud Storage URI of the main Python file to use as the driver. Must be a .py file. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param pulumi.Input[str] sql_script: The query text. The execution args are used to declare a set of script variables (set key="value";).
        :param pulumi.Input[str] sql_script_file: A reference to a query file. This can be the Cloud Storage URI of the query file or it can the path to a SqlScript Content. The execution args are used to declare a set of script variables (set key="value";).
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if infrastructure_spec is not None:
            pulumi.set(__self__, "infrastructure_spec", infrastructure_spec)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if python_script_file is not None:
            pulumi.set(__self__, "python_script_file", python_script_file)
        if sql_script is not None:
            pulumi.set(__self__, "sql_script", sql_script)
        if sql_script_file is not None:
            pulumi.set(__self__, "sql_script_file", sql_script_file)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="infrastructureSpec")
    def infrastructure_spec(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']]:
        """
        Optional. Infrastructure specification for the execution.
        """
        return pulumi.get(self, "infrastructure_spec")

    @infrastructure_spec.setter
    def infrastructure_spec(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TaskInfrastructureSpecArgs']]):
        pulumi.set(self, "infrastructure_spec", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of the jar file that contains the main class. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter(name="pythonScriptFile")
    def python_script_file(self) -> Optional[pulumi.Input[str]]:
        """
        The Gcloud Storage URI of the main Python file to use as the driver. Must be a .py file. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "python_script_file")

    @python_script_file.setter
    def python_script_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_script_file", value)

    @property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> Optional[pulumi.Input[str]]:
        """
        The query text. The execution args are used to declare a set of script variables (set key="value";).
        """
        return pulumi.get(self, "sql_script")

    @sql_script.setter
    def sql_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_script", value)

    @property
    @pulumi.getter(name="sqlScriptFile")
    def sql_script_file(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to a query file. This can be the Cloud Storage URI of the query file or it can the path to a SqlScript Content. The execution args are used to declare a set of script variables (set key="value";).
        """
        return pulumi.get(self, "sql_script_file")

    @sql_script_file.setter
    def sql_script_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_script_file", value)


@pulumi.input_type
class GoogleCloudDataplexV1TaskTriggerSpecArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['GoogleCloudDataplexV1TaskTriggerSpecType'],
                 disabled: Optional[pulumi.Input[bool]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Task scheduling and trigger settings.
        :param pulumi.Input['GoogleCloudDataplexV1TaskTriggerSpecType'] type: Immutable. Trigger type of the user-specified Task.
        :param pulumi.Input[bool] disabled: Optional. Prevent the task from executing. This does not cancel already running tasks. It is intended to temporarily disable RECURRING tasks.
        :param pulumi.Input[int] max_retries: Optional. Number of retry attempts before aborting. Set to zero to never attempt to retry a failed task.
        :param pulumi.Input[str] schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks periodically. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *. This field is required for RECURRING tasks.
        :param pulumi.Input[str] start_time: Optional. The first run of the task will be after this time. If not specified, the task will run shortly after being submitted if ON_DEMAND and based on the schedule if RECURRING.
        """
        pulumi.set(__self__, "type", type)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudDataplexV1TaskTriggerSpecType']:
        """
        Immutable. Trigger type of the user-specified Task.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudDataplexV1TaskTriggerSpecType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Prevent the task from executing. This does not cancel already running tasks. It is intended to temporarily disable RECURRING tasks.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of retry attempts before aborting. Set to zero to never attempt to retry a failed task.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks periodically. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *. This field is required for RECURRING tasks.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The first run of the task will be after this time. If not specified, the task will run shortly after being submitted if ON_DEMAND and based on the schedule if RECURRING.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class GoogleCloudDataplexV1TriggerOnDemandArgs:
    def __init__(__self__):
        """
        The scan runs once via RunDataScan API.
        """
        pass


@pulumi.input_type
class GoogleCloudDataplexV1TriggerScheduleArgs:
    def __init__(__self__, *,
                 cron: pulumi.Input[str]):
        """
        The scan is scheduled to run periodically.
        :param pulumi.Input[str] cron: Cron (https://en.wikipedia.org/wiki/Cron) schedule for running scans periodically.To explicitly set a timezone in the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database (wikipedia (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)). For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.This field is required for Schedule scans.
        """
        pulumi.set(__self__, "cron", cron)

    @property
    @pulumi.getter
    def cron(self) -> pulumi.Input[str]:
        """
        Cron (https://en.wikipedia.org/wiki/Cron) schedule for running scans periodically.To explicitly set a timezone in the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database (wikipedia (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)). For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.This field is required for Schedule scans.
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: pulumi.Input[str]):
        pulumi.set(self, "cron", value)


@pulumi.input_type
class GoogleCloudDataplexV1TriggerArgs:
    def __init__(__self__, *,
                 on_demand: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerOnDemandArgs']] = None,
                 schedule: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerScheduleArgs']] = None):
        """
        DataScan scheduling and trigger settings.
        :param pulumi.Input['GoogleCloudDataplexV1TriggerOnDemandArgs'] on_demand: The scan runs once via RunDataScan API.
        :param pulumi.Input['GoogleCloudDataplexV1TriggerScheduleArgs'] schedule: The scan is scheduled to run periodically.
        """
        if on_demand is not None:
            pulumi.set(__self__, "on_demand", on_demand)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="onDemand")
    def on_demand(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TriggerOnDemandArgs']]:
        """
        The scan runs once via RunDataScan API.
        """
        return pulumi.get(self, "on_demand")

    @on_demand.setter
    def on_demand(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerOnDemandArgs']]):
        pulumi.set(self, "on_demand", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1TriggerScheduleArgs']]:
        """
        The scan is scheduled to run periodically.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1TriggerScheduleArgs']]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 disable_type_inference: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 header_rows: Optional[pulumi.Input[int]] = None):
        """
        Describe CSV and similar semi-structured data formats.
        :param pulumi.Input[str] delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param pulumi.Input[bool] disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param pulumi.Input[int] header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if header_rows is not None:
            pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @disable_type_inference.setter
    def disable_type_inference(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_type_inference", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")

    @header_rows.setter
    def header_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "header_rows", value)


@pulumi.input_type
class GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs:
    def __init__(__self__, *,
                 disable_type_inference: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None):
        """
        Describe JSON data format.
        :param pulumi.Input[bool] disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param pulumi.Input[str] encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @disable_type_inference.setter
    def disable_type_inference(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_type_inference", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)


@pulumi.input_type
class GoogleCloudDataplexV1ZoneDiscoverySpecArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 csv_options: Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs']] = None,
                 exclude_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 json_options: Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs']] = None,
                 schedule: Optional[pulumi.Input[str]] = None):
        """
        Settings to manage the metadata discovery and publishing in a zone.
        :param pulumi.Input[bool] enabled: Whether discovery is enabled.
        :param pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs'] csv_options: Optional. Configuration for CSV data.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs'] json_options: Optional. Configuration for Json data.
        :param pulumi.Input[str] schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
        """
        pulumi.set(__self__, "enabled", enabled)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if exclude_patterns is not None:
            pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        if include_patterns is not None:
            pulumi.set(__self__, "include_patterns", include_patterns)
        if json_options is not None:
            pulumi.set(__self__, "json_options", json_options)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs']]:
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @csv_options.setter
    def csv_options(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsArgs']]):
        pulumi.set(self, "csv_options", value)

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @exclude_patterns.setter
    def exclude_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_patterns", value)

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @include_patterns.setter
    def include_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_patterns", value)

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs']]:
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @json_options.setter
    def json_options(self, value: Optional[pulumi.Input['GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsArgs']]):
        pulumi.set(self, "json_options", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class GoogleCloudDataplexV1ZoneResourceSpecArgs:
    def __init__(__self__, *,
                 location_type: pulumi.Input['GoogleCloudDataplexV1ZoneResourceSpecLocationType']):
        """
        Settings for resources attached as assets within a zone.
        :param pulumi.Input['GoogleCloudDataplexV1ZoneResourceSpecLocationType'] location_type: Immutable. The location type of the resources that are allowed to be attached to the assets within this zone.
        """
        pulumi.set(__self__, "location_type", location_type)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Input['GoogleCloudDataplexV1ZoneResourceSpecLocationType']:
        """
        Immutable. The location type of the resources that are allowed to be attached to the assets within this zone.
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: pulumi.Input['GoogleCloudDataplexV1ZoneResourceSpecLocationType']):
        pulumi.set(self, "location_type", value)


@pulumi.input_type
class GoogleIamV1AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.If there are AuditConfigs for both allServices and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class GoogleIamV1AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['GoogleIamV1AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class GoogleIamV1BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['GoogleTypeExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates members, or principals, with a role.
        :param pulumi.Input['GoogleTypeExprArgs'] condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a Google service account. For example, my-other-app@appspot.gserviceaccount.com. serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]: An identifier for a Kubernetes service account (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, my-project.svc.id.goog[my-namespace/my-kubernetes-sa]. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding.
        :param pulumi.Input[str] role: Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['GoogleTypeExprArgs']]:
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['GoogleTypeExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a Google service account. For example, my-other-app@appspot.gserviceaccount.com. serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]: An identifier for a Kubernetes service account (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, my-project.svc.id.goog[my-namespace/my-kubernetes-sa]. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class GoogleTypeExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


