# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'EntitySystem',
    'EntityType',
    'GoogleCloudDataplexV1AssetResourceSpecReadAccessMode',
    'GoogleCloudDataplexV1AssetResourceSpecType',
    'GoogleCloudDataplexV1ContentNotebookKernelType',
    'GoogleCloudDataplexV1ContentSqlScriptEngine',
    'GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationStatistic',
    'GoogleCloudDataplexV1SchemaPartitionFieldType',
    'GoogleCloudDataplexV1SchemaPartitionStyle',
    'GoogleCloudDataplexV1SchemaSchemaFieldMode',
    'GoogleCloudDataplexV1SchemaSchemaFieldType',
    'GoogleCloudDataplexV1StorageFormatCompressionFormat',
    'GoogleCloudDataplexV1TaskTriggerSpecType',
    'GoogleCloudDataplexV1ZoneResourceSpecLocationType',
    'GoogleIamV1AuditLogConfigLogType',
    'ZoneType',
]


class EntitySystem(str, Enum):
    """
    Required. Immutable. Identifies the storage system of the entity data.
    """
    STORAGE_SYSTEM_UNSPECIFIED = "STORAGE_SYSTEM_UNSPECIFIED"
    """
    Storage system unspecified.
    """
    CLOUD_STORAGE = "CLOUD_STORAGE"
    """
    The entity data is contained within a Cloud Storage bucket.
    """
    BIGQUERY = "BIGQUERY"
    """
    The entity data is contained within a BigQuery dataset.
    """


class EntityType(str, Enum):
    """
    Required. Immutable. The type of entity.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Type unspecified.
    """
    TABLE = "TABLE"
    """
    Structured and semi-structured data.
    """
    FILESET = "FILESET"
    """
    Unstructured data.
    """


class GoogleCloudDataplexV1AssetResourceSpecReadAccessMode(str, Enum):
    """
    Optional. Determines how read permissions are handled for each asset and their associated tables. Only available to storage buckets assets.
    """
    ACCESS_MODE_UNSPECIFIED = "ACCESS_MODE_UNSPECIFIED"
    """
    Access mode unspecified.
    """
    DIRECT = "DIRECT"
    """
    Default. Data is accessed directly using storage APIs.
    """
    MANAGED = "MANAGED"
    """
    Data is accessed through a managed interface using BigQuery APIs.
    """


class GoogleCloudDataplexV1AssetResourceSpecType(str, Enum):
    """
    Required. Immutable. Type of resource.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Type not specified.
    """
    STORAGE_BUCKET = "STORAGE_BUCKET"
    """
    Cloud Storage bucket.
    """
    BIGQUERY_DATASET = "BIGQUERY_DATASET"
    """
    BigQuery dataset.
    """


class GoogleCloudDataplexV1ContentNotebookKernelType(str, Enum):
    """
    Required. Kernel Type of the notebook.
    """
    KERNEL_TYPE_UNSPECIFIED = "KERNEL_TYPE_UNSPECIFIED"
    """
    Kernel Type unspecified.
    """
    PYTHON3 = "PYTHON3"
    """
    Python 3 Kernel.
    """


class GoogleCloudDataplexV1ContentSqlScriptEngine(str, Enum):
    """
    Required. Query Engine to be used for the Sql Query.
    """
    QUERY_ENGINE_UNSPECIFIED = "QUERY_ENGINE_UNSPECIFIED"
    """
    Value was unspecified.
    """
    SPARK = "SPARK"
    """
    Spark SQL Query.
    """


class GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectationStatistic(str, Enum):
    STATISTIC_UNDEFINED = "STATISTIC_UNDEFINED"
    """
    Unspecified statistic type
    """
    MEAN = "MEAN"
    """
    Evaluate the column mean
    """
    MIN = "MIN"
    """
    Evaluate the column min
    """
    MAX = "MAX"
    """
    Evaluate the column max
    """


class GoogleCloudDataplexV1SchemaPartitionFieldType(str, Enum):
    """
    Required. Immutable. The type of field.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    SchemaType unspecified.
    """
    BOOLEAN = "BOOLEAN"
    """
    Boolean field.
    """
    BYTE = "BYTE"
    """
    Single byte numeric field.
    """
    INT16 = "INT16"
    """
    16-bit numeric field.
    """
    INT32 = "INT32"
    """
    32-bit numeric field.
    """
    INT64 = "INT64"
    """
    64-bit numeric field.
    """
    FLOAT = "FLOAT"
    """
    Floating point numeric field.
    """
    DOUBLE = "DOUBLE"
    """
    Double precision numeric field.
    """
    DECIMAL = "DECIMAL"
    """
    Real value numeric field.
    """
    STRING = "STRING"
    """
    Sequence of characters field.
    """
    BINARY = "BINARY"
    """
    Sequence of bytes field.
    """
    TIMESTAMP = "TIMESTAMP"
    """
    Date and time field.
    """
    DATE = "DATE"
    """
    Date field.
    """
    TIME = "TIME"
    """
    Time field.
    """
    RECORD = "RECORD"
    """
    Structured field. Nested fields that define the structure of the map. If all nested fields are nullable, this field represents a union.
    """
    NULL = "NULL"
    """
    Null field that does not have values.
    """


class GoogleCloudDataplexV1SchemaPartitionStyle(str, Enum):
    """
    Optional. The structure of paths containing partition data within the entity.
    """
    PARTITION_STYLE_UNSPECIFIED = "PARTITION_STYLE_UNSPECIFIED"
    """
    PartitionStyle unspecified
    """
    HIVE_COMPATIBLE = "HIVE_COMPATIBLE"
    """
    Partitions are hive-compatible. Examples: gs://bucket/path/to/table/dt=2019-10-31/lang=en, gs://bucket/path/to/table/dt=2019-10-31/lang=en/late.
    """


class GoogleCloudDataplexV1SchemaSchemaFieldMode(str, Enum):
    """
    Required. Additional field semantics.
    """
    MODE_UNSPECIFIED = "MODE_UNSPECIFIED"
    """
    Mode unspecified.
    """
    REQUIRED = "REQUIRED"
    """
    The field has required semantics.
    """
    NULLABLE = "NULLABLE"
    """
    The field has optional semantics, and may be null.
    """
    REPEATED = "REPEATED"
    """
    The field has repeated (0 or more) semantics, and is a list of values.
    """


class GoogleCloudDataplexV1SchemaSchemaFieldType(str, Enum):
    """
    Required. The type of field.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    SchemaType unspecified.
    """
    BOOLEAN = "BOOLEAN"
    """
    Boolean field.
    """
    BYTE = "BYTE"
    """
    Single byte numeric field.
    """
    INT16 = "INT16"
    """
    16-bit numeric field.
    """
    INT32 = "INT32"
    """
    32-bit numeric field.
    """
    INT64 = "INT64"
    """
    64-bit numeric field.
    """
    FLOAT = "FLOAT"
    """
    Floating point numeric field.
    """
    DOUBLE = "DOUBLE"
    """
    Double precision numeric field.
    """
    DECIMAL = "DECIMAL"
    """
    Real value numeric field.
    """
    STRING = "STRING"
    """
    Sequence of characters field.
    """
    BINARY = "BINARY"
    """
    Sequence of bytes field.
    """
    TIMESTAMP = "TIMESTAMP"
    """
    Date and time field.
    """
    DATE = "DATE"
    """
    Date field.
    """
    TIME = "TIME"
    """
    Time field.
    """
    RECORD = "RECORD"
    """
    Structured field. Nested fields that define the structure of the map. If all nested fields are nullable, this field represents a union.
    """
    NULL = "NULL"
    """
    Null field that does not have values.
    """


class GoogleCloudDataplexV1StorageFormatCompressionFormat(str, Enum):
    """
    Optional. The compression type associated with the stored data. If unspecified, the data is uncompressed.
    """
    COMPRESSION_FORMAT_UNSPECIFIED = "COMPRESSION_FORMAT_UNSPECIFIED"
    """
    CompressionFormat unspecified. Implies uncompressed data.
    """
    GZIP = "GZIP"
    """
    GZip compressed set of files.
    """
    BZIP2 = "BZIP2"
    """
    BZip2 compressed set of files.
    """


class GoogleCloudDataplexV1TaskTriggerSpecType(str, Enum):
    """
    Required. Immutable. Trigger type of the user-specified Task.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Unspecified trigger type.
    """
    ON_DEMAND = "ON_DEMAND"
    """
    The task runs one-time shortly after Task Creation.
    """
    RECURRING = "RECURRING"
    """
    The task is scheduled to run periodically.
    """


class GoogleCloudDataplexV1ZoneResourceSpecLocationType(str, Enum):
    """
    Required. Immutable. The location type of the resources that are allowed to be attached to the assets within this zone.
    """
    LOCATION_TYPE_UNSPECIFIED = "LOCATION_TYPE_UNSPECIFIED"
    """
    Unspecified location type.
    """
    SINGLE_REGION = "SINGLE_REGION"
    """
    Resources that are associated with a single region.
    """
    MULTI_REGION = "MULTI_REGION"
    """
    Resources that are associated with a multi-region location.
    """


class GoogleIamV1AuditLogConfigLogType(str, Enum):
    """
    The log type that this config enables.
    """
    LOG_TYPE_UNSPECIFIED = "LOG_TYPE_UNSPECIFIED"
    """
    Default case. Should never be this.
    """
    ADMIN_READ = "ADMIN_READ"
    """
    Admin reads. Example: CloudIAM getIamPolicy
    """
    DATA_WRITE = "DATA_WRITE"
    """
    Data writes. Example: CloudSQL Users create
    """
    DATA_READ = "DATA_READ"
    """
    Data reads. Example: CloudSQL Users list
    """


class ZoneType(str, Enum):
    """
    Required. Immutable. The type of the zone.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Zone type not specified.
    """
    RAW = "RAW"
    """
    A zone that contains data that needs further processing before it is considered generally ready for consumption and analytics workloads.
    """
    CURATED = "CURATED"
    """
    A zone that contains data that is considered to be ready for broader consumption and analytics workloads. Curated structured data stored in Cloud Storage must conform to certain file formats (parquet, avro and orc) and organized in a hive-compatible directory layout.
    """
