# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConversionWorkspaceArgs', 'ConversionWorkspace']

@pulumi.input_type
class ConversionWorkspaceArgs:
    def __init__(__self__, *,
                 conversion_workspace_id: pulumi.Input[str],
                 destination: pulumi.Input['DatabaseEngineInfoArgs'],
                 source: pulumi.Input['DatabaseEngineInfoArgs'],
                 display_name: Optional[pulumi.Input[str]] = None,
                 global_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConversionWorkspace resource.
        :param pulumi.Input[str] conversion_workspace_id: Required. The ID of the conversion workspace to create.
        :param pulumi.Input['DatabaseEngineInfoArgs'] destination: The destination engine details.
        :param pulumi.Input['DatabaseEngineInfoArgs'] source: The source engine details.
        :param pulumi.Input[str] display_name: The display name for the workspace
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] global_settings: A generic list of settings for the workspace. The settings are database pair dependant and can indicate default behavior for the mapping rules engine or turn on or off specific features. Such examples can be: convert_foreign_key_to_interleave=true, skip_triggers=false, ignore_non_table_synonyms=true
        :param pulumi.Input[str] name: Full name of the workspace resource, in the form of: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
        :param pulumi.Input[str] request_id: A unique id used to identify the request. If the server receives two requests with the same id, then the second request will be ignored. It is recommended to always set this value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The maximum length is 40 characters.
        """
        pulumi.set(__self__, "conversion_workspace_id", conversion_workspace_id)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if global_settings is not None:
            pulumi.set(__self__, "global_settings", global_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)

    @property
    @pulumi.getter(name="conversionWorkspaceId")
    def conversion_workspace_id(self) -> pulumi.Input[str]:
        """
        Required. The ID of the conversion workspace to create.
        """
        return pulumi.get(self, "conversion_workspace_id")

    @conversion_workspace_id.setter
    def conversion_workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "conversion_workspace_id", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['DatabaseEngineInfoArgs']:
        """
        The destination engine details.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['DatabaseEngineInfoArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['DatabaseEngineInfoArgs']:
        """
        The source engine details.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['DatabaseEngineInfoArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the workspace
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="globalSettings")
    def global_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A generic list of settings for the workspace. The settings are database pair dependant and can indicate default behavior for the mapping rules engine or turn on or off specific features. Such examples can be: convert_foreign_key_to_interleave=true, skip_triggers=false, ignore_non_table_synonyms=true
        """
        return pulumi.get(self, "global_settings")

    @global_settings.setter
    def global_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "global_settings", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Full name of the workspace resource, in the form of: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique id used to identify the request. If the server receives two requests with the same id, then the second request will be ignored. It is recommended to always set this value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The maximum length is 40 characters.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)


class ConversionWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_workspace_id: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 global_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']]] = None,
                 __props__=None):
        """
        Creates a new conversion workspace in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] conversion_workspace_id: Required. The ID of the conversion workspace to create.
        :param pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']] destination: The destination engine details.
        :param pulumi.Input[str] display_name: The display name for the workspace
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] global_settings: A generic list of settings for the workspace. The settings are database pair dependant and can indicate default behavior for the mapping rules engine or turn on or off specific features. Such examples can be: convert_foreign_key_to_interleave=true, skip_triggers=false, ignore_non_table_synonyms=true
        :param pulumi.Input[str] name: Full name of the workspace resource, in the form of: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
        :param pulumi.Input[str] request_id: A unique id used to identify the request. If the server receives two requests with the same id, then the second request will be ignored. It is recommended to always set this value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The maximum length is 40 characters.
        :param pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']] source: The source engine details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConversionWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new conversion workspace in a given project and location.

        :param str resource_name: The name of the resource.
        :param ConversionWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConversionWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_workspace_id: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 global_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['DatabaseEngineInfoArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConversionWorkspaceArgs.__new__(ConversionWorkspaceArgs)

            if conversion_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'conversion_workspace_id'")
            __props__.__dict__["conversion_workspace_id"] = conversion_workspace_id
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["global_settings"] = global_settings
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["create_time"] = None
            __props__.__dict__["has_uncommitted_changes"] = None
            __props__.__dict__["latest_commit_id"] = None
            __props__.__dict__["latest_commit_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["conversion_workspace_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConversionWorkspace, __self__).__init__(
            'google-native:datamigration/v1:ConversionWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConversionWorkspace':
        """
        Get an existing ConversionWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConversionWorkspaceArgs.__new__(ConversionWorkspaceArgs)

        __props__.__dict__["conversion_workspace_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["destination"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["global_settings"] = None
        __props__.__dict__["has_uncommitted_changes"] = None
        __props__.__dict__["latest_commit_id"] = None
        __props__.__dict__["latest_commit_time"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["update_time"] = None
        return ConversionWorkspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conversionWorkspaceId")
    def conversion_workspace_id(self) -> pulumi.Output[str]:
        """
        Required. The ID of the conversion workspace to create.
        """
        return pulumi.get(self, "conversion_workspace_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the workspace resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.DatabaseEngineInfoResponse']:
        """
        The destination engine details.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name for the workspace
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="globalSettings")
    def global_settings(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A generic list of settings for the workspace. The settings are database pair dependant and can indicate default behavior for the mapping rules engine or turn on or off specific features. Such examples can be: convert_foreign_key_to_interleave=true, skip_triggers=false, ignore_non_table_synonyms=true
        """
        return pulumi.get(self, "global_settings")

    @property
    @pulumi.getter(name="hasUncommittedChanges")
    def has_uncommitted_changes(self) -> pulumi.Output[bool]:
        """
        Whether the workspace has uncommitted changes (changes which were made after the workspace was committed)
        """
        return pulumi.get(self, "has_uncommitted_changes")

    @property
    @pulumi.getter(name="latestCommitId")
    def latest_commit_id(self) -> pulumi.Output[str]:
        """
        The latest commit id
        """
        return pulumi.get(self, "latest_commit_id")

    @property
    @pulumi.getter(name="latestCommitTime")
    def latest_commit_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the workspace was committed.
        """
        return pulumi.get(self, "latest_commit_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Full name of the workspace resource, in the form of: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique id used to identify the request. If the server receives two requests with the same id, then the second request will be ignored. It is recommended to always set this value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The maximum length is 40 characters.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.DatabaseEngineInfoResponse']:
        """
        The source engine details.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the workspace resource was last updated.
        """
        return pulumi.get(self, "update_time")

