# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkflowConfigArgs', 'WorkflowConfig']

@pulumi.input_type
class WorkflowConfigArgs:
    def __init__(__self__, *,
                 release_config: pulumi.Input[str],
                 repository_id: pulumi.Input[str],
                 workflow_config_id: pulumi.Input[str],
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 invocation_config: Optional[pulumi.Input['InvocationConfigArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkflowConfig resource.
        :param pulumi.Input[str] release_config: The name of the release config whose release_compilation_result should be executed. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        :param pulumi.Input[str] workflow_config_id: Required. The ID to use for the workflow config, which will become the final component of the workflow config's resource name.
        :param pulumi.Input[str] cron_schedule: Optional. Optional schedule (in cron format) for automatic execution of this workflow config.
        :param pulumi.Input['InvocationConfigArgs'] invocation_config: Optional. If left unset, a default InvocationConfig will be used.
        :param pulumi.Input[str] time_zone: Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        pulumi.set(__self__, "release_config", release_config)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "workflow_config_id", workflow_config_id)
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if invocation_config is not None:
            pulumi.set(__self__, "invocation_config", invocation_config)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="releaseConfig")
    def release_config(self) -> pulumi.Input[str]:
        """
        The name of the release config whose release_compilation_result should be executed. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        """
        return pulumi.get(self, "release_config")

    @release_config.setter
    def release_config(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_config", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="workflowConfigId")
    def workflow_config_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the workflow config, which will become the final component of the workflow config's resource name.
        """
        return pulumi.get(self, "workflow_config_id")

    @workflow_config_id.setter
    def workflow_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workflow_config_id", value)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Optional schedule (in cron format) for automatic execution of this workflow config.
        """
        return pulumi.get(self, "cron_schedule")

    @cron_schedule.setter
    def cron_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_schedule", value)

    @property
    @pulumi.getter(name="invocationConfig")
    def invocation_config(self) -> Optional[pulumi.Input['InvocationConfigArgs']]:
        """
        Optional. If left unset, a default InvocationConfig will be used.
        """
        return pulumi.get(self, "invocation_config")

    @invocation_config.setter
    def invocation_config(self, value: Optional[pulumi.Input['InvocationConfigArgs']]):
        pulumi.set(self, "invocation_config", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class WorkflowConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 invocation_config: Optional[pulumi.Input[pulumi.InputType['InvocationConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_config: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 workflow_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new WorkflowConfig in a given Repository.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cron_schedule: Optional. Optional schedule (in cron format) for automatic execution of this workflow config.
        :param pulumi.Input[pulumi.InputType['InvocationConfigArgs']] invocation_config: Optional. If left unset, a default InvocationConfig will be used.
        :param pulumi.Input[str] release_config: The name of the release config whose release_compilation_result should be executed. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        :param pulumi.Input[str] time_zone: Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        :param pulumi.Input[str] workflow_config_id: Required. The ID to use for the workflow config, which will become the final component of the workflow config's resource name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new WorkflowConfig in a given Repository.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param WorkflowConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 invocation_config: Optional[pulumi.Input[pulumi.InputType['InvocationConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_config: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 workflow_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowConfigArgs.__new__(WorkflowConfigArgs)

            __props__.__dict__["cron_schedule"] = cron_schedule
            __props__.__dict__["invocation_config"] = invocation_config
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if release_config is None and not opts.urn:
                raise TypeError("Missing required property 'release_config'")
            __props__.__dict__["release_config"] = release_config
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["time_zone"] = time_zone
            if workflow_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'workflow_config_id'")
            __props__.__dict__["workflow_config_id"] = workflow_config_id
            __props__.__dict__["name"] = None
            __props__.__dict__["recent_scheduled_execution_records"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "repository_id", "workflow_config_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(WorkflowConfig, __self__).__init__(
            'google-native:dataform/v1beta1:WorkflowConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WorkflowConfig':
        """
        Get an existing WorkflowConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkflowConfigArgs.__new__(WorkflowConfigArgs)

        __props__.__dict__["cron_schedule"] = None
        __props__.__dict__["invocation_config"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["recent_scheduled_execution_records"] = None
        __props__.__dict__["release_config"] = None
        __props__.__dict__["repository_id"] = None
        __props__.__dict__["time_zone"] = None
        __props__.__dict__["workflow_config_id"] = None
        return WorkflowConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> pulumi.Output[str]:
        """
        Optional. Optional schedule (in cron format) for automatic execution of this workflow config.
        """
        return pulumi.get(self, "cron_schedule")

    @property
    @pulumi.getter(name="invocationConfig")
    def invocation_config(self) -> pulumi.Output['outputs.InvocationConfigResponse']:
        """
        Optional. If left unset, a default InvocationConfig will be used.
        """
        return pulumi.get(self, "invocation_config")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The workflow config's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="recentScheduledExecutionRecords")
    def recent_scheduled_execution_records(self) -> pulumi.Output[Sequence['outputs.ScheduledExecutionRecordResponse']]:
        """
        Records of the 10 most recent scheduled execution attempts. Updated whenever automatic creation of a compilation result is triggered by cron_schedule.
        """
        return pulumi.get(self, "recent_scheduled_execution_records")

    @property
    @pulumi.getter(name="releaseConfig")
    def release_config(self) -> pulumi.Output[str]:
        """
        The name of the release config whose release_compilation_result should be executed. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        """
        return pulumi.get(self, "release_config")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="workflowConfigId")
    def workflow_config_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the workflow config, which will become the final component of the workflow config's resource name.
        """
        return pulumi.get(self, "workflow_config_id")

