# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[str],
                 git_remote_settings: Optional[pulumi.Input['GitRemoteSettingsArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 npmrc_environment_variables_secret_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 workspace_compilation_overrides: Optional[pulumi.Input['WorkspaceCompilationOverridesArgs']] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] repository_id: Required. The ID to use for the repository, which will become the final component of the repository's resource name.
        :param pulumi.Input['GitRemoteSettingsArgs'] git_remote_settings: Optional. If set, configures this repository to be linked to a Git remote.
        :param pulumi.Input[str] npmrc_environment_variables_secret_version: Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format `projects/*/secrets/*/versions/*`. The file itself must be in a JSON format.
        :param pulumi.Input['WorkspaceCompilationOverridesArgs'] workspace_compilation_overrides: Optional. If set, fields of `workspace_compilation_overrides` override the default compilation settings that are specified in dataform.json when creating workspace-scoped compilation results. See documentation for `WorkspaceCompilationOverrides` for more information.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        if git_remote_settings is not None:
            pulumi.set(__self__, "git_remote_settings", git_remote_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if npmrc_environment_variables_secret_version is not None:
            pulumi.set(__self__, "npmrc_environment_variables_secret_version", npmrc_environment_variables_secret_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if workspace_compilation_overrides is not None:
            pulumi.set(__self__, "workspace_compilation_overrides", workspace_compilation_overrides)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the repository, which will become the final component of the repository's resource name.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="gitRemoteSettings")
    def git_remote_settings(self) -> Optional[pulumi.Input['GitRemoteSettingsArgs']]:
        """
        Optional. If set, configures this repository to be linked to a Git remote.
        """
        return pulumi.get(self, "git_remote_settings")

    @git_remote_settings.setter
    def git_remote_settings(self, value: Optional[pulumi.Input['GitRemoteSettingsArgs']]):
        pulumi.set(self, "git_remote_settings", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="npmrcEnvironmentVariablesSecretVersion")
    def npmrc_environment_variables_secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format `projects/*/secrets/*/versions/*`. The file itself must be in a JSON format.
        """
        return pulumi.get(self, "npmrc_environment_variables_secret_version")

    @npmrc_environment_variables_secret_version.setter
    def npmrc_environment_variables_secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "npmrc_environment_variables_secret_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="workspaceCompilationOverrides")
    def workspace_compilation_overrides(self) -> Optional[pulumi.Input['WorkspaceCompilationOverridesArgs']]:
        """
        Optional. If set, fields of `workspace_compilation_overrides` override the default compilation settings that are specified in dataform.json when creating workspace-scoped compilation results. See documentation for `WorkspaceCompilationOverrides` for more information.
        """
        return pulumi.get(self, "workspace_compilation_overrides")

    @workspace_compilation_overrides.setter
    def workspace_compilation_overrides(self, value: Optional[pulumi.Input['WorkspaceCompilationOverridesArgs']]):
        pulumi.set(self, "workspace_compilation_overrides", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 git_remote_settings: Optional[pulumi.Input[pulumi.InputType['GitRemoteSettingsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 npmrc_environment_variables_secret_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 workspace_compilation_overrides: Optional[pulumi.Input[pulumi.InputType['WorkspaceCompilationOverridesArgs']]] = None,
                 __props__=None):
        """
        Creates a new Repository in a given project and location.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GitRemoteSettingsArgs']] git_remote_settings: Optional. If set, configures this repository to be linked to a Git remote.
        :param pulumi.Input[str] npmrc_environment_variables_secret_version: Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format `projects/*/secrets/*/versions/*`. The file itself must be in a JSON format.
        :param pulumi.Input[str] repository_id: Required. The ID to use for the repository, which will become the final component of the repository's resource name.
        :param pulumi.Input[pulumi.InputType['WorkspaceCompilationOverridesArgs']] workspace_compilation_overrides: Optional. If set, fields of `workspace_compilation_overrides` override the default compilation settings that are specified in dataform.json when creating workspace-scoped compilation results. See documentation for `WorkspaceCompilationOverrides` for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Repository in a given project and location.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 git_remote_settings: Optional[pulumi.Input[pulumi.InputType['GitRemoteSettingsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 npmrc_environment_variables_secret_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 workspace_compilation_overrides: Optional[pulumi.Input[pulumi.InputType['WorkspaceCompilationOverridesArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["git_remote_settings"] = git_remote_settings
            __props__.__dict__["location"] = location
            __props__.__dict__["npmrc_environment_variables_secret_version"] = npmrc_environment_variables_secret_version
            __props__.__dict__["project"] = project
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["workspace_compilation_overrides"] = workspace_compilation_overrides
            __props__.__dict__["name"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "repository_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Repository, __self__).__init__(
            'google-native:dataform/v1beta1:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RepositoryArgs.__new__(RepositoryArgs)

        __props__.__dict__["git_remote_settings"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["npmrc_environment_variables_secret_version"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["repository_id"] = None
        __props__.__dict__["workspace_compilation_overrides"] = None
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gitRemoteSettings")
    def git_remote_settings(self) -> pulumi.Output['outputs.GitRemoteSettingsResponse']:
        """
        Optional. If set, configures this repository to be linked to a Git remote.
        """
        return pulumi.get(self, "git_remote_settings")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The repository's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="npmrcEnvironmentVariablesSecretVersion")
    def npmrc_environment_variables_secret_version(self) -> pulumi.Output[str]:
        """
        Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format `projects/*/secrets/*/versions/*`. The file itself must be in a JSON format.
        """
        return pulumi.get(self, "npmrc_environment_variables_secret_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the repository, which will become the final component of the repository's resource name.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="workspaceCompilationOverrides")
    def workspace_compilation_overrides(self) -> pulumi.Output['outputs.WorkspaceCompilationOverridesResponse']:
        """
        Optional. If set, fields of `workspace_compilation_overrides` override the default compilation settings that are specified in dataform.json when creating workspace-scoped compilation results. See documentation for `WorkspaceCompilationOverrides` for more information.
        """
        return pulumi.get(self, "workspace_compilation_overrides")

