# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReleaseConfigArgs', 'ReleaseConfig']

@pulumi.input_type
class ReleaseConfigArgs:
    def __init__(__self__, *,
                 git_commitish: pulumi.Input[str],
                 release_config_id: pulumi.Input[str],
                 repository_id: pulumi.Input[str],
                 code_compilation_config: Optional[pulumi.Input['CodeCompilationConfigArgs']] = None,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_compilation_result: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ReleaseConfig resource.
        :param pulumi.Input[str] git_commitish: Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        :param pulumi.Input[str] release_config_id: Required. The ID to use for the release config, which will become the final component of the release config's resource name.
        :param pulumi.Input['CodeCompilationConfigArgs'] code_compilation_config: Optional. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        :param pulumi.Input[str] cron_schedule: Optional. Optional schedule (in cron format) for automatic creation of compilation results.
        :param pulumi.Input[str] release_compilation_result: Optional. The name of the currently released compilation result for this release config. This value is updated when a compilation result is created from this release config, or when this resource is updated by API call (perhaps to roll back to an earlier release). The compilation result must have been created using this release config. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        :param pulumi.Input[str] time_zone: Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        pulumi.set(__self__, "git_commitish", git_commitish)
        pulumi.set(__self__, "release_config_id", release_config_id)
        pulumi.set(__self__, "repository_id", repository_id)
        if code_compilation_config is not None:
            pulumi.set(__self__, "code_compilation_config", code_compilation_config)
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if release_compilation_result is not None:
            pulumi.set(__self__, "release_compilation_result", release_compilation_result)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="gitCommitish")
    def git_commitish(self) -> pulumi.Input[str]:
        """
        Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        """
        return pulumi.get(self, "git_commitish")

    @git_commitish.setter
    def git_commitish(self, value: pulumi.Input[str]):
        pulumi.set(self, "git_commitish", value)

    @property
    @pulumi.getter(name="releaseConfigId")
    def release_config_id(self) -> pulumi.Input[str]:
        """
        Required. The ID to use for the release config, which will become the final component of the release config's resource name.
        """
        return pulumi.get(self, "release_config_id")

    @release_config_id.setter
    def release_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_config_id", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="codeCompilationConfig")
    def code_compilation_config(self) -> Optional[pulumi.Input['CodeCompilationConfigArgs']]:
        """
        Optional. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        """
        return pulumi.get(self, "code_compilation_config")

    @code_compilation_config.setter
    def code_compilation_config(self, value: Optional[pulumi.Input['CodeCompilationConfigArgs']]):
        pulumi.set(self, "code_compilation_config", value)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Optional schedule (in cron format) for automatic creation of compilation results.
        """
        return pulumi.get(self, "cron_schedule")

    @cron_schedule.setter
    def cron_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_schedule", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="releaseCompilationResult")
    def release_compilation_result(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the currently released compilation result for this release config. This value is updated when a compilation result is created from this release config, or when this resource is updated by API call (perhaps to roll back to an earlier release). The compilation result must have been created using this release config. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        """
        return pulumi.get(self, "release_compilation_result")

    @release_compilation_result.setter
    def release_compilation_result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_compilation_result", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ReleaseConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_compilation_config: Optional[pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']]] = None,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 git_commitish: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_compilation_result: Optional[pulumi.Input[str]] = None,
                 release_config_id: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new ReleaseConfig in a given Repository.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']] code_compilation_config: Optional. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        :param pulumi.Input[str] cron_schedule: Optional. Optional schedule (in cron format) for automatic creation of compilation results.
        :param pulumi.Input[str] git_commitish: Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        :param pulumi.Input[str] release_compilation_result: Optional. The name of the currently released compilation result for this release config. This value is updated when a compilation result is created from this release config, or when this resource is updated by API call (perhaps to roll back to an earlier release). The compilation result must have been created using this release config. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        :param pulumi.Input[str] release_config_id: Required. The ID to use for the release config, which will become the final component of the release config's resource name.
        :param pulumi.Input[str] time_zone: Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new ReleaseConfig in a given Repository.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ReleaseConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_compilation_config: Optional[pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']]] = None,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 git_commitish: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_compilation_result: Optional[pulumi.Input[str]] = None,
                 release_config_id: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseConfigArgs.__new__(ReleaseConfigArgs)

            __props__.__dict__["code_compilation_config"] = code_compilation_config
            __props__.__dict__["cron_schedule"] = cron_schedule
            if git_commitish is None and not opts.urn:
                raise TypeError("Missing required property 'git_commitish'")
            __props__.__dict__["git_commitish"] = git_commitish
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["release_compilation_result"] = release_compilation_result
            if release_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'release_config_id'")
            __props__.__dict__["release_config_id"] = release_config_id
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["name"] = None
            __props__.__dict__["recent_scheduled_release_records"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "release_config_id", "repository_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ReleaseConfig, __self__).__init__(
            'google-native:dataform/v1beta1:ReleaseConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ReleaseConfig':
        """
        Get an existing ReleaseConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReleaseConfigArgs.__new__(ReleaseConfigArgs)

        __props__.__dict__["code_compilation_config"] = None
        __props__.__dict__["cron_schedule"] = None
        __props__.__dict__["git_commitish"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["recent_scheduled_release_records"] = None
        __props__.__dict__["release_compilation_result"] = None
        __props__.__dict__["release_config_id"] = None
        __props__.__dict__["repository_id"] = None
        __props__.__dict__["time_zone"] = None
        return ReleaseConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="codeCompilationConfig")
    def code_compilation_config(self) -> pulumi.Output['outputs.CodeCompilationConfigResponse']:
        """
        Optional. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        """
        return pulumi.get(self, "code_compilation_config")

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> pulumi.Output[str]:
        """
        Optional. Optional schedule (in cron format) for automatic creation of compilation results.
        """
        return pulumi.get(self, "cron_schedule")

    @property
    @pulumi.getter(name="gitCommitish")
    def git_commitish(self) -> pulumi.Output[str]:
        """
        Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        """
        return pulumi.get(self, "git_commitish")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The release config's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="recentScheduledReleaseRecords")
    def recent_scheduled_release_records(self) -> pulumi.Output[Sequence['outputs.ScheduledReleaseRecordResponse']]:
        """
        Records of the 10 most recent scheduled release attempts. Updated whenever automatic creation of a compilation result is triggered by cron_schedule.
        """
        return pulumi.get(self, "recent_scheduled_release_records")

    @property
    @pulumi.getter(name="releaseCompilationResult")
    def release_compilation_result(self) -> pulumi.Output[str]:
        """
        Optional. The name of the currently released compilation result for this release config. This value is updated when a compilation result is created from this release config, or when this resource is updated by API call (perhaps to roll back to an earlier release). The compilation result must have been created using this release config. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        """
        return pulumi.get(self, "release_compilation_result")

    @property
    @pulumi.getter(name="releaseConfigId")
    def release_config_id(self) -> pulumi.Output[str]:
        """
        Required. The ID to use for the release config, which will become the final component of the release config's resource name.
        """
        return pulumi.get(self, "release_config_id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")

