# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'CodeCompilationConfigResponse',
    'CompilationErrorResponse',
    'GitRemoteSettingsResponse',
    'IntervalResponse',
    'InvocationConfigResponse',
    'ScheduledExecutionRecordResponse',
    'ScheduledReleaseRecordResponse',
    'StatusResponse',
    'TargetResponse',
    'WorkspaceCompilationOverridesResponse',
]

@pulumi.output_type
class CodeCompilationConfigResponse(dict):
    """
    Configures various aspects of Dataform code compilation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assertionSchema":
            suggest = "assertion_schema"
        elif key == "databaseSuffix":
            suggest = "database_suffix"
        elif key == "defaultDatabase":
            suggest = "default_database"
        elif key == "defaultLocation":
            suggest = "default_location"
        elif key == "defaultSchema":
            suggest = "default_schema"
        elif key == "schemaSuffix":
            suggest = "schema_suffix"
        elif key == "tablePrefix":
            suggest = "table_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeCompilationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeCompilationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeCompilationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assertion_schema: str,
                 database_suffix: str,
                 default_database: str,
                 default_location: str,
                 default_schema: str,
                 schema_suffix: str,
                 table_prefix: str,
                 vars: Mapping[str, str]):
        """
        Configures various aspects of Dataform code compilation.
        :param str assertion_schema: Optional. The default schema (BigQuery dataset ID) for assertions.
        :param str database_suffix: Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        :param str default_database: Optional. The default database (Google Cloud project ID).
        :param str default_location: Optional. The default BigQuery location to use. Defaults to "US". See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        :param str default_schema: Optional. The default schema (BigQuery dataset ID).
        :param str schema_suffix: Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param str table_prefix: Optional. The prefix that should be prepended to all table names.
        :param Mapping[str, str] vars: Optional. User-defined variables that are made available to project code during compilation.
        """
        pulumi.set(__self__, "assertion_schema", assertion_schema)
        pulumi.set(__self__, "database_suffix", database_suffix)
        pulumi.set(__self__, "default_database", default_database)
        pulumi.set(__self__, "default_location", default_location)
        pulumi.set(__self__, "default_schema", default_schema)
        pulumi.set(__self__, "schema_suffix", schema_suffix)
        pulumi.set(__self__, "table_prefix", table_prefix)
        pulumi.set(__self__, "vars", vars)

    @property
    @pulumi.getter(name="assertionSchema")
    def assertion_schema(self) -> str:
        """
        Optional. The default schema (BigQuery dataset ID) for assertions.
        """
        return pulumi.get(self, "assertion_schema")

    @property
    @pulumi.getter(name="databaseSuffix")
    def database_suffix(self) -> str:
        """
        Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        """
        return pulumi.get(self, "database_suffix")

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> str:
        """
        Optional. The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @property
    @pulumi.getter(name="defaultLocation")
    def default_location(self) -> str:
        """
        Optional. The default BigQuery location to use. Defaults to "US". See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        """
        return pulumi.get(self, "default_location")

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> str:
        """
        Optional. The default schema (BigQuery dataset ID).
        """
        return pulumi.get(self, "default_schema")

    @property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> str:
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> str:
        """
        Optional. The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")

    @property
    @pulumi.getter
    def vars(self) -> Mapping[str, str]:
        """
        Optional. User-defined variables that are made available to project code during compilation.
        """
        return pulumi.get(self, "vars")


@pulumi.output_type
class CompilationErrorResponse(dict):
    """
    An error encountered when attempting to compile a Dataform project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionTarget":
            suggest = "action_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompilationErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompilationErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompilationErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_target: 'outputs.TargetResponse',
                 message: str,
                 path: str,
                 stack: str):
        """
        An error encountered when attempting to compile a Dataform project.
        :param 'TargetResponse' action_target: The identifier of the action where this error occurred, if available.
        :param str message: The error's top level message.
        :param str path: The path of the file where this error occurred, if available, relative to the project root.
        :param str stack: The error's full stack trace.
        """
        pulumi.set(__self__, "action_target", action_target)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "stack", stack)

    @property
    @pulumi.getter(name="actionTarget")
    def action_target(self) -> 'outputs.TargetResponse':
        """
        The identifier of the action where this error occurred, if available.
        """
        return pulumi.get(self, "action_target")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error's top level message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file where this error occurred, if available, relative to the project root.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def stack(self) -> str:
        """
        The error's full stack trace.
        """
        return pulumi.get(self, "stack")


@pulumi.output_type
class GitRemoteSettingsResponse(dict):
    """
    Controls Git remote configuration for a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationTokenSecretVersion":
            suggest = "authentication_token_secret_version"
        elif key == "defaultBranch":
            suggest = "default_branch"
        elif key == "tokenStatus":
            suggest = "token_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitRemoteSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitRemoteSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitRemoteSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_token_secret_version: str,
                 default_branch: str,
                 token_status: str,
                 url: str):
        """
        Controls Git remote configuration for a repository.
        :param str authentication_token_secret_version: The name of the Secret Manager secret version to use as an authentication token for Git operations. Must be in the format `projects/*/secrets/*/versions/*`.
        :param str default_branch: The Git remote's default branch name.
        :param str token_status: Indicates the status of the Git access token.
        :param str url: The Git remote's URL.
        """
        pulumi.set(__self__, "authentication_token_secret_version", authentication_token_secret_version)
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "token_status", token_status)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="authenticationTokenSecretVersion")
    def authentication_token_secret_version(self) -> str:
        """
        The name of the Secret Manager secret version to use as an authentication token for Git operations. Must be in the format `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "authentication_token_secret_version")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        The Git remote's default branch name.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> str:
        """
        Indicates the status of the Git access token.
        """
        return pulumi.get(self, "token_status")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Git remote's URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class IntervalResponse(dict):
    """
    Represents a time interval, encoded as a Timestamp start (inclusive) and a Timestamp end (exclusive). The start must be less than or equal to the end. When the start equals the end, the interval is empty (matches no time). When both start and end are unspecified, the interval matches any time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntervalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntervalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntervalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a Timestamp end (exclusive). The start must be less than or equal to the end. When the start equals the end, the interval is empty (matches no time). When both start and end are unspecified, the interval matches any time.
        :param str end_time: Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
        :param str start_time: Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InvocationConfigResponse(dict):
    """
    Includes various configuration options for a workflow invocation. If both `included_targets` and `included_tags` are unset, all actions will be included.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullyRefreshIncrementalTablesEnabled":
            suggest = "fully_refresh_incremental_tables_enabled"
        elif key == "includedTags":
            suggest = "included_tags"
        elif key == "includedTargets":
            suggest = "included_targets"
        elif key == "transitiveDependenciesIncluded":
            suggest = "transitive_dependencies_included"
        elif key == "transitiveDependentsIncluded":
            suggest = "transitive_dependents_included"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvocationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvocationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvocationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fully_refresh_incremental_tables_enabled: bool,
                 included_tags: Sequence[str],
                 included_targets: Sequence['outputs.TargetResponse'],
                 transitive_dependencies_included: bool,
                 transitive_dependents_included: bool):
        """
        Includes various configuration options for a workflow invocation. If both `included_targets` and `included_tags` are unset, all actions will be included.
        :param bool fully_refresh_incremental_tables_enabled: Optional. When set to true, any incremental tables will be fully refreshed.
        :param Sequence[str] included_tags: Optional. The set of tags to include.
        :param Sequence['TargetResponse'] included_targets: Optional. The set of action identifiers to include.
        :param bool transitive_dependencies_included: Optional. When set to true, transitive dependencies of included actions will be executed.
        :param bool transitive_dependents_included: Optional. When set to true, transitive dependents of included actions will be executed.
        """
        pulumi.set(__self__, "fully_refresh_incremental_tables_enabled", fully_refresh_incremental_tables_enabled)
        pulumi.set(__self__, "included_tags", included_tags)
        pulumi.set(__self__, "included_targets", included_targets)
        pulumi.set(__self__, "transitive_dependencies_included", transitive_dependencies_included)
        pulumi.set(__self__, "transitive_dependents_included", transitive_dependents_included)

    @property
    @pulumi.getter(name="fullyRefreshIncrementalTablesEnabled")
    def fully_refresh_incremental_tables_enabled(self) -> bool:
        """
        Optional. When set to true, any incremental tables will be fully refreshed.
        """
        return pulumi.get(self, "fully_refresh_incremental_tables_enabled")

    @property
    @pulumi.getter(name="includedTags")
    def included_tags(self) -> Sequence[str]:
        """
        Optional. The set of tags to include.
        """
        return pulumi.get(self, "included_tags")

    @property
    @pulumi.getter(name="includedTargets")
    def included_targets(self) -> Sequence['outputs.TargetResponse']:
        """
        Optional. The set of action identifiers to include.
        """
        return pulumi.get(self, "included_targets")

    @property
    @pulumi.getter(name="transitiveDependenciesIncluded")
    def transitive_dependencies_included(self) -> bool:
        """
        Optional. When set to true, transitive dependencies of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependencies_included")

    @property
    @pulumi.getter(name="transitiveDependentsIncluded")
    def transitive_dependents_included(self) -> bool:
        """
        Optional. When set to true, transitive dependents of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependents_included")


@pulumi.output_type
class ScheduledExecutionRecordResponse(dict):
    """
    A record of an attempt to create a workflow invocation for this workflow config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorStatus":
            suggest = "error_status"
        elif key == "executionTime":
            suggest = "execution_time"
        elif key == "workflowInvocation":
            suggest = "workflow_invocation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledExecutionRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledExecutionRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledExecutionRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_status: 'outputs.StatusResponse',
                 execution_time: str,
                 workflow_invocation: str):
        """
        A record of an attempt to create a workflow invocation for this workflow config.
        :param 'StatusResponse' error_status: The error status encountered upon this attempt to create the workflow invocation, if the attempt was unsuccessful.
        :param str execution_time: The timestamp of this execution attempt.
        :param str workflow_invocation: The name of the created workflow invocation, if one was successfully created. Must be in the format `projects/*/locations/*/repositories/*/workflowInvocations/*`.
        """
        pulumi.set(__self__, "error_status", error_status)
        pulumi.set(__self__, "execution_time", execution_time)
        pulumi.set(__self__, "workflow_invocation", workflow_invocation)

    @property
    @pulumi.getter(name="errorStatus")
    def error_status(self) -> 'outputs.StatusResponse':
        """
        The error status encountered upon this attempt to create the workflow invocation, if the attempt was unsuccessful.
        """
        return pulumi.get(self, "error_status")

    @property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> str:
        """
        The timestamp of this execution attempt.
        """
        return pulumi.get(self, "execution_time")

    @property
    @pulumi.getter(name="workflowInvocation")
    def workflow_invocation(self) -> str:
        """
        The name of the created workflow invocation, if one was successfully created. Must be in the format `projects/*/locations/*/repositories/*/workflowInvocations/*`.
        """
        return pulumi.get(self, "workflow_invocation")


@pulumi.output_type
class ScheduledReleaseRecordResponse(dict):
    """
    A record of an attempt to create a compilation result for this release config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compilationResult":
            suggest = "compilation_result"
        elif key == "errorStatus":
            suggest = "error_status"
        elif key == "releaseTime":
            suggest = "release_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledReleaseRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledReleaseRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledReleaseRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compilation_result: str,
                 error_status: 'outputs.StatusResponse',
                 release_time: str):
        """
        A record of an attempt to create a compilation result for this release config.
        :param str compilation_result: The name of the created compilation result, if one was successfully created. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        :param 'StatusResponse' error_status: The error status encountered upon this attempt to create the compilation result, if the attempt was unsuccessful.
        :param str release_time: The timestamp of this release attempt.
        """
        pulumi.set(__self__, "compilation_result", compilation_result)
        pulumi.set(__self__, "error_status", error_status)
        pulumi.set(__self__, "release_time", release_time)

    @property
    @pulumi.getter(name="compilationResult")
    def compilation_result(self) -> str:
        """
        The name of the created compilation result, if one was successfully created. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        """
        return pulumi.get(self, "compilation_result")

    @property
    @pulumi.getter(name="errorStatus")
    def error_status(self) -> 'outputs.StatusResponse':
        """
        The error status encountered upon this attempt to create the compilation result, if the attempt was unsuccessful.
        """
        return pulumi.get(self, "error_status")

    @property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> str:
        """
        The timestamp of this release attempt.
        """
        return pulumi.get(self, "release_time")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class TargetResponse(dict):
    """
    Represents an action identifier. If the action writes output, the output will be written to the referenced database object.
    """
    def __init__(__self__, *,
                 database: str,
                 name: str,
                 schema: str):
        """
        Represents an action identifier. If the action writes output, the output will be written to the referenced database object.
        :param str database: The action's database (Google Cloud project ID) .
        :param str name: The action's name, within `database` and `schema`.
        :param str schema: The action's schema (BigQuery dataset ID), within `database`.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The action's database (Google Cloud project ID) .
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The action's name, within `database` and `schema`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The action's schema (BigQuery dataset ID), within `database`.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class WorkspaceCompilationOverridesResponse(dict):
    """
    Configures workspace compilation overrides for a repository. Primarily used by the UI (`console.cloud.google.com`). `schema_suffix` and `table_prefix` can have a special expression - `${workspaceName}`, which refers to the workspace name from which the compilation results will be created. API callers are expected to resolve the expression in these overrides and provide them explicitly in `code_compilation_config` (https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories.compilationResults#codecompilationconfig) when creating workspace-scoped compilation results.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDatabase":
            suggest = "default_database"
        elif key == "schemaSuffix":
            suggest = "schema_suffix"
        elif key == "tablePrefix":
            suggest = "table_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceCompilationOverridesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceCompilationOverridesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceCompilationOverridesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_database: str,
                 schema_suffix: str,
                 table_prefix: str):
        """
        Configures workspace compilation overrides for a repository. Primarily used by the UI (`console.cloud.google.com`). `schema_suffix` and `table_prefix` can have a special expression - `${workspaceName}`, which refers to the workspace name from which the compilation results will be created. API callers are expected to resolve the expression in these overrides and provide them explicitly in `code_compilation_config` (https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories.compilationResults#codecompilationconfig) when creating workspace-scoped compilation results.
        :param str default_database: Optional. The default database (Google Cloud project ID).
        :param str schema_suffix: Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param str table_prefix: Optional. The prefix that should be prepended to all table names.
        """
        pulumi.set(__self__, "default_database", default_database)
        pulumi.set(__self__, "schema_suffix", schema_suffix)
        pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> str:
        """
        Optional. The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> str:
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> str:
        """
        Optional. The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")


