# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkflowInvocationResult',
    'AwaitableGetWorkflowInvocationResult',
    'get_workflow_invocation',
    'get_workflow_invocation_output',
]

@pulumi.output_type
class GetWorkflowInvocationResult:
    def __init__(__self__, compilation_result=None, invocation_config=None, invocation_timing=None, name=None, state=None, workflow_config=None):
        if compilation_result and not isinstance(compilation_result, str):
            raise TypeError("Expected argument 'compilation_result' to be a str")
        pulumi.set(__self__, "compilation_result", compilation_result)
        if invocation_config and not isinstance(invocation_config, dict):
            raise TypeError("Expected argument 'invocation_config' to be a dict")
        pulumi.set(__self__, "invocation_config", invocation_config)
        if invocation_timing and not isinstance(invocation_timing, dict):
            raise TypeError("Expected argument 'invocation_timing' to be a dict")
        pulumi.set(__self__, "invocation_timing", invocation_timing)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if workflow_config and not isinstance(workflow_config, str):
            raise TypeError("Expected argument 'workflow_config' to be a str")
        pulumi.set(__self__, "workflow_config", workflow_config)

    @property
    @pulumi.getter(name="compilationResult")
    def compilation_result(self) -> str:
        """
        Immutable. The name of the compilation result to compile. Must be in the format `projects/*/locations/*/repositories/*/compilationResults/*`.
        """
        return pulumi.get(self, "compilation_result")

    @property
    @pulumi.getter(name="invocationConfig")
    def invocation_config(self) -> 'outputs.InvocationConfigResponse':
        """
        Immutable. If left unset, a default InvocationConfig will be used.
        """
        return pulumi.get(self, "invocation_config")

    @property
    @pulumi.getter(name="invocationTiming")
    def invocation_timing(self) -> 'outputs.IntervalResponse':
        """
        This workflow invocation's timing details.
        """
        return pulumi.get(self, "invocation_timing")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The workflow invocation's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        This workflow invocation's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="workflowConfig")
    def workflow_config(self) -> str:
        """
        Immutable. The name of the workflow config to invoke. Must be in the format `projects/*/locations/*/repositories/*/workflowConfigs/*`.
        """
        return pulumi.get(self, "workflow_config")


class AwaitableGetWorkflowInvocationResult(GetWorkflowInvocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowInvocationResult(
            compilation_result=self.compilation_result,
            invocation_config=self.invocation_config,
            invocation_timing=self.invocation_timing,
            name=self.name,
            state=self.state,
            workflow_config=self.workflow_config)


def get_workflow_invocation(location: Optional[str] = None,
                            project: Optional[str] = None,
                            repository_id: Optional[str] = None,
                            workflow_invocation_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowInvocationResult:
    """
    Fetches a single WorkflowInvocation.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['workflowInvocationId'] = workflow_invocation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataform/v1beta1:getWorkflowInvocation', __args__, opts=opts, typ=GetWorkflowInvocationResult).value

    return AwaitableGetWorkflowInvocationResult(
        compilation_result=__ret__.compilation_result,
        invocation_config=__ret__.invocation_config,
        invocation_timing=__ret__.invocation_timing,
        name=__ret__.name,
        state=__ret__.state,
        workflow_config=__ret__.workflow_config)


@_utilities.lift_output_func(get_workflow_invocation)
def get_workflow_invocation_output(location: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[Optional[str]]] = None,
                                   repository_id: Optional[pulumi.Input[str]] = None,
                                   workflow_invocation_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkflowInvocationResult]:
    """
    Fetches a single WorkflowInvocation.
    """
    ...
