# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkflowConfigResult',
    'AwaitableGetWorkflowConfigResult',
    'get_workflow_config',
    'get_workflow_config_output',
]

@pulumi.output_type
class GetWorkflowConfigResult:
    def __init__(__self__, cron_schedule=None, invocation_config=None, name=None, recent_scheduled_execution_records=None, release_config=None, time_zone=None):
        if cron_schedule and not isinstance(cron_schedule, str):
            raise TypeError("Expected argument 'cron_schedule' to be a str")
        pulumi.set(__self__, "cron_schedule", cron_schedule)
        if invocation_config and not isinstance(invocation_config, dict):
            raise TypeError("Expected argument 'invocation_config' to be a dict")
        pulumi.set(__self__, "invocation_config", invocation_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recent_scheduled_execution_records and not isinstance(recent_scheduled_execution_records, list):
            raise TypeError("Expected argument 'recent_scheduled_execution_records' to be a list")
        pulumi.set(__self__, "recent_scheduled_execution_records", recent_scheduled_execution_records)
        if release_config and not isinstance(release_config, str):
            raise TypeError("Expected argument 'release_config' to be a str")
        pulumi.set(__self__, "release_config", release_config)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> str:
        """
        Optional. Optional schedule (in cron format) for automatic execution of this workflow config.
        """
        return pulumi.get(self, "cron_schedule")

    @property
    @pulumi.getter(name="invocationConfig")
    def invocation_config(self) -> 'outputs.InvocationConfigResponse':
        """
        Optional. If left unset, a default InvocationConfig will be used.
        """
        return pulumi.get(self, "invocation_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The workflow config's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recentScheduledExecutionRecords")
    def recent_scheduled_execution_records(self) -> Sequence['outputs.ScheduledExecutionRecordResponse']:
        """
        Records of the 10 most recent scheduled execution attempts. Updated whenever automatic creation of a compilation result is triggered by cron_schedule.
        """
        return pulumi.get(self, "recent_scheduled_execution_records")

    @property
    @pulumi.getter(name="releaseConfig")
    def release_config(self) -> str:
        """
        The name of the release config whose release_compilation_result should be executed. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        """
        return pulumi.get(self, "release_config")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Optional. Specifies the time zone to be used when interpreting cron_schedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
        """
        return pulumi.get(self, "time_zone")


class AwaitableGetWorkflowConfigResult(GetWorkflowConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowConfigResult(
            cron_schedule=self.cron_schedule,
            invocation_config=self.invocation_config,
            name=self.name,
            recent_scheduled_execution_records=self.recent_scheduled_execution_records,
            release_config=self.release_config,
            time_zone=self.time_zone)


def get_workflow_config(location: Optional[str] = None,
                        project: Optional[str] = None,
                        repository_id: Optional[str] = None,
                        workflow_config_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowConfigResult:
    """
    Fetches a single WorkflowConfig.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['workflowConfigId'] = workflow_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataform/v1beta1:getWorkflowConfig', __args__, opts=opts, typ=GetWorkflowConfigResult).value

    return AwaitableGetWorkflowConfigResult(
        cron_schedule=__ret__.cron_schedule,
        invocation_config=__ret__.invocation_config,
        name=__ret__.name,
        recent_scheduled_execution_records=__ret__.recent_scheduled_execution_records,
        release_config=__ret__.release_config,
        time_zone=__ret__.time_zone)


@_utilities.lift_output_func(get_workflow_config)
def get_workflow_config_output(location: Optional[pulumi.Input[str]] = None,
                               project: Optional[pulumi.Input[Optional[str]]] = None,
                               repository_id: Optional[pulumi.Input[str]] = None,
                               workflow_config_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkflowConfigResult]:
    """
    Fetches a single WorkflowConfig.
    """
    ...
